# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MigrateSqlServerSqlMIDatabaseInput(Model):
    """Database specific information for SQL to Azure SQL DB Managed Instance
    migration task inputs.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the database
    :type name: str
    :param restore_database_name: Required. Name of the database at
     destination
    :type restore_database_name: str
    :param backup_file_share: Backup file share information for backing up
     this database.
    :type backup_file_share: ~azure.mgmt.datamigration.models.FileShare
    :param backup_file_paths: The list of backup files to be used in case of
     existing backups.
    :type backup_file_paths: list[str]
    """

    _validation = {
        'name': {'required': True},
        'restore_database_name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'restore_database_name': {'key': 'restoreDatabaseName', 'type': 'str'},
        'backup_file_share': {'key': 'backupFileShare', 'type': 'FileShare'},
        'backup_file_paths': {'key': 'backupFilePaths', 'type': '[str]'},
    }

    def __init__(self, *, name: str, restore_database_name: str, backup_file_share=None, backup_file_paths=None, **kwargs) -> None:
        super(MigrateSqlServerSqlMIDatabaseInput, self).__init__(**kwargs)
        self.name = name
        self.restore_database_name = restore_database_name
        self.backup_file_share = backup_file_share
        self.backup_file_paths = backup_file_paths
