# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class EntityLabelObject(Model):
    """Defines the entity type and position of the extracted entity within the
    example.

    All required parameters must be populated in order to send to Azure.

    :param entity_name: Required. The entity type.
    :type entity_name: str
    :param start_char_index: Required. The index within the utterance where
     the extracted entity starts.
    :type start_char_index: int
    :param end_char_index: Required. The index within the utterance where the
     extracted entity ends.
    :type end_char_index: int
    """

    _validation = {
        'entity_name': {'required': True},
        'start_char_index': {'required': True},
        'end_char_index': {'required': True},
    }

    _attribute_map = {
        'entity_name': {'key': 'entityName', 'type': 'str'},
        'start_char_index': {'key': 'startCharIndex', 'type': 'int'},
        'end_char_index': {'key': 'endCharIndex', 'type': 'int'},
    }

    def __init__(self, *, entity_name: str, start_char_index: int, end_char_index: int, **kwargs) -> None:
        super(EntityLabelObject, self).__init__(**kwargs)
        self.entity_name = entity_name
        self.start_char_index = start_char_index
        self.end_char_index = end_char_index
