# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .integration_account_resource import IntegrationAccountResource


class IntegrationAccountAgreement(IntegrationAccountResource):
    """IntegrationAccountAgreement.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: The resource id.
    :type id: str
    :param name: The resource name.
    :type name: str
    :param type: The resource type.
    :type type: str
    :param location: The resource location.
    :type location: str
    :param tags: The resource tags.
    :type tags: dict
    :ivar created_time: The created time.
    :vartype created_time: datetime
    :ivar changed_time: The changed time.
    :vartype changed_time: datetime
    :param metadata: The metadata.
    :type metadata: object
    :param agreement_type: The agreement type. Possible values include:
     'NotSpecified', 'AS2', 'X12', 'Edifact'
    :type agreement_type: str or :class:`AgreementType
     <azure.mgmt.logic.models.AgreementType>`
    :param host_partner: The host partner.
    :type host_partner: str
    :param guest_partner: The guest partner.
    :type guest_partner: str
    :param host_identity: The host identity.
    :type host_identity: :class:`BusinessIdentity
     <azure.mgmt.logic.models.BusinessIdentity>`
    :param guest_identity: The guest identity.
    :type guest_identity: :class:`BusinessIdentity
     <azure.mgmt.logic.models.BusinessIdentity>`
    :param content: The agreement content.
    :type content: :class:`AgreementContent
     <azure.mgmt.logic.models.AgreementContent>`
    """ 

    _validation = {
        'created_time': {'readonly': True},
        'changed_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'properties.changedTime', 'type': 'iso-8601'},
        'metadata': {'key': 'properties.metadata', 'type': 'object'},
        'agreement_type': {'key': 'properties.agreementType', 'type': 'AgreementType'},
        'host_partner': {'key': 'properties.hostPartner', 'type': 'str'},
        'guest_partner': {'key': 'properties.guestPartner', 'type': 'str'},
        'host_identity': {'key': 'properties.hostIdentity', 'type': 'BusinessIdentity'},
        'guest_identity': {'key': 'properties.guestIdentity', 'type': 'BusinessIdentity'},
        'content': {'key': 'properties.content', 'type': 'AgreementContent'},
    }

    def __init__(self, id=None, name=None, type=None, location=None, tags=None, metadata=None, agreement_type=None, host_partner=None, guest_partner=None, host_identity=None, guest_identity=None, content=None):
        super(IntegrationAccountAgreement, self).__init__(id=id, name=name, type=type, location=location, tags=tags)
        self.created_time = None
        self.changed_time = None
        self.metadata = metadata
        self.agreement_type = agreement_type
        self.host_partner = host_partner
        self.guest_partner = guest_partner
        self.host_identity = host_identity
        self.guest_identity = guest_identity
        self.content = content
