# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class IotHubNameAvailabilityInfo(Model):
    """The properties indicating whether a given iothub name is available.

    :param name_available: The value which indicates whether the provided
     name is available.
    :type name_available: bool
    :param reason: The reason for unavailability. Possible values include:
     'Invalid', 'AlreadyExists'
    :type reason: str or :class:`IotHubNameUnavailabilityReason
     <azure.mgmt.iothub.models.IotHubNameUnavailabilityReason>`
    :param message: The message describing the detailed reason.
    :type message: str
    """ 

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'IotHubNameUnavailabilityReason'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, name_available=None, reason=None, message=None):
        self.name_available = name_available
        self.reason = reason
        self.message = message
