from Xslt import test_harness

sheet_str_1 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
        <xsl:output method="html"/>

        <xsl:template match="/">
        <xsl:apply-templates/>
        </xsl:template>

        <xsl:template match="PARA">
                <p CLASS="dtp"><xsl:apply-templates/></p>
        </xsl:template>

        <xsl:template match="LINK">
                <a href="resolvterm?{@LINKEND}"><xsl:value-of select="."/></a>
        </xsl:template>

</xsl:stylesheet>
"""

xml_source_1 = """<PARA>This should have a trailing space <LINK LINKEND="foo">this should have no leading or trailing ws</LINK> this should have a leading space</PARA>"""

expected_1 = """<p CLASS='dtp'>This should have a trailing space <a href='resolvterm?foo'>this should have no leading or trailing ws</a> this should have a leading space</p>"""
#"

def Test(tester):
    tester.startGroup("Whitespace Handling")

    source = test_harness.FileInfo(string=xml_source_1)
    sty = test_harness.FileInfo(string=sheet_str_1)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_1,
                                    )

    xtest.test(tester)
    tester.groupDone()
    return
