#! /usr/bin/env python

import socket
import SubnetTree

t = SubnetTree.SubnetTree()

t.insert("1.2.3.4/16")

if "1.2.3.255" in t:
    print "yes [correct]"
else:
    print "no [incorrect]"

if socket.inet_aton("1.2.3.255") in t:
    print "yes [correct]"
else:
    print "no [incorrect]"
    
if "1.3.3.255" in t:
    print "yes [correct]"
else:
    print "no [correct]"

if socket.inet_aton("1.3.3.255") in t:
    print "yes [correct]"
else:
    print "no [correct]"
    
if socket.inet_aton("0.1.2.3") in t:
    print "yes [incorrect]"
else:
    print "no [correct]"

t["4.3.2.1/8"] = "Indexing works [correct]"
print t["4.3.255.255"]

try:
    print t["42.42.42.42"],
    print "[incorect]"
except KeyError:
    print "Exception caught [correct]"

del t["4.3.2.1/8"]

try:
    print t["4.3.2.1/8"],
    print "[incorect]"
except KeyError:
    print "del works [correct]"

try:
    t["a.b.c.d/error"] = 5
except IndexError:
    print "catching parsing errors [correct]"

    
