/*
	PSEmu Plugin Developer Kit Header definition

	(C)1998 Vision Thing

	This file can be used only to develop PSEmu Plugins
	Other usage is highly prohibited.
*/


// IMPORTANT!!!
// This file will be used by PSEmu version >= 1.0.3
// so, please, develop Plugins w/o using this header file now
// if you want to add return codes (any) just drop mail to
// duddie@psemu.com

#define DECLSPEC

#ifndef _PSEMU_PLUGIN_DEFS_H
#define _PSEMU_PLUGIN_DEFS_H

// header version
#define _PPDK_HEADER_VERSION		1

#define PLUGIN_VERSION				1

// plugin type returned by PSEgetLibType (types can be merged if plugin is multi type!)
#define PSE_LT_CDR					1
#define PSE_LT_GPU					2
#define PSE_LT_SPU					4
#define PSE_LT_PAD					8


// every function in DLL if completed sucessfully should return this value
#define PSE_ERR_SUCCESS				0
// undefined error but fatal one, that kills all functionality
#define PSE_ERR_FATAL				-1


// XXX_Init return values
// Those return values apply to all libraries

// initialization went OK
#define PSE_INIT_ERR_SUCCESS		0

// this driver is not configured
#define PSE_INIT_ERR_NOTCONFIGURED	-2

// this driver can not operate properly on this hardware or hardware is not detected
#define PSE_INIT_ERR_NOHARDWARE		-3

/*         PAD PlugIn          */

// PADquery responses (notice - values ORed)
// PSEmu will use them also in PADinit to tell Plugin which Ports will use
// notice that PSEmu will call PADinit and PADopen only once when they are from
// same plugin

// might be used in port 1 (must support PADreadPort1() function)
#define PSE_PAD_USE_PORT1			1
// might be used in port 2 (must support PADreadPort2() function)
#define PSE_PAD_USE_PORT2			2



// MOUSE SCPH-1030
#define PSE_PAD_TYPE_MOUSE			1
// NEGCON - 16 button analog controller SLPH-00001
#define PSE_PAD_TYPE_NEGCON			2
// GUN CONTROLLER - gun controller SLPH-00014 from Konami
#define PSE_PAD_TYPE_GUN			3
// STANDARD PAD SCPH-1080, SCPH-1150
#define PSE_PAD_TYPE_STANDARD		4
// ANALOG JOYSTICK SCPH-1110
#define PSE_PAD_TYPE_ANALOGJOY		5
// GUNCON - gun controller SLPH-00034 from Namco
#define PSE_PAD_TYPE_GUNCON			6
// ANALOG CONTROLLER SCPH-1150
#define PSE_PAD_TYPE_ANALOGPAD		7


// sucess, everything configured, and went OK.
#define PSE_PAD_ERR_SUCCESS			0
// general plugin failure (undefined error)
#define PSE_PAD_ERR_FAILURE			-1


// ERRORS
// this error might be returned as critical error but none of below
#define PSE_PAD_ERR					-80
// this driver is not configured
#define PSE_PAD_ERR_NOTCONFIGURED	PSE_PAD_ERR - 1
// this driver failed Init
#define PSE_PAD_ERR_INIT			PSE_PAD_ERR - 2


// WARNINGS
// this warning might be returned as undefined warning but allowing driver to continue
#define PSE_PAD_WARN				80


typedef struct
{
	// controler type - fill it withe predefined values above
	unsigned char controllerType;
	
	// status of buttons - every controller fills this field
	unsigned short buttonStatus;
	
	// for analog pad fill those next 4 bytes
	// values are analog in range 0-255 where 128 is center position
	unsigned char rightJoyX, rightJoyY, leftJoyX, leftJoyY;

	// for mouse fill those next 2 bytes
	// values are in range -128 - 127
	unsigned char moveX, moveY;

	unsigned char reserved[91];

} PadDataS;

#endif // _PSEMU_PLUGIN_DEFS_H
