/*-----------------------------------------------------------------------
QMBTagger - Qt Based MusicBrainz MP3/OGG/FLAC Tagger
Copyright (C) 2003,2004 Ewen Cheslack-Postava
 
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-----------------------------------------------------------------------*/

#ifndef _QMBFILE_H_
#define _QMBFILE_H_

#if HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#if HAVE_LIBMUSICBRAINZ

#include "qmbmetadata.h"
#include "prokyon.h"

#include <musicbrainz/musicbrainz.h>
#include <musicbrainz/mb_c.h>

/**
 * This class is a wrapper for  MusicBrainz API. 
 * Unfortunately, musicbrainz only fully support latin1 encoding 
 * at the moment. 
 */

class QMBFile {
public:
    QMBFile();
    ~QMBFile();

    virtual int Extract(QString filename) = 0;
    int CreateID(trm_t &trm);
    int QueryServer(MusicBrainz* mb);
    void StripURL(QString &url);
    void setMetadata(TRACK*);

    long bufferlen;
    char* buffer;
    int channels;
    long sampleRate;
    unsigned int bits_per_sample;
    double songlength;
    char signature[17];
    char ascii_sig[37];
    QString fullfilename;
    QString serverurl;
    int serverport;

    //metadata
    QMBMetadata metadata;
    QMBMetadata* queryresults;
    int numresults;
};

#endif /*HAVE_LIBMUSICBRAINZ*/

#endif //define _QMBFILE_H_
