/***************************************************************************
                          gui.h  -  description
                             -------------------
    begin                : Wed May 2 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GUI_H
#define GUI_H

#include "prokyon.h"

#include "gui_selector.h"
#include "gui_sourcer.h"
#include "gui_listing.h"
#include "gui_taglisting.h"
#include "gui_playlist.h"

#include <qwidget.h>
#include <qmainwindow.h>
#include <qaction.h>
#include <qlabel.h>
#include <qtoolbar.h>
#include <qevent.h>
#include <qsplitter.h>
#include <qprogressbar.h>
#include <qwidgetstack.h>

class GUI : public QMainWindow  {
    Q_OBJECT
public:
    GUI(QWidget *parent=0, const char *name=0);

    void notifyEstablishedConnection();
    void notifyLostConnection();
    #ifdef HAVE_MIXXX

    void notifyEstablishedMixxxConnection();
    void notifyLostMixxxConnection();
    #endif /* HAVE_MIXXX */

    GUI_Selector*   getSelector()    {
        return selector;
    }
    GUI_Sourcer*    getSourcer()     {
        return sourcer;
    }
    GUI_Listing*    getListing()     {
        return listing;
    }
    GUI_TagListing* getTagListing()  {
        return taglisting;
    }
    GUI_Playlist*   getPlaylisting() {
        return playlisting;
    }

    QToolBar* getSwitchBar() {
        return switchbar;
    }

    void setStatusInfo(QString message, int i);
    QString getStatusInfo(int i);
    #ifdef HAVE_MIXXX

    void enterMixxxMode();
    void leaveMixxxMode();
    #endif /* HAVE_MIXXX */

    #ifdef HAVE_MEXTRAS

    void addMextraJobToStatusBar();
    void reportMextraJobDoneToStatusBar();
    void notifyMextrasTrackListing ( QList<TRACK> *list );
    #endif /* HAVE_MEXTRAS */

    bool getConnectionState() {
        return connectionState;
    }

    static QPixmap fadeOutIcon(QString file);
    static QImage& blend(const QColor& clr, QImage& dst, float opacity);

    ~GUI();

public slots:
    void slot_setConnectionState(bool);
    void slot_WELCOME();

protected:
    void customEvent(QCustomEvent*);
    void closeEvent(QCloseEvent*);

private:
    #ifdef HAVE_MIXXX

    void setMixxxConnectionState(bool);
    bool mixxxConnectionState;
    #endif /* HAVE_MIXXX */

    bool connectionState;
    bool togglebottom_state;

    GUI_Selector   *selector;
    GUI_Sourcer    *sourcer;
    GUI_Listing    *listing;
    GUI_TagListing *taglisting;
    GUI_Playlist   *playlisting;

    QToolBar *switchbar, *commoditybar, *playerbar, *prelistenbar;

    QAction *action_disconnect, *action_connect, *action_createdb, *action_about, *action_welcome, *action_documentation;

    #ifdef HAVE_MEXTRAS

    QAction *action_mextras_log, *action_mextras_scan, *action_mextras_zap, *action_mextras_abort, *action_mextras_version, *action_mextras_plugins, *action_mextras_update;
    #endif /* HAVE_MEXTRAS */

    #ifdef HAVE_MIXXX

    QAction *action_mixxx_connect, *action_mixxx_disconnect;
    #endif /* HAVE_MIXXX */

    QLabel *status1, *status2, *status3, *status4, *status5, *status6, *labelpix;

    #ifdef HAVE_MEXTRAS

    QProgressBar *mextrasProgress;
    #endif /* HAVE_MEXTRAS */

    QWidgetStack *stackStatus6;

    QAction *action_toggleleft, *action_togglebottom, *action_toggleright;

    QSplitter *hsplit, *vsplitr, *vsplitm, *vsplitl;
    QString getLanguageCode();

private slots:
    void slot_connectToDB();
    void slot_disconnectFromDB();
    void slot_connectToMixxx();
    void slot_disconnectFromMixxx();
    void slot_QUIT();
    void slot_PREF();
    void slot_CREATEDB();
    void slot_INITDB();
    void slot_ABOUT();
    void slot_DOCUMENTATION();
    void slot_selectAll();
    void slot_unselectAll();
    void slot_pause();
    void slot_stop();
    void slot_next();
    void slot_prev();
    void slot_prepause();
    void slot_prestop();
    void slot_prenext();
    void slot_preprev();
    void slot_MEXTRAS_LOG();
    void slot_MEXTRAS_SCAN();
    void slot_MEXTRAS_ABORT();
    void slot_MEXTRAS_ZAP();
    void slot_MEXTRAS_VERSION();
    void slot_MEXTRAS_PLUGINS();
    void slot_MEXTRAS_UPDATE();

    void slot_toggleleft(bool);
    void slot_togglebottom(bool);
    void slot_toggleright(bool);
    void polish();
};

class SortList : public  QPtrList<TRACK> {
protected:
    int compareItems(QPtrCollection::Item t1, QPtrCollection::Item t2) {
        if (static_cast<TRACK*>(t1)->
                title == static_cast<TRACK*>(t2)->title) return 0;
        if (static_cast<TRACK*>
                (t1)->title > static_cast<TRACK*>(t2)->title) return 1;
        if (static_cast<TRACK*>
                (t1)->title < static_cast<TRACK*>(t2)->title) return -1;
    }
};
#endif
