/*
    SubprojectsManager.h

    Interface declaration of the SubprojectsManager class for the
    ProjectManager application.

    Copyright (C) 2005, 2006  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import "../../ProjectModule.h"

@class NSDictionary,
       NSMutableDictionary,
       NSBox,
       NSNotification,
       NSOutlineView,
       NSTableColumn,
       NSFileManager;

@class ProjectDocument;

@protocol SubprojectsManagerDelegate;

@interface SubprojectsManager : NSObject <ProjectModule>
{
  // weak references
  ProjectDocument * document;
  id <SubprojectsManagerDelegate> delegate;

  id bogusWindow, view;
  id outline;

  /**
   * This array contains the subprojects hierarchy.
   * It's contents are NSDictionary's of the following structure:
   *
   * {
   *   Type = "Category";
   *   Name = "<subcategory-name>";
   *   Contents = ( contents-array );
   * }
   *
   * if the entry is a subcategory of subprojects, or:
   *
   * {
   *   Type = "Subproject";
   *   Name = "<subproject-name>";
   *   ProjectFile = "<subproject-project-file-name>";
   * }
   *
   * if the entry is a subproject.
   */
  NSMutableArray * subprojects;
  // an unsorted list of names of all subproject names
  NSMutableArray * subprojectNames;

  // file operation errors from the file manager
  NSDictionary * fileOpErrorDict;
}

- (NSArray *) subprojectNames;

- (id)outlineView: (NSOutlineView *)outlineView 
            child: (int)index 
           ofItem: (id)item;
- (BOOL)outlineView: (NSOutlineView *)outlineView
   isItemExpandable: (id)item;
- (int)outlineView: (NSOutlineView *)outlineView
numberOfChildrenOfItem: (id)item;
- (id)outlineView: (NSOutlineView *)outlineView
objectValueForTableColumn:(NSTableColumn *)tableColumn
           byItem:(id)item;
- (void)outlineView: (NSOutlineView *)outlineView
     setObjectValue: (id)object
     forTableColumn: (NSTableColumn *)tableColumn
             byItem: (id)item;

- (BOOL) fileManager: (NSFileManager*)fileManager
  shouldProceedAfterError: (NSDictionary*)errorDictionary;

- (void) fileManager: (NSFileManager*)fileManager
     willProcessPath: (NSString*)path;

- (void) newSubprojectAction: sender;
- (void) addSubprojectAction: sender;
- (void) removeSubprojectAction: sender;
- (void) openSubprojectAction: sender;
- (void) newSubprojectCategoryAction: sender;
- (void) removeSubprojectCategoryAction: sender;

@end
