/*
    ProjectAttributesDelegate.h

    Declaration of the ProjectAttributesDelegate protocol for the
    ProjectManager app.

    Copyright (C) 2005, 2006  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import <Foundation/NSObject.h>

@class NSArray,
       NSView,
       NSString;

@protocol ProjectAttributesDelegate

/**
 * Asks the delegate to return a list of attributes tab identifiers.
 *
 * @param sender The sender ProjectAttributes object.
 *
 * @return An array of string identifiers of attributes tabs.
 */
- (NSArray *) tabIdentifiersForProjectAttributes: (id) sender;

/**
 * Asks the delegate to provide a label for it's tab toolbar item.
 *
 * @param tab The tab for which the label is intended.
 * @param sender The sender ProjectAttributes object.
 *
 * @return A string which to set as the toolbar item's label.
 */
- (NSString *)  projectAttributes:  (id) sender
 toolbarItemLabelForTabIdentifier: (NSString *) tab;

/**
 * Asks the delegate to provide a tool tip for it's tab toolbar item.
 *
 * @param tab The tab for which the tool tip is intended.
 * @param sender The sender ProjectAttributes object.
 *
 * @return A string which to set as the toolbar item's tool tip.
 */
- (NSString *)    projectAttributes:  (id) sender
 toolbarItemToolTipForTabIdentifier: (NSString *) tab;

/**
 * Asks the delegate to provide an icon for it's tab toolbar item.
 *
 * @param tab The tab for which the icon is intended.
 * @param sender The sender ProjectAttributes object.
 *
 * @return An NSImage which to set as the toolbar item's icon.
 *      Returning `nil' means `no icon'.
 */
- (NSImage *)  projectAttributes:  (id) sender
 toolbarItemIconForTabIdentifier: (NSString *) tab;

/**
 * Asks the delegate to provide a view which to put into the sender's
 * content view.
 *
 * @param sender The sender ProjectAttributes object.
 * @param tab The tab for which to provide the view.
 *
 * @return A view object which will be put into the sender's content view.
 */
- (NSView *) projectAttributes: (id) sender
          viewForTabIdentifier: (NSString *) tab;

@end
