/*
    ProjectModuleLoader.h

    Interface declaration of the ProjectModuleLoader class for the
    ProjectManager application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import <Foundation/NSObject.h>

@class NSDictionary, NSArray, NSString;

@class ProjectDocument;
@protocol ProjectModule;

@interface ProjectModuleLoader : NSObject
{
  /* A dictionary where keys are project module names and values
   * are classes which handle them. */
  NSDictionary * projectModules;
}

/// Returns a shared instance of a ProjectModuleLoader.
+ shared;

/**
 * Returns the a dictionary where keys are project types and values are
 * classes which implement the respective project type.
 */
- (NSDictionary *) projectModules;

/**
 * Initializes a project type of type `projectTypeID' for a project
 * named `projectName', located at `aPath' and with `infoDict' where the
 * project type has it's saved private data.
 */
- (id <ProjectModule>)
  projectModuleForModuleName: (NSString *) projectModuleName
                     project: (ProjectDocument *) project
              infoDictionary: (NSDictionary *) infoDict;

@end
