/* OTGrammar_def.h
 *
 * Copyright (C) 1997-2008 Paul Boersma
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * pb 2008/04/08
 */


#define ooSTRUCT OTGrammarConstraint
oo_DEFINE_STRUCT (OTGrammarConstraint)

	oo_STRINGW (name)
	oo_DOUBLE (ranking)
	oo_DOUBLE (disharmony)
	oo_FROM (2)
		oo_DOUBLE (plasticity)
	oo_ENDFROM
	#if OO_READING
		if (localVersion < 2) {
			my plasticity = 1.0;
		}
	#endif
	#if !oo_READING && !oo_WRITING
		oo_INT (tiedToTheLeft)
		oo_INT (tiedToTheRight)
	#endif

oo_END_STRUCT (OTGrammarConstraint)
#undef ooSTRUCT


#define ooSTRUCT OTGrammarFixedRanking
oo_DEFINE_STRUCT (OTGrammarFixedRanking)

	oo_LONG (higher)
	oo_LONG (lower)

oo_END_STRUCT (OTGrammarFixedRanking)
#undef ooSTRUCT


#define ooSTRUCT OTGrammarCandidate
oo_DEFINE_STRUCT (OTGrammarCandidate)

	oo_STRINGW (output)
	oo_LONG (numberOfConstraints)
	oo_INT_VECTOR (marks, my numberOfConstraints)
	#if !oo_READING && !oo_WRITING
		oo_DOUBLE (harmony)
		oo_DOUBLE (probability)
		oo_LONG (numberOfPotentialPartialOutputsMatching)
		oo_BOOLEAN_VECTOR (partialOutputMatches, my numberOfPotentialPartialOutputsMatching)
	#endif

oo_END_STRUCT (OTGrammarCandidate)
#undef ooSTRUCT


#define ooSTRUCT OTGrammarTableau
oo_DEFINE_STRUCT (OTGrammarTableau)

	oo_STRINGW (input)
	oo_LONG (numberOfCandidates)
	oo_STRUCT_VECTOR (OTGrammarCandidate, candidates, my numberOfCandidates)

oo_END_STRUCT (OTGrammarTableau)
#undef ooSTRUCT


#define ooSTRUCT OTGrammar
oo_DEFINE_CLASS (OTGrammar, Data)

	oo_FROM (1)
		oo_ENUM (OTGrammar_DECISION_STRATEGY, decisionStrategy)
	oo_ENDFROM
	oo_FROM (2)
		oo_DOUBLE (leak)
	oo_ENDFROM
	oo_LONG (numberOfConstraints)
	oo_STRUCT_VECTOR (OTGrammarConstraint, constraints, my numberOfConstraints)
	oo_LONG_VECTOR (index, my numberOfConstraints)
	oo_LONG (numberOfFixedRankings)
	oo_STRUCT_VECTOR (OTGrammarFixedRanking, fixedRankings, my numberOfFixedRankings)
	oo_LONG (numberOfTableaus)
	oo_STRUCT_VECTOR (OTGrammarTableau, tableaus, my numberOfTableaus)
	#if oo_READING
		OTGrammar_sort (me);
	#endif

oo_END_CLASS (OTGrammar)
#undef ooSTRUCT


/* End of file OTGrammar_def.h */
