#ifndef	_LIB_XCIO_H
#define	_LIB_XCIO_H

#include <xcmd.h>

#define	PIST_NONE	0
#define	PIST_DOWN	1
#define	PIST_RUN	2
#define	PIST_UP		3

#define	PINFO_LCP	0
#define	PINFO_CCP	1
#define	PINFO_IPCP	2
#define	PINFO_MAX	10

#define	XCBUFSIZ	256

#define	CONSOLE_AUTOF	1
#define	CONSOLE_AUTOC	2
#define	CONSOLE_CURRENT	4

typedef enum {
    PS_DEAD,
/*    PS_AUTO,*/
    PS_ESTABLISH,
    PS_AUTHENTICATE,
    PS_CALLBACK,
    PS_NETWORK,
    PS_TERMINATE
} phasestate_t;

enum {
    XCIO_WAIT,
    XCIO_HELLO,
    XCIO_S_IN,
    XCIO_S_OUT,
    XCIO_RETURN,
    XCIO_UP_INFO,	/* pppInfo update */
    XCIO_UP_ENVS,	/* envs update */
    XCIO_UP_AUTO,	/* switch auto-update console */
    XCIO_LOCK,		/* lock/unlock console */
    XCIO_CONSOLES,	/* console list */
    XCIO_PWD_REQ,
    /*
     * request name/password/entry
     * console        ppxpd  <return>
     *        - none ->      all e/n/p (PWD_SET)
     *        -   E  ->      N/P/E (PWD_SET)
     *       <- none -       N/P (PWD_SET)
     */
    XCIO_PWD_SET,
    /*
     * name/password/entry set
     * console        ppxpd
     *        - N/P  ->      store to authName/authKey
     *        - N/P/E->      store to authName/authKey and update E
     *        -   E  ->      remove E
     *       <- none -       N/P (PWD_SET)
     *
     *        - none ->
     *       <- N/P/E
     */
    XCIO_ENV_REQ,
    XCIO_ENV_SET,	/* env set (name and value) */
    XCIO_XCMD,
    XCIO_MESSAGE,
    XCIO_LISTUP,
    XCIO_ACTIVATE,
};

#define	XCIO_LAST	0x80
#define	XCIO_MASK	(~XCIO_LAST)

#define	XID_UPDATE	0
#define	XID_ANY		0xA20000

#define	XLABEL_COMMAND	0xff

#define	LSTAT_PROMPT	0x00	/* prompt mode */
#define	LSTAT_NONE	0x00	/* prompt mode */
#define	LSTAT_TTY	0x01	/* terminal mode */
#define	LSTAT_CHAT	0x02	/* chat mode */
#define	LSTAT_PPP	0x04	/* PPP mode */
#define	LSTAT_NLINK	0x08	/* network link is established */
#define	LSTAT_DIAL	0x10	/* dialing... */

#define	MFLAG_AUTO	0x01	/* auto mode */

#define	NSTAT_IP	0x01	/* IP is established */
#define	NSTAT_IPX	0x02	/* IPX is established */
#define	NSTAT_NP	(LINE_IP|LINE_IPX)

typedef	u_int8_t	linestat_t;
typedef	u_int8_t	nlpstat_t;	/* network layer protocols */
typedef	u_int8_t	modeflag_t;	/* network layer protocols */

struct pppinfo_s {
    phasestate_t phase;
    u_int32_t idle;	/* idle time (sec) */
    u_int32_t connect;	/* connect time (sec) */
    struct npkt_s {
	u_int count;	/* total count */
	u_int error;	/* error count */
	u_int lsize;	/* total size (read/write from/to line) */
	u_int nsize;	/* total size (read/write from/to network i/f) */
    } s, r;
    unsigned int minfo;	/* modem info(TIOCMGET) */
#if 0
    struct pinfo_s {
	char name[7];
	u_int8_t st;
    } p[PINFO_MAX];
#endif
    linestat_t l_stat;
    nlpstat_t n_stat;
    modeflag_t m_flag;
};

struct xcio_s {
    u_int8_t type;
    u_int8_t xid;		/* non zero */
    u_int8_t len;
    u_char buf[XCBUFSIZ];
};

extern struct pppinfo_s pppInfo;
extern int XcioRead();
extern int XcioWrite();
extern void XcioOpen();

#define	LEN_SA_DATA(s)	(sizeof(s.sa_family)+strlen(s.sa_data)+1)

#endif	/* _LIB_XCIO_H */
