#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Vendor.h>
#include <stdio.h>
#include "CtimerP.h"

#define sDisp      XtDisplay(cw)
#define sScreen    XtScreen(cw)
#define sRoot      XRootWindowOfScreen(XtScreen(cw))
#define sWidth     cw->core.width
#define sHeight    cw->core.height
#define sPixmap(i) cw->ctimer.pixmap[i]
#define sAttr(i)   cw->ctimer.attr[i]
#define sState     cw->ctimer.state

#define offset(field) XtOffsetOf(CtimerRec, field)
static XtResource resources[] = {
  { XtNstate, XtCState, XtRInt, sizeof(int),
            offset(ctimer.state), XtRImmediate, (XtPointer)0 },
  { XtNoffPixmapData, XtCPixmapData, XtRPointer, sizeof(XtPointer),
            offset(ctimer.pixmap_data[0]), XtRPointer, NULL },
  { XtNonPixmapData, XtCPixmapData, XtRPointer, sizeof(XtPointer),
            offset(ctimer.pixmap_data[1]), XtRPointer, NULL },
  { XtNboffPixmapData, XtCPixmapData, XtRPointer, sizeof(XtPointer),
            offset(ctimer.pixmap_data[2]), XtRPointer, NULL },
  { XtNbonPixmapData, XtCPixmapData, XtRPointer, sizeof(XtPointer),
            offset(ctimer.pixmap_data[3]), XtRPointer, NULL },
};
#undef offset

static void CtimerBlink();
static void ShowCtimer();
static void Initialize();
static void Resize();
static void Redisplay();
static Boolean SetValues();
static void Destroy();
static XtGeometryResult QueryGeometry();

static char defaultTranslation[] = "";
static XtActionsRec actions[] = {{NULL, NULL}};

CtimerClassRec ctimerClassRec = {
  {
  /* superclass             */ (WidgetClass) &coreClassRec,
  /* class_name             */ "Ctimer",
  /* widget_size            */ sizeof(CtimerRec),
  /* class_initialize       */ NULL,
  /* class_part_initialize  */ NULL,
  /* class_inited           */ FALSE,
  /* initialize             */ Initialize,
  /* initialize_hook        */ NULL,
  /* realize                */ XtInheritRealize,
  /* actions                */ actions,
  /* num_actions            */ XtNumber(actions),
  /* resources              */ resources,
  /* num_resourece          */ XtNumber(resources),
  /* xrm_class              */ NULLQUARK,
  /* compress_motion        */ TRUE,
  /* compress_exposure      */ TRUE,
  /* compress_enterleave    */ TRUE,
  /* visible_interest       */ FALSE,
  /* destroy                */ Destroy,
  /* resize                 */ Resize,
  /* expose                 */ Redisplay,
  /* set_values             */ SetValues,
  /* set_values_hook        */ NULL,
  /* set_values_almoset     */ XtInheritSetValuesAlmost,
  /* get_values_hook        */ NULL,
  /* accept_focus           */ NULL,
  /* version                */ XtVersion,
  /* callback_private       */ NULL,
  /* tm_table               */ defaultTranslation,
  /* query_geometry         */ QueryGeometry,
  /* display_accelator      */ XtInheritDisplayAccelerator,
  /* extention              */ NULL
  },{
  /* foo                    */ 0
  }
};
WidgetClass ctimerWidgetClass = (WidgetClass)&ctimerClassRec;

static void
CtimerBlink(CtimerWidget cw)
{
        cw->ctimer.timer = False;
        ShowCtimer(cw);
}

static void
ShowCtimer(CtimerWidget cw)
{
        switch(sState) {
        case 0:
        case 1:
        case 2:
        case 3:
                XtVaSetValues((Widget)cw,
                              XtNbackgroundPixmap, sPixmap(sState), NULL);
                break;
        default:
                if (!cw->ctimer.timer) {
                        if (cw->ctimer.blink) {
                                XtVaSetValues((Widget)cw,
                                      XtNbackgroundPixmap, sPixmap(2), NULL);
                                cw->ctimer.blink = False;
                        } else {
                                XtVaSetValues((Widget)cw,
                                      XtNbackgroundPixmap, sPixmap(3), NULL);
                                cw->ctimer.blink = True;
                        }
                        cw->ctimer.timer = XtAppAddTimeOut(
                               XtWidgetToApplicationContext((Widget)cw),
                               sState * 50, 
                               (XtTimerCallbackProc) CtimerBlink,
                               (Widget)cw);
                        cw->ctimer.timer = True;
                }
                break;
        }
}

static void
Initialize(Widget wreq, Widget wnew)
{
        CtimerWidget cw = (CtimerWidget) wnew;
        Pixmap Mask;
        int i;
        int rst;

        for(i=0; i<4; i++) {
                sAttr(i).valuemask = XpmReturnInfos 
                                   | XpmReturnAllocPixels
                                   | XpmReturnExtensions;
                rst = XpmCreatePixmapFromData(sDisp, sRoot, 
                                        cw->ctimer.pixmap_data[i], 
                                        &sPixmap(i), &Mask, &sAttr(i));
                if (rst != 0) XpmError(rst);
                if (Mask) XFreePixmap(sDisp, Mask);
        }
        if (sWidth == 0) {
                sWidth = sAttr(0).width;
        }
        if (sHeight == 0) {
                sHeight = sAttr(0).height;
        }

        cw->ctimer.blink = False;
        cw->ctimer.timer = False;
        ShowCtimer(cw);
}

static void
Redisplay(Widget w, XExposeEvent *event)
{
        CtimerWidget cw = (CtimerWidget) w;

        return;
}

static Boolean
SetValues(Widget wcur, Widget wreq, Widget wnew)
{
        CtimerWidget cur = (CtimerWidget) wcur;
        CtimerWidget cw  = (CtimerWidget) wnew;
        Boolean redraw = False;

        if (cur->ctimer.state != cw->ctimer.state) {
                ShowCtimer(cw);
        }

        return redraw;
}

static
void Destroy(Widget w)
{
        CtimerWidget cw = (CtimerWidget) w;
        Colormap cmap;
        int i;

        cmap=DefaultColormapOfScreen(sScreen);
        for(i=0; i<4; i++) {
                if (sPixmap(i))
                        XFreePixmap(sDisp, sPixmap(i));
                XFreeColors(sDisp, cmap,
                            sAttr(i).alloc_pixels,
                            sAttr(i).nalloc_pixels, 0);
                XpmFreeAttributes(&sAttr(i));
        }
}

static void
Resize(Widget w)
{
        CtimerWidget cw = (CtimerWidget) w;

        return;
}

static XtGeometryResult
QueryGeometry(Widget w, XtWidgetGeometry *proposed, XtWidgetGeometry *answer)
{
        CtimerWidget cw = (CtimerWidget) w;

        answer->request_mode = CWWidth | CWHeight;
        answer->width  = sWidth;
        answer->height = sHeight;
        return XtGeometryAlmost;
}
