//******************************************************************************
// Copyright (C) 1998-2000 TLK Games all rights reserved.
// project						: Powermanga shoot'm up game
// programmers				:	Jean-Michel Martin de Santero mailto:jmm@freetlk.com									: main programmer & creator of game
//										: Bruno Ethvignot								bruno@tlk.friend												: Linux port, score, about
//										:	Andre Majorel									mailto:amajorel@teaser.fr								: Linux port, makefile
//										: Etienne Sobole								e.sobole@nexcom.friend									: anim player, visuals effects
//										: Emmanuel Founaud																											: sprites routines
// gfx								:	David Igreja									david@tlk.friend												: modeling
//										: Jean-Michel Martin de Santero jmm@freetlk.com													: design & modeling
// company						: TLK Games BP 24 81150 Florentin France
//------------------------------------------------------------------------------
// file								: "main.cpp"
// created 						: 1999-08-17
// updates						: 2000-08-15
//------------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it under the terms of the 
// GNU General Public License as published by the Free Software Foundation; either version 2 of the License, 
// or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
// without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License along with this program; 
// if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//******************************************************************************
#include "powermanga.hpp"
//..............................................................................
extern unsigned int 		iCompteurBoucle ;
extern int							vmode ;									//0=320*200 ; 1=640*400 
extern int							fullscreen ; 						//1=full screen (use dga)
#ifdef UTILISE_SEAL
extern unsigned int			utilise_seal ;					//1=use seal for music and sound binary is libaudio.a, no source :-(
#endif
//..............................................................................
unsigned int						iVerbeux=0 ;						//1=verbose mode, 2=super verbose mode
int											quit_game=0 ;						//1=leave the game
int											nosync=0 ;							//1=pas d'attente avant deux images du jeu / no sleep between two images
unsigned int 						iFrame=14286 ;					//game speed : 70 frames/sec
unsigned int 						iFrame2=20000 ; 				//music speed : 50 frames/sec
unsigned int 						iFrame3=35715 ;					//game speed : 28 frames/sec
extern unsigned int			iJoueIntro ;						//(1=animation du debut/start anim ; 2=animation de fin/end anim )

//..............................................................................
void						scan_arguments(int _iNombreArgument, char** _pArguments) ;
int							powermanga() ;
//int							first_window()
#ifdef UTILISE_SEAL
pthread_t 			powermanga_thread ;
void*						powermanga_thread_ret ;
void* 					seal_thread_process(void* arg) ;
pthread_t 			seal_thread ;
void*						seal_thread_ret ;
unsigned 	int 	seal_thread_run=1 ;
#endif
//firstwindow*		pPremiereFenetre=new firstwindow() ;

//------------------------------------------------------------------------------
// main  						: a simple main loop  
// _iNombreArgument	: taille de la chaine d'argument / size of string
// _pArguments			: pointeur sur le pointeur contenat la dite chaine / pointer to the pointer to the arguments
//------------------------------------------------------------------------------
int main(int _iNombreArgument, char** _pArguments) 
{	scan_arguments(_iNombreArgument, _pArguments) ;
	powermanga() ;
	exit(0) ;
}

//------------------------------------------------------------------------------
// thread 1 : powermanga
//------------------------------------------------------------------------------
int powermanga()
{	int _iTempsPause=0 ;
	int _iTempsDifference=0 ;
	fps_init() ;
	if(!mem_initialise(22000)) exit(1) ;		//allocate memory table
	//if(!first_window()) goto quitter ;
	if(xw_init()==1)												//xwindow initialize
	{	if(!inits_game()) goto quitter ;
		else
		{	
#ifdef _VERBEUX_
			if(iVerbeux>0) afficheMessage("PowerManga : welcome, program run !\n\n") ;
#endif
//start seal thread ............................................................
#ifdef UTILISE_SEAL
			if(utilise_seal)
			{	seal_thread_run=1 ;
				if(pthread_create(&seal_thread, NULL, seal_thread_process, 0)<0)
				{	afficheErreur("pthread_create() failed", "main.cpp/main()");
					exit(1) ;
				}
#ifdef _VERBEUX_
					if(iVerbeux>0) afficheMessage("seal_thread_process running...\n") ;
#endif
			}
			seal_thread_run=0 ;
#endif
		do
		{	iCompteurBoucle++ ;										//counter of loops
			if(nosync==0)
			{	_iTempsDifference=synchro_CalculDifference();
				if(iJoueIntro)	_iTempsPause=synchro_processusPause(iFrame3 - _iTempsDifference + _iTempsPause);
				else						_iTempsPause=synchro_processusPause(iFrame - _iTempsDifference + _iTempsPause);
			}
			if(!UpdateFrame()) quit_game=1  ;			//"powermanga.cpp" : update all
			xw_exec() ;														//display window or screen
		} while(quit_game==0) ;

//stop thread from seal ........................................................
#ifdef UTILISE_SEAL
			if(utilise_seal)
			{	seal_thread_run=2 ;								//2=stop the thread
				struct timeval temps ; temps.tv_usec = 500000; temps.tv_sec = 0 ;
				while(seal_thread_run>0)
				{	select(0, NULL, NULL, NULL, &temps);					//sleep for a time interval
				}
				(void)pthread_join(seal_thread, &seal_thread_ret) ;
			}
#endif
		}
	}
quitter: ;
	xw_kill() ;															//free xwindow ressources
	fps_affiche() ;
  mem_libereTous() ;											//free all memory
#ifdef _VERBEUX_
	if(iVerbeux>0) afficheMessage("PowerManga : end program ! bye bye\n\n") ;
#endif
	return 0 ;
}

//------------------------------------------------------------------------------
// thread 2 : music and sound from powermanga
//------------------------------------------------------------------------------
#ifdef UTILISE_SEAL
void* seal_thread_process(void *arg)
{	int _iTempsPause=0 ;
	int _iTempsDifference=0 ;
	while(seal_thread_run!=0)
	{
	}
	seal_thread_run=1 ;
	while(seal_thread_run==1)
	{	if(utilise_seal==1)
		{	_iTempsDifference=synchro_CalculDifference2();
			_iTempsPause=synchro_processusPause(iFrame2 - _iTempsDifference + _iTempsPause);
			seal_exec() ;
		}
	}
	seal_thread_run=0 ;
	pthread_exit(0) ;
}
#endif


//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
/*
int	first_window()
{	if(pPremiereFenetre->initialise(640,480))  
	{	while(!pPremiereFenetre->execution() && !pPremiereFenetre->tst_ferme())
		{	//printf("==> %i\n", pPremiereFenetre->tst_ferme()) ;
		}	
		pPremiereFenetre->ferme() ;
		delete pPremiereFenetre ;
	}
	else
	{	 mem_libereTous() ;											//free all memory
		 return 0 ;
	}
	return 1 ;
*/



//------------------------------------------------------------------------------
// scan_arguments  	: analyse les arguements 
// _iNombreArgument	: taille de la chaine d'argument
// _pArguments			: pointeur sur le pointeur contenat la dite chaine
//------------------------------------------------------------------------------
void	scan_arguments(int _iNombreArgument, char** _pArguments)
{	int _iIndex ;
	#ifdef UTILISE_SEAL
	utilise_seal=1 ;
	#endif
	for(_iIndex=1 ; _iIndex<_iNombreArgument ; _iIndex++)
	{	if(*_pArguments[_iIndex]=='-')
		{	if(strcmp(_pArguments[_iIndex], "-h")==0 || strcmp(_pArguments[_iIndex], "--help")==0)
			{	printf("\noptions:\n") ;
				printf("-h, --help     print Help (this message) and exit\n") ;
				printf("--version      print version information and exit\n") ;
				printf("--640          game run in a 640*400 window\n") ;
				printf("--full         game run in full screen with DGA (experimental)\n") ;
				printf("-v             verbose mode\n") ;
				printf("--verbose      verbose mode (more messages)\n") ;
				printf("--nosound      force no sound\n") ;
				printf("--nosync       disable timer\n") ;
				printf("--------------------------------------------------------------\n") ;
				printf("keys recognized during the game:\n") ;
				printf("CTRL+S         enable/disable the music\n") ;
				printf("CTRL+Q         finish the play current\n") ;
				printf("CTRL+A         about Powermanga\n") ;
				printf("F10            quit Powermanga\n") ;
				printf("P              enable/disable pause\n") ;
				printf("\n") ;
				if(!iVerbeux && !vmode && !fullscreen) exit(0) ;
			}
			else
			{	if(strcmp(_pArguments[_iIndex], "--version")==0)
				{	printf(POWERMANGA_VERSION) ;
					printf("\n") ;
					printf("copyright (c) 2000 TLK Games\n") ;
					printf("website : http://www.tlk.fr\n") ;
					if(!iVerbeux && !vmode && !fullscreen) exit(0) ;
				}	
				else
				{	if(strcmp(_pArguments[_iIndex], "--verbose" )==0) 
					{ iVerbeux=2 ;
					}
					else
					{	if(strcmp(_pArguments[_iIndex], "-v" )==0) 
						{	iVerbeux=1 ; 
						}
						else
						{	if (strcmp(_pArguments[_iIndex], "--640" )==0) 
							{	vmode=1 ;
							}
							else
							{	if(strcmp(_pArguments[_iIndex], "--full" )==0) 
								{	fullscreen=1 ;
								}
								else
								{	if (strcmp(_pArguments[_iIndex], "--nosync" )==0) 
									{	nosync=1 ;
									}
									else
									if(strcmp(_pArguments[_iIndex], "--nosound")==0)
									{	
										#ifdef UTILISE_SEAL
										utilise_seal=0 ;
										#endif
									}
								}
							}
						}
					}
				}
			}
		} //=='-'
	} //for
}


/*
captures d'ecran
Gnome :
- utiliser Electric Eyes (bouton du milieu fenetre de ee)
KDE :
-	Menu K/Graphiques/Capture d'ecran
- ksnapshot & en ligne de commande.
Shell :
- ecran complet			: xwd -root -out fichier.xwd
- fenetre seulement	: xwd -frame -out fichier.xwd
- man xwd pour plus de renseignements
Autres :
- Gimp : fonction grab (menu Xtns, Screen shot)
- XV   : fonction grab
*/

