//******************************************************************************
// Copyright (C) 1998-2000 TLK Games all rights reserved.
// project						: Powermanga shoot'm up game
// programmers				:	Jean-Michel Martin de Santero : main programmer & creator of game
//										: Bruno Ethvignot								: Linux port, score, about
//										: Etienne Sobole								: anim player, visuals effects
//										: Emmanuel Founaud							: sprites routines
// gfx								:	David Igreja									: modeling
//										: Jean-Michel Martin de Santero : design & modeling
// company						: TLK Games BP 24 81150 Florentin France
//------------------------------------------------------------------------------
// file						: "linux.hpp"
// created 				: 1999-08-17
// updates				: 2000-08-16
//------------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it under the terms of the 
// GNU General Public License as published by the Free Software Foundation; either version 2 of the License, 
// or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
// without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License along with this program; 
// if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//******************************************************************************
#ifndef __LINUXHPP__
#define __LINUXHPP__
//..............................................................................
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <math.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/utsname.h>
#include <pthread.h>
#include <unistd.h>
#include <sys/types.h>
//..............................................................................
#define _VERBEUX_
#define		TRUE			1
#define		FALSE			0
//codes clavier sous xwindow / xwindow keys codes ..............................
/*#define		VK_RETURN 	36
#define		VK_DOWN			104
#define		VK_UP				98
#define		VK_LEFT			100
#define		VK_RIGHT		102
#define		VK_INSERT		106
#define		VK_F1 			67
#define		VK_F2 			68
#define		VK_F3 			69
#define		VK_F4 			70
#define		VK_F5 			71
#define		VK_F6 			72
#define		VK_F7 			73
#define		VK_F8 			74
#define		VK_F9 			75
#define		VK_F10 			76
#define		VK_F11 			95
#define		VK_F12 			96
#define		VK_PAUSE 		16		//pause key
#define		VK_SHIFT 		50		//shift left
#define		VK_SHIFT2		62		//shift right
#define		VK_SPACE		65
#define		VK_BACK			22
#define		VK_DELETE		107		//
#define		VK_CONTROL	109		//ctrl right
#define		VK_CONTROL2	37		//ctrl left
#define		VK_ESCAPE		9
*/
//gestion des fichiers gif ......................................................
typedef struct 
{	char		imageSepar;		//code Image Seperator Header (0x2C ou ',')
	char		abscisseLW;		//abscisse du coin superieur
	char		abscisseHI;		//abscisse du coin superieur
	char		ordonneeLW;		//ordonne du coin superieur	
	char		ordonneeHI;		//ordonne du coin superieur	
	char		largeur_LW;		//largeur image en pixels
	char		largeur_HI;		//largeur image en pixels
	char		hauteur_LW;		//hauteur image en pixels	
	char		hauteur_HI;		//hauteur image en pixels	
	char		indicateur;		//indicateur : bit 7->TRUE=Palette locale disponible		
												// 6->image entrelacee / 5->ordre placement palette locale
												// 3-4-> reserve / 0-2 ->nombre de bits par pixels						
}	sDescriptionGif ;
//gestion fichier graphique en memoire ...........................................
typedef struct
{	unsigned int		iLargeur ;								//image width
	unsigned int		iHauteur ;								//image height
	unsigned int		iProfond ;								//bits per pixels
	unsigned int		iTaille ;									//memory size
	char*						pAdresse ;								//pointer to the image data
	unsigned char   tPaletteGif[768]	;				//palette
} sDescriptionGfx ;

//"xwindow.cpp"....................................................................
int 		xw_init() ;
int			reserve_ecran_ram() ;
int			charge_palette(char* _pNomFichier) ;
int 		xw_exec() ;
int 		change_resolution() ;
int 		xw_kill() ;
char*		Xload_pcx(char* _pNomFichier) ;
int			Xload_pcx(char* _pNomFichier, char* _pMem) ;
char*		convertit_16ou24(sDescriptionGfx* _pSrc) ;
void 		copie_gfx(sDescriptionGfx* _pGfx) ;
int			reserve_ecranPlayanim() ;
void    kill_ecranPlayanim() ;

//linuxroutines.cpp ------------------------------------------------------------
int 							mem_initialise(unsigned int _iNombreZones) ;
char*							reserveMemoire(unsigned int _iTailleMemoire) ;
void							libereMemoire(char* _pMemoire) ;
int								mem_retourneTaille(char* _pMem) ;
void							mem_libereTous() ;
int							 	load_pcx(char*, char*) ;
sDescriptionGfx* 	load_pcx(char*) ;
unsigned int			littleWord(char* _pMem) ;
short							litMot16bits(short* _pMem) ;
int								litMot32bits(int* _pMem) ;
int								chaine_cmp(char* _pChaine1, char* _pChaine2, unsigned int _iTaille) ;
char*							chargeFichier(char* _pNomFichier) ;
char*							chargeFichier(char* _pNomFichier, unsigned int* pTaille) ;
int 							chargeFichier(char* _pMemoire, char* _pNomFichier) ;
void							fps_init() ;
void							fps_affiche() ;
void							afficheMessage(char* _Message) ;
void							afficheMessage(char* _Message1, char* _Message2) ;
void							afficheErreur(char* _pErreur1, char* _pErreur2) ;
void 							afficheErreur(char* _pErreur1, char* _pErreur2, int _iErreur) ;
void 							afficheErreur(char* _pErreur1, char* _pErreur2, char* _pErreur3) ;
int 							synchro_processusPause(int _iTemps) ;
int							 	synchro_CalculDifference() ;
int							 	synchro_CalculDifference2() ;
#endif



