#!/bin/csh -f

##      fp.csh <username>
#               Generate a fingerprint from a X509 certificate
#               and updates /etc/postfix/relay_clientcerts
#               It presumes a user certificate in /etc/postfix/certs/
#               with name <username>-cert.pem
#       author: walcir fontanini (walcir@densis.fee.unicamp.br) Apr-08-1999

set USER=$1
set FP=`/usr/local/ssl/bin/openssl x509 -fingerprint -in /etc/postfix/certs/$USER-cert.pem | grep Fingerprint | awk -F= '{print $2}' | tr ":" "_"`

cat >> /etc/postfix/relay_clientcerts <<EOT
$FP $USER
EOT

postmap dbm:/etc/postfix/relay_clientcerts

exit
#
