#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# Copyright 2009 Zuza Software Foundation
#
# This file is part of translate.
#
# translate is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# translate is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with translate; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from django.db                import models

from pootle_app.models.translation_project import TranslationProject
from pootle_app.models.suggestion import Suggestion
from pootle_app.models.profile import PootleProfile
from pootle_app.lib.util import RelatedManager

class Submission(models.Model):
    class Meta:
        app_label = "pootle_app"
        get_latest_by = "creation_time"

    creation_time       = models.DateTimeField(db_index=True)
    translation_project = models.ForeignKey(TranslationProject, db_index=True)
    submitter           = models.ForeignKey(PootleProfile, null=True, db_index=True)
    from_suggestion     = models.OneToOneField(Suggestion, null=True, db_index=True)

    objects = RelatedManager()

    def __unicode__(self):
        return u"%s (%s)" % (self.creation_time.strftime("%Y-%m-%d %H:%M"), unicode(self.submitter))


