/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef POLYXDEF_DEFCTXT_H
#define POLYXDEF_DEFCTXT_H

#include "polyxdef-globals.h"


typedef struct _PxmDefCtxt PxmDefCtxt;


struct _PxmDefCtxt
{
  /* The definition window.
   */
  GtkWidget *definition_wnd;
  
  /* The syntax-checking window.
   */
  GtkWidget *syntax_check_wnd;
    
  /* Is the definition of atoms or of polymer chemistry ?
   */
  gint definition_type;

  /* To tell if the definition is modified or not.
   */
  gboolean is_modified;
  
  /* The filename of the definition, be it of a polymer chemistry or
     of atoms.
  */
  gchar *filename;
  
  /* If we are working on a polymer chemistry definition we can store
     its pointer here.
   */
  PxmPolchemdef *polchemdef;
  
  /* If we are working on an atom definition then, we can store the
     atoms in this array of PxmAtom instances. If we are working on a
     polymer chemistry definition, atoms are required, and are stored
     in the polchemdef->atomGPA array.
   */
  GPtrArray *atomGPA;
  
  /* The conventional system of prop array.
   */
  GPtrArray *propGPA;
};


PxmDefCtxt *
polyxdef_defctxt_new (void);


gboolean 
polyxdef_defctxt_free (PxmDefCtxt *defctxt);





/* GPtrArray-RELATED FUNCTIONS
 */
gint
polyxdef_defctxt_GPA_free (GPtrArray *GPA);












#endif /* ifndef POLYXDEF_DEFCTXT_H */
