/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#include "polyxmass-globals.h"


PxmAtomSpec *
polyxmass_globals_get_matching_polchemdef_atomdef (gchar *polchemdef, 
						   gint *polchemdef_idx,
						   gchar *atomdef,
						   gint *atomdef_idx) 
{
  PxmPolchemdefSpec *ps_cat = NULL;
  
  PxmAtomSpec *as_dic = NULL;
  PxmAtomSpec *as_cat = NULL;

  PxmAtomSpec *as_new = NULL;

  gboolean polchemdef_found = FALSE;
  gboolean atomdef_found = FALSE;

  gboolean finished = FALSE;

  gint iter = 0;
    
  /* We are asked to create a PxmAtomSpec instance that will hold all
     the data allowing to match the optional polymer definition type
     passed as parameter 'polchemdef' with the optional 'atomdef'
     parameter.

     polchemdef is the type of the polymer chemistry defintion, like
     "protein".

     atomdef is the name of the atom definition, like "basic".

     polchemdef cannot be NULL while atomdef can. If atomdef is
     non-NULL, that means that the correspondence is know, but the
     caller wants actually to get the name of the files where both
     polchemdef and atomdef are defined.
  */
  g_assert (polchemdef != NULL || atomdef != NULL);
  

  for (iter = 0; iter < polyxmass_polchematomdicGPA->len; iter++)
    {
      polchemdef_found = FALSE;
      atomdef_found = FALSE;
      
      as_dic = g_ptr_array_index (polyxmass_polchematomdicGPA, iter);
      g_assert (as_dic != NULL);
      
      if (polchemdef != NULL)
	{
	  if (0 == strcmp (polchemdef, as_dic->poltype))
	    {
	      polchemdef_found = TRUE;
	    }
	  else
	    continue;
	}
      if (atomdef != NULL)
	{
	  if (0 == strcmp (atomdef, as_dic->atomdef))
	    {
	      if (polchemdef != NULL)
		{
		  /* The polchemdef is also required to match.
		   */
		  if (polchemdef_found == TRUE)
		    {
		      /* We have found the correspondence.
		       */
		      finished = TRUE;
		      
		      break;
		    }
		  else /* polchemdef_found == FALSE */
		    {
		      /* We did find an atomdef, but the required
			 polchemdef did not match... continue...
		      */
		      continue;
		    }
		}
	      else /* polchemdef == NULL i.e. is not required to match. */
		{
		  /* We have found the correspondence.
		   */
		  finished = TRUE;
		  
		  break;
		}
	    }
	  else 
	    {
	      /* the comparison 0 == strcmp (atomdef, as_dic->atomdef) fails 
	       */
	      continue;
	    }
	}
      else /* atomdef == NULL */
	{
	  /* The atomdef is not required to match, so since the
	     polchemdef did match, we're done.
	  */
	  finished = TRUE;
	  
	  break;
	}
    }
  
  if (FALSE == finished)
    return NULL;
  
  /* So we now have a as_dic corresponding either to polchemdef
     (as_dic->poltype) or to atomdef (as_dic->atomdef) or both.

     Since we have the correspondence, we can now look for each
     as_dic->poltype (in polyxmass_polchemdefsGPA) and as_dic->atomdef
     (in polyxmass_atomdefsGPA) members in their respective arrays.
  */
  polchemdef_found = FALSE;
  atomdef_found = FALSE;

  /* We now have to find the as_dic->poltype string in the array
     polyxmass_polchemdefsGPA of available pol. chem. definitions.
  */
  for (iter = 0 ; iter < polyxmass_polchemdefsGPA->len; iter++)
    {
      ps_cat = g_ptr_array_index (polyxmass_polchemdefsGPA, iter);
      g_assert (ps_cat != NULL);
      
      if (0 == strcmp (as_dic->poltype, ps_cat->type))
	{
	  /*  We have found an instance that matches. 
	      OK, we thus have all we need...
	  */
	  polchemdef_found = TRUE;
	  
	  if (polchemdef_idx != NULL)
	    *polchemdef_idx = iter;
	  
	  break;
	}
      else
	continue;
    }
    
  /* We now have to find the as_dic->atomdef string in the array
     polyxmass_atomdefsGPA of available atom definitions.
  */
  for (iter = 0 ; iter < polyxmass_atomdefsGPA->len; iter++)
    {
      as_cat = g_ptr_array_index (polyxmass_atomdefsGPA, iter);
      g_assert (as_cat != NULL);
      
      if (0 == strcmp (as_dic->atomdef, as_cat->atomdef))
	{
	  atomdef_found = TRUE;
	  
	  if (atomdef_idx != NULL)
	    *atomdef_idx = iter;
	  
	  break;
	}
      else
	continue;
    }
  
  if (polchemdef_found == FALSE && atomdef_found == FALSE)
    return NULL;
  
  /* At this point we have all informations to construct a fully
     characterized PxmAtomSpec instance.
  */
  as_new = libpolyxmass_atomspec_new ();

  if (polchemdef_found == TRUE)
    libpolyxmass_atomspec_set_poltype (as_new, ps_cat->type);
  
  if (atomdef_found == TRUE)
    {
      libpolyxmass_atomspec_set_atomdef (as_new, as_cat->atomdef);
      libpolyxmass_atomspec_set_file (as_new, as_cat->file);
    }
    
  return as_new;
}





void
polyxmass_globals_print_greeting (void)
{
  fprintf (stdout, "polyxmass version %s\n\n", VERSION);
  
  fprintf (stdout,
	   "GNU %s is an official GNU project package.\n"
	   "GNU %s is Copyright 2000, 2001, 2002, 2003, 2004\n"
	   "by Filippo Rusconi.\n"
	   "GNU %s is free software, covered by the GNU General\n"
	   "Public License Version 2, and you are welcome to change it\n"
	   "and/or distribute copies of it under certain conditions.\n"
	   "Check the file COPYING in the distribution and/or the\n"
	   "About item of the program.\n"
	   "\nHappy polyxmass'ing!\n\n", PACKAGE, PACKAGE, PACKAGE);

  return;
}

void
polyxmass_globals_print_polchemdef_xml_file_version (void)
{
  gchar *version = NULL;
  
  version = pxmchem_polchemdef_get_current_xml_version ();
  
  fprintf (stdout,
	   "GNU polyxmass version %s writes polymer chemistry "
	   "definition XML files of version %s\n", VERSION, version);
  
  g_free (version);
  
  return ;
}

void
polyxmass_globals_print_polymer_sequence_xml_file_version (void)
{
  gchar *version = NULL;
  
  version = pxmchem_polymer_get_current_xml_version ();
  
  fprintf (stdout,
	   "GNU polyxmass version %s writes polymer sequence "
	   "XML files of version %s\n", VERSION, version);
  
  g_free (version);
  
  return ;
}


void
polyxmass_globals_log_warning_msg (const gchar *log_domain,
				       GLogLevelFlags log_level,
				       const gchar *message,
				       gpointer data)
{
  GtkWidget *textview = data;

  GtkTextIter end_iter;

  GtkTextBuffer *buffer = NULL;
  
  g_assert (textview != NULL);
  g_assert (message != NULL);
  if (strlen (message) <= 0)
    return;
  

  /*We have to append the 'message' text to the textview.
   */
  buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (textview));
  
  /* Get end of buffer where we'll insert (that is append actually) 
     the message text.
  */
  gtk_text_buffer_get_end_iter (buffer, &end_iter);
  
  gtk_text_buffer_insert_with_tags_by_name (buffer,
					    &end_iter,
					    message,
					    -1,
					    "warning_tag",
					    NULL);
  return;
}
  

void
polyxmass_globals_log_libpolyxmass_warning_msg (const gchar *log_domain,
						GLogLevelFlags log_level,
						const gchar *message,
						gpointer data)
{
  GtkWidget *textview = data;
  
  GtkTextIter end_iter;

  GtkTextBuffer *buffer = NULL;
  
  g_assert (textview != NULL);
  g_assert (message != NULL);
  if (strlen (message) <= 0)
    return;
  

  /*We have to append the 'message' text to the textview.
   */
  buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (textview));
  
  /* Get end of buffer where we'll insert (that is append actually) 
     the message text.
  */
  gtk_text_buffer_get_end_iter (buffer, &end_iter);
  
  gtk_text_buffer_insert_with_tags_by_name (buffer,
					    &end_iter,
					    message,
					    -1,
					    "warning_tag",
					    NULL);
  return;
}
  

void
polyxmass_globals_log_critical_msg (const gchar *log_domain,
				    GLogLevelFlags log_level,
				    const gchar *message,
				    gpointer data)
{
  GtkWidget *textview = data;

  GtkTextIter end_iter;

  GtkTextBuffer *buffer = NULL;
  
  g_assert (textview != NULL);
  g_assert (message != NULL);
  if (strlen (message) <= 0)
    return;
  

  /*We have to append the 'message' text to the textview.
   */
  buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (textview));
  
  /* Get end of buffer where we'll insert (that is append actually) 
     the message text.
  */
  gtk_text_buffer_get_end_iter (buffer, &end_iter);
  
  gtk_text_buffer_insert_with_tags_by_name (buffer,
					    &end_iter,
					    message,
					    -1,
					    "critical_tag",
					    NULL);



  return;
}

void
polyxmass_globals_log_libpolyxmass_critical_msg (const gchar *log_domain,
						 GLogLevelFlags log_level,
						 const gchar *message,
						 gpointer data)
{
  GtkWidget *textview = data;

  GtkTextIter end_iter;

  GtkTextBuffer *buffer = NULL;
  
  g_assert (textview != NULL);
  g_assert (message != NULL);
  if (strlen (message) <= 0)
    return;
  

  /*We have to append the 'message' text to the textview.
   */
  buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (textview));
  
  /* Get end of buffer where we'll insert (that is append actually) 
     the message text.
  */
  gtk_text_buffer_get_end_iter (buffer, &end_iter);
  
  gtk_text_buffer_insert_with_tags_by_name (buffer,
					    &end_iter,
					    message,
					    -1,
					    "critical_tag",
					    NULL);



  return;
}


void
polyxmass_globals_log_message_msg (const gchar *log_domain,
				    GLogLevelFlags log_level,
				    const gchar *message,
				    gpointer data)
{
  GtkWidget *textview = data;

  GtkTextIter end_iter;

  GtkTextBuffer *buffer = NULL;
  
  g_assert (textview != NULL);
  g_assert (message != NULL);
  if (strlen (message) <= 0)
    return;
  

  /*We have to append the 'message' text to the textview.
   */
  buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (textview));
  
  /* Get end of buffer where we'll insert (that is append actually) 
     the message text.
  */
  gtk_text_buffer_get_end_iter (buffer, &end_iter);
  
  gtk_text_buffer_insert_with_tags_by_name (buffer,
					    &end_iter,
					    message,
					    -1,
					    "message_tag",
					    NULL);



  return;
}

void
polyxmass_globals_log_libpolyxmass_message_msg (const gchar *log_domain,
						 GLogLevelFlags log_level,
						 const gchar *message,
						 gpointer data)
{
  GtkWidget *textview = data;

  GtkTextIter end_iter;

  GtkTextBuffer *buffer = NULL;
  
  g_assert (textview != NULL);
  g_assert (message != NULL);
  if (strlen (message) <= 0)
    return;
  

  /*We have to append the 'message' text to the textview.
   */
  buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (textview));
  
  /* Get end of buffer where we'll insert (that is append actually) 
     the message text.
  */
  gtk_text_buffer_get_end_iter (buffer, &end_iter);
  
  gtk_text_buffer_insert_with_tags_by_name (buffer,
					    &end_iter,
					    message,
					    -1,
					    "message_tag",
					    NULL);



  return;
}







/* Automatical destroying of widget referenced into a prop object.
 */
gint
polyxmass_globals_gtk_window_prop_free (PxmProp *prop)
{
  g_assert (prop != NULL);
  
  g_assert (prop->name != NULL);
  g_free (prop->name);
  
  g_assert (prop->data != NULL);
  
  g_assert (0 == strcmp ("GtkWindow", 
			 g_type_name (GTK_OBJECT_TYPE (prop->data))));
  
  gtk_widget_destroy (GTK_WIDGET (prop->data));
  
  return TRUE;
}
