/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#include "polyxedit-ui-findrep-options.h"
#include "polyxedit-ui-seqed-wnd.h"
#include "polyxedit-rendering.h"

enum
  {
    COLUMN_MNM_PIXBUF,
    COLUMN_COL_COUNT
  };

#define FIND_TREEVIEW 1
#define REPL_TREEVIEW 2


GtkWidget *
polyxedit_findrep_opt_setup_wnd (PxmEditCtxt *editctxt)
{
  GtkWidget *window = NULL;
  GtkWidget *widget = NULL;
  GtkWidget *repl_vbox = NULL;
  
  GladeXML *xml = NULL;

  gchar *gui_file = NULL;
  gchar *help = NULL;

  GPtrArray *find_monomer_GPA = NULL;
  GPtrArray *repl_monomer_GPA = NULL;
  

  g_assert (editctxt != NULL);

  gui_file = 
    g_strdup_printf ("%s/polyxedit-find-replace.glade", 
		     userspec->gladedir);
  
  g_assert (gui_file != NULL);
  
  xml = glade_xml_new (gui_file, "find_repl_options_wnd", 
		       PACKAGE);
  if (xml == NULL)
    {
      g_error (_("%s@%d: failed loading the interface\n"),
	     __FILE__, __LINE__);

      return NULL;
    }
  
  window = glade_xml_get_widget (xml, "find_repl_options_wnd");
  
  if (window == NULL)
    {
      g_critical (_("%s@%d: failed creating the find/replace options window\n"),
	     __FILE__, __LINE__);

      g_object_unref (G_OBJECT (xml));

      return NULL;
    }


  /* 
     Immediately set a datum to the window, that contains the editctxt
     pointer passed as parameter.
  */
  g_object_set_data (G_OBJECT (window), "editctxt", editctxt);
  
  /* 
     We'll almost certainly have to display messages to the user.
  */
  widget = glade_xml_get_widget (xml, "messages_entry");
  g_object_set_data (G_OBJECT (window), "messages_entry",
		     widget);


  /* The frame where the polymer sequence data are displayed:
   */
  widget = glade_xml_get_widget (xml, "polymer_sequence_data_vbox");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), 
		     "polymer_sequence_data_vbox", widget);

  widget = glade_xml_get_widget (xml, "sequence_data_frame");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), 
		     "sequence_data_frame", widget);

  /* 
     Set the name of the protein to its correspondent GtkEntry.
  */
  widget = glade_xml_get_widget (xml, "sequence_entry"); 
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), 
		     "sequence_entry", widget);
  gtk_entry_set_text (GTK_ENTRY (widget), 
		      editctxt->polymer->plminfo->name);

  /* 
     Set the identity number (actually the editctxt pointer) to its
     GtkEntry (this is useful to identify unambiguously the polymer
     for which the find/replace operation is required).
  */
  widget = glade_xml_get_widget (xml, "identity_entry");
  g_object_set_data (G_OBJECT (window), "identity_entry",
		     widget);
  help = g_strdup_printf ("%p", editctxt);
  gtk_entry_set_text (GTK_ENTRY (widget), help);
  g_free (help);

  /* 
     The button in the polymer sequence data frame, thanks to which we
     can hide/show the sequence data.
  */
  widget = glade_xml_get_widget (xml, "polymer_sequence_data_button");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), 
		     "polymer_sequence_data_button", widget);

  /* 
     Let's connect the button to a "clicked" signal.
  */
  g_signal_connect 
    (G_OBJECT (widget),
     "clicked",
     G_CALLBACK 
     (polyxedit_findrep_opt_sequence_data), 
     window);


  /* 
     Now start to work on the REAL widgets...
  */

  /* FIND section of the window.
   */
  widget = glade_xml_get_widget (xml, "find_options_frame");
  g_assert (widget != NULL);  
  g_object_set_data (G_OBJECT (window), 
		     "find_options_frame", widget);

  widget = glade_xml_get_widget (xml, "find_sequence_hbox");
  g_assert (widget != NULL);  
  g_object_set_data (G_OBJECT (window), 
		     "find_sequence_hbox", widget);

  widget = glade_xml_get_widget (xml, "find_sequence_treeview_vbox");
  g_assert (widget != NULL);  
  g_object_set_data (G_OBJECT (window), 
		     "find_sequence_treeview_vbox", widget);

  /* Set up the treeview right away.
   */
  polyxedit_findrep_opt_find_treeview_setup (window, FIND_TREEVIEW);

  widget = glade_xml_get_widget (xml, "find_sequence_textview_vbox");
  g_assert (widget != NULL);  
  g_object_set_data (G_OBJECT (window), 
		     "find_sequence_textview_vbox", widget);

  widget = glade_xml_get_widget (xml, "find_sequence_textview_sw");
  g_assert (widget != NULL);  
  g_object_set_data (G_OBJECT (window), 
		     "find_sequence_textview_sw", widget);

  widget = glade_xml_get_widget (xml, "find_sequence_textview");
  g_assert (widget != NULL);  
  g_object_set_data (G_OBJECT (window), 
		     "find_sequence_textview", widget);

  widget = glade_xml_get_widget (xml, "find_update_graphics_button");
  g_assert (widget != NULL);  
  g_object_set_data (G_OBJECT (window), 
		     "find_update_graphics_button", widget);
  g_signal_connect 
    (G_OBJECT (widget),
     "clicked",
     G_CALLBACK (polyxedit_findrep_opt_find_update_graphics_button), 
     window);

  widget = glade_xml_get_widget (xml, "find_anywhere_button");
  g_assert (widget != NULL);  
  g_object_set_data (G_OBJECT (window), 
		     "find_anywhere_button", widget);
  g_signal_connect 
    (G_OBJECT (widget),
     "clicked",
     G_CALLBACK (polyxedit_findrep_opt_find_anywhere_button), 
     window);

  widget = glade_xml_get_widget (xml, "find_button");
  g_assert (widget != NULL);  
  g_object_set_data (G_OBJECT (window), 
		     "find_button", widget);
  g_signal_connect 
    (G_OBJECT (widget),
     "clicked",
     G_CALLBACK (polyxedit_findrep_opt_find_button), 
     window);

  widget = glade_xml_get_widget (xml, "find_results_prop_button");
  g_assert (widget != NULL);  
  g_object_set_data (G_OBJECT (window), 
		     "find_results_prop_button", widget);
  g_signal_connect 
    (G_OBJECT (widget),
     "clicked",
     G_CALLBACK (polyxedit_findrep_opt_find_results_prop_button), 
     window);
  
  /* Now that all the widets are OK, we can allocate the array that
     will receive the monomers corresponding to the find sequence present 
     in the textview widget. That text sequence will be converted into 
     an array of monomers, from which the treeview will be filled.
  */
  find_monomer_GPA = g_ptr_array_new ();
  g_object_set_data (G_OBJECT (window), 
		     "find_monomer_GPA", find_monomer_GPA);
  
  
  /* REPLACE section of the window.
   */
  widget = glade_xml_get_widget (xml, "repl_opt_checkbutton");
  g_assert (widget != NULL);  
  g_object_set_data (G_OBJECT (window), 
		     "repl_opt_checkbutton", widget);
  g_signal_connect 
    (GTK_OBJECT (widget), 
     "toggled",
     G_CALLBACK (polyxedit_findrep_opt_repl_opt_checkbutton), 
     window);
  
  widget = glade_xml_get_widget (xml, "repl_options_frame");
  g_assert (widget != NULL);  
  g_object_set_data (G_OBJECT (window), 
		     "repl_options_frame", widget);
  
  repl_vbox = glade_xml_get_widget (xml, "repl_vbox");
  g_assert (repl_vbox != NULL);  
  g_object_set_data (G_OBJECT (window), 
		     "repl_vbox", repl_vbox);

  widget = glade_xml_get_widget (xml, "repl_sequence_textview_vbox");
  g_assert (widget != NULL);  
  g_object_set_data (G_OBJECT (window), 
		     "repl_sequence_textview_vbox", widget);

  widget = glade_xml_get_widget (xml, "repl_sequence_textview_sw");
  g_assert (widget != NULL);  
  g_object_set_data (G_OBJECT (window), 
		     "repl_sequence_textview_sw", widget);

  widget = glade_xml_get_widget (xml, "repl_sequence_textview");
  g_assert (widget != NULL);  
  g_object_set_data (G_OBJECT (window), 
		     "repl_sequence_textview", widget);

  widget = glade_xml_get_widget (xml, "repl_sequence_treeview_vbox");
  g_assert (widget != NULL);  
  g_object_set_data (G_OBJECT (window), 
		     "repl_sequence_treeview_vbox", widget);

  /* Set up the treeview right away.
   */
  polyxedit_findrep_opt_find_treeview_setup (window, REPL_TREEVIEW);

  widget = glade_xml_get_widget (xml, "repl_button");
  g_assert (widget != NULL);  
  g_object_set_data (G_OBJECT (window), 
		     "repl_button", widget);
  g_signal_connect 
    (G_OBJECT (widget),
     "clicked",
     G_CALLBACK (polyxedit_findrep_opt_repl_button), 
     window);
  
  widget = glade_xml_get_widget (xml, "repl_results_prop_button");
  g_assert (widget != NULL);  
  g_object_set_data (G_OBJECT (window), 
		     "repl_results_prop_button", widget);
  g_signal_connect 
    (G_OBJECT (widget),
     "clicked",
     G_CALLBACK (polyxedit_findrep_opt_repl_results_prop_button), 
     window);

  /* Now that all the widets are OK, we can allocate the array that
     will receive the monomers corresponding to the replace sequence present 
     in the textview widget. That text sequence will be converted into 
     an array of monomers, from which the treeview will be filled.
  */
  repl_monomer_GPA = g_ptr_array_new ();
  g_object_set_data (G_OBJECT (window), 
		     "repl_monomer_GPA", repl_monomer_GPA);

  
  /*
    widget = glade_xml_get_widget (xml, "");
    g_assert (widget != NULL);  
    g_object_set_data (G_OBJECT (window), 
    "", widget);
    
    widget = glade_xml_get_widget (xml, "");
    g_assert (widget != NULL);  
    g_object_set_data (G_OBJECT (window), 
    "", widget);
  */
  
  gtk_widget_show_all (GTK_WIDGET (window));
  
  /*
    However we need to hide the replace section of the window.
  */
  gtk_widget_hide (GTK_WIDGET (repl_vbox));
  
  /* We have finished setting up the window, and so also using
   * the xml data, unref them
   */
  g_object_unref (G_OBJECT (xml));

  /* The signal of the window itself.
   */
  /* Signal / callback connections.
   */
  g_signal_connect 
    (G_OBJECT (window),
     "delete_event",
     G_CALLBACK (polyxedit_findrep_opt_wnd_delete_event), 
     NULL);

  g_free (gui_file);

  return window;
}


GtkWidget *
polyxedit_findrep_opt_find_treeview_setup (GtkWidget *widget,
					   gint what_treeview)
{
  GtkWidget *window = widget;
  
  GtkWidget *treeview_vbox = NULL;
  GtkWidget *scroll_wnd = NULL;
  GtkWidget *treeview = NULL;
  GtkTreeModel *model = NULL;
  GtkCellRenderer *renderer = NULL;


  g_assert (window != NULL);
  
  /* All we have to do is set up the treeview... either the find or the
     replace one.
  */
  if (what_treeview == FIND_TREEVIEW)
    treeview_vbox = g_object_get_data (G_OBJECT (window), 
				       "find_sequence_treeview_vbox");
  if (what_treeview == REPL_TREEVIEW)
    treeview_vbox = g_object_get_data (G_OBJECT (window), 
				       "repl_sequence_treeview_vbox");
  g_assert (treeview_vbox != NULL);
  
  /* Create the scrolled window that we'll pack into widget.
   */
  scroll_wnd = gtk_scrolled_window_new (NULL, NULL);

  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scroll_wnd),
				       GTK_SHADOW_ETCHED_IN);

  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll_wnd),
				  GTK_POLICY_AUTOMATIC,
				  GTK_POLICY_AUTOMATIC);

  gtk_box_pack_start (GTK_BOX (treeview_vbox), scroll_wnd, 
		      TRUE, TRUE, 0);  
  
  if (what_treeview == FIND_TREEVIEW)
    g_object_set_data (G_OBJECT (window), 
		       "find_sequence_scroll_wnd", scroll_wnd);
  if (what_treeview == REPL_TREEVIEW)
    g_object_set_data (G_OBJECT (window), 
		       "repl_sequence_scroll_wnd", scroll_wnd);

  /* Create the treeview model.
   */
  model = (GtkTreeModel *) 
    gtk_list_store_new (COLUMN_COL_COUNT, /*Numb. of columns*/
			GDK_TYPE_PIXBUF /* monicon's pixbuf */);
    
  /* Set to the model a datum with a pointer to the window!
   */
  g_object_set_data (G_OBJECT (model), "window", window);

  /* And now set the window a datum with a pointer to the mode,
   * so that later the model is accessible.
   */
  if (what_treeview == FIND_TREEVIEW)
    g_object_set_data (G_OBJECT (window), 
		       "FIND_TREEVIEW_MODEL", model);

  if (what_treeview == REPL_TREEVIEW)
    g_object_set_data (G_OBJECT (window), 
		       "REPL_TREEVIEW_MODEL", model);

  /* Create the treeview proper.
   */
  treeview = gtk_tree_view_new_with_model (model);

  g_object_unref (G_OBJECT (model));

  gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (treeview), TRUE);

  /* 
     Set to the window a datum with a pointer to the treeview, so that
     it is accessible later.
  */
  if (what_treeview == FIND_TREEVIEW)
    g_object_set_data (G_OBJECT (window), 
		       "FIND_TREEVIEW", treeview);

  if (what_treeview == REPL_TREEVIEW)
    g_object_set_data (G_OBJECT (window), 
		       "REPL_TREEVIEW", treeview);

  gtk_tree_selection_set_mode (gtk_tree_view_get_selection 
			       (GTK_TREE_VIEW (treeview)),
			       GTK_SELECTION_SINGLE);

  /* Reacts when a double-click happens on an item.
   */
  if (what_treeview == FIND_TREEVIEW)
    g_signal_connect 
      (G_OBJECT (treeview),
       "row-activated",
       G_CALLBACK (polyxedit_findrep_opt_find_treeview_row_activated), 
       window);
  if (what_treeview == REPL_TREEVIEW)
    g_signal_connect 
      (G_OBJECT (treeview),
       "row-activated",
       G_CALLBACK (polyxedit_findrep_opt_repl_treeview_row_activated), 
       window);

  /* We want to be able to trap the ENTER key.
   */
  gtk_widget_add_events (GTK_WIDGET (treeview), GDK_KEY_PRESS_MASK);
  
  if (what_treeview == FIND_TREEVIEW)
    g_signal_connect 
      (G_OBJECT (treeview),
       "key-release-event",
       G_CALLBACK (polyxedit_findrep_opt_find_treeview_key_release),
       window);
  if (what_treeview == REPL_TREEVIEW)
    g_signal_connect 
      (G_OBJECT (treeview),
       "key-release-event",
       G_CALLBACK (polyxedit_findrep_opt_repl_treeview_key_release),
       window);

  /* Pixbuf column.
   */
  renderer = gtk_cell_renderer_pixbuf_new ();

  gtk_tree_view_insert_column_with_attributes 
    (GTK_TREE_VIEW (treeview),
     -1, "Monicon", renderer,
     "pixbuf", COLUMN_MNM_PIXBUF,
     NULL);
  
  g_object_set_data (G_OBJECT (renderer), "column", 
		     (gint *) COLUMN_MNM_PIXBUF);


  /* Add the treeview to the scroll_wnd.
   */
  gtk_container_add (GTK_CONTAINER (scroll_wnd), treeview);
  
  gtk_widget_show_all (window);

  return treeview;
}


void
polyxedit_findrep_opt_find_treeview_row_activated (GtkTreeView *treeview,
						   GtkTreePath *path,
						   GtkTreeViewColumn *col,
						   gpointer data)
{
  
}

void
polyxedit_findrep_opt_repl_treeview_row_activated (GtkTreeView *treeview,
						   GtkTreePath *path,
						   GtkTreeViewColumn *col,
						   gpointer data)
{
  
}

void
polyxedit_findrep_opt_find_treeview_key_release (GtkWidget *widget,
						 GdkEventKey *event,
						 gpointer data)
{
  
}

void
polyxedit_findrep_opt_repl_treeview_key_release (GtkWidget *widget,
						 GdkEventKey *event,
						 gpointer data)
{
  
}


void 
polyxedit_findrep_opt_repl_opt_checkbutton (GtkWidget *widget,
					    gpointer data)
{
  GtkWidget *window = data;
  GtkWidget *repl_vbox = NULL;
  GtkWidget *repl_frame = NULL;
  
  
  GtkCheckButton *checkbutton = NULL;
  


  g_assert (window != NULL);
  
  checkbutton = 
    GTK_CHECK_BUTTON (g_object_get_data (G_OBJECT (window), 
					 "repl_opt_checkbutton"));
  g_assert (checkbutton != NULL);
  
  repl_vbox = g_object_get_data (G_OBJECT (window), 
				 "repl_vbox");
  g_assert (repl_vbox != NULL);
  
  repl_frame = g_object_get_data (G_OBJECT (window), 
				  "repl_options_frame");
  g_assert (repl_frame != NULL);
  

  if (TRUE == gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (checkbutton)))
    {
      gtk_widget_show_all (GTK_WIDGET (repl_vbox));
    }
  else
    {
      gtk_widget_hide_all (GTK_WIDGET (repl_vbox));
    }
}

void
polyxedit_findrep_opt_sequence_data (GtkWidget *button,
				     gpointer data)
{
  GtkWidget *window = data;
  GtkWidget *vbox = NULL;

  g_assert (window != NULL);
  
  /* Get the vertical box where the polymer sequence data displaying
     widgets are packed.
  */
  vbox = g_object_get_data (G_OBJECT (window),
			    "polymer_sequence_data_vbox");
  g_assert (vbox != NULL);

  /* If the vbox is visible we make it invisible, and vice-versa.
   */
  if (GTK_WIDGET_VISIBLE (vbox))
    gtk_widget_hide (vbox);
  else
    gtk_widget_show (vbox);
  
  return ;
}


void 
polyxedit_findrep_opt_find_update_graphics_button (GtkWidget *button,
						   gpointer data)
{
  GtkWidget *window = data;
  
  gint count = 0;
  gint iter = 0;
  gint codelen = 0;

  gchar *find_sequence_text = NULL;
  
  gboolean valid = FALSE;
  
  GtkTreeModel *model = NULL;
  GtkTreeIter treeiter ;
  GtkTreeView *treeview = NULL;
  GtkTreePath *path = NULL;
  
  GtkTextView *textview = NULL;
  GtkTextIter text_iter_start;
  GtkTextIter text_iter_end;
  GtkTextBuffer *buffer = NULL;

  GdkPixbuf *pixbuf = NULL;

  PxmEditCtxt *editctxt = NULL;
  PxmSeqEditorCtxt *seqeditorctxt = NULL;
  PxmPolchemdefCtxt *polchemdefctxt = NULL;
  PxmPolchemdef *polchemdef = NULL;
  PxmMonomer *monomer = NULL;

  GPtrArray *find_monomer_GPA = NULL;
  


  /* 
     We are asked to synchronize the data in both the textview and the
     pixmaps' treeview. So we ought to first remove all the items from
     the tree view. Next we have to parse the contents of the find
     sequence textview, make an array of monomers out of it, and fill the
     textview with these monomers' pixbufs. That's so easy !
  */

  g_assert (window != NULL);

  editctxt = g_object_get_data (G_OBJECT (window), 
				  "editctxt");
  g_assert (editctxt != NULL);
  
  seqeditorctxt = editctxt->seqeditorctxt;
  g_assert (seqeditorctxt != NULL);
  
  polchemdefctxt = editctxt->polchemdefctxt;
  g_assert (polchemdefctxt != NULL);
  
  polchemdef = polchemdefctxt->polchemdef;
  g_assert (polchemdef != NULL);
  
  codelen = polchemdef->codelen;
  
  
  /* EMPTY the find sequence treeview *****************************
   */
  treeview = 
    (GtkTreeView *) g_object_get_data (G_OBJECT (window), 
				       "FIND_TREEVIEW");

  model = gtk_tree_view_get_model (treeview);

  path = gtk_tree_path_new_first ();  

  if (TRUE == gtk_tree_model_get_iter_first (model, &treeiter))
    {
      /* The tree is not empty. We should first empty it.
       */
      
      /* Get the first iter in the list.
       */
      valid = gtk_tree_model_get_iter_first (model, &treeiter);

      while (valid == TRUE)
	{
	  /* Walk through the list, reading each row.
	   */
	  /* Make sure to terminate calls to gtk_tree_model_get()
	   * with a '-1' value.
	   */
	  gtk_tree_model_get (model, &treeiter, 
			      COLUMN_MNM_PIXBUF, &pixbuf,
			      -1);
	  
	  /* Unref the pixbuf that was gotten from previous call.
	   */
	  g_object_unref (G_OBJECT (pixbuf));
	  
	  count++;
	  
	  valid = gtk_tree_model_iter_next (model, &treeiter);
	}
      
      /* Now that we have made the necessary with all the items, we 
       * can remove them from the list in a single step:
       */
      gtk_list_store_clear (GTK_LIST_STORE (model));
    }


  /*
    debug_printf (("number of items removed: %d\n", count));
  */


  /* Parse the find sequence entry into an array of monomers ******
   */
  find_monomer_GPA = g_object_get_data (G_OBJECT (window),
					"find_monomer_GPA");
  g_assert (find_monomer_GPA != NULL);
      
  /* We have to ensure that this array is empty !
   */
  pxmchem_monomer_GPA_empty (find_monomer_GPA);
  
  /* And now we can fill it with monomers parsed off the textview
     text. So get the text out of the textview first.
  */
  textview = g_object_get_data (G_OBJECT (window),
				"find_sequence_textview");
  g_assert (textview != NULL);
  
  buffer = gtk_text_view_get_buffer (textview);

  gtk_text_buffer_get_start_iter (buffer, &text_iter_start);
  gtk_text_buffer_get_end_iter (buffer, &text_iter_end);

  find_sequence_text = gtk_text_buffer_get_text (buffer,
						 &text_iter_start,
						 &text_iter_end,
						 FALSE);
  
  count = pxmchem_monomer_fill_array_from_string (find_monomer_GPA, 
						  find_sequence_text, 
						  codelen,
						  polchemdef->monomerGPA, FALSE);
  if (-1 == count)
    {
      g_critical ("%s@%d: failed filling monomer array from string "
	     "of codes: %s\n",
	     __FILE__, __LINE__, find_sequence_text);
      
      return;
    }

  count = 0;
  
  /* OK, at this point, we do have an array of monomer objects corresponding
     to the sequence that is listed in the find sequence textview. What we
     have to do now is to create the visual display of that sequence using 
     pixbuf objects displayed in the find sequence treeview.
  */
  for (iter = 0 ; iter < find_monomer_GPA->len ; iter++)
    {
      /* Acquire an iterator.
       */
      gtk_list_store_append (GTK_LIST_STORE (model), &treeiter);
      
      monomer = g_ptr_array_index (find_monomer_GPA, iter);
      g_assert (monomer != NULL);
      
      /* We now have to get a pointer to the monomer's monicon's
       * pixbuf.
       */
      pixbuf = 
	polyxedit_rendering_pixbuf_get_from_data_list (monomer->code,
						       NULL,
						       editctxt);
      
      if (pixbuf != NULL)
	{
	  /* We should refcount this instance.
	   */
	  g_object_ref (G_OBJECT (pixbuf));
	}
      
      if (pixbuf == NULL)
	{
	  pixbuf = 
	    polyxedit_rendering_pixbuf_render_no_modif (monomer->code,
							seqeditorctxt->
							monicon_size,
							editctxt);
	  if (pixbuf != NULL)
	    {
	      /* Let the polymer definition context know that we
	       * have rendered the pixbuf for the monomer 'code'.
	       * Note that we just created a pixbuf from nothing
	       * and it was created by a reference count of 1, so
	       * we do not need to do anything.
	       */
	      polyxedit_rendering_pixbuf_set_to_data_list (pixbuf, 
							   monomer->code,
							   NULL, 
							   editctxt);
	    }
	  else
	    {
	      g_error (_("%s@%d: failed rendering pixbuf for code: %s\n"),
		     __FILE__, __LINE__, monomer->code);
	    }
	}
      
      gtk_list_store_set (GTK_LIST_STORE (model), &treeiter,
			  
			  COLUMN_MNM_PIXBUF,
			  pixbuf,
			  
			  -1);
      count++;
    }
  
  return;
}

void 
polyxedit_findrep_opt_find_anywhere_button (GtkWidget *button,
					    gpointer data)
{
  debug_printf (("polyxedit_findrep_opt_find_anywhere_button\n"));
}

void 
polyxedit_findrep_opt_find_button (GtkWidget *button,
				   gpointer data)
{
  
}

void 
polyxedit_findrep_opt_find_results_prop_button (GtkWidget *button,
						gpointer data)
{
  
}

void 
polyxedit_findrep_opt_repl_button (GtkWidget *button,
				   gpointer data)
{
  
}

void 
polyxedit_findrep_opt_repl_results_prop_button (GtkWidget *button,
						gpointer data)
{
  
}





gboolean
polyxedit_findrep_opt_wnd_delete_event (GtkWidget *window, 
					GdkEventAny *event, 
					gpointer data)
{
  gint count = 0;

  /* Do not forget to free the arrays find_monomer_GPA and
     repl_monomer_GPA.
  */

  /* 
     Prior to closing the window, we want to make sure that no
     pending timed-out messages are there...
  */
  count = polyxmass_timeoutmsg_messages_remove ((GtkWindow *) window);
  
  /*
    printf ("polyxedit_findrep_opt_wnd_delete_event, count is %d\n",
    count);
  */
  
  return FALSE;
}

  
