from util import *
from operator import *
import specs
import patterns
from futil import reads_from, writes_to
from walk import instance2individuals
from pconf import conf_mappings
from gen import get_collabs, builder

""" Post processing to assign pattern information
to the resources that are participants"""

def invoke_extending_super ():
     """Handler for cgi pattern"""
     cgis = PRGM.pattern_instances['RecogCGI']
     for cgi in cgis:
         individuals = instance2individuals(cgi)
         for ind in individuals:
             if extending_super_capabilities(ind):
                p = ind[3]
                u_and_r = user_and_role(p.security_context)
                ty = PRGM.name_for_type + '_cgi_t'
                p.security_context = u_and_r + ':' + ty
                bfile_context = u_and_r + 'polgen_temp_exec_t'
                p.assoc_binary_file.security_context = bfile_context
                p.assoc_binary_file.original_context = bfile_context
 

                              
def extending_super_capabilities (ind_list):
    """ written for cgi scripts may need to extend"""
    toreturn = 0
    process = ind_list[3]
    super = ind_list[0]
    super_from = seq2set([x.security_context for x in reads_from(super)])
    super_to = seq2set([x.security_context for x in writes_to(super)])
    p_from = seq2set([x.security_context for x in reads_from(process)])
    p_to = seq2set([x.security_context for x in writes_to(process)])
    from_diff = setdiff(p_from, super_from)
    to_diff = setdiff(p_to, super_to)
    if len(from_diff) > 0 or len(to_diff) > 0:
             toreturn = 1
    return toreturn

def do_recognition ():
    """ Runs recognizer - enforces ordering"""
    print 'RecogCGI'
    recover('RecogCGI')
    invoke_extending_super()
    for item in specs.SPECIFIERS:
        if item.__name__ == 'RecogCGI':
            continue
        else:
            print item.__name__
            recover(item.__name__)

def rebuild (specStr, do_create_finder = 1, do_propagate_to_classes = 1):
    """ Generates a new version of the spec's finder and reloads the module"""
    specObj = eval("specs." + specStr)
    #print specObj
    for pre in specObj.prerequisites:
        #print pre.__name__ + " prerequisite"
        for recogname in [x.__name__ for x in specs.SPECIFIERS if x.pattern == pre]:
            print "    Checking " + recogname
            if recogname not in get_current_program().pattern_instances.keys():
                rebuild(recogname, 0, 0)
    if do_create_finder:
        builder(specObj)
    mod = __import__(specStr)
    reload(mod)
    found = mod.finder()
    return found

def recover (str):
    return rebuild(str, 0)

def adjust_contexts ():
    for p in [x for x in resources_dict.values() if the_type(x) == 'Process']:
        for r in p.roles:
            patobj = r[0]
            part = r[1]
            if patobj.gen_resource_types == part:
                p.type_contributors.append(patobj.name.lower())
    ### Now determine best assignment for security context of non-process resources"""
    res = resources_dict.values()
    for r in res:
        if r.__class__.__name__ not in ["Process", "Fifo_file"]:
            #r is not a process
            status = r.context_assignment_status
            if status != "none":
                connections_dict = {'out': flatten([t.meanings for t in r.out_edges]), \
                           'in' : flatten([t.meanings for t in r.in_edges])}
                context = r.get_sc()
                u_and_r = user_and_role(context)
                if len(connections_dict.values()) > 0:
                    #may need to change security_context
                    #print "Adjusting context for " + r.name
                    type_info = get_type_from_meanings(connections_dict)
                    contributors = type_info[0]
                    multiples = type_info[1]
                    if contributors != None:
                        new_type = get_name_from_patterns (contributors, multiples)
                        PRGM.new_contexts.append([r, new_type])
                        if status == "default":
                            r.context_assignment_status = "new"

                        elif status in ["external", "new", "problematic"]:
                            r.context_assignment_status = "problematic"
                            r.original_context = r.get_sc()

                        #print contributors
                        r.type_contributors = seq2set(r.type_contributors + contributors)
        sc = r.get_sc()
        if sc in ['???', 'tbd']:
            #print r
            possible = []
            for item in conf_mappings:
                #print item
                if r.name.find(item[0]) != -1: # contains proc
                    if r.name.find(item[1]) != -1:
                        possible.append(item)
                if len(possible) != 0:
                    max = 0
                    ans = ""
                    for p in possible:
                        if len(p[1]) > max:
                            max = len(p[1])
                            ans = p[2]
                    r.set_sc(ans, 'default')
                    r.context_assignment_status = "new"
                    r.original_context = ans


def merge_contexts (string1, string2):
    """ string concatenation """
    if string2 == "":
        return string1
    return  string1 + "-&-" + string2

def get_type_from_meanings (meanings_dict):
    """meanings_dict is a dictionary with directionality keys all wrt a holder"""
    toreturn = None
    #Three cases resource->process
    #           process->resource
    #           process->resource_>process
    #Are there matching pairs?
    ans = [] # a sequence of strings
    multiples = 0
    for item1 in meanings_dict['out']:
        if item1.detection != 'violator':
            pat = item1.pattern
            asserts = patterns.pattern_asserts_types(pat)
            if asserts in ['individual', 'one_only']:
                if asserts == 'individual':
                    multiples = 1
                ty = item1.range_type
                done = 0
                for item2 in meanings_dict['in']:
                    item2.used = 0
                    pat2 = item2.pattern
                    #print item2.domain
                    ty2 = item2.domain_type
                    if pat == pat2 and ty == ty2:
                        #these go together
                        ans.append(pat.lower())
                        done = 1
                        item2.used = 1
                        break
                if not done:
                    #pattern with resource writing only
                    ans.append(pat.lower())
    #now need to do out links that are not covered
    for item2 in meanings_dict['in']:
        if item2.used == 0 and item2.detection != 'violator':
            #hasn't been used
            in_asserts = patterns.pattern_asserts_types(item2.pattern)
            if in_asserts in ['individual', 'one_only']:
                ans.append(item2.pattern.lower())
                if in_asserts == 'individual':
                    multiples = 1
    #remove duplicates
    if len(ans) == 0:
        return [toreturn, multiples]
    return [[x.lower() for x in ans], multiples]

def get_name_from_patterns (ans, multiples):
    """Used for resources that participate in multiple pattern types"""
    seen = []
    final =  PRGM.name_for_type + "_"
    for x in ans:
        if x not in seen:
            seen.append(x)
            final = final + x + '_'
    return final[0:-1] + '_t'

