from patterns import *

class MacroTemplate:
    def __init__(self, parent, name, roles, doc = ""):
        self.parent = parent # back pointer to the pattern
        self.name = name
        self.roles = roles

def add_templates ():
    for str in PATTERN_TYPES:
        pat = eval(str)
        pat.template = MacroTemplate(pat, pat.pat2macro(), pat.participants)

CanCheckSelinux.template = MacroTemplate(CanCheckSelinux, \
                                         'can_check_selinux',  ['main'],\
         """Macro for allowing a program to check is_selinux_enabled().
         Macro itself needs to be written. Generally want to allow this.
         Characterized by main wanting to read /proc/filesystems and
         /proc/self/attr/current.""")
