#!/usr/bin/env python

from util import *

if not PRGM.no_gui:
	import pygtk
	pygtk.require('2.0')
	import gtk
        import gobject
import specs

import config

import fc
import os, os.path

import fixer
import textentry


MAX_WINDOW_Y_SIZE=650

class SparHelp:

    def destroy(self, widget, data=None):
        widget.destroy()

    def __init__(self):
        self.init_gui()
    def init_gui(self):
        # create a new window
        self.window = gtk.Window(gtk.WINDOW_TOPLEVEL)
        #self.window.connect("delete_event", self.delete_event)
    
        # Here we connect the "destroy" event to a signal handler.  
        # This event occurs when we call gtk_widget_destroy() on the window,
        # or if we return 0 in the "delete_event" callback.
        self.window.connect("destroy", self.destroy)
        self.button = gtk.Button("""Using this interface you can modify the specifications for te and fc files generated by Polgen's Spar module.
        1. First you can accept or reject Spar assertions about patterns of interactions.  In some cases, Spar creates new types to
        enforce constraints associated with patterns.
        2. Next you will be able to set up and provide your own name for groups of processes.  The notion is that you may want to establish new
        types for all files read or modified by processes in a group.
        3. The next step will be for you to verify Spar's type assignments based on your input. You will be able to select a group or pattern
        designation for a type or return to an original type.  The default is to apply pattern and group constraints for typegen-created types
        and to use an original type for others.  If you override one of these original types, Polgen will ask for confirmation. 
        4. The final step is to set the directory level for all files with a new type.""")
 

    
        # This will cause the window to be destroyed by calling
        # gtk_widget_destroy(window) when "clicked".  Again, the destroy
        # signal could come from here, or the window manager.
        self.button.connect_object("clicked", gtk.Widget.destroy, self.window)
        self.window.add(self.button)
        self.button.show()
        self.window.show()




class TopLevel:

    def help(self, window):
        SparHelp()

    def when_done(self, window):
        PRGM.unconfined_domain = self.domain_options[self.choice.get_active()]
        files = [f for f in resources_dict.values() if \
                       f.__class__.__name__ == 'File' and \
                       len(f.type_contributors) != 0]
        files2check = fc.files_for_checking(files)
        if len(files2check) != 0:
               app = fc.SetFileContext("Select Types", files2check)
               window.destroy()
        else:
            fc.end_session(self)

    def callback(self, button_pressed, data = None):
        id = data
        #print id
        if id == 'opt':
            Options()
        elif id == 'ppr':
            AcceptPatternAssertions([[p.uid, p.print_form, p.treat_as] \
                                    for p in self.pattern_assertions])

        elif id == 'sig':
            if PRGM.unlimited_typing == 1:
                SetIntegrityGroups()
            else:
                print "adding new types is restricted"

    def __init__(self, pattern_assertions):
        self.init_gui(pattern_assertions)
            
    def init_gui(self, pattern_assertions):
        self.window = gtk.Window(gtk.WINDOW_TOPLEVEL)
        self.window.set_title("Polgen Policy Generation")
        self.window.set_border_width(30)
        #self.window.set_position(gtk.WIN_POS_MOUSE)
        self.window.modify_bg(gtk.STATE_NORMAL, gtk.gdk.Color(30000, 65000, 50000)) 
        #self.window.set_size_request(600, 300)
        self.pattern_assertions = pattern_assertions
        box1 = gtk.VBox(0, 0)
        self.window.add(box1)
        box1.show()
        create_button(self, box1, "Help", self.help)
        box2 = gtk.VBox(0, 10)
        box2.set_border_width(10)
        box1.pack_start(box2, 0, 0, 0)
        box2.show()

        actions = {"ppr": 'Confirm Recognized Patterns', 
                  
                   
                   "sig": "Create Information Flow Groups"
                  }
        #print actions.keys()
        for a in actions.keys():
            button = gtk.CheckButton(actions[a])
            button.connect("toggled", self.callback, a)
            box2.pack_start(button, 1, 1, 0)
            button.show()
        separator = gtk.HSeparator()
        box2.pack_start(separator, 0, 1, 0)
        separator.show()

        button = gtk.CheckButton('Options')
        button.connect("toggled", self.callback, 'opt')
        box2.pack_start(button, 1, 1, 0)
        button.show()
        

        separator = gtk.HSeparator()
        box1.pack_start(separator, 0, 1, 0)
        separator.show()


        separator = gtk.HSeparator()
        box1.pack_start(separator, 0, 1, 0)
        separator.show()
 

        box3 = gtk.HBox(0, 10)
        box3.set_border_width(10)
        label = gtk.Label('Replace "unconfined_t"?')
        box3.pack_start(label, 0, 0, 0)
        label.show()
        opt = gtk.combo_box_new_text()
        self.choice = opt
        self.domain_options = ['unconfined_t', 'sysadm_t', 'usr_t', 'staff_t']
        count = 0
        for choice in self.domain_options:
            count = count + 1
            opt.insert_text(count, choice)
            opt.set_active(0)
        box3.pack_start(opt, 1, 1, 0)
        opt.show()

        box1.pack_start(box3, 1, 1, 0)
        box3.show()

        separator = gtk.HSeparator()
        box1.pack_start(separator, 0, 1, 0)
        separator.show()

        
        create_button(self, box1, "All modifications completed; Do te and fc generation", self.when_done)
        self.window.show()
     

def create_button (top, box1, label, callback):
        box2 = gtk.HBox(0, 10) 
        #box2.set_border_width(10)
        box1.pack_start(box2, 0, 1, 0)
        box2.show()

        button = gtk.Button(label)
        button.connect_object("clicked", callback, top.window)

        box2.pack_start(button, 0, 1, 0)
        button.set_flags(gtk.CAN_DEFAULT)
        button.grab_default()
        button.show()

class Options:
    
    def when_done(self, window):
        window.destroy()
        
    def callback(self, widget, data = None):
        val = 1
        if widget.get_active():
            val = 0
        print data
        setattr(PRGM, data, val)
        
    def __init__(self):
        self.window = gtk.Dialog() 
        self.window.set_title("Processing Options")
        self.window.set_border_width(0)
        scrolled_window = gtk.ScrolledWindow()
        scrolled_window.set_border_width(10)
        scrolled_window.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_ALWAYS)
        self.window.vbox.pack_start(scrolled_window, 1, 1, 0)
        self.window.set_size_request(600, 300)
        scrolled_window.show()
        box1 = gtk.VBox(0, 0)
        scrolled_window.add_with_viewport(box1)
        box1.show()
  
        box2 = gtk.VBox(0, 10)
        box2.set_border_width(10)
        box1.pack_start(box2, 0, 1, 0)
        box2.show()

        options = {'outsiders_mutable' : 'Changing external types is never allowed', \
##                  'no_directory_constraints' : 'All files in a given directory must have the same type', \
                  'unlimited_typing' : 'Minimize the number of new types created'}
        for k in options.keys():
            button = gtk.CheckButton(options[k])
            activep = 0
            if getattr(PRGM, k) == 0:
                activep = 1
            button.set_active(activep)
            button.connect("toggled", self.callback, k)
            box2.pack_start(button, 1, 1, 0)
            button.show()

        separator = gtk.HSeparator()
        box1.pack_start(separator, 0, 1, 0)
        separator.show()

        box2 = gtk.HBox(0, 10)
        box2.set_border_width(10)
        box1.pack_start(box2, 0, 1, 0)
        box2.show()

        button = gtk.Button("Done")
        button.connect_object("clicked", self.when_done, self.window)
        box2.pack_start(button, 0, 1, 0)
        button.set_flags(gtk.CAN_DEFAULT)
        button.grab_default()
        button.show()

        self.window.show()

        
class AcceptPatternAssertions:
    def callback(self, widget, data=None):
        fixer.set_active_valueCB(data, ("OFF", "ON")[widget.get_active()])

    def when_done(self, window):
        fixer.adjust_pattern_list_finalCB()
        window.destroy()
        
    def help(self, window):
          url =  config.results_directory + '/home.html'
          url = os.path.abspath(url)
          mozilla_loc = 'mozilla'
          ie_loc = 'C:\Program Files\Internet Explorer\iexplore.exe'
          command =  mozilla_loc + " -remote 'openurl(file:" + url + ")'"
          if PRGM.platform == 'windows':
              os.spawnv(1, ie_loc, ['foo', url])
          else:
              os.system(command)

    def close_application(self, widget, event, data=None):
        gtk.main_quit()
        return 0

    def __init__(self, pattern_assertions):
        self.pattern_assertions = pattern_assertions
        self.answers = {}
        for p in pattern_assertions:
            self.answers[p[0]] = 1
        self.init_gui(pattern_assertions)
            
    def init_gui(self, pattern_assertions):
        self.window = gtk.Dialog() 
        self.window.set_title("Confirm Recognized Patterns")
        self.window.set_border_width(0)
        ysz = 1000
        nbr = len(pattern_assertions)
        if 0==nbr:
            return
        if nbr < 6:
            ysz = 80 * nbr
        self.window.set_size_request(600, min(MAX_WINDOW_Y_SIZE,ysz))

        scrolled_window = gtk.ScrolledWindow()
        scrolled_window.set_border_width(10)
        scrolled_window.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_ALWAYS)
        self.window.vbox.pack_start(scrolled_window, 1, 1, 0)
        scrolled_window.show()

        self.window.connect("delete_event", self.close_application)


        self.window.set_border_width(0)

        box1 = gtk.VBox(0, 0)
        scrolled_window.add_with_viewport(box1)
        box1.show()
        create_button(self, box1, "Help", self.help)
        box2 = gtk.VBox(0, 10)
        box2.set_border_width(10)
        box1.pack_start(box2, 0, 1, 0)
        box2.show()

        for p in pattern_assertions:
            pp = p[1].replace('_', '__')
            button = gtk.CheckButton(p[0] + ": " + p[2].name + ": " + pp)
            activep = 1
            if p[2] in [specs.Violator, specs.OutOfScope]: # working with a violator pattern
                activep = 0
            button.set_active(activep)
            button.connect("toggled", self.callback, p[0])
            box2.pack_start(button, 1, 1, 0)
            button.show()

        separator = gtk.HSeparator()
        box1.pack_start(separator, 0, 1, 0)
        separator.show()

 
        box2 = gtk.HBox(0, 10)
        box2.set_border_width(10)
        box1.pack_start(box2, 0, 1, 0)
        box2.show()

        button = gtk.Button("Done")
        button.connect_object("clicked", self.when_done, self.window)
        box2.pack_start(button, 0, 1, 0)
        button.set_flags(gtk.CAN_DEFAULT)
        button.grab_default()
        button.show()

        self.window.show()

class SetGroupInteractions:

    def done (self, the_done_button = None):
        count = 0
        for g in self.groups:
            item = self.choices[g]
            fixer.set_file_contextsCB(g, self.options[item.get_active()])
        self.window.destroy()
        textentry.GroupName(self.groups)

    def __init__(self, groups):
        self.choices = {}
        self.groups = groups
        self.options = ['ignore', 'ALL files read', 'ALL files modified', \
                        'ALL files read or modified']
        self.init_gui(groups)
        
    def init_gui(self,groups):
        self.window = gtk.Window (gtk.WINDOW_TOPLEVEL)
        self.window.set_title("Set Type for Files Read or Modified")
        ysz = 700
        nbr = len(groups)
        if 0==nbr:
            return
        if nbr < 6:
            ysz = (80 * nbr) + 60
        self.window.set_size_request(400, min(MAX_WINDOW_Y_SIZE,ysz))
  
        box1 = gtk.VBox(0, 0)
        self.window.add(box1)
        box1.show()

        box2 = gtk.HBox(0, 10)
        self.box2 = box2

        box1.pack_start(box2, 1, 1, 0)
        box2.show()
   
        for g in groups:
            box2 = gtk.HBox(0, 10)
            box2.set_border_width(10)
            label = gtk.Label(g)
            box2.pack_start(label, 0, 0, 0)
            label.show()
            opt = gtk.combo_box_new_text()
            self.choices[g] = opt
            count = 1
            for choice in self.options:
                opt.insert_text(count, choice)
                opt.set_active(0)
                count = count + 1
            box2.pack_start(opt, 1, 1, 0)
            opt.show()

            box1.pack_start(box2, 1, 1, 0)
            box2.show()
            
        box2 = gtk.HBox(0, 10)
        box1.pack_start(box2, 0, 1, 0)
        box2.show()

        button = gtk.Button("Done")
        button.connect("clicked", self.done)
        box2.pack_start(button, 0, 1, 0)
        button.set_flags(gtk.CAN_DEFAULT)
        button.grab_default()
        button.show()
        self.window.show()

class SetIntegrityGroups:

    def when_done(self, window):
        processes = [x for x in resources_dict.values() \
                     if x.__class__.__name__ == 'Process']
        groups = []
        for p in processes:
            group = self.options[self.answers[p.name].get_active()]
            if group != 'n/a':
                groups.append(group)
                fixer.set_integrity_groupCB(p.name, group)
        window.destroy()
        SetGroupInteractions(seq2set(groups))

    def help(self, window):
          url =  config.results_directory + '/home.html'
          url = os.path.abspath(url)
          mozilla_loc = 'mozilla'
          ie_loc = 'C:\Program Files\Internet Explorer\iexplore.exe'
          command =  mozilla_loc + " -remote 'openurl(file:" + url + ")'"
          if PRGM.platform == 'windows':
              os.spawnv(1, ie_loc, ['foo', url])
          else:
              os.system(command)

    def __init__(self):
        self.answers = {}
        self.options = ['n/a', 'group1', 'group2', 'group3', 'group4', \
                           'group5', 'group6']
        self.init_gui()
        
    def init_gui(self):
        self.window = gtk.Dialog() 
        self.window.set_title("Create Information Flow Groups")
        self.window.set_border_width(0)
        processes = [p for p in resources_dict.values() \
                  if p.__class__.__name__ == 'Process']
        ysz = 700
        nbr = len(processes)
        if 0==nbr:
            return
        if nbr < 6:
            ysz = (120 * nbr) + 40
        self.window.set_size_request(400, min(MAX_WINDOW_Y_SIZE,ysz))       

        scrolled_window = gtk.ScrolledWindow()
        scrolled_window.set_border_width(10)
        scrolled_window.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_ALWAYS)
        self.window.vbox.pack_start(scrolled_window, 1, 1, 0)
        scrolled_window.show()

        box1 = gtk.VBox(0, 10)
        scrolled_window.add_with_viewport(box1)
        box1.show()
        create_button(self, box1, "Help", self.help)
        box2 = gtk.VBox(0, 10)
        #box2.set_border_width(10)
        box1.pack_start(box2, 1, 1, 0)
        box2.show()
        
        box2 = gtk.VBox(0, 10)
        self.box2 = box2
        #box2.set_border_width(10)
        box1.pack_start(box2, 1, 1, 0)
        box2.show()  

        for p in [p for p in resources_dict.values() \
                  if p.__class__.__name__ == 'Process']:
            nbr_in = len([t for t in p.in_edges if t.domain.__class__.__name__ == 'File'])
            nbr_out = len([t for t in p.out_edges if t.range.__class__.__name__ == 'File'])
            nbrstr = " (" + str(nbr_in) + "," + str(nbr_out) + ")"
            box2 = gtk.HBox(0, 10)
            box2.set_border_width(10)
            label = gtk.Label(p.name + nbrstr)
            box2.pack_start(label, 0, 0, 0)
            label.show()
            opt = gtk.combo_box_new_text()
            self.answers[p.name] = opt
            count = 1
            for choice in self.options:
                opt.insert_text(count, choice)
                opt.set_active(0)
                count = count + 1
            box2.pack_start(opt, 1, 1, 0)
            opt.show()
            box1.pack_start(box2, 1, 1, 0)
            box2.show()
        separator = gtk.HSeparator()
        box1.pack_start(separator, 0, 1, 0)
        separator.show()

        box2 = gtk.HBox(0, 10)
        #box2.set_border_width(10)
        box1.pack_start(box2, 0, 1, 0)
        box2.show()


        button = gtk.Button("Done")
        button.connect_object("clicked", self.when_done, self.window)
        box2.pack_start(button, 0, 1, 0)
        button.set_flags(gtk.CAN_DEFAULT)
        button.grab_default()
        button.show()

        self.window.show()

global app
app = None

def get_analyst_input (pattern_assertions, no_gui):
    """ This function kicks off the GUI asking for user interventions """
    if not no_gui:
        global app
        global root
        app = TopLevel(pattern_assertions)
        gtk.main()
    else:
        #need to set default values for security contexts of files
        fixer.adjust_pattern_list_finalCB() # sets up contrib list
        # need something to determine type from contrib list
        fixer.do_policy_generationCB()
        

def main():
    global no_gui
    if not no_gui: gtk.main()
    return 0

if __name__ == "__main__":
    app = TopLevel([])
    main()
