# A test routine that imports a python script generated using the main
# routine it produces.

import sys, types

def main():
    if len(sys.argv) != 2:
	usage()
	sys.exit(1)
    sys.stdout.write('#include <stdio.h>\n')
    sys.stdout.write('#include "pyval.h"\n')
    sys.stdout.write('int main(int argc, char **argv)\n{\n')
    sys.stdout.write('pyval_t val;\n')
    sys.stdout.write('pyval_init("pyval");\n')
    execfile(sys.argv[1])
    sys.stdout.write('return 0;\n}\n')

def usage():
    print "Usage: " + sys.argv[0] + " INPUT"

def pyval(val):
    sys.stdout.write('\nval = ')
    showval(val)
    sys.stdout.write(';\npyval_print(stdout, val, 40);\n')
    sys.stdout.write("putchar('\\n');\n")

def showval(val):
    if isinstance(val, types.StringType):
	showstr(val)
    elif isinstance(val, types.DictType):
	entries = val.items()
	entries.sort()
	entries.reverse()
	showdict(entries)

def showstr(val):
    sys.stdout.write('pyval_string("' + val + '")')

def showdict(items):
    if len(items) == 0:
	sys.stdout.write("pyval_dictionary()")
    else:
	entry = items[0]
	sys.stdout.write('pyval_entry("' + entry[0] + '",\n')
	showval(entry[1])
	sys.stdout.write(',\n')
	showdict(items[1:])
	sys.stdout.write(')')

if __name__ == "__main__":
    main()
