/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.image.png;

import com.sixlegs.image.png.Chunk;
import com.sixlegs.image.png.ChunkHandler;
import com.sixlegs.image.png.Chunk_IDAT;
import com.sixlegs.image.png.Chunk_IEND;
import com.sixlegs.image.png.Chunk_IHDR;
import com.sixlegs.image.png.Chunk_PLTE;
import com.sixlegs.image.png.Chunk_tRNS;
import com.sixlegs.image.png.DummyImageConsumer;
import com.sixlegs.image.png.IDATInputStream;
import com.sixlegs.image.png.Interlacer;
import com.sixlegs.image.png.PixelReader;
import com.sixlegs.image.png.PngException;
import com.sixlegs.image.png.PngExceptionSoft;
import com.sixlegs.image.png.TextChunk;
import com.sixlegs.image.png.UnfilterInputStream;
import com.sixlegs.image.png.UserChunk;
import java.awt.Color;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class PngImage
implements ImageProducer {
    static boolean allFatal = false;
    static final int BUFFER_SIZE = 8192;
    private static boolean progressive = true;
    private static Hashtable prototypes = new Hashtable();
    static final String ASCII_ENCODING = "US-ASCII";
    static final String LATIN1_ENCODING = "8859_1";
    static final String UTF8_ENCODING = "UTF8";
    static final long DEFAULT_GAMMA = 45455L;
    private static double DISPLAY_EXPONENT = 2.2;
    private static double USER_EXPONENT = 1.0;
    public static final int COLOR_TYPE_GRAY = 0;
    public static final int COLOR_TYPE_GRAY_ALPHA = 4;
    public static final int COLOR_TYPE_PALETTE = 3;
    public static final int COLOR_TYPE_RGB = 2;
    public static final int COLOR_TYPE_RGB_ALPHA = 6;
    public static final int INTERLACE_TYPE_NONE = 0;
    public static final int INTERLACE_TYPE_ADAM7 = 1;
    public static final int FILTER_TYPE_BASE = 0;
    public static final int FILTER_TYPE_INTRAPIXEL = 64;
    public static final int COMPRESSION_TYPE_BASE = 0;
    public static final int UNIT_UNKNOWN = 0;
    public static final int UNIT_METER = 1;
    public static final int UNIT_PIXEL = 0;
    public static final int UNIT_MICROMETER = 1;
    public static final int UNIT_RADIAN = 2;
    public static final int SRGB_PERCEPTUAL = 0;
    public static final int SRGB_RELATIVE_COLORIMETRIC = 1;
    public static final int SRGB_SATURATION_PRESERVING = 2;
    public static final int SRGB_ABSOLUTE_COLORIMETRIC = 3;
    Data data;
    private Vector errorList;

    public final void addConsumer(ImageConsumer imageConsumer) {
        if (this.data == null) {
            return;
        }
        if (this.data.consumers.contains(imageConsumer)) {
            return;
        }
        this.data.consumers.addElement(imageConsumer);
    }

    public final boolean isConsumer(ImageConsumer imageConsumer) {
        if (this.data == null) {
            return false;
        }
        return this.data.consumers.contains(imageConsumer);
    }

    public final void removeConsumer(ImageConsumer imageConsumer) {
        if (this.data == null) {
            return;
        }
        this.data.consumers.removeElement(imageConsumer);
    }

    public final void startProduction(ImageConsumer imageConsumer) {
        if (this.data == null) {
            throw new IllegalStateException("Object has been flushed.");
        }
        this.addConsumer(imageConsumer);
        Object[] objectArray = new ImageConsumer[this.data.consumers.size()];
        this.data.consumers.copyInto(objectArray);
        this.produceHelper((ImageConsumer[])objectArray);
    }

    public final void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        if (this.data == null || this.data.pixels == null) {
            return;
        }
        this.startProduction(imageConsumer);
    }

    public static final void setUserExponent(double d) {
        USER_EXPONENT = d;
    }

    public static final void setDisplayExponent(double d) {
        DISPLAY_EXPONENT = d;
    }

    public final boolean hasErrors() {
        if (this.errorList == null) {
            return false;
        }
        boolean bl = false;
        if (this.errorList.size() > 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean hasFatalError() {
        boolean bl = false;
        if (this.hasErrors() && !(this.errorList.elementAt(this.errorList.size() - 1) instanceof PngExceptionSoft)) {
            bl = true;
        }
        return bl;
    }

    public final Enumeration getErrors() {
        return this.errorList.elements();
    }

    public static final void setAllErrorsFatal(boolean bl) {
        allFatal = bl;
    }

    public static final void setProgressiveDisplay(boolean bl) {
        progressive = bl;
    }

    public final Color getBackgroundColor() throws IOException {
        return (Color)this.getProperty("background");
    }

    public final int getWidth() throws IOException {
        this.readToData();
        return this.data.header.width;
    }

    public final int getHeight() throws IOException {
        this.readToData();
        return this.data.header.height;
    }

    public final int getBitDepth() throws IOException {
        this.readToData();
        return this.data.header.depth;
    }

    public final int getInterlaceType() throws IOException {
        this.readToData();
        return this.data.header.interlace;
    }

    public final int getColorType() throws IOException {
        this.readToData();
        return this.data.header.colorType;
    }

    public final boolean hasAlphaChannel() throws IOException {
        this.readToData();
        return this.data.header.alphaUsed;
    }

    public final boolean isGrayscale() throws IOException {
        this.readToData();
        return this.data.header.colorUsed ^ true;
    }

    public final boolean isIndexedColor() throws IOException {
        this.readToData();
        return this.data.header.paletteUsed;
    }

    public final Object getProperty(String string) throws IOException {
        this.readToData();
        return this.data.properties.get(string);
    }

    public final Enumeration getProperties() throws IOException {
        this.readToData();
        return this.data.properties.keys();
    }

    public final void getEverything() {
        this.startProduction(new DummyImageConsumer());
    }

    public final void getEverything(boolean bl) throws IOException {
        this.startProduction(new DummyImageConsumer());
        if (this.hasFatalError()) {
            throw (IOException)this.errorList.elementAt(this.errorList.size() - 1);
        }
    }

    public final boolean hasChunk(String string) throws IOException {
        this.readToData();
        boolean bl = false;
        if (this.data.chunks.get(new Integer(Chunk.stringToType(string))) != null) {
            bl = true;
        }
        return bl;
    }

    public static final void registerChunk(ChunkHandler chunkHandler, String string) throws PngException {
        if (string.length() < 4) {
            throw new PngException("Invalid chunk type length.");
        }
        int n = Chunk.stringToType(string);
        if (prototypes.containsKey(new Integer(n))) {
            throw new PngException("Chunk type already registered.");
        }
        if ((n & 0x20000000) == 0) {
            throw new PngException("Chunk must be ancillary.");
        }
        PngImage.registerChunk(new UserChunk(chunkHandler, n));
    }

    public final Enumeration getSuggestedPalettes() throws IOException {
        this.readToData();
        return this.data.palettes.keys();
    }

    public final int[][] getSuggestedPalette(String string) throws IOException {
        this.readToData();
        return (int[][])this.data.palettes.get(string);
    }

    public final TextChunk getTextChunk(String string) throws IOException {
        this.readToData();
        return (TextChunk)this.data.textChunks.get(string);
    }

    public final Enumeration getTextChunks() throws IOException {
        this.readToData();
        return this.data.textChunks.elements();
    }

    public final Enumeration getGifExtensions() throws IOException {
        this.readToData();
        return this.data.gifExtensions.elements();
    }

    public final void setFlushAfterNextProduction(boolean bl) {
        this.data.useFlush = bl;
    }

    public final void setBuffer(int[] nArray) throws IOException {
        if (this.data == null) {
            throw new IllegalStateException("Object has been flushed.");
        }
        int n = this.getWidth() * this.getHeight();
        if (nArray.length < n) {
            throw new IllegalArgumentException("Buffer size must be at least " + n + " (W * H)");
        }
        this.data.pixels = nArray;
    }

    private final void flush() {
        if (this.data != null) {
            try {
                if (this.data.close) {
                    this.data.in_idat.close();
                }
            }
            catch (IOException iOException) {}
            this.data = null;
        }
    }

    private final synchronized void readToData() throws IOException {
        try {
            if (this.data == null) {
                throw new EOFException("Object has been flushed.");
            }
            this.data.in_idat.readToData();
        }
        catch (PngException pngException) {
            this.addError(pngException);
            throw pngException;
        }
    }

    private static final void registerChunk(Chunk chunk) {
        prototypes.put(new Integer(chunk.type), chunk);
    }

    static final Chunk getRegisteredChunk(int n) {
        Integer n2 = new Integer(n);
        if (prototypes.containsKey(n2)) {
            return ((Chunk)prototypes.get(n2)).copy();
        }
        try {
            String string = "com.sixlegs.image.png.Chunk_" + Chunk.typeToString(n);
            PngImage.registerChunk((Chunk)Class.forName(string).newInstance());
            return PngImage.getRegisteredChunk(n);
        }
        catch (Exception exception) {
            return new Chunk(n);
        }
    }

    final Chunk getChunk(int n) {
        return (Chunk)this.data.chunks.get(new Integer(n));
    }

    final void putChunk(int n, Chunk chunk) {
        this.data.chunks.put(new Integer(n), chunk);
    }

    final void addError(IOException iOException) {
        if (this.errorList == null) {
            this.errorList = new Vector();
        }
        this.errorList.addElement(iOException);
    }

    final void fillGammaTable() {
        try {
            long l = (Long)this.getProperty("gamma");
            int n = this.data.header.paletteUsed ? 255 : (1 << this.data.header.outputDepth) - 1;
            double d = USER_EXPONENT * 100000.0 / ((double)l * DISPLAY_EXPONENT);
            int n2 = 0;
            while (n2 <= n) {
                int n3 = (int)(Math.pow((double)n2 / (double)n, d) * 255.0);
                this.data.gammaTable[n2] = !this.data.header.colorUsed ? n3 | n3 << 8 | n3 << 16 : n3;
                ++n2;
            }
            if (this.data.palette != null) {
                this.data.palette.calculate();
            }
        }
        catch (IOException iOException) {}
    }

    /*
     * Unable to fully structure code
     */
    private final synchronized void produceHelper(ImageConsumer[] var1_1) {
        block10: {
            try {
                this.readToData();
                var2_2 = 0;
                while (var2_2 < var1_1.length) {
                    var1_1[var2_2].setDimensions(this.data.header.width, this.data.header.height);
                    var1_1[var2_2].setProperties(this.data.properties);
                    var1_1[var2_2].setColorModel(this.data.header.model);
                    if (this.data.produceFailed) {
                        var1_1[var2_2].imageComplete(1);
                    }
                    ++var2_2;
                }
                if (this.data.produceFailed) {
                    return;
                }
                if (!this.data.produced) {
                    this.firstProduction(var1_1);
                } else {
                    this.setHints(var1_1);
                    var2_2 = 0;
                    while (var2_2 < var1_1.length) {
                        var1_1[var2_2].setPixels(0, 0, this.data.header.width, this.data.header.height, this.data.header.model, this.data.pixels, 0, this.data.header.width);
                        var1_1[var2_2].imageComplete(3);
                        ++var2_2;
                    }
                }
                break block10;
            }
            catch (IOException var2_3) {
                this.data.produceFailed = true;
                this.addError(var2_3);
                var3_4 = 0;
                ** while (var3_4 < var1_1.length)
            }
lbl-1000:
            // 1 sources

            {
                var1_1[var3_4].imageComplete(1);
                ++var3_4;
                continue;
            }
        }
        if (this.data.useFlush) {
            this.flush();
        }
    }

    private final void firstProduction(ImageConsumer[] imageConsumerArray) throws IOException {
        this.data.produced = true;
        UnfilterInputStream unfilterInputStream = new UnfilterInputStream(this, this.data.in_idat);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(unfilterInputStream, 8192);
        PixelReader pixelReader = new PixelReader(this, bufferedInputStream);
        this.setHints(imageConsumerArray);
        if (this.data.header.interlace == 0) {
            this.produceNonInterlaced(imageConsumerArray, pixelReader);
        } else {
            this.produceInterlaced(imageConsumerArray, pixelReader);
        }
        int n = 0;
        while (n < imageConsumerArray.length) {
            imageConsumerArray[n].imageComplete(3);
            ++n;
        }
    }

    private final void setHints(ImageConsumer[] imageConsumerArray) {
        int n = 0;
        while (n < imageConsumerArray.length) {
            if (progressive && this.data.pixels == null && this.data.header.interlace != 0) {
                imageConsumerArray[n].setHints(1);
            } else {
                imageConsumerArray[n].setHints(30);
            }
            ++n;
        }
    }

    private final void produceNonInterlaced(ImageConsumer[] imageConsumerArray, PixelReader pixelReader) throws IOException {
        int n = this.data.header.width;
        int n2 = this.data.header.height;
        if (!this.data.useFlush && this.data.pixels == null) {
            this.data.pixels = new int[n * n2];
        }
        int[] nArray = new int[n + 8];
        int n3 = n;
        int n4 = n % pixelReader.fillSize;
        if (n4 > 0) {
            n3 += pixelReader.fillSize - n4;
        }
        int n5 = 0;
        while (n5 < n2) {
            pixelReader.read(nArray, 0, n3);
            if (this.data.pixels != null) {
                System.arraycopy(nArray, 0, this.data.pixels, n * n5, n);
            }
            int n6 = 0;
            while (n6 < imageConsumerArray.length) {
                imageConsumerArray[n6].setPixels(0, n5, n, 1, this.data.header.model, nArray, 0, n3);
                ++n6;
            }
            ++n5;
        }
    }

    private final void produceInterlaced(ImageConsumer[] imageConsumerArray, PixelReader pixelReader) throws IOException {
        int n = this.data.header.width;
        int n2 = this.data.header.height;
        if (this.data.pixels == null) {
            this.data.pixels = new int[n * n2];
        }
        int[] nArray = new int[n + 8];
        int n3 = this.data.header.interlacer.numPasses();
        Interlacer interlacer = this.data.header.interlacer;
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            int n6 = interlacer.getPassWidth(n4);
            int n7 = n6 % pixelReader.fillSize;
            if (n7 > 0) {
                n6 += pixelReader.fillSize - n7;
            }
            int n8 = 1;
            if (progressive) {
                n8 = interlacer.getBlockWidth(n4);
            }
            int n9 = n8;
            int n10 = 1;
            if (progressive) {
                n10 = interlacer.getBlockHeight(n4);
            }
            int n11 = n10;
            int n12 = interlacer.getSpacingY(n4);
            int n13 = interlacer.getSpacingX(n4);
            int n14 = n12 * n;
            int n15 = interlacer.getOffsetX(n4);
            int n16 = interlacer.getOffsetY(n4);
            int n17 = n16 * n;
            while (n16 < n2) {
                pixelReader.read(nArray, 0, n6);
                n5 = n15;
                int n18 = 0;
                while (n5 < n) {
                    int n19 = Math.min(n9, n - n5);
                    int n20 = Math.min(n11, n2 - n16);
                    int n21 = n17 + n5;
                    int n22 = nArray[n18++];
                    while (n20-- > 0) {
                        int n23 = n21 + n19;
                        while (n21 < n23) {
                            this.data.pixels[n21++] = n22;
                        }
                        n21 += n - n19;
                    }
                    n5 += n13;
                }
                n17 += n14;
                n16 += n12;
            }
            if (progressive) {
                n5 = 0;
                while (n5 < imageConsumerArray.length) {
                    imageConsumerArray[n5].setPixels(0, 0, n, n2, this.data.header.model, this.data.pixels, 0, n);
                    ++n5;
                }
            }
            ++n4;
        }
        if (!progressive) {
            n4 = 0;
            while (n4 < imageConsumerArray.length) {
                imageConsumerArray[n4].setPixels(0, 0, n, n2, this.data.header.model, this.data.pixels, 0, n);
                ++n4;
            }
        }
    }

    private final /* synthetic */ void this() {
        this.data = new Data();
    }

    public PngImage(String string) throws IOException {
        this(new BufferedInputStream(new FileInputStream(string), 8192));
    }

    public PngImage(URL uRL) throws IOException {
        this(new BufferedInputStream(uRL.openConnection().getInputStream(), 8192));
    }

    public PngImage(InputStream inputStream) {
        this(inputStream, true);
    }

    public PngImage(InputStream inputStream, boolean bl) {
        this.this();
        this.data.close = bl;
        this.data.properties.put("gamma", new Long(45455L));
        this.data.in_idat = new IDATInputStream(this, inputStream, bl);
    }

    static {
        PngImage.registerChunk(new Chunk_IHDR());
        PngImage.registerChunk(new Chunk_PLTE());
        PngImage.registerChunk(new Chunk_IDAT());
        PngImage.registerChunk(new Chunk_IEND());
        PngImage.registerChunk(new Chunk_tRNS());
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    final class Data {
        final Vector consumers;
        final Hashtable chunks;
        int[] pixels;
        boolean produced;
        boolean produceFailed;
        boolean useFlush;
        boolean close;
        IDATInputStream in_idat;
        Chunk_IHDR header;
        Chunk_PLTE palette;
        final int[] gammaTable;
        final Hashtable textChunks;
        final Hashtable properties;
        final Hashtable palettes;
        final Vector gifExtensions;

        private final /* synthetic */ void this() {
            this.consumers = new Vector();
            this.chunks = new Hashtable();
            this.gammaTable = new int[256];
            this.textChunks = new Hashtable();
            this.properties = new Hashtable();
            this.palettes = new Hashtable(1);
            this.gifExtensions = new Vector();
        }

        private Data() {
            this.this();
        }
    }
}

