#!@PYTHON@    

import string
import os
import getopt
import sys
import re
import tempfile
import shutil

prefix='@prefix@'
exec_prefix='@exec_prefix@'
datadir='@datadir@'
libdir="@libdir@"



def interpolate (str):
	str = string.replace (str, '{', '(')
        str = string.replace (str, '}', ')s')
        str = string.replace (str, '$', '%')        
        return str

if prefix <> '@' + 'prefix@':
        exec_prefix = interpolate (exec_prefix) % vars()
        datadir = os.path.join (interpolate (datadir) % vars() , 'pktrace')
        libdir = interpolate (libdir) % vars()

# run from textrace-source dir.

simplify_p = 0
verbose_p = 0
pfa_p = 1
keep_trying_p = 0
# should be installed.
autotrace_bin = 'autotrace'

program_name = 'pktrace'
temp_dir = os.path.join (os.getcwd (), program_name + '.dir' )

keep_temp_dir_p = 0
program_version='@VERSION@'
map_file = ''
trace_file = ''
encoding_file = ''
encoding_string = ''
origdir= os.getcwd ()

if datadir == '@' + "datadir" + "@":
	datadir = os.getcwd ()

sys.path.append (datadir)

import tfm

errorport = sys.stderr

################################################################
# lilylib.py -- options and stuff
# 
# source file of the GNU LilyPond music typesetter

try:
	import gettext
	gettext.bindtextdomain ('pktrace', localedir)
	gettext.textdomain ('pktrace')
	_ = gettext.gettext
except:
	def _ (s):
		return s

def identify ():
	sys.stdout.write ('%s %s\n' % (program_name, program_version))

def warranty ():
	identify ()
	sys.stdout.write ('\n')
	sys.stdout.write (_ ('Copyright (c) %s by' % ' 2001'))
	sys.stdout.write ('\n')
	sys.stdout.write ('  Han-Wen Nienhuys')
	sys.stdout.write ('  Jan Nieuwenhuizen')
	sys.stdout.write ('\n')
	sys.stdout.write (_ (r'''
Distributed under terms of the GNU General Public License. It comes with
NO WARRANTY.'''))
	sys.stdout.write ('\n')

def progress (s):
	errorport.write (s + '\n')

def warning (s):
	progress (_ ("warning: ") + s)
		
def error (s):


	'''Report the error S.  Exit by raising an exception. Please
	do not abuse by trying to catch this error. If you do not want
	a stack trace, write to the output directly.

	RETURN VALUE

	None
	
	'''
	
	progress (_ ("error: ") + s + '\n')
	raise _ ("Exiting ... ")

def getopt_args (opts):
	'''Construct arguments (LONG, SHORT) for getopt from  list of options.'''
	short = ''
	long = []
	for o in opts:
		if o[1]:
			short = short + o[1]
			if o[0]:
				short = short + ':'
		if o[2]:
			l = o[2]
			if o[0]:
				l = l + '='
			long.append (l)
	return (short, long)

def option_help_str (o):
	'''Transform one option description (4-tuple ) into neatly formatted string'''
	sh = '  '	
	if o[1]:
		sh = '-%s' % o[1]

	sep = ' '
	if o[1] and o[2]:
		sep = ','
		
	long = ''
	if o[2]:
		long= '--%s' % o[2]

	arg = ''
	if o[0]:
		if o[2]:
			arg = '='
		arg = arg + o[0]
	return '  ' + sh + sep + long + arg


def options_help_str (opts):
	'''Convert a list of options into a neatly formatted string'''
	w = 0
	strs =[]
	helps = []

	for o in opts:
		s = option_help_str (o)
		strs.append ((s, o[3]))
		if len (s) > w:
			w = len (s)

	str = ''
	for s in strs:
		str = str + '%s%s%s\n' % (s[0], ' ' * (w - len(s[0])  + 3), s[1])
	return str

def help ():
	ls = [(_ ("Usage: %s [OPTION] ... FILE") % program_name),
		('\n\n'),
		(help_summary),
		('\n\n'),
		(_ ("Options:")),
		('\n'),
		(options_help_str (option_definitions)),
		('\n\n'),
		(_ ("Report bugs to %s") % 'hanwen@cs.uu.nl'),
		('\n')]
	map (sys.stdout.write, ls)
	
def setup_temp ():
	"""
	Create a temporary directory, and return its name. 
	"""
	global temp_dir
	if not keep_temp_dir_p:
		temp_dir = tempfile.mktemp (program_name)
	try:
		os.mkdir (temp_dir, 0700)
	except OSError:
		pass

	return temp_dir

def popen (cmd, mode = 'r', ignore_error = 0):
	if verbose_p:
		progress (_ ("Opening pipe  `%s\'") % cmd)
	return os.popen (cmd, mode)

def system (cmd, ignore_error = 0):
	"""Run CMD. If IGNORE_ERROR is set, don't complain when CMD returns non zero.

	RETURN VALUE

	Exit status of CMD
	"""
	
	if verbose_p:
		progress (_ ("Invoking `%s\'") % cmd)
	st = os.system (cmd)
	if st:
		name = re.match ('[ \t]*([^ \t]*)', cmd).group (1)
		msg = name + ': ' + _ ("command exited with value %d") % st
		if ignore_error:
			warning (msg + ' ' + _ ("(ignored)") + ' ')
		else:
			error (msg)

	return st


def cleanup_temp ():
	if not keep_temp_dir_p:
		if verbose_p:
			progress (_ ("Cleaning %s...") % temp_dir)
		shutil.rmtree (temp_dir)


def strip_extension (f, ext):
	(p, e) = os.path.splitext (f)
	if e == ext:
		e = ''
	return p + e


################################################################
# END Library


help_summary = _ ("""Trace one PK font to a PFB font. Example:

   pktrace cmr10

""")

option_definitions = [
	('', 'h', 'help', _ ("This help")),
	('', 'k', 'keep', _ ("Keep all output in directory %s.dir") % program_name),
	('', 'V', 'verbose', _ ("Verbose")),
	('', 'v', 'version', _ ("Print version number")),
	('', 'a', 'pfa', _ ("Generate PFA file (default)")),
	('', 'b', 'pfb', _ ("Generate PFB file")),
	('', '', 'simplify', _("Simplify using pfaedit")),
	('DIR', 'I', 'include', _("Add to path for searching files")),	
	('LIST','', 'glyphs', _('Process only these glyphs. LIST is comma separated')),
	('FILE', '', 'tfmfile' , _("Use FILE for the TFM file")),
	('FILE', 'o', 'output-base', _("Set output file name")), 
	('ENC', 'e', 'encoding', _("Use encoding file ENC")),
	('', '', 'keep-trying', _("Don't stop if autotrace fails")),
	('', 'w', 'warranty', _ ("show warranty and copyright")),
	]



include_dirs = [origdir]
def find_file (nm):
	for d in include_dirs:
		p = os.path.join (d, nm)
		try:
			f = open (p)
			return p
		except IOError:
			pass
	
	p = popen ('kpsewhich %s' % nm).read ()[:-1]

	return p



################################################################
# TRACING.
################################################################

def autotrace_command (fi, fn, opts):
	opts = " " + opts + " --output-format=eps --input-format=pbm "
	cmd = autotrace_bin + opts + " --output-file=char.eps -filter-iterations %d %s  " % (fi,fn)
	return cmd

def run_autotrace  (fi,fn,opts):
	stat = system (autotrace_command (fi,fn,opts), 1)
	return stat

def do_autotrace_best_fi (fn, opts):

	""" Run autotrace, and find the
	best filter-iterations value.
	"""
	fi = 8
	while fi >= 0:
		if run_autotrace (fi, fn, opts) ==0:
			return 0

		fi  = fi -1  

	return 1

def blank_pbm (filename):
	"""
	Kill the contents of a PBM: write 0xFF to the PBM.
	"""
	f = open (filename)
	l = f.readline ()
	length = len (f.read())

	f.close ()
	
	open (filename, 'w').write ('%s\n%s' % (l,'\377' * length))

def do_autotrace_one (pbmfile, id):
	"""
	Run autotrace, first with -background-color, then without.
	"""
	
	status = run_autotrace (9, pbmfile , '-background-color FFFFFF')
	if status <> 0:
		error_file = os.path.join (origdir, 'autotrace-bug-%s.pbm' % id)
		shutil.copy2 (pbmfile, error_file)
		msg = """Autotrace failed on bitmap. Bitmap left in `%s\'
Failed command was:

	%s

Please submit a bugreport to autotrace development.""" % (error_file, autotrace_command (9, error_file, '-background-color FFFFFF'))

		if keep_trying_p:
			warning (msg)
			sys.stderr.write ("\nContinuing trace...\n")
		else:
			msg = msg + '\nRun pktrace with --keep-trying to produce a font anyway\n'
			error (msg)
	else:
		return 1

	status = do_autotrace_best_fi (pbmfile, '-background-color FFFFFF')
	if status <> 0:
		warning ("Failing even  -filter-iterations=0. Skipping character.\n")
		return 0
	else:
		return 1


	
def make_pbm (fontname, outname, char_number):
	""" Extract bitmap from the PK file using `gf2pbm'
	Return FALSE if the glyph is not valid. 
	"""

	status = system ("gf2pbm -n %d -o %s %s" %(char_number, outname, fontname), ignore_error = 1)
	
	return  (status == 0)

def read_encoding (file):
	sys.stderr.write(_("Using encoding file: `%s'\n") % file)
	
	str = open (file).read ()
	str = re.sub ("%.*", '', str)
	str = re.sub ("[\n\t \f]+", ' ', str)
	m = re.search ('/([^ ]+) \[([^\]]+)\] def', str)
	if not m:
		raise 'Encoding file invalid.'
	
	name = m.group(1)	
	cod =m.group( 2)
	cod = re.sub('[ /]+', ' ',cod)
	cods = string.split (cod)

	return (name, cods)



def zip_to_pairs(as):
	r = []
	while as :
		r.append((as[0],  as[1]))
		as = as[2:]
	return r

def unzip_pairs (tups):
	l = []
	while tups:
		l = l + list (tups[0])
		tups = tups[1:]
	return l

def autotrace_path_to_type1_ops (at_file, bitmap_metrics, tfm_wid):
	(size_y, size_x, off_x,off_y)= bitmap_metrics
	ls = open (at_file).readlines ()
	bbox =  (10000,10000,-10000,-10000)

	while ls and ls[0] <> '*u\n':
		ls = ls[1:]

	if ls == []:
		return (bbox, '')

	ls = ls[1:]

	commands = []
	


	while ls[0] <> '*U\n':
		l = ls[0]
		ls = ls[1:]

		toks = string.split (l)

		if len(toks) < 1:
			continue
		cmd= toks[-1]
		args = map (string.atof, toks[:-1])
		args = zip_to_pairs (map (round, args))
		commands.append ((cmd,args))


	expand = {
		'l': 'rlineto',
		'm': 'rmoveto',
		'c': 'rrcurveto',
		'sbw' : 'sbw',
		'f': 'closepath' ,
		}

	cx = 0
	cy = size_y - off_y -1

	# t1asm seems to fuck up when using sbw. Oh well. 
	t1_outline =  '  %d %d hsbw\n' % (- off_x, tfm_wid)
	bbox =  (10000,10000,-10000,-10000)

	for (c,args) in commands[0:]:

		na = []
		for a in args:
			(nx, ny) = a
			if c == 'l' or c == 'c':
				bbox = update_bbox_with_point (bbox, a)
				
			na.append( (nx -cx, ny -cy) )
			(cx, cy) = (nx, ny)

		a = na
		c = expand[c]
		a = map (lambda x: '%d' % int (x),  unzip_pairs (a))

		t1_outline = t1_outline + '  %s %s\n' % (string.join (a),c)

	t1_outline = t1_outline + ' endchar '
	t1_outline = '{\n %s } |- \n' % t1_outline
	
	return (bbox, t1_outline)
	
def read_gf_dims (name, c):
	str = popen ('gf2pbm -n %d -s %s' % (c, name)).read ()
	m = re.search ('size: ([0-9]+)+x([0-9]+), offset: \(([0-9-]+),([0-9-]+)\)', str)

	return tuple (map (string.atoi ,m.groups ()))
		       

	
def autotrace_font (fontname_base, metric, glyphs, encoding, outname):

	base =  gen_pixel_font (fontname_base, metric)

	gf_fontname = base + 'gf'
	t1os = []
	font_bbox =  (10000,10000,-10000,-10000)

	progress ('Tracing bitmaps ... ')

	eps_lines = []

	# for single glyph testing.
	# glyphs = []
	for a in glyphs:
		valid = metric.has_char (a)
		if not valid:
			continue

		valid = make_pbm (gf_fontname, 'char.pbm', a)
		if not valid:
			continue

		(w,h, xo, yo) = read_gf_dims (gf_fontname, a)
			
		if not verbose_p:
			sys.stderr.write('[%d' % a)
			sys.stderr.flush()

		
		success = do_autotrace_one ("char.pbm", '%s-%d' % (fontname_base, a))
		if not success :
			sys.stderr.write ("(skipping character)]")
			sys.stderr.flush ()			
			continue 
		
		if not verbose_p:
			sys.stderr.write(']')
			sys.stderr.flush()

		tw = int (round (metric.get_char (a).width / metric.design_size * 1000))
		
		(bbox, t1o)  = autotrace_path_to_type1_ops ("char.eps",
						    (h, w, xo, yo),
						    tw)

		if t1o == '' :
			continue
		
		font_bbox = update_bbox_with_bbox (font_bbox, bbox)

		t1os.append ('/%s %s ' % (encoding[a] , t1o ))

		
	to_type1 (t1os, font_bbox, fontname_base, outname, encoding)


def ps_encode_encoding (encoding):
	str = ' %d array\n0 1 %d {1 index exch /.notdef put} for\n' % (len (encoding), len(encoding)-1)

	
	for i in range (0, len (encoding)):
		str = str  + 'dup %d /%s put\n' % (i, encoding[i])

	return str
	
 

def to_type1 (outlines, bbox, fontname_base, outname,encoding):
	"""
	Fill in the header template for the font, append charstrings,
	and shove result through t1asm
	"""
	template = r"""%%!PS-AdobeFont-1.0: %(FullName)s %(VVV)s.%(WWW)s
13 dict begin
/FontInfo 16 dict dup begin
/version (%(VVV)s.%(WWW)s) readonly def
/Notice (%(Notice)s) readonly def
/FullName (%(FullName)s) readonly def
/FamilyName (%(FamilyName)s) readonly def
/Weight (%(Weight)s) readonly def
/ItalicAngle %(ItalicAngle)s def
/isFixedPitch %(isFixedPitch)s def
/UnderlinePosition %(UnderlinePosition)s def
/UnderlineThickness %(UnderlineThickness)s def
end readonly def
/FontName /%(FontName)s def
/UniqueID %(UniqueID)s def
/FontType 1 def
/PaintType 0 def 
/FontMatrix [%(xrevscale)f 0 0 %(yrevscale)f 0 0] readonly def
/FontBBox {%(llx)d %(lly)d %(urx)d %(ury)d} readonly def
/Encoding %(Encoding)s readonly def
currentdict end
currentfile eexec
dup /Private 20 dict dup begin
/-|{string currentfile exch readstring pop}executeonly def
/|-{noaccess def}executeonly def
/|{noaccess put}executeonly def
/lenIV 4 def
/password 5839 def
/MinFeature {16 16} |-
/UniqueID %(UniqueID)d def
/BlueValues [] |-
/OtherSubrs [ {} {} {} {} ] |-
/ForceBold false def
/Subrs 1 array
dup 0 { return } |
|-
2 index 
/CharStrings %(CharStringsLen)d dict dup begin
%(CharStrings)s

 
 /.notdef { 0 0 hsbw endchar } |-
end 
end
readonly put
noaccess put
dup/FontName get exch definefont 
pop mark currentfile closefile
cleartomark
"""
## apparently, some fonts end the  file with cleartomark. Don't know why.
	
	vars = { 
		'FontName': '%s' % fontname_base,
		'VVV': '001',
		'WWW': '001',
		'Notice': 'Generated from MetaFont bitmap by pktrace, http://www.cs.uu.nl/~hanwen/pktrace/ ',
		'FullName': '%s' % fontname_base,
		'FamilyName': '%s' % fontname_base,
		'Weight': 'Regular',
		'ItalicAngle': '0',
		'isFixedPitch': 'false',
		'UnderlinePosition': '-100',
		'UnderlineThickness': '50',
		'UniqueID':  0 ,
		'xrevscale': 0.001,
		'yrevscale': 0.001,
		'llx' : bbox[0],
		'lly' : bbox[1],
		'urx' : bbox[2],
		'ury' : bbox[3], 
		'Encoding' : ps_encode_encoding (encoding),
		
		# need one extra entry for .notdef
		'CharStringsLen': len(outlines) + 1,
		'CharStrings': string.join (outlines),
		'CharBBox': '0 0 0 0'
	}

	open ('pktrace.t1asm','w').write (template  % vars)

	opt = ''
	if not verbose_p:
		sys.stderr.write ('\nAssembling font ... ')
		sys.stderr.flush()

	
	if pfa_p:
		opt = '--pfa'
		
	system('t1asm %s pktrace.t1asm %s' % (opt, outname))
	if not verbose_p:
		sys.stderr.write ('\n')

def update_bbox_with_point (bbox, pt):
	(llx,lly,urx,ury) = bbox
	llx = min(pt[0], llx)
	lly = min(pt[1], lly)
	urx = max(pt[0], urx)
	ury = max(pt[1], ury)

	return 	(llx,lly,urx,ury)

def update_bbox_with_bbox (bb, dims):
	(llx,lly,urx,ury) = bb
	llx = min(llx, dims[0])
	lly = min(lly, dims[1])
	urx = max(urx, dims[2])
	ury = max(ury, dims[3])
		
	return (llx,lly,urx,ury) 

def cleanup_font (file):
        """
        run pfaedit to simplify and auto-hint the PFX
        """
	stat = system ("pfaedit -usage > pfv 2>&1", ignore_error = 1)
	if stat <> 0:
		warning ("Command `pfaedit -usage' failed. Not simplifying\n")
		return 0
		
	if re.search ("-script", open ('pfv').read()) == None:
		warning ("pfaedit does not support -script. Install 020215 or later. Not simplifying font")
		return 0

	shutil.copy2 (outname, "before-pfaedit.pfx")
	open ('simplify.pe', 'w').write ('''#!/usr/bin/env pfaedit

Open ($1);
SelectAll ();
Simplify ();
AutoHint ();
Generate ("%s");
Quit (0);
''' % outname)
#	simplify_script = os.path.join (datadir, 'simplify.pe')
	system ("pfaedit -script simplify.pe %s %s" % (file, file))


def getenv (var, default):
	if os.environ.has_key (var):
		return os.environ[var]
	else:
		return default
	
	
def gen_pixel_font (fontname, metric):
	"""
	Generate a GF file  for FONTNAME, such that 1000 points fit on the designsize.
	"""
	base_dpi = 600
	mag = 1

	size = metric.design_size
	
	size_points = size * 1/72.27 * base_dpi
	
	mag = 1000.0 / size_points
	prod = mag * base_dpi
	try:
		f = open ('%s.%dgf' % (fontname, prod))
	except IOError:
		
		os.environ['KPSE_DOT'] = '%s:' % origdir
		os.environ['MFINPUTS'] =  '%s:%s' % (origdir,getenv('MFINPUTS',''))
		os.environ['TFMFONTS'] =  '%s:%s' % (origdir,getenv('TFMINPUTS',''))

		system(r"mf '\mode:=ljfour; mag:=%f; nonstopmode; input %s'" % (mag,fontname))
		log = open ('%s.log' % fontname).read ()
		m = re.search('Output written on %s.([0-9]+)gf' % re.escape (fontname), log)
		prod = string.atoi (m.group (1))

	
	return "%s.%d" % (fontname , prod)

(sh, long) = getopt_args (option_definitions)
try:
	(options, files) = getopt.getopt(sys.argv[1:], sh, long)
except getopt.error, s:
	errorport.write ('\n')
	errorport.write (_ ("error: ") + _ ("getopt says: `%s\'" % s))
	errorport.write ('\n')
	errorport.write ('\n')
	help ()
	sys.exit (2)

tfmfile = ''
outname = ''
glyph_range=[]
for (o,a) in options:
	if 0:
		pass
	elif o == '--help' or o == '-h':
		help ()
		sys.exit (0)
	elif o == '--keep' or o == '-k':
		keep_temp_dir_p = 1
	elif o == '--verbose' or o == '-V':
		verbose_p = 1
	elif o == '--keep-trying':
		keep_trying_p = 1
	elif o == '--version' or o == '-v':
		identify ()
		sys.exit (0)
	elif o == '--warranty' or o == '-w':
		warranty ()
		sys.exit (0)
	elif o == '--encoding' or o == '-e':
		encoding_file = a
	elif o == '--glyphs':
		glyph_range = map (string.atoi, string.split(a, ','))
	elif o == '--output-base' or o == '-o':
		outname = a
	elif o == '--tfmfile' :
		tfmfile = a
	elif o == '--pfa' or o == '-a':
		pfa_p = 1
	elif o == '--pfb' or o == '-b':
		pfa_p = 0
	elif o== '--include' or o == '-I':
		include_dirs.append (a)
	elif o == '--simplify':
		simplify_p = 1
	else:
		raise 'Ugh -- forgot to implement option %s. :)' % o
	
if not files:
	try:
		error("No input files specified.")
	except:
		pass
	help ()
	sys.exit(2)

fontname = files[0]


fontname = strip_extension(fontname, '.mf')

if not tfmfile:
	tfmfile = find_file (fontname + '.tfm')

if not tfmfile:
	tfmfile =  popen ("mktextfm %s" % fontname).read ()
	if tfmfile:
		tfmfile = tfmfile[:-1]

if not tfmfile:
	error (_("Can not find a TFM file to match `%s'") % fontname) 

tfmfile = os.path.abspath(tfmfile)
metric = tfm.read_tfm_file (tfmfile)

	
if not outname:
	outname = fontname

if pfa_p:
	outname = outname + '.pfa'
else:
	outname = outname + '.pfb'

if encoding_file and not os.path.exists (encoding_file):
	encoding_file = find_file (encoding_file)

coding_dict = {
	'Extended TeX Font Encoding - Latin' : 'tex256.enc',
	'TeX text': 'tex256.enc',
	'feta music': 'feta20.enc',
	}

if not encoding_file:
	codingfile = 'tex256.enc'
	if not coding_dict.has_key (metric.coding):
		sys.stderr.write ("Unknown encoding `%s'; assuming tex256.\n" % metric.coding)
	else:
		codingfile = coding_dict[metric.coding]
		
	encoding_file = find_file (codingfile)
	if not encoding_file:
		error (_("Can not find encoding file `%s'" % codingfile))

(enc_name, encoding) = read_encoding (encoding_file)

if not len(glyph_range):
	glyph_range = range(0,len(encoding))

temp_dir =setup_temp ()

if verbose_p:
	progress ('Temporary directory is `%s\' ' % temp_dir)
os.chdir (temp_dir)

autotrace_font (fontname, metric, glyph_range, encoding, outname)

if simplify_p:
	cleanup_font (outname)

shutil.copy2 (outname, origdir)
os.chdir (origdir)

cleanup_temp ()
