/*	test_Splash_Screen

CVS ID: test_Splash_Screen.java,v 1.5 2012/04/16 06:23:00 castalia Exp

Copyright (C) 2007-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

import PIRL.Viewers.Splash_Screen;
import PIRL.Viewers.Icons;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.Timer;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;


public class test_Splash_Screen
{
public static final String
	ICONS_DIRECTORY			= ".",
	DEFAULT_IMAGE_FILENAME	= "PIRL.png";

private JFrame
	Frame;

public test_Splash_Screen ()
{
Frame = new JFrame ("Splash Screen Test");
Frame.setDefaultCloseOperation (JFrame.EXIT_ON_CLOSE);
JPanel
	panel = new JPanel ();
panel.add (new JLabel (Splash_Screen.ID));
Frame.setContentPane (panel);
Frame.pack ();
}


public void Run_Test
	(
	String	pathname
	)
{
Icons.Directory (ICONS_DIRECTORY, this.getClass ());

final Splash_Screen
	splash = new Splash_Screen (pathname);
splash.Start ();

final Timer
	timer = new Timer (2000, new ActionListener ()
		{
		public void actionPerformed (ActionEvent event)
			{
			splash.Parent (Frame);
			splash.Duration (5);
			}
		});
timer.setRepeats (false);
timer.start ();
}


public static void main
	(
	String[]	args)
{
System.out.println (Splash_Screen.ID);
test_Splash_Screen
	tester = new test_Splash_Screen ();
String
	pathname = DEFAULT_IMAGE_FILENAME;
if (args.length > 0)
	pathname = args[0];
tester.Run_Test (pathname);
}

}
