/*
 * Function prototypes for Bowser 
 *
 */

#ifndef BOWSER_PROTO_H
#define BOWSER_PROTO_H

#include <common.h>
#include <gnome.h>
#include <mysql/mysql.h>

/************* Data structures ******************************/

struct bowser_column
{
    char *column_name;
    unsigned int column_type;
    unsigned int column_width;
	char *column_default;
	gpointer column_extra;
};

typedef struct bowser_column bowser_column;

struct bowser_table
{
	bowser_column *table_column;
	char *table_name;
	int table_column_amount;
	
//  Autodefined

	GtkCList *table_list;
};

typedef struct bowser_table bowser_table;

struct bowser_flags
{
	char **flag_name;
	int flag_amount;
	
//  Autodefined

	unsigned long flag_flag;
};

typedef struct bowser_flags bowser_flags;

struct bowser_foreign
{
    char *foreign_name;
    char *foreign_key;
    char *foreign_table;
};

typedef struct bowser_foreign bowser_foreign;

typedef enum
{
	COLUMN_TEXT		=	0,
	COLUMN_NUMBER	=	1,
	COLUMN_FLAGS	=	2,
	COLUMN_COMBO    =	3
} ColumnType;

/************* Function prototypes **************************/

// in "assign.c"

GtkWidget *get_assigns_box(void);

// in "dialog.c"

extern GtkWidget *InfoWindow, *InfoText;

int createinfowindow(gchar *dummy, gpointer visible);
void my_error_dialog(const gchar * format,...);
GtkWidget *note_dialog(const gchar *format,...);

// in "files.c"

GtkWidget *get_areas_box(void);
GtkWidget *get_stuff_box(void);
int view_since(void);
int externcmd(gchar *dummy, gpointer data);

// in "groups.c"

GtkWidget *get_groups_box(void);
void leech_all(void);
void leech_win(void);

// in "main.c"

int save_yourself(void);

extern char FifoFile[PATH_MAX];
extern MYSQL *db;
extern GtkWidget *Bowser;
extern GtkWidget *statusBar;

// in "misc.c"

GtkWidget *get_misc_box(void);
GList *get_sql(MYSQL *db, const char *format, ...);
void clear_glist(GtkWidget *widget, gpointer data);
void select_all(GtkWidget *dummy, GtkWidget *list);
void unselect_all(GtkWidget *dummy, GtkWidget *list);

// in "prefs.c"

void preferences(void);

// in "servers.c"

GtkWidget *get_server_box(void);

// in "rules.c"

GtkWidget *get_rules_box(void);

// in "stats.c"

void show_stats(void);

// in "table.c"

// in "contexts.c"

GtkWidget *get_contexts_box(void);

// in "types.c"

GtkWidget *get_types_box(void);

// in "menu.c"

void create_menus(void);
void newbox(gchar *boxname, GtkWidget *vbox, gchar *initstring, GtkWidget **entry, gint boxlen);

GtkWidget *get_table(bowser_table *table);

#endif
