/*
 * PIMPPA - pnewarea (Adds a new area)
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <unistd.h>
#include <sys/stat.h>
#include <string.h>

#include "pimppa.h"

	
void usage(char *progname)
{
	fprintf(stderr, "Usage: %s -n <area_name> -p <area_path> [-I id] [-it]\n\n%s", progname,
	"-a           Mark area as AREA_NOASSIGN\n"
	"-c           Context number for this area, default: 0==global\n"
	"-i           Mark area as AREA_INCOMING\n"
	"-I <id>      Suggest id number for the new area\n"
	"-n <name>    Area name, MUST\n"
	"-t           Mark area as AREA_NOTRANS\n"
	"-T <regexp>  RegExp dupecheck pattern, default $\n"
	"-p <path>    Area path, MUST\n");
}

int main(int argc, char *argv[])
{
	char areaname[PATH_MAX];
	char areapath[PATH_MAX];
	char regexp[PATH_MAX];
	unsigned long areaflags=0;
	int suggestid=0, have_id=0, context=0;
	MYSQL *db;
	MYSQL_RES *sql_result;
	struct stat st;
	int go=1;

	areaname[0]=areapath[0]=regexp[0]=0;

	while(go)
	{
		switch(getopt(argc, argv, "ac:hI:in:p:tTV"))
		{
			case 'a':
				areaflags|=AREA_NOASSIGN;
				break;
			case 'c':
				context=atoi(optarg);
				break;
			case 'n':
				strcpy(areaname, optarg);
				break;
			case 'p':
				strcpy(areapath, optarg);
				break;
			case 't':
				areaflags|=AREA_NOTRANS;
				break;
			case 'T':
				strcpy(regexp, optarg);
				break;
			case 'i':
				areaflags|=AREA_INCOMING;
				break;
			case 'I':
				have_id=1;
				suggestid=atoi(optarg);
				break;
			case -1:
				go=0;
				break;
			case 'V':
				printf("%s %s %s\n", PACKAGE, argv[0], VERSION);
				return(0);
				break;
			case 'h':
			default:
				usage(argv[0]);
				return(0);
				break;
		}
	}
	
	if(!areaname[0])
	{
		fprintf(stderr, "Please supply area name with -n <name>\n");
		return(0);
	}
	if(!areapath[0])
	{
		fprintf(stderr, "Please supply area path with -p <path>\n");
		return(0);
	}
	if(!regexp[0])
	{
		strcpy(regexp, "$");
	}

	if(!p_checkp(areapath))
		strcat(areapath, "/");

	db=p_connect();
	if(!db)
		return(-1);

/************ Check for the validity of the suggested id if any ************/

	if(have_id)
	{
		p_query(db, "SELECT 1 FROM p_areas "
			    "WHERE area_id=%d",
			suggestid);
		sql_result=mysql_store_result(db);
		if(sql_result)
		{	
			if(mysql_num_rows(sql_result)>0)
			{
				mysql_free_result(sql_result);
				fprintf(stderr, "Area ID %d is already in use.\n", suggestid);
				return(-2);
			}
			mysql_free_result(sql_result);
		}
	}

/********************** Check that the area doesn't exist **************/

	p_query(db, "SELECT 1 "
		    "FROM p_areas "
		    "WHERE area_name='%s' OR area_path='%s'", 
		areaname, areapath);
	sql_result=mysql_store_result(db);
	if(sql_result)
	{
		if(mysql_num_rows(sql_result)>0)
		{
			mysql_free_result(sql_result);
			fprintf(stderr, "Such area or path already exists in db...\n");
			return(-1);
		}
		mysql_free_result(sql_result);
	}

/***************** Check for the validity of physical path **********/

	if(stat(areapath, &st))
	{
		fprintf(stderr, "stat() error on %s\n", areapath);
		return(-1);
	}
	else
	{
		if(!S_ISDIR(st.st_mode))
		{
			fprintf(stderr, "%s is not a directory...\n", areapath);
			return(-1);
		}
	}

/****************** Ok, lets add **********************/

	if(have_id)
		p_query(db, "INSERT INTO p_areas " 
			    "  (area_name, area_path, area_flags, "
			    "   area_id, area_targets, area_context) "
			    "VALUES ('%s', '%s', %ld, %d, '%s', %d)", 
			areaname, areapath, areaflags, suggestid, 
			regexp, context);
	else
		p_query(db, "INSERT INTO p_areas (area_name, area_path, "
			    "  area_flags, area_targets, area_context) "
			    "VALUES ('%s', '%s', %ld, '%s', %d)", 
			areaname, areapath, areaflags, regexp, context);
	if(mysql_error(db)[0])
	{
		fprintf(stderr, "Unable to add the area (%s)...\n",
				mysql_error(db));
		mysql_close(db);
		return(-1);
	}

	mysql_close(db);

	fprintf(stderr, "Area added ok...\n");

	return(0);
}

