# -*- mode: python; coding: utf-8 -*-
#
# Pigment Python binding unit tests
#
# Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

from pgm_test_case import PgmTestCase
import pgm
import time
import string

class TestEvent(PgmTestCase):

    def test_nothing(self):
        evt = pgm.Event(pgm.NOTHING)
        self.failUnless(evt)

        # err, nothing to test :)

    def create_event(self, typ):
        evt = pgm.Event(typ)

        evt.source = 1

        if typ != pgm.CONFIGURE:
            now = int(time.time())
            evt.time = now
            self.assertEqual(evt.time, now)

        self.assertEqual(evt.source, 1)
        self.assertEqual(evt.type, typ)
        return evt

    def test_motion_notify(self):
        evt = self.create_event(pgm.MOTION_NOTIFY)

        x, y = 2.0, 50.0
        evt.x = x
        evt.y = y

        self.assertEqual(evt.x, x)
        self.assertEqual(evt.y, y)

    def test_button_press(self):
        evt = self.create_event(pgm.BUTTON_PRESS)

        x, y = 2.0, 50.0
        evt.x = x
        evt.y = y

        self.assertEqual(evt.x, x)
        self.assertEqual(evt.y, y)

        b = pgm.BUTTON_LEFT
        evt.button = b
        self.assertEqual(evt.button, b)

    def test_button_release(self):
        evt = self.create_event(pgm.BUTTON_RELEASE)

        x, y = 2.0, 50.0
        evt.x = x
        evt.y = y

        self.assertEqual(evt.x, x)
        self.assertEqual(evt.y, y)

        b = pgm.BUTTON_LEFT
        evt.button = b
        self.assertEqual(evt.button, b)

    def test_2_button_press(self):
        evt = self.create_event(pgm.DOUBLE_BUTTON_PRESS)

        x, y = 2.0, 50.0
        evt.x = x
        evt.y = y

        self.assertEqual(evt.x, x)
        self.assertEqual(evt.y, y)

        b = pgm.BUTTON_LEFT
        evt.button = b
        self.assertEqual(evt.button, b)


    def test_3_button_press(self):
        evt = self.create_event(pgm.TRIPLE_BUTTON_PRESS)

        x, y = 2.0, 50.0
        evt.x = x
        evt.y = y

        self.assertEqual(evt.x, x)
        self.assertEqual(evt.y, y)

        b = pgm.BUTTON_LEFT
        evt.button = b
        self.assertEqual(evt.button, b)


    def test_key_press(self):
        evt = self.create_event(pgm.KEY_PRESS)

        k = pgm.keysyms.a
        evt.keyval = k
        self.assertEqual(evt.keyval, k)


    def test_key_release(self):
        evt = self.create_event(pgm.KEY_RELEASE)

        k = pgm.keysyms.a
        evt.keyval = k
        self.assertEqual(evt.keyval, k)

    def test_scroll(self):
        evt = self.create_event(pgm.SCROLL)

        x, y = 2.0, 50.0
        evt.x = x
        evt.y = y

        self.assertEqual(evt.x, x)
        self.assertEqual(evt.y, y)

        d = pgm.SCROLL_UP
        evt.direction  = d
        self.assertEqual(evt.direction, d)

    def test_configure(self):
        evt = self.create_event(pgm.CONFIGURE)

        x, y = 2, 50
        evt.x = x
        evt.y = y

        self.assertEqual(evt.x, x)
        self.assertEqual(evt.y, y)

        w, h = 50, 60
        evt.width = w
        evt.height = h
        self.assertEqual(evt.width, w)
        self.assertEqual(evt.height, h)
