from PyQt4 import QtCore, QtGui

import selection, defaults

class AxisName(QtGui.QWidget):
	def __init__(self, ui, parent = None):
		QtGui.QWidget.__init__(self, parent)
		self.combo = QtGui.QComboBox()
		ui.horizontalLayout.addWidget(self.combo)
		self.connect(self.combo, QtCore.SIGNAL('currentIndexChanged(int)'),
				self.indexChanged)

	def setItemName(self, label, id):
		if label:
			self.combo.addItem(label)
		else:
			self.combo.addItem("axis%d" % id)

	def indexChanged(self, id):
		pass
		#print "Change axis id: %d" % id

	def setCurrentIndex(self, i):
		self.combo.setCurrentIndex(i)


def addAxes(image, scene, lines):
	pen = QtGui.QPen()
	pen.setColor(QtCore.Qt.black)

	i = 0
	while i < image['axes_number']:
		scene.addLine(i * defaults.axiswidth, 0, i * defaults.axiswidth, image['height'], pen)
	# Removed for 0.1 release. Be back on trunk soon
	#	item = selection.SelectionItem(image, scene, lines, i*defaults.axiswidth , 0)
	#        scene.addItem(item)
		i = i + 1

