#!/usr/bin/perl
#
# Perl script to generate PCV file for Sotm 30
#

print "header {\n";
print "        title = \"Syslog picviz analysis\";\n";
print "}\n";
print "engine {\n";
print "        relative = \"1\";\n";
print "}\n";
print "axes {\n";
print "        years      t [label=\"Timeline\"];\n";
print "        string   m [label=\"Machine\"];\n";
print "        string   src [label=\"Source\"];\n";
print "        string   dst [label=\"Dest\"];\n";
print "        gold  len [label=\"Len\"];\n";
print "        char  ttl [label=\"TTL\"];\n";
print "        integer  spt [label=\"Sport\"];\n";
print "        integer  dpt [label=\"Dport\"];\n";
print "}\n";

print "data {\n";

while ($line = <>) {

        $line =~ s/\"/\\"/g; # We escape our quotes
        # Mar 31 23:44:10 bridge kernel: INBOUND TCP: IN=br0 PHYSIN=eth0 OUT=br0 PHYSOUT=eth1 SRC=200.30.113.203 DST=11.11.79.95 LEN=48 TOS=0x00 PREC=0x00 TTL=111 ID=11129 DF PROTO=TCP SPT=3734 DPT=445 WINDOW=8760 RES=0x00 SYN URGP=0
        $line =~ m/(\w+)  (\d+) (\d+:\d+:\d+) (\w+) (\S+):(.*):.*SRC=(\d+.\d+.\d+.\d+) DST=(\d+.\d+.\d+.\d+) LEN=(\d+).*TTL=(\d+).*SPT=(\d+) DPT=(\d+).*/;

	$month = $1;
	$day = $2;
	$time = $3;
	$machine = $4;
	$log_type = $5; # kernel all the time, so we don't care
	$flow = $6; # INBOUND/OUTBOUND
	$src = $7;
	$dst = $8;
	$len = $9;
	$ttl = $10;
	$sport = $11;
	$dport = $12;

	if ($month == "Jan") {
		$mn = "01";
	}
	if ($month == "Feb") {
		$mn = "02";
	}
	if ($month == "Mar") {
		$mn = "03";
	}
	if ($month == "Apr") {
		$mn = "04";
	}
	if ($month == "May") {
		$mn = "05";
	}
	if ($month == "Jun") {
		$mn = "06";
	}
	if ($month == "Jul") {
		$mn = "07";
	}
	if ($month == "Aug") {
		$mn = "08";
	}
	if ($month == "Sep") {
		$mn = "09";
	}
	if ($month == "Oct") {
		$mn = "10";
	}
	if ($month == "Nov") {
		$mn = "11";
	}
	if ($month == "Dec") {
		$mn = "12";
	}

	if ( $flow =~ /.*INBOUND.*/) {
	#if ( $flow =~ /.*OUT.*/) {
		if ($dport > 1024) {
			print "    t=\"2004-$mn-$day $time\",m=\"$machine\",src=\"$src\",dst=\"$dst\",len=\"$len\",ttl=\"$ttl\", spt=\"$sport\", dpt=\"$dport\" [color=\"green\"];\n";
		} else {
			print "    t=\"2004-$mn-$day $time\",m=\"$machine\",src=\"$src\",dst=\"$dst\",len=\"$len\",ttl=\"$ttl\", spt=\"$sport\", dpt=\"$dport\" [color=\"blue\"];\n";
		}
	}
}

print "}\n";

