#define _XOPEN_SOURCE 500
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/io.h>
#include <sys/mman.h>
#include <dirent.h>
#include <ctype.h>
#include <malloc.h>
#include <string.h>
#include <signal.h>
#include <getopt.h>
#include <linux/pci.h>
#include <sys/time.h>


#define DATA_REG 0x62
#define CST_REG  0x66

typedef unsigned short u16;

static void ecr_set(u16 addr, u16 value)
{
	while (inw(CST_REG) & 3) usleep(1);
	outw(0x81, CST_REG);
	while (inw(CST_REG) & 2) usleep(1);
	outw(addr, DATA_REG);
	while (inw(CST_REG) & 2) usleep(1);
	outw(value, DATA_REG);
	while (inw(CST_REG) & 2) usleep(1);
}

static u16 ecr_get(u16 addr)
{
	while (inw(CST_REG) & 3) usleep(1);
	outb(0x80, CST_REG);
	while (inw(CST_REG) & 2) usleep(1);
	outb(addr, DATA_REG);
	while (inw(CST_REG) & 2) usleep(1);
	return inw(DATA_REG);
}

int main(int argc, char *argv[])
{
	iopl(3);
	printf("currently %x\n", ecr_get(0x96));
	ecr_set(0x96, atoi(argv[1]));
	return 0;
}
