<?php
/**
 * Polish Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2005  Michael Paluchowski, Tymoteusz Motylewski
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author Michael Paluchowski, http://genealogy.nethut.pl
 * @author Tymoteusz Motylewski www.motylewscy.com
 * @version $Id: lang.pl.php,v 1.15.2.12 2006/09/17 23:29:18 canajun2eh Exp $
 */
if (preg_match("/lang\...\.php$/", $_SERVER["PHP_SELF"])>0) {
	print "You cannot access a language file directly.";
	exit;
}
//-- GENERAL HELP MESSAGES
$pgv_lang["qm"]				= "?";
$pgv_lang["qm_ah"]				= "?";
$pgv_lang["page_help"]			= "Pomoc";
$pgv_lang["help_for_this_page"]	= "Pomoc dla tej strony";
$pgv_lang["help_contents"]		= "Pomoc ogólna";
$pgv_lang["show_context_help"]	= "Pokaż pomoc z kontekstu";
$pgv_lang["hide_context_help"]	= "Ukryj pomoc z kontekstu";
$pgv_lang["sorry"]				= "<b>Niestety treść pomocy dla tej strony nie została jeszcze przygotowana</b>";
$pgv_lang["help_not_exist"]		= "<b>Pomoc dla tego elementu lub strony jest niedostępna</b>";
$pgv_lang["resolution"]			= "Rozdzielczość ekranu";
$pgv_lang["menu"]				= "Menu";
$pgv_lang["header"]				= "Nagłówek";
$pgv_lang["imageview"]			= "Przeglądarka obrazów";

//-- CONFIG FILE MESSAGES
$pgv_lang["login_head"]			= "Logowanie użytkownika PhpGedView";
$pgv_lang["error_title"]			= "BŁĄD: Nie mogę otworzyć pliku GEDCOM";
$pgv_lang["error_header"] 			= "Plik GEDCOM [#GEDCOM#], nie istnieje pod podaną lokalizacją.";
$pgv_lang["error_header_write"]	= "Plik GEDCOM [#GEDCOM#] jest zabezpieczony przed zapisem. Sprawdź ustawienie atrybutów.";
$pgv_lang["for_support"]			= "W celu uzyskania pomocy lub informacji skontaktuj się z";
$pgv_lang["for_contact"]		= "Pytania dotyczące kwestii genealogicznych należy kierować do";
$pgv_lang["for_all_contact"]	= "Pytania genealogiczne lub natury technicznej należy kierować do";
$pgv_lang["build_title"]			= "Budowanie Indeksów";
$pgv_lang["build_error"]			= "Nowy plik GEDCOM został znaleziony.";
$pgv_lang["please_wait"]			= "Zaczekaj aż zostaną utworzone pliki indeksów.";
$pgv_lang["choose_gedcom"]			= "Wybierz zbiór danych GEDCOM";
$pgv_lang["username"]				= "Login";
$pgv_lang["invalid_username"]	= "Nazwa użytkownika zawiera niedozwolone znaki";
$pgv_lang["lastname"]				= "Nazwisko";
$pgv_lang["firstname"]				= "Imię";
$pgv_lang["fullname"]			= "Imię i nazwisko";
$pgv_lang["password"]				= "Hasło";
$pgv_lang["confirm"]			= "Potwierdź hasło";
$pgv_lang["user_contact_method"]	= "Preferowana metoda kontaktu";
$pgv_lang["login"]				= "Zaloguj się";
$pgv_lang["login_aut"]			= "Edytuj użytkownika";
$pgv_lang["logout"]				= "Wyloguj";
$pgv_lang["admin"]				= "Panel administracyjny";
$pgv_lang["logged_in_as"]			= "Zalogowany(a) jako ";
$pgv_lang["my_pedigree"]			= "Mój rodowód";
$pgv_lang["my_indi"]				= "Moje dane";
$pgv_lang["yes"]				= "Tak";
$pgv_lang["no"]					= "Nie";
$pgv_lang["add_gedcom"]				= "Dodaj kolejny GEDCOM";
$pgv_lang["no_support"]			= "Wykryliśmy, że twoja przeglądarka nie obsługuje standardów, które wykorzystywane są przez PphGedView. Większość przeglądarek w najnowszych wersjach je obsługuje. Zaktualizuj przeglądarkę aby w pełni korzystać z zasobów PhpGedView.";
$pgv_lang["change_theme"]		= "Zmień wygląd";
$pgv_lang["gedcom_downloadable"] 	= "Ten plik GEDCOM może zostać ściągnięty przez internet!<br />Zobacz sekcję BEZPIECZEŃSTWO(SECURITY) w pliku <a href=\"readme.txt\"><b>readme.txt</b></a> aby naprawić ten problem";

//-- INDEX (PEDIGREE_TREE) FILE MESSAGES
$pgv_lang["index_header"]			= "Drzewo rodowe";
$pgv_lang["gen_ped_chart"]			= "#PEDIGREE_GENERATIONS# -pokoleniowy wykres rodowy";
$pgv_lang["generations"]			= "Pokoleń";
$pgv_lang["view"]				= "Zobacz";
$pgv_lang["fam_spouse"]				= "Rodzina z małżonkiem";
$pgv_lang["root_person"]			= "ID osoby głównej";
$pgv_lang["hide_details"]			= "Ukryj szczegóły";
$pgv_lang["show_details"]			= "Pokaż szczegóły";
$pgv_lang["person_links"]			= "Odnośniki do wykresów, rodzin i bliskich krewnych tej osoby.";
$pgv_lang["zoom_box"]				= "Powiększ/pomniejsz ten obszar.";
$pgv_lang["orientation"]			= "Orientacja";
$pgv_lang["portrait"]			= "Portret";
$pgv_lang["landscape"]			= "Pejzaż";
$pgv_lang["start_at_parents"]	= "Zacznij od rodziców";
$pgv_lang["charts"]				= "Wykresy";
$pgv_lang["lists"]				= "Listy";
$pgv_lang["welcome_page"]		= "Strona powitalna";
$pgv_lang["max_generation"]		= "Maksymalna liczba pokoleń wykresu to #PEDIGREE_GENERATIONS#.";
$pgv_lang["min_generation"]		= "Minimalna liczba pokoleń wykresu to 3.";
$pgv_lang["box_width"] 				= "Szerokość okna";

//-- FUNCTIONS FILE MESSAGES
$pgv_lang["unable_to_find_family"]		= "Nie znaleziono rodziny z tym ID";
$pgv_lang["unable_to_find_indi"]		= "Nie znaleziono osoby z tym ID";
$pgv_lang["unable_to_find_record"]		= "Nie znaleziono wpisu z tym ID";
$pgv_lang["unable_to_find_source"]		= "Nie znaleziono źródła z tym ID";
$pgv_lang["unable_to_find_repo"]		= "Nie znaleziono magazynu z tym ID";
$pgv_lang["repo_name"]				= "Nazwa magazynu:";
$pgv_lang["address"]				= "Adres:";
$pgv_lang["phone"]				= "Telefon:";
$pgv_lang["source_name"]			= "Nazwa źródła:";
$pgv_lang["title"]				= "Tytuł";
$pgv_lang["author"]				= "Autor(ka):";
$pgv_lang["publication"]			= "Publikacja:";
$pgv_lang["call_number"]			= "Numer źródła:";
$pgv_lang["living"]				= "Żyjący(a)";
$pgv_lang["private"]				= "Prywatne";
$pgv_lang["birth"]				= "Urodzony(a):";
$pgv_lang["death"]				= "Umarł(a):";
$pgv_lang["descend_chart"]			= "Wykres potomków";
$pgv_lang["individual_list"]			= "Lista osób";
$pgv_lang["family_list"]			= "Lista rodzin";
$pgv_lang["source_list"]			= "Lista źródeł";
$pgv_lang["place_list"]				= "Hierarchia miejsc";
$pgv_lang["media_list"]				= "Lista multimediów";
$pgv_lang["search"]				= "Szukaj";
$pgv_lang["clippings_cart"]			= "Koszyk wycinków z drzewa";
$pgv_lang["not_an_array"]			= "Nie jest tablicą";
$pgv_lang["print_preview"]			= "Wersja do druku";
$pgv_lang["cancel_preview"]		= "Powrót do normalnego widoku";
$pgv_lang["change_lang"]			= "Zmień język";
$pgv_lang["print"]				= "Drukuj";
$pgv_lang["total_queries"]			= "Zapytań do bazy danych: ";
$pgv_lang["total_privacy_checks"]	= "Sprawdzeń prywatności w sumie: ";
$pgv_lang["back"]				= "Wstecz";
$pgv_lang["privacy_list_indi_error"]	= "Ze względu na ograniczenia ochrony danych osobowych niektóre osoby są ukryte.";
$pgv_lang["privacy_list_fam_error"]	= "Ze względu na ograniczenia ochrony danych osobowych niektóre rodziny są ukryte.";

//-- INDIVIDUAL FILE MESSAGES
$pgv_lang["aka"]				= "VEL";
$pgv_lang["male"]				= "Mężczyzna";
$pgv_lang["female"]				= "Kobieta";
$pgv_lang["temple"]				= "Świątynia Mormońska";
$pgv_lang["temple_code"]			= "Kod Świątyni Mormońskiej:";
$pgv_lang["status"]				= "Status";
$pgv_lang["source"]				= "źródło";
$pgv_lang["citation"]				= "Cytat:";
$pgv_lang["text"]				= "Tekst:";
$pgv_lang["note"]				= "Notka";
$pgv_lang["NN"]					= "(nieznane)";
$pgv_lang["PN"]					= "(nieznane)";
$pgv_lang["unrecognized_code"]			= "Nierozpoznany kod GEDCOM";
$pgv_lang["unrecognized_code_msg"]	= "To jest błąd, który chcielibyśmy naprawić. Proszę zgłoś go do";
$pgv_lang["indi_info"]				= "Informacje o osobie";
$pgv_lang["individual"]				= "Osoba";
$pgv_lang["pedigree_chart"]			= "Wykres<br />rodowy";
$pgv_lang["desc_chart2"]			= "Wykres<br />potomków";
$pgv_lang["family"]				= "Rodzina";
$pgv_lang["family_with"]		= "W rodzinie z";
$pgv_lang["as_spouse"]				= "W rodzinie<br />jako małżonek";
$pgv_lang["as_child"]				= "W rodzinie<br />jako dziecko";
$pgv_lang["view_gedcom"]			= "Pokaż Fragment<br />GEDCOM";
$pgv_lang["add_to_cart"]			= "Dodaj do<br />koszyka wycinków";
$pgv_lang["still_living_error"]			= "Ta osoba wciąż żyje albo nie ma podanej daty urodzenia lub śmierci. Wszystkie dane osób żyjących nie są wyświetlane.<br />W celu uzyskania dalszych informacji skontaktuj się z";
$pgv_lang["privacy_error"]	  		= "Dane  dotyczące tej osoby są prywatne.<br /> Skontaktuj się by uzyskać więcej informacji ";
$pgv_lang["more_information"]	= "Więcej informacji uzyskasz od";
$pgv_lang["name"]				= "Imię i Nazwisko";
$pgv_lang["given_name"]				= "Imię:";
$pgv_lang["surname"]				= "Nazwisko:";
$pgv_lang["suffix"]				= "Sufiks:";
$pgv_lang["object_note"]			= "Notka o obiekcie:";
$pgv_lang["sex"]				= "Płeć";
$pgv_lang["personal_facts"]			= "Wydarzenia i szczegóły";
$pgv_lang["lasttab"]				= "Ostatnio odwiedzana zakładka dla osoby";
$pgv_lang["type"]				= "Typ";
$pgv_lang["date"]				= "Data";
$pgv_lang["place_description"]			= "Miejsce / Opis";
$pgv_lang["parents"] 				= "Rodzice:";
$pgv_lang["siblings"] 				= "Rodzeństwo";
$pgv_lang["parent"] 				= "Rodzic";
$pgv_lang["father"] 				= "Ojciec";
$pgv_lang["mother"] 				= "Matka";
$pgv_lang["relatives"]				= "Bliscy krewni";
$pgv_lang["relatives_events"]		= "Wydarzenia związane z bliskimi krewnymi";
$pgv_lang["child"]				= "Dzieci";
$pgv_lang["spouse"]				= "Małżonek";
$pgv_lang["surnames"]				= "Wszystkich nazwisk";
$pgv_lang["adopted"]				= "Adoptowany(a)";
$pgv_lang["foster"]				= "Wychowywany(a)";
$pgv_lang["sealing"]				= "Sealing";
$pgv_lang["stillborn"]				= "Urodzony martwy(a)";
$pgv_lang["infant"]					= "Niemowlę";
$pgv_lang["disproved"]				= "Zweryfikowane jako nieprawda";
$pgv_lang["link_as_husband"]		= "Dodaj jako męża do istniejącej rodziny";
$pgv_lang["link_as_wife"]			= "Dodaj jako żonę do istniejącej rodziny";
$pgv_lang["link_as_child"]			= "Dodaj jako dziecko do istniejącej rodziny";
$pgv_lang["link_as"]				= "Połącz tą osobę z istniejącą rodziną jako ";
$pgv_lang["no_tab1"]				= "Nie ma faktów dla tej osoby";
$pgv_lang["no_tab2"]				= "Nie ma notatek dla tej osoby";
$pgv_lang["no_tab3"]				= "Nie ma cytatów dla tej osoby";
$pgv_lang["no_tab4"]				= "Nie ma multimediów dla tej osoby<br />";
$pgv_lang["no_tab6"]				= "Nie ma żadnych dzienników badań związanych z tą osobą.";
$pgv_lang["no_tab5"]				= "Nie ma bliskich krewnych dla tej osoby";

//-- FAMILY FILE MESSAGES
$pgv_lang["family_info"]			= "Informacje o rodzinie";
$pgv_lang["family_group_info"]			= "Informacje o grupie rodzinnej";
$pgv_lang["husband"]				= "Mąż:";
$pgv_lang["wife"]				= "Żona:";
$pgv_lang["marriage"]				= "Małżeństwo:";
$pgv_lang["lds_sealing"]			= "Naznaczenie Mormońskie:";
$pgv_lang["marriage_license"]			= "Licencja Małżeńska:";
$pgv_lang["number_children"]		= "Liczba dzieci: ";
$pgv_lang["childless_family"]		= "Rodzina pozostała bezdzietna";
$pgv_lang["media_object"]			= "Obiekt multimedialny:";
$pgv_lang["children"]				= "Dzieci";
$pgv_lang["no_children"]			= "Brak dzieci";
$pgv_lang["parents_timeline"]			= "Pokaż rodziców na<br />wykresie linii czasu";

//-- CLIPPINGS FILE MESSAGES
$pgv_lang["clip_cart"]				= "Koszyk wycinków";
$pgv_lang["clip_explaination"]			= "Koszyk wycinków drzewa genealogicznego pozwala wybrać &quot;wycinki&quot; z całego drzewa i powiązać je w jeden GEDCOM do ściągnięcia.<br /><br />";
$pgv_lang["item_with_id"]			= "Obiekt z ID";
$pgv_lang["error_already"]			= "jest już w twoim koszyku wycinków.";
$pgv_lang["which_links"]			= "Ktore powiązania tej rodziny chciał(a)byś również dodać?";
$pgv_lang["just_family"]			= "Dodaj tylko dane tej rodziny.";
$pgv_lang["parents_and_family"]			= "Dodaj rodziców z danymi tej rodziny.";
$pgv_lang["parents_and_child"]			= "Dodaj rodziców i dzieci z danymi tej rodziny.";
$pgv_lang["parents_desc"]			= "Dodaj rodziców i dane wszystkich potomków z danymi tej rodziny.";
$pgv_lang["continue"]				= "Kontynuuj dodawanie";
$pgv_lang["which_p_links"]			= "Które powiązania tej osoby chciał(a)byś również dodać?";
$pgv_lang["just_person"]			= "Dodaj tylko tą osobę.";
$pgv_lang["person_parents_sibs"]		= "Dodaj tą osobę, rodziców i rodzeństwo.";
$pgv_lang["person_ancestors"]			= "Dodaj tą osobę i przodków w linii prostej.";
$pgv_lang["person_ancestor_fams"]		= "Dodaj tą osobę, przodków w linii prostej i ich rodziny.";
$pgv_lang["person_spouse"]			= "Dodaj tą osobę, małżonka i dzieci.";
$pgv_lang["person_desc"]			= "Dodaj tą osobę, małżonka i wszystkich potomków.";
$pgv_lang["unable_to_open"]			= "Nie mogę zapisać w folderze wycinków";
$pgv_lang["person_living"]			= "Ta osoba żyje. Dane personalne nie będą dołączone.";
$pgv_lang["person_private"]			= "Szczegółowe informacje o tej osobie są prywatne. Nie zostaną one dołączone.";
$pgv_lang["family_private"]		= "Szczegółowe informacje o tej rodzinie są prywatne. Nie zostaną one dołączone.";
$pgv_lang["download"]				= "Kliknij prawym przyciskiem (control-click na Mac'u) na odnośnikach poniżej i wybierz &quot;Zapisz element docelowy jako...&quot; aby ściągnąc pliki.";
$pgv_lang["media_files"]			= "Pliki medialne opisane w tym GEDCOM'ie";
$pgv_lang["cart_is_empty"]			= "Twój koszyk wycinków jest pusty.";
$pgv_lang["id"]					= "ID";
$pgv_lang["name_description"]			= "Nazwa / Opis";
$pgv_lang["remove"]				= "Usuń";
$pgv_lang["empty_cart"]				= "Opróżnij koszyk";
$pgv_lang["download_now"]			= "Ściągnij teraz";
$pgv_lang["indi_downloaded_from"]	= "Ta osoba została ściągnięta z:";
$pgv_lang["family_downloaded_from"]	= "Ta rodzina została ściągnięta z:";
$pgv_lang["source_downloaded_from"]	= "To źródło zostało ściągnięte z:";

//-- PLACELIST FILE MESSAGES
$pgv_lang["connections"]			= "Znaleziono powiązania z miejscem";
$pgv_lang["top_level"]				= "Najwyższy Poziom";
$pgv_lang["form"]				= "Miejsca są wpisane w formie: ";
$pgv_lang["default_form"]		= "Miasto, Powiat/Gmina, Województwo/Stan, Kraj";
$pgv_lang["default_form_info"]	= "(Domyślnie)";
$pgv_lang["gedcom_form_info"]	= "(GEDCOM)";
$pgv_lang["unknown"]				= "Nieznane";
$pgv_lang["individuals"]		= "Osób";
$pgv_lang["view_records_in_place"]	= "Zobacz wszystkie rekordy dotyczące tego miejsca";
$pgv_lang["external_objects"]		= "Zewnętrzne obiekty";
$pgv_lang["show_place_list"]		= "Pokaż wszystkie miejsca z listy";
$pgv_lang["show_place_hierarchy"]	= "Pokaż miejsca w hierarchii";
$pgv_lang["total_unic_places"]		= "Wszystkich unikalnych miejsc";
$pgv_lang["place_list2"] 			= "Lista miejsc";

//-- MEDIALIST FILE MESSAGES
$pgv_lang["multi_title"]			= "Lista obiektów multimedialnych";
$pgv_lang["view_object"]			= "Pokaż obiekt";
$pgv_lang["media_found"]			= "Znaleziono obiekty multimedialne";
$pgv_lang["view_person"]			= "Zobacz osobę";
$pgv_lang["view_family"]			= "Zobacz rodzinę";
$pgv_lang["view_source"]			= "Zobacz źródło";
$pgv_lang["delete_file"]			= "Usuń plik";
$pgv_lang["directory_not_empty"]	= "Katalog nie jest pusty.";
$pgv_lang["current_dir"]			= "Aktualny katalog";
$pgv_lang["media_deleted"]			= "Katalog mediów usunięty.";
$pgv_lang["thumbs_deleted"]			= "Katalog miniatur został usunięty.";
$pgv_lang["thumbs_not_deleted"]		= "Katalog miniatur nie został usunięty.";
$pgv_lang["media_not_deleted"]		= "Katalog mediów nie został usunięty.";
$pgv_lang["directory_not_exist"]	= "Katalog nie istnieje.";
$pgv_lang["confirm_delete_file"]	= "Czy na pewno chcesz usunąć ten plik?";
$pgv_lang["prev"]				= "< Poprzednia";
$pgv_lang["next"]				= "Następna >";
$pgv_lang["file_not_found"]			= "Plik nie znaleziony.";
$pgv_lang["per_page"]				= "obiektów medialnych na stronę";
$pgv_lang["delete_directory"]		= "Usuń katalog";
$pgv_lang["confirm_remove_object"]	= "Czy na pewno chcesz usunąć ten obiekt z bazy danych?";
$pgv_lang["remove_object"]			= "Usuń obiekt";
$pgv_lang["medialist_show"] 		= "Pokaż";

//-- SEARCH FILE MESSAGES
$pgv_lang["search_gedcom"]			= "Przeszukaj plik GEDCOM";
$pgv_lang["enter_terms"]			= "Wpisz szukane wyrażenia";
$pgv_lang["soundex_search"]			= "Wyszukiwanie wg Soundex:";
$pgv_lang["search_results"]			= "Wyniki Wyszukiwania";
$pgv_lang["sources"]				= "ŹRÓDŁA";
$pgv_lang["firstname_search"]			= "Imię ";
$pgv_lang["lastname_search"]			= "Nazwisko ";
$pgv_lang["search_place"]			= "Miejsce ";
$pgv_lang["search_year"]			= "Rok ";
$pgv_lang["lastname_empty"]			= "Wpisz nazwisko.";
$pgv_lang["no_results"]				= "Nic nie znaleziono.";
$pgv_lang["invalid_search_input"] 	= "Wprowadź imię, nazwisko lub miejsce \\n\\t w danym roku";
$pgv_lang["search_general"]			= "Wyszukiwanie proste";
$pgv_lang["search_soundex"]			= "Znajdź wg Soundex";
$pgv_lang["search_replace"]			= "Znajdź i zamień";
$pgv_lang["search_tagfon"]			= "Wyłącz niektóre nie-genealogiczne dane";
$pgv_lang["search_tagfoff"]			= "Wyłączony";
$pgv_lang["search_record"]			= "Cały rekord";
$pgv_lang["replace_with"]			= "Zamień na";
$pgv_lang["results_per_page"]		= "Wyników na stronę";
$pgv_lang["search_asso_label"]		= "Powiązania";
$pgv_lang["search_asso_text"]		= "Pokaż związane osoby/rodziny";
$pgv_lang["search_tagfilter"]		= "Filtr";
$pgv_lang["search_sources"]			= "Źródła";
$pgv_lang["search_prthit"]			= "Tylko trafione";
$pgv_lang["search_prtall"]			= "Wszystkie";
$pgv_lang["search_prtnames"]		= "Imiona<br />do wyświetlenia:";
$pgv_lang["search_DM"]				= "Daitch-Mokotoff";
$pgv_lang["search_russell"]			= "Basic";
$pgv_lang["search_soundextype"]		= "Typ Soundex'u:";
$pgv_lang["search_more_chars"]      = "Wprowadź więcej niż jeden znak";
$pgv_lang["search_indis"]			= "Osoby";
$pgv_lang["search_fams"]			= "Rodziny";
$pgv_lang["search_inrecs"]			= "Wyszukaj";
$pgv_lang["search_type"]			= "Typ wyszukiwania";
$pgv_lang["search_options"]			= "Opcje wyszukiwania";
$pgv_lang["soundex_results"]			= "Być może poniższe wyniki wyszukiwania z soundex będą pomocne.";


$pgv_lang["repos_found"]			= "Znaleziono repozytoria";
//-- SOURCELIST FILE MESSAGES
$pgv_lang["sources_found"]			= "Znaleziono źródła";
$pgv_lang["titles_found"]			= "Tytuł";
$pgv_lang["find_source"]			= "Znajdź Źrodło";
$pgv_lang["other_repo_records"]		= "Rekordy powiązane z tym repozytorium:";
$pgv_lang["repo_list"]				= "Lista repozytoriów";
$pgv_lang["confirm_delete_repo"]	= "Czy na pewno chcesz usunąć to repozytorium z bazy danych?";
$pgv_lang["paste_rid_into_field"]	= "Wstaw następujące ID do pola edycji by odnieść się do tego repozytorium ";
$pgv_lang["new_repo_created"]		= "Utworzono nowe repozytorium";
$pgv_lang["create_repository"]		= "Utwórz repozytorium";
$pgv_lang["delete_repo"]			= "Usuń repozytorium";
$pgv_lang["repo_info"]				= "Informacja o repozytorium";
$pgv_lang["total_repositories"]		= "Wszystkich repozytoriów";
$pgv_lang["find_repository"]		= "Znajdź repozytorium";

//-- SOURCE FILE MESSAGES
$pgv_lang["source_info"]			= "Informacje o źródłach";
$pgv_lang["other_records"]			= "Inne dane powiązane z tym źródłem:";
$pgv_lang["people"]				= "OSOBY";
$pgv_lang["families"]				= "RODZINY";
$pgv_lang["total_sources"]			= "ŹRÓDŁA";

//-- BUILDINDEX FILE MESSAGES
$pgv_lang["building_indi"]			= "Budowanie indeksu osób i rodzin";
$pgv_lang["building_index"]			= "Budowanie list indeksów";
$pgv_lang["invalid_gedformat"]	= "Nieprawidłowy format GEDCOM 5.5";
$pgv_lang["importing_records"]			= "Importowanie rekordów do bazy danych";
$pgv_lang["detected_change"]			= "phpGedView wykrył zmianę w pliku GEDCOM \$GEDCOM. Pliki indeksowe muszą zostać przetworzone przed kontynuacją.";
$pgv_lang["please_be_patient"]			= "PROSIMY O CIERPLIWOŚĆ";
$pgv_lang["reading_file"]			= "Odczytuję plik GEDCOM";
$pgv_lang["flushing"]				= "Usuwanie dotychczasowej zawartości";
$pgv_lang["found_record"]			= "Znaleziono dane";
$pgv_lang["exec_time"]				= "Całkowity czas wykonywania:";
$pgv_lang["time_limit"]				= "Limit czasu:";
$pgv_lang["unable_to_create_index"]		= "Utworzenie indeksu nie było możliwe. Upewnij się, że zapis jest dozwolony w katalogu phpGedView. Uprawnienia mogą być przywrócone gdy indeksy zostaną utworzone.";
$pgv_lang["indi_complete"]			= "Aktualizacja indeksu osób została zakończona.";
$pgv_lang["family_complete"]			= "Aktualizacja indeksu rodzin została zakończona.";
$pgv_lang["source_complete"]			= "Aktualizacja Indeksu źródeł została zakończona.";
$pgv_lang["tables_exist"]			= "Tabele PHPGedView już istnieją w bazie danych";
$pgv_lang["you_may"]				= "Możesz:";
$pgv_lang["drop_tables"]			= "Usunąć istniejące tabele";
$pgv_lang["import_multiple"]			= "Importować i pracować z wieloma GEDCOM-ami";
$pgv_lang["explain_options"]			= "Jeśli wybierzesz usuwanie istniejących tabel wszystkie dane zostaną zastąpione przez ten GEDCOM.<br />Jeśli wybierzesz import i pracę z wieloma GEDCOMami, phpGedView usunie wszystkie dane importowane z wykorzystaniem gedcomu o tej samej nazwie co \$GEDCOM. Ta opcja pozwala przechowywać dane z wielu GEDCOM'ow w tych samych tabelach i łatwo się między nimi przełączać.";
$pgv_lang["path_to_gedcom"]			= "Wpisz ścieżkę do pliku GEDCOM:";
$pgv_lang["gedcom_title"]			= "Wpisz tytuł opisujący dane w tym pliku GEDCOM:";
$pgv_lang["dataset_exists"]			= "Plik GEDCOM o takiej nazwie został juz raz zaimportowany do bazy danych.";
$pgv_lang["changes_present"]		= "W tym pilku GEDCOM znajdują się zmiany czekające na zatwierdzenie. Jeżeli będziesz kontynuować import, wszystkie te zmiany zostaną automatycznie zatwierdzone i wpisane do bazy danych. Zalecane jest najpierw przejżeć wszystkie oczekujące zmiany przed importem pliku GEDCOM.";
$pgv_lang["empty_dataset"]			= "Czy chcesz zaktualizować bazę danych?";
$pgv_lang["index_complete"]			= "Indeksowanie ukończone.";
$pgv_lang["click_here_to_go_to_pedigree_tree"] 	= "Kliknij tu by iść do drzewa genealogicznego.";
$pgv_lang["updating_is_dead"]			= "Updating is dead status for INDI ";
$pgv_lang["import_complete"]			= "Importowanie ukończone";
$pgv_lang["updating_family_names"]		= "Aktualizacja nazwisk rodzinnych dla FAM ";
$pgv_lang["processed_for"]			= "Przetworzono plik dla ";
$pgv_lang["run_tools"]			= "Czy chcesz uruchomić jedno z poniższych narzędzi zanim GEDCOM zostanie zaimportowany:";
$pgv_lang["addmedia"]			= "Narzędzie dodawania multimediów";
$pgv_lang["dateconvert"]		= "Narzędzie konwersji daty";
$pgv_lang["xreftorin"]			= "Konwersja identyfikatorów XREF do numerów RIN";
$pgv_lang["tools_readme"]		= "Więcej informacji znajdziesz w sekcji dotyczącej narzędzi w pliku #README.TXT#.";
$pgv_lang["sec"]				= "sec.";
$pgv_lang["bytes_read"]			= "Odczytano bajtów:";
$pgv_lang["created_remotelinks_fail"] 	= "Nie można utworzyć tabeli <i>Remotelinks</i>.";
$pgv_lang["created_remotelinks"]	= "Tabela <i>Remotelinks</i> utworzona pomyślnie.";
$pgv_lang["created_indis"]		= "Utworzono tabelę <i>Osób</i>.";
$pgv_lang["created_indis_fail"]	= "Błąd utworzenia tabeli <i>Osób/i>.";
$pgv_lang["created_fams"]		= "Utworzono tabelę <i>Rodzin</i>.";
$pgv_lang["created_fams_fail"]	= "Błąd utworzenia tabeli <i>Rodzin</i>.";
$pgv_lang["created_sources"]	= "Utworzono tabelę <i>Źródeł</i>.";
$pgv_lang["created_sources_fail"]	= "Błąd utworzenia tabeli <i>Źródeł</i>.";
$pgv_lang["created_other"]		= "Utworzono tabelę <i>Innych</i>.";
$pgv_lang["created_other_fail"]	= "Błąd utworzenia tabeli <i>Innych</i>.";
$pgv_lang["created_places"]		= "Utworzono tabelę <i>Miejsc</i>.";
$pgv_lang["created_places_fail"]	= "Błąd utworzenia tabeli <i>Miejsc</i>.";
$pgv_lang["import_progress"]	= "Importowanie w toku...";

//-- INDIVIDUAL AND FAMILYLIST FILE MESSAGES
$pgv_lang["total_fams"]				= "Wszystkich rodzin";
$pgv_lang["total_indis"]			= "Wszystkich osób";
$pgv_lang["starts_with"]			= "Zaczyna się od:";
$pgv_lang["person_list"]			= "Lista osób:";
$pgv_lang["paste_person"]			= "Wklej osobę";
$pgv_lang["notes_sources_media"]		= "Notatki, Źródła, i Multimedia";
$pgv_lang["notes"]				= "Notatki";
$pgv_lang["ssourcess"]			= "Źródła";
$pgv_lang["media"]				= "Multimedia";
$pgv_lang["name_contains"]			= "Nazwa zawiera:";
$pgv_lang["filter"]				= "Filtr";
$pgv_lang["find_individual"]			= "Znajdź ID osoby";
$pgv_lang["find_familyid"]			= "Znajdź ID rodziny";
$pgv_lang["find_familyid"]			= "Znajdź ID rodziny";
$pgv_lang["magnify"]				= "Powiększenie";
$pgv_lang["find_sourceid"]		= "Znajdź ID źródła";
$pgv_lang["find_specialchar"]		= "Znajdź znak specjalny";
$pgv_lang["alpha_index"]				= "Indeks alfabetyczny";
$pgv_lang["skip_surnames"]			= "Pomiń listę nazwisk";
$pgv_lang["show_surnames"]			= "Pokaż listę nazwisk";
$pgv_lang["all"]				= "Wszystkie";
$pgv_lang["year1"]					= "rok";
$pgv_lang["month1"]					= "miesiąc";
$pgv_lang["day1"]					= "dzień";
$pgv_lang["years"]					= "lata";
$pgv_lang["months"]					= "miesiące";
$pgv_lang["days"]					= "dni";
$pgv_lang["confidential"]			= "Poufne dane";
$pgv_lang["hidden"]					= "Ukryte";

//-- TIMELINE FILE MESSAGES
$pgv_lang["age"]				= "Wiek";
$pgv_lang["timeline_title"]			= "Linia czasu phpGedView";
$pgv_lang["timeline_chart"]			= "Wykres linii czasu";
$pgv_lang["remove_person"]			= "Usuń osobę";
$pgv_lang["show_age"]				= "Pokaż znacznik wieku";
$pgv_lang["add_another"]			= "Dodaj inną osobę do wykresu:<br />ID Osoby:";
$pgv_lang["find_id"]				= "Znajdź ID";
$pgv_lang["show"]				= "Pokaż";
$pgv_lang["year"]				= "Rok:";
$pgv_lang["timeline_instructions"]		= "W najnowszych przeglądarkach możesz przeciągać bloki po wykresie.";
$pgv_lang["zoom_in"]				= "Powiększ";
$pgv_lang["zoom_out"]				= "Pomniejsz";
$pgv_lang["lifespan_chart"] = "Wykres długości życia";
$pgv_lang["timeline_scrollSpeed"] = "Szybkość przewijania";
$pgv_lang["timeline_zoom"] = "Powiększenie";
$pgv_lang["include_family"] = "Dodaj najbliższą rodzinę";

//-- MONTH NAMES
$pgv_lang["jan"]				= "Styczeń";
$pgv_lang["feb"]				= "Luty";
$pgv_lang["mar"]				= "Marzec";
$pgv_lang["apr"]				= "Kwiecień";
$pgv_lang["may"]				= "Maj";
$pgv_lang["jun"]				= "Czerwiec";
$pgv_lang["jul"]				= "Lipiec";
$pgv_lang["aug"]				= "Sierpień";
$pgv_lang["sep"]				= "Wrzesień";
$pgv_lang["oct"]				= "Październik";
$pgv_lang["nov"]				= "Listopad";
$pgv_lang["dec"]				= "Grudzień";
$pgv_lang["abt"]				= "około";
$pgv_lang["aft"]				= "po";
$pgv_lang["and"]				= "i";
$pgv_lang["bef"]				= "przed";
$pgv_lang["bet"]				= "między";
$pgv_lang["cal"]				= "obliczone";
$pgv_lang["est"]				= "szacowane";
$pgv_lang["from"]				= "od";
$pgv_lang["int"]				= "zinterpretowane";
$pgv_lang["to"]					= "do";
$pgv_lang["cir"]				= "około";
$pgv_lang["apx"]				= "w przybl.";

//-- Admin File Messages
$pgv_lang["select_an_option"]			= "Wybierz opcje poniżej:";
$pgv_lang["readme_documentation"]		= "Dokumentacja README";
$pgv_lang["configuration"]			= "Konfiguracja";
$pgv_lang["rebuild_indexes"]			= "Przebuduj indeksy";
$pgv_lang["user_admin"]				= "Zarządzanie użytkownikami";
$pgv_lang["user_created"]			= "Użytkownik stworzony pomyślnie.";
$pgv_lang["user_create_error"]			= "Nie można dodać użytkownika.  Proszę się cofnąć i spróbować ponownie.";
$pgv_lang["password_mismatch"]			= "Hasło nie pasuje.";
$pgv_lang["enter_username"]			= "Musisz wpisać login.";
$pgv_lang["enter_fullname"]			= "Musisz wpisać pełne imię i nazwisko.";
$pgv_lang["enter_password"]			= "Musisz wpisać hasło.";
$pgv_lang["confirm_password"]			= "Musisz potwierdzić hasło.";
$pgv_lang["update_user"]			= "Uaktualnij użytkownika";
$pgv_lang["update_myaccount"]	= "Uaktualnij moje konto";
$pgv_lang["save"]				= "Zapisz";
$pgv_lang["delete"]				= "Skasuj";
$pgv_lang["edit"]				= "Edytuj";
$pgv_lang["editaccount"]			= "Zezwól użytkownikowi na edycję konta";
$pgv_lang["visibleonline"]			= "Widoczny dla innych użytkowników";
$pgv_lang["full_name"]				= "Imię i nazwisko";
$pgv_lang["admin_gedcom"]			= "Administrator GEDCOM";
$pgv_lang["confirm_user_delete"]	= "Czy na pewno chcesz usunąć tego użytkownika";
$pgv_lang["create_user"]		= "Utwórz użytkownika";
$pgv_lang["no_login"]				= "Błędny login lub hasło.";
$pgv_lang["import_gedcom"]			= "Importuj tem plik GEDCOM";
$pgv_lang["duplicate_username"]			= "Zduplikowana nazwa użytkownika. Taka nazwa już istnieje, wróć i wybierz inną.";
$pgv_lang["gedcomid"]				= "Identyfikator osoby w GEDCOMie";
$pgv_lang["enter_gedcomid"]			= "Musisz podać identyfikator GEDCOMu.";
$pgv_lang["user_info"]				= "Informacje o użytkowniku";
$pgv_lang["rootid"]				= "Korzeń wykresu rodowego";
$pgv_lang["download_gedcom"]			= "Ściagnij GEDCOM";
$pgv_lang["upload_gedcom"]			= "Wyślij GEDCOM";
$pgv_lang["add_new_gedcom"]		= "Dodaj nowy GEDCOM";
$pgv_lang["gedcom_file"]			= "Plik GEDCOM:";
$pgv_lang["enter_filename"]		= "Musisz podać nazwę pliku GEDCOM.";
$pgv_lang["file_not_exists"]	= "Podany plik nie istnieje.";
$pgv_lang["file_exists"]		= "Istnieje już GEDCOM o tej nazwie pliku. Wybierz inną nazwę lub usuń stary plik.";
$pgv_lang["new_gedcom_title"]	= "Dane genealogiczne z [#GEDCOMFILE#]";
$pgv_lang["upload_error"]			= "Wystąpił błąd podczas przesyłania pliku.";
$pgv_lang["upload_help"]			= "Wybierz plik ze swojego komputera do wysłania na serwer. Wszystkie pliki zostaną umieszczone w katalogu:";
$pgv_lang["add_gedcom_instructions"]	= "Podaj nazwę pliku dla nowego GEDCOMu. Nowy plik zostanie utworzony w katalogu indeksowym: ";
$pgv_lang["research_assistant"]		= "Asystent badań";
$pgv_lang["file_success"]			= "Plik został wysłany";
$pgv_lang["file_too_big"]			= "Plik przekracza dozwolony rozmiar";
$pgv_lang["file_partial"]			= "Plik wysłany jedynie częściowo, spróbuj ponownie";
$pgv_lang["file_missing"]			= "Plik nie został wysłany, spróbuj ponownie.";
$pgv_lang["manage_gedcoms"]			= "Zarządzaj plikami GEDCOM";
$pgv_lang["research_log"]			= "Dziennik Badań";
$pgv_lang["administration"]		= "Administracja";
$pgv_lang["ansi_to_utf8"]		= "Skonwertuj zakodowany w ANSI plik do UTF-8?";
$pgv_lang["utf8_to_ansi"]		= "Czy chcesz skonwertować GEDCOM zakodowany w UTF-8 do ANSI (ISO-8859-1)?";
$pgv_lang["siteadmin"]				= "Administrator strony";
$pgv_lang["user"]					= "Użytkownik zalogowany";
$pgv_lang["visitor"]				= "Gość";
$pgv_lang["user_manual"]		= "Podręcznik użytkownika PhpGedView";
$pgv_lang["upgrade"]			= "Zaktualizuj PhpGedView/ResearchLog";
$pgv_lang["view_logs"]			= "Pokaż logi";
$pgv_lang["logfile_content"]	= "Zawartość logu";
$pgv_lang["step1"]				= "Krok 1 z 4:";
$pgv_lang["step2"]				= "Krok 2 z 4:";
$pgv_lang["step3"]				= "Krok 3 z 4:";
$pgv_lang["step4"]				= "Krok 4 z 4:";
$pgv_lang["validate_gedcom"]	= "Sprawdź poprawność GEDCOM-u";
$pgv_lang["verify_upload_instructions"]	= "Jeżeli zdecydujesz się na kontynuację, stary plik gedcom zostanie zastąpiony nowym i zacznie się importowanie. Jeżeli przerwiesz, stary gedcom pozostanie niezmieniony.";
$pgv_lang["img_admin_settings"]	= "Zmień konfigurację manipulacji obrazami";
$pgv_lang["download_note"]		= "UWAGA: Duże GEDCOMy potrzebują sporo czasu na przetworzenie przed ściągnięciem. Jeśli czas wykonywania skryptu PHP okaże się krótszy, możesz nie ściągnąć całości. Sprawdź czy ściągnięty plik zawiera linię 0 TRLR na końcu, co oznacza kompletność. Generalnie ściągnięcie może zająć tyle samo czasu co importowanie.";
$pgv_lang["pgv_registry"]		= "Zobacz inne strony korzystające z PHPGedView";
$pgv_lang["cancel_upload"]			= "Przerwij wysyłanie";
$pgv_lang["manage_media_files"]		= "Zarządzaj plikami mediów";

//-- Relationship chart messages
$pgv_lang["relationship_chart"]			= "Wykres pokrewieństwa";
$pgv_lang["person1"]				= "Osoba 1";
$pgv_lang["person2"]				= "Osoba 2";
$pgv_lang["no_link_found"]			= "Nie znaleziono powiązań między tymi osobami.";
$pgv_lang["sibling"]				= "Rodzeństwo";
$pgv_lang["follow_spouse"]			= "Sprawdź pokrewieństwo przez małżeństwo.";
$pgv_lang["timeout_error"]			= "Czas wykonywania został przekroczony przez zakończeniem poszukiwań.";
$pgv_lang["son"]				= "Syn";
$pgv_lang["aunt"]					= "Ciocia";
$pgv_lang["uncle"]				= "Wujek";
$pgv_lang["femalecousin"]			= "Kuzynka";
$pgv_lang["malecousin"]				= "Kuzyn";
$pgv_lang["firstcousin"]			= "Kuzyn";
$pgv_lang["daughter"]				= "Córka";
$pgv_lang["granddaughter"]			= "Wnuczka";
$pgv_lang["grandson"]				= "Wnuk";
$pgv_lang["sister-in-law"]			= "Szwagierka";
$pgv_lang["brother-in-law"]		= "Szwagier";
$pgv_lang["daughter-in-law"]		= "Synowa";
$pgv_lang["son-in-law"]				= "Zięć";
$pgv_lang["brother"]				= "Brat";
$pgv_lang["sister"]				= "Siostra";
$pgv_lang["relationship_to_me"]	= "Pokrewieństwo ze mną";
$pgv_lang["bosa_2"] 				= "Syn";
$pgv_lang["bosa_11"]				= "Prawnuczka";
$pgv_lang["bosa_15"]				= "Prawnuczka";
$pgv_lang["bosa_14"]				= "Prawnuk";
$pgv_lang["bosa_13"]				= "Prawnuczka";
$pgv_lang["bosa_12"]				= "Prawnuk";
$pgv_lang["bosa_10"]				= "Prawnuk";
$pgv_lang["bosa_9"] 				= "Prawnuczka";
$pgv_lang["bosa_8"] 				= "Prawnuk";
$pgv_lang["bosa_7"] 				= "Wnuczka";
$pgv_lang["bosa_6"] 				= "Wnuk";
$pgv_lang["bosa_5"] 				= "Wnuczka";
$pgv_lang["bosa_4"] 				= "Wnuk";
$pgv_lang["bosa_3"] 				= "Córka";
$pgv_lang["rela_husb"]				= "Pokrewieństwo z mężem";
$pgv_lang["rela_wife"]				= "Pokrewieństwo z żoną";
$pgv_lang["next_path"]			= "Pokaż następną ścieżkę";
$pgv_lang["show_path"]			= "Pokaż ścieżkę";
$pgv_lang["oldest_top"]             = "Pokaż starszych u góry";
$pgv_lang["line_up_generations"]	= "Uporządkuj w linii te same pokolenia";

//-- gedcom edit utility
$pgv_lang["check_delete"]			= "Czy na pewno chcesz usunąć tą informację z GEDCOM-u?";
$pgv_lang["access_denied"]			= "<b>Brak dostępu</b><br />Nie masz uprawnień dostępu do tych zasobów.";
$pgv_lang["gedrec_deleted"]			= "Informaja z GEDCOMu została usunięta.";
$pgv_lang["gedcom_deleted"]		= "GEDCOM [#GED#] został usunięty.";
$pgv_lang["changes_exist"]			= "Ten GEDCOM został zmieniony.";
$pgv_lang["accept_changes"]			= "Akceptuj / Odrzuć zmiany";
$pgv_lang["show_changes"]			= "Te dane zostały zaktualizowane. Kliknij tutaj aby zobaczyć zmiany.";
$pgv_lang["hide_changes"]		= "Kliknij aby ukryć zmiany.";
$pgv_lang["refresh"]				= "Odśwież";
$pgv_lang["review_changes"]			= "Przeglądnij zmiany w GEDCOM";
$pgv_lang["undo_successful"]			= "Cofnięcie zakończone sukcesem";
$pgv_lang["undo"]				= "Cofnij";
$pgv_lang["view_change_diff"]			= "Pokaż porównianie zmian";
$pgv_lang["changes_occurred"]			= "Następujące zmiany dokonano w informacjach o tej osobie:";
$pgv_lang["find_place"]				= "Znajdź miejsce";
$pgv_lang["close_window"]			= "Zamknij okno";
$pgv_lang["close_window_without_refresh"] = "Zamknij okno bez odświeżania";
$pgv_lang["place_contains"]			= "Miejsce zawiera:";
$pgv_lang["accept_gedcom"]			= "Każdą zmnianę możesz zaakceptować lub odrzucić.<br />Aby zaakceptować wszystko na raz kliknij \"Zaakceptuj wszystkie zmiany\" poniżej.<br />Aby zobaczyć więcej informacji o zmianie, <br />kliknij \"Pokaż porównianie zmian\" co wyświetli różnice między starą i nową sytuacją, <br />lub kliknij \"Zobacz rekord GEDCOM\" aby zobaczyć nowe informacje w formacie GEDCOM.";
$pgv_lang["ged_import"]				= "Importuj GEDCOM";
$pgv_lang["now_import"]				= "Teraz możesz zaimportować dane z GEDCOM-u do phpGedView klikając na odnośnik poniżej.";
$pgv_lang["add_fact"]				= "Dodaj nowy fakt";
$pgv_lang["add"]				= "Dodaj";
$pgv_lang["custom_event"]			= "Inne wydarzenie";
$pgv_lang["update_successful"]			= "Aktualizacja zakończona sukcesem";
$pgv_lang["add_child"]				= "Dodaj dziecko";
$pgv_lang["add_child_to_family"]		= "Dodaj dziecko do tej rodziny";
$pgv_lang["add_sibling"]		= "Dodaj brata lub siostrę";
$pgv_lang["add_son_daughter"]	= "Dodaj syna lub córkę";
$pgv_lang["must_provide"]			= "Musisz podać ";
$pgv_lang["delete_person"]			= "Usuń tą osobę";
$pgv_lang["confirm_delete_person"]		= "Czy na pewno chcesz usunąć tą osobę z pliku GEDCOM?";
$pgv_lang["find_media"]				= "Znajdź multimedia";
$pgv_lang["set_link"]				= "Ustaw odnośnik";
$pgv_lang["add_source_lbl"]		= "Dodaj cytat źródła";
$pgv_lang["add_source"]				= "Dodaj źródło do faktu";
$pgv_lang["add_note_lbl"]		= "Dodaj notatkę";
$pgv_lang["add_note"]				= "Dodaj nową notatkę";
$pgv_lang["add_media_lbl"]		= "Dodaj multimedia";
$pgv_lang["add_media"]			= "Dodaj nowe multimedia";
$pgv_lang["delete_source"]		= "Usuń to źródło";
$pgv_lang["confirm_delete_source"]	= "Czy na pewno chcesz usunąć to źródło z pliku GEDCOM?";
$pgv_lang["add_husb"]			= "Dodaj męża";
$pgv_lang["add_husb_to_family"]	= "Dodaj męża do tej rodziny";
$pgv_lang["add_wife"]			= "Dodaj żonę";
$pgv_lang["add_wife_to_family"]	= "Dodaj żonę do tej rodziny";
$pgv_lang["find_family"]		= "Znajdź rodzinę";
$pgv_lang["find_fam_list"]		= "Znajdź listę rodzin";
$pgv_lang["add_new_wife"]		= "Dodaj nową żonę";
$pgv_lang["add_new_husb"]		= "Dodaj nowego męża";
$pgv_lang["edit_name"]			= "Zmień nazwisko";
$pgv_lang["delete_name"]		= "Usuń nazwisko";
$pgv_lang["no_temple"]			= "Brak świątyni - Living Ordinance";
$pgv_lang["replace"]			= "Zamień rekord";
$pgv_lang["append"]				= "Dołącz rekord";
$pgv_lang["add_father"]			= "Dodaj nowego ojca";
$pgv_lang["add_mother"]			= "Dodaj nową matkę";
$pgv_lang["add_obje"]			= "Dodaj nowy obiekt multimedialny";
$pgv_lang["no_changes"]			= "Nie ma obecnie zmian oczekujących akceptacji.";
$pgv_lang["accept"]				= "Zaakceptuj";
$pgv_lang["accept_all"]			= "Zaakceptuj wszystkie zmiany";
$pgv_lang["accept_successful"]	= "Zmiany zostały wprowadzone do bazy danych";
$pgv_lang["edit_raw"]			= "Edytuj plik GEDCOM";
$pgv_lang["edit_sex"]				= "Edytuj płeć";
$pgv_lang["ged_noshow"]				= "Ta strona została wyłączona przez administratora.";
$pgv_lang["bdm"]					= "Urodziny, śmierci, małżeństwa";
$pgv_lang["select_date"]		= "Wybierz datę";
$pgv_lang["create_source"]		= "Utwórz nowe źródło";
$pgv_lang["new_source_created"]	= "Nowe źródło zostało utworzone.";
$pgv_lang["paste_id_into_field"]= "Wklej poniższy identyfikator źródła w pole edycji aby powołać się na to źródło ";
$pgv_lang["user_cannot_edit"]		= "Użytkownik nie może edytować tego GEDCOM";
$pgv_lang["privacy_prevented_editing"]	= "Ustawienie prywatności uniemożliwia ci edycję";
$pgv_lang["add_asso"]				= "Dodaj nowe powiązanie";
$pgv_lang["gedcom_editing_disabled"]	= "Edycja tego GEDCOM'u została zablokowana";
$pgv_lang["add_name"]				= "Dodaj nowe imię";
$pgv_lang["privacy_not_granted"]	= "Nie masz dostępu do ";
$pgv_lang["add_name"]				= "";
$pgv_lang["add_name"]				= "Dodaj nowe nazwisko";

//-- calendar.php messages
$pgv_lang["on_this_day"]			= "Tego dnia w twojej historii...";
$pgv_lang["in_this_month"]		= "W tym miesiącu, w twojej historii...";
$pgv_lang["in_this_year"]		= "W tym roku, w twojej historii...";
$pgv_lang["year_anniversary"]			= "#year_var# rocznica";
$pgv_lang["today"]				= "Dzisiaj";
$pgv_lang["day"]				= "Dzień:";
$pgv_lang["month"]				= "Miesiąc:";
$pgv_lang["showcal"]			= "Pokaż wydarzenia:";
$pgv_lang["anniversary_calendar"] 		= "Kalendarz rocznic";
$pgv_lang["sunday"]				= "Niedziela";
$pgv_lang["monday"]				= "Poniedziałek";
$pgv_lang["tuesday"]				= "Wtorek";
$pgv_lang["wednesday"]				= "Środa";
$pgv_lang["thursday"]				= "Czwartek";
$pgv_lang["friday"]				= "Piątek";
$pgv_lang["saturday"]				= "Sobota";
$pgv_lang["viewday"]				= "Pokaż dzień";
$pgv_lang["viewmonth"]				= "Pokaż miesiąc";
$pgv_lang["viewyear"]			= "Pokaż rok";
$pgv_lang["all_people"]			= "Wszystkich ludzi";
$pgv_lang["living_only"]		= "Żyjących ludzi";
$pgv_lang["recent_events"]		= "Z ostatnich lat (&lt; 100 lat)";
$pgv_lang["day_not_set"]			= "Dzień nie ustawiony";
$pgv_lang["year_error"]			= "Niestety, daty sprzed 1970 nie są obsługiwane.";

//-- upload media messages
$pgv_lang["upload_media"]			= "Wyślij pliki multimedialne";
$pgv_lang["media_file"]				= "Plik multimedialny";
$pgv_lang["thumbnail"]				= "Miniaturka";
$pgv_lang["upload_successful"]			= "Wysyłanie zakończone sukcesem";

//-- user self registration module
//$pgv_lang["no_pw_or_account"]		= "If you have no account yet, or lost your password, just click the <b>Login</b> button";
$pgv_lang["lost_password"]		= "Zgubione hasło?";
$pgv_lang["requestpassword"]	= "Wysyłka nowego hasła";
$pgv_lang["no_account_yet"]		= "Nie masz konta?";
$pgv_lang["requestaccount"]		= "Poproś o nowe konto";
$pgv_lang["register_info_01"]	= "Ilość danych, które są publicznie dostępne na tej stronie może być ograniczona przez funkcje ochrony prywatności. Większość ludzi nie życzy sobie aby ich dane były publicznie dostępne. Mogłyby one zostać wykorzystane do spamowania lub kradzieży tożsamości.<br /><br />Aby uzyskać dostęp do prywatnych informacji musisz posiadać konto na stronie. Aby otrzymać konto możesz się zarejestrować podając wymagane informacje. Po tym jak administrator sprawdzi i zatwierdzi twoją rejestrację, będziesz mógł (mogła) logować się i przeglądać prywatne dane.<br /><br />Jeśli włączona została prywatność pokrewieństwa będziesz mógł(mogła) jedynie przeglądać informacje dotyczące bliskich krewnych. Administrator może również udzielić zezwolenia na edycję danych zawartych w GEDCOM-ie.<br /><br />UWAGA: Otrzymasz dostęp do prywatnych informacji tylko wtedy, kiedy zdołasz udowodnić, że jesteś krewnym(krewną) jednej z osób w bazie danych.<br /><br />Osoby spoza rodziny mają niewielkie szanse otrzymania konta, mogą więc równie dobrze darować sobie kłopotu.<br />Jeśli będziesz potrzebował(a) dalszej pomocy, skorzystaj z odnośnika kontaktowego poniżej aby napisać do administratora.<br /><br />";
$pgv_lang["register_info_02"]	= "";
$pgv_lang["pls_note01"]			= "Uwaga: System rozpoznaje małe i duże litery!";
$pgv_lang["mandatory"] 			= "Pola oznaczone * są obowiązkowe.";
$pgv_lang["min6chars"]			= "Hasło powinno zawierać minimum 6 znaków";
$pgv_lang["pls_note02"]			= "Uwaga: Hasła mogą zawierać litery, cyfry i inne znaki.";
$pgv_lang["pls_note03"]			= "Adres email zostanie zweryfikowany przed aktywacją konta. Nie będzie on wyświetlany nigdzie na stronie. Wiadomość zawierająca twoje dane rejestracyjne zostanie wysłana pod ten adres.";
$pgv_lang["emailadress"]		= "Adres email";
$pgv_lang["pls_note04"]			= "Pola oznaczone przez * są obowiązkowe.";
$pgv_lang["pls_note05"]			= "W oczekiwaniu na weryfikację twoich odpowiedzi otrzymasz email potwierdzający na adres podany przy rejestracji. Postępując według instrukcji zawartych w tej wiadomości będziesz musiał(a) aktywować swoje konto. Jeśli nie dokonasz tego w przeciągu siedmiu dni, zostanie ono usunięte (będziesz mógł (mogła) ponownie się zarejestrować po tym czasie). Aby korzystać z zasobów tej strony będziesz musiał(a) zapamiętać swój login i hasło. Musisz podać istniejący, prawidłowy adres email na tej stronie aby otrzymać email aktywujący konto.<br /><br />Jeżeli napotkasz problemy podczas rejestracji, skontaktuj się z webmasterem.";

$pgv_lang["mail01_line01"]		= "Witaj #user_fullname# ...";
$pgv_lang["mail01_line02"]		= "Podczas rejestracji na ( #SERVER_NAME# ) podany został twój adres email ( #user_email# ).";
$pgv_lang["mail01_line03"]		= "Wykorzystano następujące dane.";
$pgv_lang["mail01_line04"]		= "Kliknij na odnośnik poniżej i wpisz wymagane informacje aby zweryfikować twoje konto i adres email.";
$pgv_lang["mail01_line05"]		= "Jeśli nie prosiłeś(aś) o te dane możesz po prostu skasować tą wiadomość.";
$pgv_lang["mail01_line06"]		= "Nie otrzymasz więcej żadnych listów, ponieważ konto zostanie w ciągu siedmiu dni usunięte.";

$pgv_lang["mail01_subject"]		= "Twoja rejestracja na #SERVER_NAME#";

$pgv_lang["mail02_line01"]		= "Witaj Administratorze ...";
$pgv_lang["mail02_line02"]		= "Nowy użytkownik zarejestrował się na ( #SERVER_NAME# ).";
$pgv_lang["mail02_line03"]		= "Otrzymał email z informacjami niezbędnymi do weryfikacji konta.";
$pgv_lang["mail02_line04"]		= "Gdy tylko zakończy ten proces zostaniesz o tym poinformowany przez email aby udzielić nowemu użytkownikowi pozwolenia na zalogowanie się.";
$pgv_lang["mail02_line04a"]			= "Zostaniesz poinformowany przy pomocy poczty elektronicznej kiedy przyszły użytkownik zweryfikuje swoje dane. Po weryfikacji, użytkownik ten będzie mógł zalogować się bez twojego udziału.";

$pgv_lang["mail02_subject"]		= "Nowa rejestracja na #SERVER_NAME#";

$pgv_lang["hashcode"]			= "Kod weryfikacyjny:";
$pgv_lang["thankyou"]			= "Witaj #user_fullname# ...<br />Dziękujemy za rejestrację";
$pgv_lang["pls_note06"]			= "Otrzymasz teraz email potwierdzający pod adres ( #user_email# ). Postępując według instrukcji zawartych w tej wiadomości będziesz musiał(a) aktywować swoje konto. Jeśli nie dokonasz tego w przeciągu siedmiu dni, zostanie ono usunięte (będziesz mógł (mogła) ponownie się zarejestrować po tym czasie). Aby korzystać z zasobów tej strony będziesz musiał (musiała) zapamiętać swój login i hasło.";
$pgv_lang["pls_note06a"] 			= "Zaraz zostanie wysłany potwierdzający email na adres (#user_email#). Musisz zweryfikować swoje konto według intrukcji zawartej w tym mailu. Jeżeli tego nie zrobisz w przeciągu 3 dni, twoja prośba o założenie konta zostanie automatycznie skasowana. Będziesz musiał ponownie wysłać prośbę o nowe konto.<br/><br/>Po wykonaniu wszystkich intrukcji zawartych w potwierdzającym emialu będziesz mógł się zalogować. Aby zalogować się na stronie, musisz znać swoją nazwę użytkownika i hasło.<br /><br />";

$pgv_lang["registernew"]		= "Potwierdzenie nowego konta";
$pgv_lang["user_verify"]		= "Weryfikacja użytkownika";
$pgv_lang["send"]				= "Wyślij";

$pgv_lang["pls_note07"]			= "Podaj swoją nazwę użytkownika, hasło oraz kod weryfikacyjny, który otrzymałeś(łaś) w wiadomości email w celu zweryfikowania twojego konta.";
$pgv_lang["pls_note08"]			= "Informacje o użytkowniku #user_name# zostały sprawdzone.";

$pgv_lang["mail03_line01"]		= "Witaj Administratorze ...";
$pgv_lang["mail03_line02"]		= "#newuser[username]# ( #newuser[fullname]# ) zweryfikował swoje dane rejestracyjne.";
$pgv_lang["mail03_line03"]		= "Korzystając z poniższego odnośnika możesz zalogować się na stronie, poddać edycji konto użytkownika i udzielić mu zezwolenia na zalogowanie się na stronie.";

$pgv_lang["mail03_subject"]		= "Nowa weryfikacja na #SERVER_NAME#";

$pgv_lang["pls_note09"]			= "Zosta-łeś(łaś) zidentyfikowany(a) jako zarejestrowany użytkownik.";
$pgv_lang["pls_note10"]			= "Administrator został o tym poinformowany.<br />Gdy tylko udzieli zezwolenia będziesz mógł (mogła) zalogować się na stronie korzystając ze swojego loginu i hasła.";
$pgv_lang["pls_note10a"]			= "Możesz teraz się zalogować używając swojej nazwy użytkownika i hasła.";
$pgv_lang["data_incorrect"]		= "Dane nie są prawidłowe!<br />Spróbuj ponownie!";
$pgv_lang["user_not_found"]		= "Weryfikacja podanych informacji nie była możliwa. Wróć i spróbuj ponownie.";

$pgv_lang["lost_pw_reset"]		= "Zgubione hasło";

$pgv_lang["pls_note11"]			= "Aby twoje hasło zostało zresetowane, podaj nazwę użytkownika i adres email twojego konta.<br /><br />Wyślemy ci wiadomość z adresem, który zawierał będzie kod aktywacyjny dla twojego konta. Odwiedzając podany adres będziesz mógł (mogła) zmienić swoje hasło i zalogować się na stronie. Z powodów bezpieczeństwa nie powinieneś (powinnaś) pokazywać tego kodu nikomu, włączając w to administratorów tej strony (nie będziemy o niego pytać).<br /><br />Jeśli będziesz potrzebował(a) pomocy, skontaktuj się z administratorem.";
$pgv_lang["enter_email"]		= "Musisz podać adres email.";

$pgv_lang["mail04_line01"]		= "Witaj #user_fullname# ...";
$pgv_lang["mail04_line02"]		= "Otrzymaliśmy wniosek o nowe hasło dla twojego konta!";
$pgv_lang["mail04_line03"]		= "Recomendacja:";
$pgv_lang["mail04_line04"]		= "Teraz kliknij na odnośnik poniżej, zaloguj się korzystając z nowego hasła i zmień je aby zachować odpowiedni poziom bezpieczeństwa.";

$pgv_lang["mail04_subject"]		= "Wniosek o dane z #SERVER_NAME#";

$pgv_lang["pwreqinfo"]			= "Witaj...<br /><br />Wiadomość została wysłana pod adres (#user[email]#) zawierająca nowe hasło.<br /><br />Sprawdź pocztę, ponieważ wiadomość ta powinna dojść w przeciągu kilku minut.<br /><br />Rekomendacja:<br /><br />Po otrzymaniu maila powinieneś (powinnaś) zalogować się korzystając z nowego hasła i zmienić je aby zachować odpowiedni poziom bezpieczeństwa.";

$pgv_lang["editowndata"]		= "Moje konto";
$pgv_lang["savedata"]			= "Zapisz zmiany";
$pgv_lang["datachanged"]		= "Dane użytkownika zostały zmienione!";
$pgv_lang["datachanged_name"]		= "Może być wymagane ponowne zalogowanie.";
$pgv_lang["myuserdata"]			= "Moje konto";
$pgv_lang["verified"]			= "Użytkownik zweryfikowany";
$pgv_lang["verified_by_admin"]	= "Zatwierdzony przez administratora";
$pgv_lang["user_theme"]			= "Mój wygląd";
$pgv_lang["mgv"]				= "MyGedView";
$pgv_lang["mygedview"]			= "Portal MyGedView";
$pgv_lang["passwordlength"]		= "Hasło musi zawierać przynajmniej 6 znaków.";
$pgv_lang["admin_approved"]		= "Twoje konto na #SERVER_NAME# zostało zatwierdzone";
$pgv_lang["you_may_login"]		= " przez administratora.  Możesz teraz zalogować się podążając za odnośnikiem poniżej:";
$pgv_lang["welcome_text_auth_mode_1"]	=	"<b>WITAJ NA TEJ STRONIE GENEALOGICZNEJ</b><br /><br />Dostęp do tej strony mają jedynie osoby posiadające konto użytkownika.<br />Jeżeli już posiadasz takie konto, możesz zalogować się na tej stronie.<br /><br />Jeśli nie posiadasz jeszcze konta możesz ubiegać się o nie klikając na odpowiedni odnośnik poniżej.<br />Po weryfikacji administrator aktywuje twoje konto.<br />Otrzymasz wtedy email z powiadomieniem.";
$pgv_lang["welcome_text_auth_mode_2"]	=	"<b>WITAJ NA TEJ STRONIE GENEALOGICZNEJ</b><br /><br />Dostęp do tej strony mają jedynie <b>autoryzowani</b> użytkownicy.<br />Jeżeli już posiadasz konto, możesz zalogować się na tej stronie.<br /><br />Jeśli nie posiadasz jeszcze konta możesz ubiegać się o nie klikając na odpowiedni odnośnik poniżej.<br />Po weryfikacji administrator zaakceptuje lub odrzuci twój wniosek.<br />Otrzymasz email z powiadomieniem w przypadku akceptacji twojego wniosku.";
$pgv_lang["welcome_text_auth_mode_3"]	=	"<b>WITAJ NA TEJ STRONIE GENEALOGICZNEJ</b><br /><br />Dostęp do tej strony mają jedynie <b>członkowie rodziny</b>.Jeżeli już posiadasz takie konto, możesz zalogować się na tej stronie.<br /><br />Jeśli nie posiadasz jeszcze konta możesz ubiegać się o nie klikając na odpowiedni odnośnik poniżej.<br />Po weryfikacji administrator zaakceptuje lub odrzuci twój wniosek.<br />Otrzymasz email z powiadomieniem w przypadku akceptacji twojego wniosku.";
$pgv_lang["welcome_text_cust_head"]		=	"<b>WITAJ NA TEJ STRONIE GENEALOGICZNEJ</b><br /><br />Dostęp do tej strony mają jedynie osoby posiadające już konta.<br />";


//-- mygedview page
$pgv_lang["no_login_users"]			= "Brak zalogowanych użytkowników";
$pgv_lang["login_users"]			= "#pgv_lang[global_num1]# zalogowanych użytkowników";
$pgv_lang["welcome"]			= "Witaj";
$pgv_lang["upcoming_events"]	= "Nadchodzące wydarzenia";
$pgv_lang["basic_or_all"]			= "Pokaż tylko narodziny, śmierci i śluby?";
$pgv_lang["living_or_all"]			= "Pokaż tylko zdarzenia ludzi żyjących?";
$pgv_lang["no_events_living"]		= "Brak zdarzeń dla osób żyjących na najbliższe #pgv_lang[global_num1]# dni.";
$pgv_lang["no_events_living1"]		= "Brak zdarzeń dla osób żyjących na jutro.";
$pgv_lang["none_today_privacy"]		= "Istnieją zdarzenia na dziś, ale ustawienia prywatności nie pozwalają ich wyświetlić.";
$pgv_lang["none_today_all"]			= "Brak zdarzeń na dziś.";
$pgv_lang["none_today_living"]		= "Brak zdarzeń dla osób żyjących na dziś.";
$pgv_lang["more_events_privacy1"]	= "<br />Istnieje więcej zdarzeń na jutro, ale ustawienia prywatności nie pozwalają ich wyświetlić.";
$pgv_lang["more_events_privacy"]	= "<br />Istnieje więcej zdarzeń na najbliższe #pgv_lang[global_num1]# dni, ale ustawienia prywatności nie pozwalają ich wyświetlić.";
$pgv_lang["no_events_all1"]			= "Brak zdarzeń na jutro.";
$pgv_lang["no_events_privacy1"]		= "Istnieją zdarzenia na jutro, ale ustawienia prywatności nie pozwalają ich wyświetlić.";
$pgv_lang["no_events_privacy"]		= "Istnieją zdarzenia na najbliższe #pgv_lang[global_num1]# dni, ale ustawienia prywatności nie pozwalają ich wyświetlić.";
$pgv_lang["no_events_all"]			= "Brak zdarzeń na najbliższe #pgv_lang[global_num1]# dni.";
$pgv_lang["chat"]				= "Chat";
$pgv_lang["users_logged_in"]	= "Użytkownicy zalogowani";
$pgv_lang["login_user"]				= "1 zalogowany użytkownik";
$pgv_lang["message"]			= "Wyślij wiadomość";
$pgv_lang["my_messages"]		= "Moje wiadomości";
$pgv_lang["date_created"]		= "Data wysłania:";
$pgv_lang["message_from"]		= "Adres eMail:";
$pgv_lang["message_from_name"]	= "Twoje imię:";
$pgv_lang["message_to"]			= "Wiadomość do:";
$pgv_lang["message_subject"]	= "Temat:";
$pgv_lang["message_body"]		= "Treść:";
$pgv_lang["no_to_user"]			= "Nie podano odbiorcy, nie można kontynuować.";
$pgv_lang["provide_email"]		= "Podaj swój adres email abyśmy mogli odpowiedzieć na twoją wiadomość. Jeśli go nie podasz, odpowiedź nie będzie możliwa. Twój adres nie zostanie wykorzystany w żadnym innym celu poza wysłaniem odpowiedzi.";
$pgv_lang["reply"]				= "Odpowiedz";
$pgv_lang["message_deleted"]	= "Wiadomość usunięta";
$pgv_lang["message_sent"]		= "Wiadomość wysłana";
$pgv_lang["reset"]				= "Zresetuj";
$pgv_lang["site_default"]		= "Domyślne ustawienia strony";
$pgv_lang["mygedview_desc"]		= "Strona MyGedView pozwala zapisywać zakładki do najważniejszych osób, śledzić nadchodzące wydarzenia i komunikować się z innymi użytkownikami phpGedView.";
$pgv_lang["no_messages"]		= "Nie masz żadnych wiadomości.";
$pgv_lang["clicking_ok"]		= "Kliknięcie OK otworzy nowe okno, w którym będziesz mógł (mogła)skontaktować się z #user[fullname]#";
$pgv_lang["favorites"]				= "Zakładki";
$pgv_lang["my_favorites"]		= "Moje zakładki";
$pgv_lang["no_favorites"]		= "Nie określiłeś (określiłaś) żadnych zakładek. Aby oznaczyć zakładkę przy danej osobie znajdź jej szczegóły i kliknij \"Dodaj do zakładek\" lub skorzystaj z formularza poniżej aby dodać zakładkę dla osoby o danym ID.";
$pgv_lang["add_to_my_favorites"]	= "Dodaj do zakładek";
$pgv_lang["gedcom_favorites"]	= "Główne postacie GEDCOM-u";
$pgv_lang["no_gedcom_favorites"]	= "W tej chwili administrator nie określił głównych postaci.";
$pgv_lang["confirm_fav_remove"]	= "Czy na pewno chcesz usunąć ten element z zakładek?";
$pgv_lang["invalid_email"]		= "Podaj prawidłowy adres email.";
$pgv_lang["enter_subject"]		= "Podaj tytuł wiadomości.";
$pgv_lang["enter_body"]			= "Wpisz tekst wiadomości przed wysłaniem.";
$pgv_lang["confirm_message_delete"]	= "Czy na pewno chcesz usunąć tą wiadomość? Nie będzie można jej później odzyskać.";
$pgv_lang["message_email1"]		= "Następująca wiadomość została wysłana do ciebie od ";
$pgv_lang["message_email2"]		= "Wysłałeś następującą wiadomość do użytkownika PhpGedView:";
$pgv_lang["message_email3"]		= "Wysłałeś następującą wiadomość do administratora PhpGedView:";
$pgv_lang["viewing_url"]		= "Ta wiadomość została wysłana z odnośnika na stronie: ";
$pgv_lang["messaging2_help"]		= "Po wysłaniu tej wiadomości otrzymasz jej kopię na adres email, który podałeś.";
$pgv_lang["random_picture"]		= "Losowe zdjęcie";
$pgv_lang["message_instructions"]	= "<b>Uwaga:</b> Informacje na temat osób żyjących będą wyświetlane jedynie dla członków rodziny i bliskich znajomych. Zostaniesz poproszony(a) o zweryfikowanie swojego pokrewieństwa przed otrzymaniem jakichkolwiek danych. Czasami informacje o osobach zmarłych mogą rówmnież zostać zatajone. Dzieje się tak najczęściej wtedy, gdy nie ma wystarczającej ilości informacji do określenia czy osoba ta żyje czy nie.<br /><br />Przed zadaniem pytania sprawdź czy interesujesz się właściwą osobą, sprawdzając daty, miejsca i bliskich krewnych. Jeśli wysyłasz nowe dane genealogiczne dołącz także informacje o źródłach pochodzenia tych danych.<br /><br />";
$pgv_lang["sending_to"]			= "Ta wiadomość zostanie wysłana do #TO_USER#";
$pgv_lang["preferred_lang"]	 	= "Ten użytkownik preferuje otrzymywać wiadomości w języku #USERLANG#";
$pgv_lang["gedcom_created_using"]	= "Ten GEDCOM został utworzony przez <b>#SOFTWARE# #VERSION#</b>";
$pgv_lang["gedcom_created_on"]	= "Ten GEDCOM został utworzony dnia <b>#DATE#</b>";
$pgv_lang["gedcom_created_on2"]	= " dnia <b>#DATE#</b>";
$pgv_lang["gedcom_stats"]		= "Statystyki GEDCOM";
$pgv_lang["stat_individuals"]	= "Osób";
$pgv_lang["stat_families"]		= "Rodzin";
$pgv_lang["stat_sources"]		= "Źródeł";
$pgv_lang["stat_other"]			= "Innych danych";
$pgv_lang["stat_earliest_birth"] 	= "Osoba urodzona najwcześniej";
$pgv_lang["stat_latest_birth"] 	= "Osoba urodzona najpóźniej";
$pgv_lang["stat_latest_death"] 	= "Osoba zmarła najpóźniej";
$pgv_lang["stat_earliest_death"] 	= "Osoba zmarła najwcześniej";
$pgv_lang["customize_page"]		= "Dostosuj wygląd portalu MyGedView";
$pgv_lang["customize_gedcom_page"]	= "Dostosuj tą stronę powitalną";
$pgv_lang["upcoming_events_block"]	= "Blok nadchodzących wydarzeń";
$pgv_lang["upcoming_events_descr"]	= "Blok nadchodzących wydarzeń pokazuje listę zbliżających się rocznic w ciągu najbliższych 30 dni. Na stronie MyGedView blok ten wyświetla jedynie żyjące osoby. Na stronie powitalnej wyświetlone zostaną wszystkie osoby.";
$pgv_lang["todays_events_block"]	= "Blok tego dnia w historii";
$pgv_lang["todays_events_descr"]	= "Blok tego dnia w historii pokazuje listę wydarzeń z aktywnego GEDCOM-u, których rocznica przypada na dany dzień. W przypadku braku takich wydarzeń blok nie jest pokazywany. Na stronie MyGedView blok ten wyświetla jedynie żyjące osoby. Na stronie powitalnej wyświetlone zostaną wszystkie osoby.";
$pgv_lang["logged_in_users_block"]	= "Blok zalogowanych użytkowników";
$pgv_lang["logged_in_users_descr"]	= "Blok zalogowanych użytkowników zawiera listę innych osób, które aktualnie zalogowały się w systemie.";
$pgv_lang["user_messages_block"]	= "Blok wiadomości użytkownika";
$pgv_lang["user_messages_descr"]	= "Blok wiadomości użytkownika zawiera listę wiadomości, które zostały wysłane do użytkownika.";
$pgv_lang["user_favorites_block"]	= "Blok zakładek użytkownika";
$pgv_lang["user_favorites_descr"]	= "Blok zakładek użytkownika pokazuje listę wybranych przez niego osób, do których chciałby mieć szybki dostęp.";
$pgv_lang["welcome_block"]		= "Blok powitania użytkownika";
$pgv_lang["welcome_descr"]		= "Blok powitania użytkownika pokazuje aktualną datę i czas, odnośniki do zmiany ustawień konta i wykresu rodowego użytkownika oraz do dostosowania strony MyGedView.";
$pgv_lang["random_media_block"]		= "Blok losowych multimediów";
$pgv_lang["random_media_descr"]		= "Blok losowych multimediów wyświetla pojedyncze zdjęcie lub inny obiekt medialny z aktywnego GEDCOM-u, wraz z przypisaną mu osobą.";
$pgv_lang["random_media_persons_or_all"]	= "Pokazać tylko osoby, zdarzenia czy wszystko?";
$pgv_lang["random_media_events"]	= "Zdarzenia";
$pgv_lang["random_media_persons"]	= "Osoby";
$pgv_lang["gedcom_block"]		= "Blok powitania GEDCOMu";
$pgv_lang["gedcom_descr"]		= "Blok powitania GEDCOMu działa tak samo jak Blok powitania użytkownika, wyświetlając powitanie na stronie oraz tytuł aktywnego GEDCOMu i aktualną datę i czas.";
$pgv_lang["gedcom_favorites_block"]	= "Blok głównych postaci GEDCOMu";
$pgv_lang["gedcom_favorites_descr"]	= "Blok głównych postaci GEDCOMu pozwala administratorowi określić, które jego zdaniem osoby są najważniejsze, aby odwiedzający mogli łatwo do nich dotrzeć. Jest to sposób wyróżnienia szczególnych członków rodziny.";
$pgv_lang["gedcom_stats_show_surnames"]	= "Pokazać wspólne nazwiska?";
$pgv_lang["gedcom_stats_block"]		= "Blok statystyk GEDCOMu";
$pgv_lang["gedcom_stats_descr"]		= "Blok statystyk GEDCOMu zawiera kilka podstawowych informacji o pliku GEDCOM, takich jak data utworzenia i ilość ludzi w nim spisanych.";
$pgv_lang["portal_config_intructions"]	= "Tutaj możesz dostosować stronę zmieniając pozycje bloków. Strona podzielona jest na dwie sekcje, 'Główną' i 'Prawą'. Bloki sekcji głównej są większe i umieszczone tuż pod tytułem. Sekcja prawa zaczyna się na prawo od tytułu i na całej swej długości pozostaje z prawej strony. Każda sekcja ma swoją listę bloków, które zostaną wyświetlone w kolejności występowania na liście. Możesz dodawać, usuwać i reorganizować bloki w dowolny sposób.";
$pgv_lang["login_block"]		= "Blok logowania";
$pgv_lang["login_descr"]		= "Blok logowania zawiera formularz logowania użytkowników.";
$pgv_lang["block_top10"]			= "Blok 10 najpowrzechniejszych nazwisk";
$pgv_lang["block_top10_descr"]		= "Ten blok pokazuje listę 10 najczęsciej występujących nazwisk w tej bazie danych";
$pgv_lang["block_top10_title"]		= "Najczęściej występujące nazwiska";
$pgv_lang["theme_select_block"] 	= "Blok zmiany wystroju";
$pgv_lang["gedcom_news_block"]		= "Blok wiadomości GEDCOM";
$pgv_lang["gedcom_news_descr"]		= "Blok wiadomości GEDCOM pokazuje artykuły napisane przez użytkowników lub administratora. Jest to dobre miejsce na ogłoszenie aktualizacji w pliku lub zjazdu rodzinnego.";
$pgv_lang["gedcom_news_limit_nolimit"]	= "Bez limitu";
$pgv_lang["gedcom_news_limit_date"]		= "Wiek elementu";
$pgv_lang["gedcom_news_limit_count"]	= "Liczba elementów";
$pgv_lang["gedcom_news_flag"]		= "Limit:";
$pgv_lang["gedcom_news_archive"] 	= "Pokaż archiwum";
$pgv_lang["user_news_block"]		= "Blok dziennika użytkownika";
$pgv_lang["user_news_descr"]		= "Blok dziennika użytkownika pozwala przechowywać notatki lub prowadzić dziennik.";
$pgv_lang["my_journal"]			= "Mój dziennik";
$pgv_lang["no_journal"]			= "Nie utworzyłeś(utworzyłaś) żadnych wpisów w dzienniku.";
$pgv_lang["confirm_journal_delete"]	= "Czy na pewno chcesz usunąć ten wpis?";
$pgv_lang["add_journal"]		= "Dodaj nowy wpis do dziennika";
$pgv_lang["gedcom_news"]		= "Wiadomości";
$pgv_lang["confirm_news_delete"]	= "Czy na pewno chcesz usunąć tą wiadomosć?";
$pgv_lang["add_news"]			= "Dodaj wiadomość";
$pgv_lang["no_news"]			= "Nie dodano żadnych wiadomości.";
$pgv_lang["edit_news"]			= "Dodaj/Zmień wpis do dziennika/wiadomości";
$pgv_lang["enter_title"]		= "Podaj tytuł.";
$pgv_lang["enter_text"]			= "Wpisz jakiś tekst dla tego artykułu.";
$pgv_lang["news_saved"]			= "Wpis do dziennika/wiadomości został zapisany.";
$pgv_lang["article_text"]		= "Treść wpisu:";
$pgv_lang["available_blocks"]		= "Dostępne bloki";
$pgv_lang["main_section"]		= "Bloki głównej sekcji";
$pgv_lang["right_section"]		= "Bloki prawej sekcji";
$pgv_lang["move_up"]			= "W górę";
$pgv_lang["move_down"]			= "W dół";
$pgv_lang["move_right"]			= "W prawo";
$pgv_lang["move_left"]			= "W lewo";
$pgv_lang["add_main_block"]		= "Dodaj blok do sekcji głównej...";
$pgv_lang["add_right_block"]		= "Dodaj blok do sekcji prawej...";
$pgv_lang["broadcast_all"]		= "Wyślij do wszystkich użytkowników";
$pgv_lang["hit_count"]			= "Odwiedzin:";
$pgv_lang["phpgedview_message"]		= "Wiadomość PhpGedView";
$pgv_lang["common_surnames"]		= "Najczęściej występujące nazwiska";
$pgv_lang["default_news_title"]		= "Witaj w swojej genealogii";
$pgv_lang["default_news_text"]		= "Informacje genealogiczne na tej stronie są wyświetlane przez <a href=\"http://www.phpgedview.net/\" target=\"_blank\">PhpGedView #VERSION#</a>. Ta strona jest wprowadzeniem i przeglądem wszystkich informacji. Aby rozpocząć pracę z danymi wybierz jeden z wykresów powyżej, przejdź do listy osób lub poszukaj nazwiska czy miejsca.<br /><br />Jeśli napotkasz problemy przy korzystaniu ze strony, możesz w każdej chwili uzyskać pomocne informacje dotyczące danego działu z menu pomocy.<br /><br />Dziękujemy za odwiedziny.";
$pgv_lang["hide_block_warn"]		= "Jeśli ukryjesz pusty blok to nie będziesz w stanie zmienić jego konfiguracji do momentu gdy sam zrobi się widoczny.";
$pgv_lang["reset_default_blocks"]	= "Zresetuj do domyślnych bloków";
$pgv_lang["recent_changes_some"]	= "<b>Zmiany dokonane w ciągu ostatnich #pgv_lang[global_num1]# dni</b><br />";
$pgv_lang["show_empty_block"]		= "Ukryj blok jeśli jest pusty?";
$pgv_lang["recent_changes_none"]	= "<b>W ciągu ostatich #pgv_lang[global_num1]# dni nie wystąpiły żadne zmiany.</b><br />";
$pgv_lang["block_not_configure"]	=	"Ten blok nie może zostać skonfigurowany.";
$pgv_lang["recent_changes"]		= "Ostatnie zmiany";
$pgv_lang["recent_changes_block"]	= "Blok ostatnich zmian";
$pgv_lang["recent_changes_descr"]	= "Blok ostatnich zmian zawiera listę modyfikacji, jakim podlegał GEDCOM w ciągu ostatniego miesiąca. Może on pomóc pozostać na bierząco z nowymi informacjami dodawanymi do pliku. Zmiany są wykrywane na podstawie znaczników CHAN.";
$pgv_lang["delete_selected_messages"]	= "Usuń wybrane wiadomości";
$pgv_lang["use_blocks_for_default"]	= "Użyj tych bloków jako domyślną konfigurację dla wszystkich użytkowników.";


//-- upgrade.php messages
$pgv_lang["upgrade_util"]		= "Narzędzie aktualizacji";
$pgv_lang["no_upgrade"]			= "Nie ma plików do zaktualizowania.";
$pgv_lang["use_version"]		= "Używasz wersji:";
$pgv_lang["current_version"]		= "Obecna stabilna wersja:";
$pgv_lang["upgrade_download"]		= "Ściągnij:";
$pgv_lang["upgrade_tar"]		= "TAR";
$pgv_lang["upgrade_zip"]		= "ZIP";
$pgv_lang["latest"]			= "Używasz najnowszej wersji PhpGedView.";
$pgv_lang["location"]			= "Lokalizacja plików aktualizacyjnych: ";
$pgv_lang["include"]			= "Dołącz:";
$pgv_lang["page_x_of_y"]				= "Strona #GLOBALS[currentPage]# z #GLOBALS[lastPage]#";
$pgv_lang["options"]			= "Opcje:";
$pgv_lang["inc_phpgedview"]		= " PhpGedView";
$pgv_lang["inc_languages"]		= " Języki";
$pgv_lang["inc_config"]			= " Plik konfiguracyjny";
$pgv_lang["inc_researchlog"]		= " Researchlog";
$pgv_lang["inc_index"]			= " Pliki indeksowe";
$pgv_lang["inc_themes"]			= " Wystroje";
$pgv_lang["inc_docs"]			= " Podręczniki";
$pgv_lang["inc_privacy"]		= " Pliki prywatności";
$pgv_lang["inc_backup"]			= " Utwórz kopię zapasową";
$pgv_lang["upgrade_help"]		= " Pomóż mi";
$pgv_lang["cannot_read"]		= "Nie można odczytać pliku:";
$pgv_lang["not_configured"]		= "Nie skonfigurowałeś(łaś) jeszcze PhpGedView.";
$pgv_lang["location_upgrade"]		= "Podaj lokalizację plików aktualizacyjnych.";
$pgv_lang["new_variable"]		= "Znaleziono nową zmienną: ";
$pgv_lang["config_open_error"] 		= "Wystąpił błąd przy otwieraniu pliku konfiguracyjnego.";
$pgv_lang["gedcom_config_write_error"]	= "Błąd ! Nie można zapisać pliku konfiguracyjnego GEDCOM'u";
$pgv_lang["config_write_error"] 	= "Błąd!!! Nie można zapisać pliku konfiguracyjnego.";
$pgv_lang["link_new_wife"]			= "Dodaj istniejącą żonę";
$pgv_lang["add_fav_or_enter_url"]	= "LUB<br />Wprowadź adres URL i tytuł";
$pgv_lang["undo_all"]				= "Cofnij wszystkie zmiany";
$pgv_lang["autocomplete"]			= "Autouzupełnianie";
$pgv_lang["add_fav_enter_id"]		= "Wprowadź ID osoby, rodziny lub źródła";
$pgv_lang["confirm_remove"]			= "Czy na pewno chcesz usunąć tą osobę z rodziny?";
$pgv_lang["remove_child"]			= "Usuń to dziecko z rodziny";
$pgv_lang["link_new_husb"]			= "Dodaj istniejącego męża";
$pgv_lang["filter_address"]			= "Pokaż adresy zawierające:";
$pgv_lang["address_list"]			= "Lista adresów";
$pgv_lang["add_fav_enter_note"]		= "Wprowadź opcjonalną notatkę o tej zakładce";
$pgv_lang["change_family_members"]	= "Zmień członków rodziny";
$pgv_lang["delete_family"]			= "Usuń rodzinę";
$pgv_lang["add_favorite"]			= "Dodaj nową zakładkę";
$pgv_lang["config_update_ok"]		= "Plik konfiguracyjny został zaktualizowany.";
$pgv_lang["date_of_entry"]				= "Data wpisu w oryginalnym źródle";
$pgv_lang["cancel"]					= "Anuluj";
$pgv_lang["change"]					= "Zmień";
$pgv_lang["label_add_remote_link"]  = "Dodaj łącze";
$pgv_lang["link_remote"]            = "Połącz zdalną osobę";
$pgv_lang["cancel"]					= "Anuluj";
$pgv_lang["edit_source"]			= "Edytuj źródło";
$pgv_lang["descent_steps"]			= "Liczba pokoleń";
$pgv_lang["user_auto_accept"]		= "Automatycznie akceptuj zmiany dokonane przez tego użytkownika";
$pgv_lang["december_1st"]			= "Grudzień";
$pgv_lang["november_1st"]			= "Listopad";
$pgv_lang["october_1st"]			= "Październik";
$pgv_lang["september_1st"]			= "Wrzesień";
$pgv_lang["august_1st"]				= "Sierpień";
$pgv_lang["july_1st"]				= "Lipiec";
$pgv_lang["june_1st"]				= "Czerwiec";
$pgv_lang["may_1st"]				= "Maj";
$pgv_lang["april_1st"]				= "Kwiecień";
$pgv_lang["march_1st"]				= "Marzec";
$pgv_lang["february_1st"]			= "Luty";
$pgv_lang["january_1st"]			= "Styczeń";
$pgv_lang["january_1st"]			= "Sty";
$pgv_lang["saturday_1st"]			= "So";
$pgv_lang["friday_1st"]				= "Pt";
$pgv_lang["thursday_1st"]			= "Czw";
$pgv_lang["wednesday_1st"]			= "Śr";
$pgv_lang["tuesday_1st"]			= "Wt";
$pgv_lang["monday_1st"]				= "Pon";
$pgv_lang["sunday_1st"]				= "Nd";
$pgv_lang["stat_average_children"]	= "Średnia liczba dzieci w rodzinie";
$pgv_lang["stat_events"]			= "Wszystkich zdarzeń";
$pgv_lang["stat_media"]				= "Mediów";
$pgv_lang["stat_surnames"]			= "Nazwisk";
$pgv_lang["stat_users"]				= "Wszystkich użytkowników";
$pgv_lang["no_family_facts"]		= "Brak faktów dla tej rodziny.";
$pgv_lang["stat_most_children"]		= "Rodzina z największą liczbą dzieci";
$pgv_lang["stat_longest_life"]		= "Osoba żyjąca najdłużej";
$pgv_lang["stat_avg_age_at_death"]	= "Średni wiek w momencie śmierci";
$pgv_lang["ex-husband"] = "Były mąż";
$pgv_lang["broadcast_not_logged_6mo"]	= "Wyślij wiadomość do użytkowników którzy nie logowali się przez ostatnie 6 miesięcy";
$pgv_lang["broadcast_never_logged_in"]	= "Wyślij wiadomość do użytkowników którzy nigdy się nie zalogowali";
$pgv_lang["ex-wife"] = "Była żona";
$pgv_lang["label_families"]         = "Rodziny";
$pgv_lang["ex-spouse"] = "Ex-małżonek";
$pgv_lang["label_add_server"]       = "Dodaj";
$pgv_lang["label_delete"]           = "Usuń";
$pgv_lang["error_ban_server"]       = "Nieprawidłowy adres IP.";
$pgv_lang["label_password_id2"]		= "Hasło: ";
$pgv_lang["label_password_id"]		= "Hasło";
$pgv_lang["label_username_id2"]		= "Nazwa użytkownika: ";
$pgv_lang["label_username_id"]		= "Nazwa użytkownika";
$pgv_lang["remove_ip"] 			= "Usuń IP";
$pgv_lang["label_add_search_server"]	= "Dodaj IP";
$pgv_lang["label_ban_server"]		= "Wyślij";
$pgv_lang["label_add_remote_link"]  = "Dodaj łącze";
$pgv_lang["label_local_id"]         = "ID osoby";
$pgv_lang["label_rel_to_current"]   = "Relacja do aktualnej osoby";
$pgv_lang["label_remote_id"]        = "ID zdalnej osoby";
$pgv_lang["title_remote_link"]      = "Dodaj zewnętrzne łącze";
$pgv_lang["current_person"]         = "Aktualna osoba";
$pgv_lang["link_remote"]            = "Połącz zdalną osobę";
$pgv_lang["site_had"]				= " zawiera";
$pgv_lang["invalid_search_multisite_input_gender"] = "Szukaj ponownie z większą ilością informacji niż tylko płeć";
$pgv_lang["invalid_search_multisite_input"] = "Podaj jedno z następujących: imię/nazwisko, data urodzenia, miejsce urodzenia, data śmierci, miejsce śmierci, płeć ";
$pgv_lang["gender_search"]			= "Płeć: ";
$pgv_lang["deathplace_search"]		= "Miejsce śmierci: ";
$pgv_lang["deathdate_search"]		= "Data śmierci: ";
$pgv_lang["birthplace_search"]		= "Miejsce urodzin: ";
$pgv_lang["birthdate_search"]		= "Data urodzin: ";
$pgv_lang["page_size"]					= "Wielkość strony";
$pgv_lang["wiki_admin_guide"]			= "Podręcznik administratora Wiki";
$pgv_lang["other_searches"]			= "Inne typy wyszukiwania";
$pgv_lang["wiki_users_guide"]			= "Podręcznik użytkownika Wiki";
$pgv_lang["wiki_main_page"]				= "Główna strona Wiki";
$pgv_lang["edit_media"]					= "Edytuj media";
$pgv_lang["result_page"]				= "Rezultaty";
$pgv_lang["record_marked_deleted"]		= "Ten rekord został zaznaczony do usunięcia po zatwierdzeniu przez administratora.";
$pgv_lang["link_to_existing_media"]		= "Dodaj istniejący obiekt mediów";
$pgv_lang["add_media_other_folder"]		= "Inny katalog...proszę wprowadzić";
$pgv_lang["add_media_file"]				= "Istniejący plik mediów na serwerze";
$pgv_lang["server_folder"]				= "Nazwa katalogu na serwerze";
$pgv_lang["server_file_advice"]			= "Nie zmieniaj aby zachować oryginalną nazwę pliku.";
$pgv_lang["server_file"]				= "Nazwa pliku na serwerze";
$pgv_lang["config_uptodate"]		= "Twoja konfiguracja jest aktualna up-to-date.";
$pgv_lang["processing"]			= "Przetwarzanie...";
$pgv_lang["privacy_open_error"] 	= "Wystąpił błąd przy otwieraniu pliku [#PRIVACY_MODULE#].";
$pgv_lang["privacy_write_error"]	= "BŁĄD!!! Nie można zapisać do pliku [#PRIVACY_MODULE#].<br />Upewnij się, że ma on uprawnienia do zapisu.<br />Po dokonaniu zmian poprzednie ustawienia mogą zostać przywrócone.";
$pgv_lang["privacy_update_ok"]		= "Plik ochrony prywatności: [#PRIVACY_MODULE#] został zaktualizowany.";
$pgv_lang["privacy_uptodate"]		= "Twój [#PRIVACY_MODULE#] jest aktualny.";
$pgv_lang["heading_privacy"]		= "Pliki prywatności:";
$pgv_lang["heading_phpgedview"]		= "Pliki PhpGedView:";
$pgv_lang["heading_image"]		= "Pliki zdjęć:";
$pgv_lang["heading_index"] 		= "Pliki indeksowe:";
$pgv_lang["heading_language"]		= "Pliki językowe:";
$pgv_lang["heading_theme"]		= "Pliki wystroju:";
$pgv_lang["heading_docs"]		= "Podręczniki:";
$pgv_lang["heading_researchlog"]	= "Pliki dziennika badań:";
$pgv_lang["heading_researchloglang"]	= "Pliki językowe dziennika badań:";
$pgv_lang["folder_no_create"]		= "Katalog nie mógł zostać utworzony";
$pgv_lang["copied_success"]		= "zostały skopiowane.";
$pgv_lang["backup_copied_success"]	= "kopia zapasowa została utworzona.";
$pgv_lang["folder_created"]		= "Utworzono katalog";
$pgv_lang["process_error"]		= "Wystąpił problem w przetwarzaniu strony. Nie można określić nowej wersji.";
$pgv_lang["upgrade_completed"]		= "Aktualizacja zakończona sukcesem";
$pgv_lang["start_using_upgrad"]		= "Kliknij aby zacząć korzystanie z nowej wersji";

//-- validate gedcom
$pgv_lang["performing_validation"]	= "Kontrola poprawności GEDCOMu, wybierz konieczne opcje i kliknij 'Oczyszczanie'";
$pgv_lang["changed_mac"]		= "Wykryto zakończenia linii w formacie Macintosh. Linie zakończone jedynie przez znak powrotu karetki zostały uzupełnione o znak zakończenia.";
$pgv_lang["changed_places"]		= "Wykryto miejsca z nieprawidłowym kodowaniem. Oczyszczono rekordy aby dostosować plik do specyfikacji GEDCOM 5.5. Oto przykład z twojego gedcomu:";
$pgv_lang["invalid_dates"]		= "Wykryto nieprawidłowy format daty. Podczas oczyszczania zostanie poprawiony do formatu DD MMM RRRR (np. 1 JAN 2004).";
$pgv_lang["valid_gedcom"]		= "Wykryto prawidłowy GEDCOM. Oczyszczanie nie jest porzebne.";
$pgv_lang["optional_tools"]		= "Możesz również wybrać uruchomienie jednego z opcjonalnych narzędzi przed importowaniem.";
$pgv_lang["example_place"]			= "Przykład nieprawidłowego miejsca w twoim GEDCOM-ie:";
$pgv_lang["optional"]			= "Opcjonalne narzędzia";
$pgv_lang["date_format"]		= "Format daty:";
$pgv_lang["day_before_month"]		= "Dzień przed miesiącem (DD MM RRRR)";
$pgv_lang["month_before_day"]		= "Miesiąc przed dniem (MM DD RRRR)";
$pgv_lang["do_not_change"]		= "Bez zmian";
$pgv_lang["change_id"]			= "Zmień ID osoby na:";
$pgv_lang["example_date"]		= "Przykład nieprawidłowej daty w twoim GEDCOM-ie:";
$pgv_lang["add_media_tool"]		= "Narzędzie dodawania multimediów";
$pgv_lang["launch_media_tool"]		= "Kliknij aby uruchomić narzędzie dodawania multimediów.";
$pgv_lang["add_media_descr"]		= "To narzędzie doda znaczniki multimediów OBJE do gedcomu. Zamknij to okno kiedy skończysz dodawać multimedia.";
$pgv_lang["highlighted"]		= "Zaznaczony obraz";
$pgv_lang["extension"]			= "Rozszerzenie";
$pgv_lang["order"]			= "Porządek";
$pgv_lang["inject_media_tool"]		= "Dodaj media do pliku GEDCOM";
$pgv_lang["add_media_button"]		= "Dodaj multimedia";
$pgv_lang["phpinfo"]				= "PHPInfo";
$pgv_lang["admin_info"]				= "Informacyjne";
$pgv_lang["admin_site"]				= "Strona administracyjna";
$pgv_lang["media_table_created"]	= "Tabela <i>multimediów</i> została zaktualizowana.";
$pgv_lang["click_to_add_media"]		= "Kliknij aby dodać multimedia z listy do GEDCOM-u #GEDCOM#";
$pgv_lang["import_statistics"]	= "Statystyki importu";
$pgv_lang["import_options"]		= "Opcje importu";
$pgv_lang["verify_gedcom"]		= "Weryfikuj GEDCOM";
$pgv_lang["adds_completed"]		= "Multimedia zostały dodane do pliku GEDCOM.";
$pgv_lang["ansi_encoding_detected"]	= "Wykryto kodowanie znaków w pliku w standardzie ANSI. PhpGedView działa najlepiej z plikami zakodowanymi w UTF-8.";
$pgv_lang["invalid_header"]		= "Wykryto linie przed nagłówkiem GEDCOM-u (0 HEAD). Podczas oczyszczania zostaną one usunięte.";
$pgv_lang["macfile_detected"]	= "Wykryto plik w formacie Macintosha. Podczas oczyszczania zostanie skonwertowany do formatu DOS.";
$pgv_lang["place_cleanup_detected"]	= "Wykryto miejsca z nieprawidłowym kodowaniem. Te błędy trzeba skorygować. Poniżej pokazany jest przykład wykrytego błędu: ";
$pgv_lang["cleanup_places"]		= "Miejsca do oczyszczenia";
$pgv_lang["empty_lines_detected"]	= "Wykryto puste linie w pliku GEDCOM. Podczas oczyszczania zostaną one usunięte.";

//-- hourglass chart
$pgv_lang["hourglass_chart"]		= "Wykres klepsydrowy";

//-- report engine
$pgv_lang["choose_report"]		= "Wybierz raport do utworzenia";
$pgv_lang["enter_report_values"]	= "Wpisz wartości raportu";
$pgv_lang["selected_report"]		= "Wybrany raport";
$pgv_lang["run_report"]			= "Pokaż raport";
$pgv_lang["select_report"]		= "Wybierz raport";
$pgv_lang["download_report"]			= "Ściągnij raport";
$pgv_lang["family_group_report"]	= "Raport grupy rodzinnej";
$pgv_lang["individual_report"]		= "Raport osobowy";
$pgv_lang["individual_list_report"]	= "Raport listy osób";
$pgv_lang["list_children"]			= "Pokaż dzieci według daty urodzenia.";
$pgv_lang["birthdate2"]				= "Koniec zakresu dat urodzenia";
$pgv_lang["deathdate2"]				= "Koniec zakresu daty";
$pgv_lang["deathdate1"]				= "Początek zakresu daty";
$pgv_lang["deathplace"]				= "Miejsce zawiera";
$pgv_lang["death_report"]			= "Raport o datach i miejscach śmierci";
$pgv_lang["marr_report"]			= "Raport o datach i miejscach ślubów";
$pgv_lang["marrdate2"]				= "Koniec zakresu daty";
$pgv_lang["marrdate1"]				= "Początek zakresu daty";
$pgv_lang["marrplace"]				= "Miejsce zawiera";
$pgv_lang["birthdate1"]				= "Początek zakresu dat urodzenia";
$pgv_lang["birthplace"]				= "Miejsce urodzenia zawiera";
$pgv_lang["birth_report"]			= "Raport dat i miejsc urodzenia";
$pgv_lang["generated_by"]			= "Utworzony przez";
$pgv_lang["sort_by"]				= "Sortuj w/g";
$pgv_lang["enter_pid"]				= "Wprowadź ID osoby";
$pgv_lang["individual_report"]		= "Raport indywidualny";
$pgv_lang["show_photos"]			= "Pokazać zdjęcia ?";
$pgv_lang["with"]					= "z";
$pgv_lang["in"]						= "w";
$pgv_lang["on"]						= "na";
$pgv_lang["relatives_report_ext"]	= "Rozszerzony raport o krewnych";
$pgv_lang["show_notes"] 			= "Pokazać notatki ?";
$pgv_lang["show_basic"] 			= "Pokaż zdarzenia nawet jeżeli puste";
$pgv_lang["show_sources"]			= "Pokazać źródła ?";
$pgv_lang["enter_famid"]			= "Wprowadź ID rodziny";
$pgv_lang["of"] 					= "z";
$pgv_lang["page"]					= "Strona";
$pgv_lang["html_reports"]			= "Raporty HTML";
$pgv_lang["pdf_reports"]			= "Raporty PDF";
$pgv_lang["reports"]				= "Raporty";


$pgv_lang["cleanup"]			= "Oczyszczanie";
$pgv_lang["skip_cleanup"]			= "Pomiń oczyszczanie";

//-- CONFIGURE (extra) messgaes for programs patriarch, slklist and statistics
$pgv_lang["dynasty_list"]		= "Przegląd rodzin";
$pgv_lang["make_slklist"]		= "Utwórz listę EXCEL (SLK)";
$pgv_lang["excel_list"]			= "Utwórz w formacie EXCEL (SLK) z poniższych plików (najpierw użyj listę patriarchów):";
$pgv_lang["excel_tab"]			= "tabulator:";
$pgv_lang["chart_booklet"]   	= "Broszura";
$pgv_lang["chart_list"]			= "Lista";
$pgv_lang["excel_create"]		= " zostanie utworzone w pliku:";
$pgv_lang["patriarch_list"]		= "Lista patriarchów";
$pgv_lang["slk_list"]			= "Lista SLK z EXCELa";
$pgv_lang["ancestry_chart"] 		= "Wykres przodków";
$pgv_lang["chart_style"]			= "Styl wykresu";
$pgv_lang["gen_ancestry_chart"]		= "#PEDIGREE_GENERATIONS# pokoleniowy wykres potomków";
$pgv_lang["compact_chart"]			= "Wykres kompaktowy";
$pgv_lang["sosa_7"] 				= "Babka";
$pgv_lang["sosa_14"]				= "pradziadek";
$pgv_lang["sosa_15"]				= "prababka";
$pgv_lang["sosa_30"]				= "pra pradziadek";
$pgv_lang["sosa_31"]				= "pra prababka";
$pgv_lang["sosa_62"]			   = "pra pra pradziadek";
$pgv_lang["sosa_63"]			   = "pra pra prababka";
$pgv_lang["fan_chart"]				= "Wykres kołowy";
$pgv_lang["fontfile_error"]			= "Plik czcionki nie znaleziony na serwerze";
$pgv_lang["rss_descr"]				= "Najnowsze wiadomości i linki ze strony #GEDCOM_TITLE#";
$pgv_lang["attendant"] = "Pomocnik";
$pgv_lang["buyer"] = "Kupiec";
$pgv_lang["bridesmaid"] = "Druhna";
$pgv_lang["best_man"] = "Drużba";
$pgv_lang["seller"] = "Sprzedawca";
$pgv_lang["twin"] = "Bliźniak";
$pgv_lang["RSS_block"]				= "Blok RSS";
$pgv_lang["friend"] = "Przyjaciel";
$pgv_lang["rabbi"] = "Rabin";
$pgv_lang["stat_10_none"]		 = "brak";
$pgv_lang["servant"] = "Służący";
$pgv_lang["twin_brother"] = "Brat bliźniak";
$pgv_lang["twin_sister"] = "Siostra bliźniaczka";
$pgv_lang["statlza"]			 = "na osi z:";
$pgv_lang["stat_11_mb"]			 = "Miesiąc narodzin";
$pgv_lang["stat_12_md"]			 = "Miesiąc śmierci";
$pgv_lang["stat_13_mm"]			 = "Miesiąc ślubu";
$pgv_lang["stat_15_mm1"]		= "Miesiąc pierwszego ślubu";
$pgv_lang["stat_16_mmb"]		= "Miesiąc między ślubem a pierwszym dzieckiem";
$pgv_lang["statlya"]			 = "na osi y:";
$pgv_lang["statlxa"]			 = "na osi x:";
$pgv_lang["witness"] = "Świadek";
$pgv_lang["statutci"]			= "Nie można utworzyć indeksu";
$pgv_lang["statnnames"]                = "Liczba nazwisk =";
$pgv_lang["statnfam"]                  = "Liczba rodzin =";
$pgv_lang["statnmale"]                 = "Liczba mężczyzn =";
$pgv_lang["statnfemale"]               = "Liczba kobiet =";
$pgv_lang["gd_helplink"]			= "http://www.php.net/gd";
$pgv_lang["informant"] = "Informator";
$pgv_lang["godparent"] = "Rodzic chrzestny";
$pgv_lang["lodger"] = "Lokator";
$pgv_lang["nurse"] = "Pielęgniarka";
$pgv_lang["godmother"] = "Matka chrzestna";
$pgv_lang["stat_300_none"]		= "brak";
$pgv_lang["priest"] = "Ksiądz";
$pgv_lang["godfather"] = "Ojciec chrzestny";
$pgv_lang["stat_21_nok"]			 = "ilość dzieci";
$pgv_lang["stat_201_num"]			 = "liczby";
$pgv_lang["stat_202_perc"]			 = "procenty";
$pgv_lang["stat_301_mf"]			 = "mężczyzna/kobieta";
$pgv_lang["statmess1"]			 = "|<b>Wypełnij następny rząd zależnie od wcześniejszych ustawień na osi x lub osi z</b>|";
$pgv_lang["statsubmit"]			 = "pokaż wykres";
$pgv_lang["stpl"]			 	= "...";
$pgv_lang["stplGDno"]			 = "Biblioteka wyświetlania grafiki (Graphics Display Library) nie jest dostępna w PHP 4.Skontaktuj się z twoim administratorem systemu.";
$pgv_lang["stpljpgraphno"]		= "Moduł JPgraph nie jest dostępny  w katalogu phpgedview/jpgraph/ . Proszę zciągnąć ze stronyfrom http://www.aditus.nu/jpgraph/jpdownload.php<br> <h3>Najpierw zainstaluj l JPgraph w katalogu PhpGedview/jpgraph/</h3><br>\";\$pgv_lang[\"stplinfo\"] = \"Informacje rysowania:";
$pgv_lang["stplinfo"]			 = "zmienne wykresu:";
$pgv_lang["stpltype"]			 = "typ:";
$pgv_lang["stplmonth"]			 = "miesiąc";
$pgv_lang["stplage"]			 = "wiek";
$pgv_lang["dead"]					= "Zmarli ";
$pgv_lang["alive"]					= "Żyjący ";
$pgv_lang["alive_in_year"]			= "Żyjący w roku";
$pgv_lang["is_alive_in"]			= "Żył w roku #YEAR#";
$pgv_lang["stplmarrbirth"]		 = "Miesiące między małżeństwem a narodzinami pierwszego dziecka";
$pgv_lang["stplperc"]			 = "procenty";
$pgv_lang["media_format"]			= "Format multimediów";
$pgv_lang["block_summary_table"]	= "&nbsp;";
$pgv_lang["hs_close"] 			= "Zamknij okno";
$pgv_lang["media_file_size"]		= "Wielkość mediów";
$pgv_lang["image_format"]			= "Format obrazka";
$pgv_lang["maybe"]					= "Może";
$pgv_lang["add_directory"]			= "Dodaj Katalog";
$pgv_lang["block_desc"]				= "Opis bloku";
$pgv_lang["click_here"]				= "Kliknij tutaj by kontynuować";
$pgv_lang["total_places"]			= "Znalezione miejsca";
$pgv_lang["hs_searchconfig"]	= "Pomoc administratora";
$pgv_lang["hs_searchuser"]		= "Pomoc użytkownika";
$pgv_lang["hs_searchhow"]		= "Typ wyszukiwania";
$pgv_lang["hs_searchall"]		= "Wszystkie słowa";
$pgv_lang["hs_searchany"]		= "Dowolne słowo";
$pgv_lang["confirm_folder_delete"] = "Czy na pewno chcesz usunąć ten folder?";
$pgv_lang["show_thumbnail"]			= "Pokaż miniaturki";
$pgv_lang["image_size"]				= "Wymiary Obrazka";
$pgv_lang["no_thumb_dir"]			= "Katalog miniaturek nie istnieje i nie można go utworzyć";
$pgv_lang["description"]			= "Opis";
$pgv_lang["manage_media"]			= "Zarządzaj mediami";
$pgv_lang["gen_thumb"]				= "Wygeneruj miniaturkę";
$pgv_lang["security_no_create"]		= "Ostrzeżenie: Plik <b><i>index.php</i></b> nie istnieje w";
$pgv_lang["security_no_create"]		= "Ostrzeżenie: Plik <b><i>index.php</i></b> nie istnieje w";
$pgv_lang["move_to"]				= "Przenieś do -->";
$pgv_lang["TYPE__fiche"] = "Mikrofisza";
$pgv_lang["illegal_chars"]			= "Niedozwolone znaki w nazwisku";
$pgv_lang["move_file_success"]		= "Pliki mediów i miniatur pomyślnie przeniesione.";
$pgv_lang["media_thumb_exists"]		= "Miniatura mediów już istnieje.";
$pgv_lang["media_exists"]			= "Plik mediów już istnieje.";
$pgv_lang["module_error_unknown_type"] = "Nieznany typ modułu.";
$pgv_lang["invalid_id"]				= "Nie istnieje takie id w pilku GEDCOM";
$pgv_lang["definitions"]		= "Definicje";
$pgv_lang["account_information"] = "Informacja o koncie";
$pgv_lang["choose"] = "Wybierz: ";
$pgv_lang["TYPE__audio"] = "Dźwięk";
$pgv_lang["TYPE__book"] = "Książka";
$pgv_lang["TYPE__card"] = "Karta";
$pgv_lang["TYPE__certificate"] = "Certyfikat";
$pgv_lang["TYPE__document"] = "Dokument";
$pgv_lang["TYPE__film"] = "Mikrofilm";
$pgv_lang["TYPE__video"] = "Film";
$pgv_lang["TYPE__tombstone"] = "Nagrobek";
$pgv_lang["TYPE__photo"] = "Fotografia";
$pgv_lang["TYPE__newspaper"] = "Gazeta";
$pgv_lang["TYPE__map"] = "Mapa";
$pgv_lang["TYPE__manuscript"] = "Manuskrypt";
$pgv_lang["TYPE__magazine"] = "Magazyn";
$pgv_lang["image_size"]				= "Wymiary Obrazka";
$pgv_lang["gd_freetype"]			= "Źle skonfigurowany serwer PHP : wymagana jest biblioteka Freetype do obsługi czcionek TrueType.";
$pgv_lang["gd_library"]				= "Źle skonfigurowany serwer PHP : wymagana biblioteka GD by używać funkcji obrazkowych.";
$pgv_lang["gen_fan_chart"]  		= "#PEDIGREE_GENERATIONS# Pokoleniowy wykres kołowy";
$pgv_lang["fan_width"]				= "Rozmiar wykresu";
$pgv_lang["sosa_61"]			   = "pra pra prababka";
$pgv_lang["sosa_59"]			   = "pra pra prababka";
$pgv_lang["sosa_57"]			   = "pra pra prababka";
$pgv_lang["sosa_55"]			   = "pra pra prababka";
$pgv_lang["sosa_53"]			   = "pra pra prababka";
$pgv_lang["sosa_51"]			   = "pra pra prababka";
$pgv_lang["sosa_49"]			   = "pra pra prababka";
$pgv_lang["sosa_47"]			   = "pra pra prababka";
$pgv_lang["sosa_45"]			   = "pra pra prababka";
$pgv_lang["sosa_43"]			   = "pra pra prababka";
$pgv_lang["sosa_41"]			   = "pra pra prababka";
$pgv_lang["sosa_39"]			   = "pra pra prababka";
$pgv_lang["sosa_37"]			   = "pra pra prababka";
$pgv_lang["sosa_35"]			   = "pra pra prababka";
$pgv_lang["sosa_33"]			   = "pra pra prababka";
$pgv_lang["sosa_43"]			   = "pra pra prababka";
$pgv_lang["sosa_53"]			   = "pra pra prababka";
$pgv_lang["sosa_60"]			   = "pra pra pradziadek";
$pgv_lang["sosa_58"]			   = "pra pra pradziadek";
$pgv_lang["sosa_56"]			   = "pra pra pradziadek";
$pgv_lang["sosa_54"]			   = "pra pra pradziadek";
$pgv_lang["sosa_52"]			   = "pra pra pradziadek";
$pgv_lang["sosa_50"]			   = "pra pra pradziadek";
$pgv_lang["sosa_48"]			   = "pra pra pradziadek";
$pgv_lang["sosa_46"]			   = "pra pra pradziadek";
$pgv_lang["sosa_44"]			   = "pra pra pradziadek";
$pgv_lang["sosa_42"]			   = "pra pra pradziadek";
$pgv_lang["sosa_40"]			   = "pra pra pradziadek";
$pgv_lang["sosa_38"]			   = "pra pra pradziadek";
$pgv_lang["sosa_36"]			   = "pra pra pradziadek";
$pgv_lang["sosa_34"]			   = "pra pra pradziadek";
$pgv_lang["sosa_32"]			   = "pra pra pradziadek";
$pgv_lang["sosa_29"]				= "pra prababka";
$pgv_lang["sosa_27"]				= "pra prababka";
$pgv_lang["sosa_25"]				= "pra prababka";
$pgv_lang["sosa_23"]				= "pra prababka";
$pgv_lang["sosa_21"]				= "pra prababka";
$pgv_lang["sosa_19"]				= "pra prababka";
$pgv_lang["sosa_17"]				= "pra prababka";
$pgv_lang["sosa_28"]				= "pra pradziadek";
$pgv_lang["sosa_26"]				= "pra pradziadek";
$pgv_lang["sosa_24"]				= "pra pradziadek";
$pgv_lang["sosa_22"]				= "pra pradziadek";
$pgv_lang["sosa_20"]				= "pra pradziadek";
$pgv_lang["sosa_18"]				= "pra pradziadek";
$pgv_lang["sosa_16"]				= "pra pradziadek";
$pgv_lang["sosa_14"]				= "pradziadek";
$pgv_lang["sosa_12"]				= "pradziadek";
$pgv_lang["sosa_13"]				= "prababka";
$pgv_lang["sosa_10"]				= "pradziadek";
$pgv_lang["sosa_11"]				= "prababka";
$pgv_lang["show_cousins"]			= "Pokaż kuzynostwo";
$pgv_lang["sosa_8"] 				= "pradziadek";
$pgv_lang["sosa_9"] 				= "prababka";
$pgv_lang["sosa_6"] 				= "Dziadek";
$pgv_lang["sosa_5"] 				= "Babka";
$pgv_lang["sosa_4"] 				= "Dziadek";
$pgv_lang["sosa_3"] 				= "Matka";
$pgv_lang["ancestry_booklet"]   	= "Układ książkowy";
$pgv_lang["sosa_2"] 				= "Ojciec";
$pgv_lang["ancestry_list"]			= "Lista przodków";
$pgv_lang["statistics"]			= "Statystyki";
$pgv_lang["merge_step3"]			= "Krok 3 z 3 łączenia";
$pgv_lang["no_matches_found"]		= "Nie znaleziono pasujących faktów";
$pgv_lang["same_ids"]				= "Zostały wybrane te same ID, nie można łączyć tych samych rekordów.";
$pgv_lang["updating_linked"]		= "Uaktualnienie połączonych rekordów";
$pgv_lang["merge_more"] 			= "Połącz więcej rekordów";
$pgv_lang["adding"] 				= "Dodawanie";
$pgv_lang["record"] 				= "Rekord";
$pgv_lang["unmatching_facts"]		= "Następujące fakty nie są zgodne. Wybierz informację którą chcesz zachować.";
$pgv_lang["no_matches_found"]		= "Nie znaleziono faktów";
$pgv_lang["merge_facts_same"]		= "Następujące fakty były identyczne w obu rekordach więc zostaną połączone";
$pgv_lang["merge_from"] 			= "Łącz od ID: ";
$pgv_lang["merge_to"]				= "Łącz do ID: ";
$pgv_lang["select_gedcom_records"]	= "Wybierz 2 rekordy gedcomu do połączenia; rekordy muszą być tego samego typu.";
$pgv_lang["merge_step2"]			= "Krok 2 z 3 łączenia";
$pgv_lang["merge_step1"]			= "Krok 1 z 3 łączenia";
$pgv_lang["merge_same"] 			= "Rekordy nie są tego samego typu dlatego nie można ich połączyć.";
$pgv_lang["merge_records"]			= "Łączenie rekordów";



$pgv_lang["mothers_family_with"]	= "Rodzina matki z ";
$pgv_lang["fathers_family_with"]	= "Rodzina ojca z ";
$pgv_lang["halfsibling"]			= "Przyrodnie rodzeństwo";
$pgv_lang["halfbrother"]			= "Przyrodni brat";
$pgv_lang["halfsister"]				= "Przyrodnia siostra";
$pgv_lang["family_timeline"]		= "Pokaż rodzinę na wykresie czasu";
$pgv_lang["children_timeline"]		= "Pokaż dzieci na wykresie czasu";
$pgv_lang["other"]					= "Inne";
$pgv_lang["sort_by_marriage"]		= "Sortuj według daty ślubu";
$pgv_lang["reorder_families"]		= "Uporządkuj rodziny";
$pgv_lang["total_names"]			= "Wszystkich nazwisk";
$pgv_lang["upload_file"]			= "Załaduj plik z twojego komputera";
$pgv_lang["thumb_genned"]			= "Mianiturka automatycznie wygenerowana.";
$pgv_lang["thumbgen_error"]			= "Nie można wygenerować miniaturki dla";
$pgv_lang["generate_thumbnail"]		= "Wygeneruj miniaturkę automatycznie z ";
$pgv_lang["no_upload"]				= "Ładowanie plików multimedialnych jest niedozwolone ponieważ opcja ta została wyłączona albo katalog z plikami multimedialnymi jest ustawiony na \"Tylko do odczytu\".";
$pgv_lang["review_changes_email_freq"]	= "Częstotliwość przypomnień przez e-mail (dni)";
$pgv_lang["review_changes_email"]	= "Wysyłaj e-maile przypominające?";
$pgv_lang["top10_pageviews_msg"]	= "Liczniki odwiedzin muszą być właczone w konfiguracji GEDCOM aby ten blok poprawnie funkcjonował.";
$pgv_lang["review_changes_block"]	= "Oczekujące zmiany";
$pgv_lang["review_changes_subject"]	= "PhpGedView - Przegląd zmian";
$pgv_lang["total_names"]			= "Wszystkich nazwisk";
$pgv_lang["indis_with_surname"]		= "Osoby z nazwiskiem #surname#";
$pgv_lang["first_letter_fname"]		= "Wybierz literę aby wyświetlić osoby, których imię zaczyna się od tej litery";
$pgv_lang["import_marr_names"]		= "Importuj nazwiska małżeńskie";
$pgv_lang["calc_marr_names"]		= "Generowanie nazwisk małżeńskich";
$pgv_lang["show_spouses"]			= "Pokaż małżonków";
$pgv_lang["quick_update_title"] 	= "Szybka aktualizacja";
$pgv_lang["quick_update_instructions"] = "Ta strona pozawala na szybkie zaktualizowanie informacji o osobie. Musisz tylko wypełnić pola gdzie informacje wymagają uzupełnienia lub poprawienia. Po wprowadzeniu danych zmiany będą widoczne dopiero po zatwierdzeniu przez administratora.";
$pgv_lang["update_name"] = "Zaktualizuj nazwisko";
$pgv_lang["update_fact"] 			= "Zaktualizuj wydarzenie";
$pgv_lang["update_photo"] 			= "Zaktualizuj zdjęcie";
$pgv_lang["photo_replace"] = "Czy chcesz zastąpic stare zdjęcie tym nowym?";
$pgv_lang["user_default_tab"]		= "Domyślna zakładka do pokazania na stronie informacyjnej osoby";
$pgv_lang["update_address"] 		= "Zaktualizuj adres";
$pgv_lang["top10_pageviews_descr"]	= "Ten blok pokazuje 10 najczęściej przeglądanych osób. Blok ten wymaga włączenia licznika odwiedzin w ustawieniach GEDCOM.";
$pgv_lang["top10_pageviews"]		= "Najczęściej przeglądane";
$pgv_lang["top10_pageviews_block"]		= "Najczęsciej przeglądane osoby";
$pgv_lang["select_fact"] 			= "Wybierz wydarzenie...";
$pgv_lang["add_new_chil"] 			= "Dodaj nowe dziecko";
$pgv_lang["stepdad"]				= "Ojczym";
$pgv_lang["sort_by_birth"]			= "Sortuj według dat urodzin";
$pgv_lang["reorder_children"]		= "Uporządkuj dzieci";
$pgv_lang["cut"]					= "Wytnij";
$pgv_lang["indis_charts"]			= "Opcje dla osoby";
$pgv_lang["edit_indi"] 				= "Edytuj osobę";
$pgv_lang["locked"]					= "Zablokowana edycja";
$pgv_lang["privacy"]				= "Prywatne dane";
$pgv_lang["copy"]					= "Kopiuj";
$pgv_lang["edit_fam"]				= "Edytuj rodzinę";
$pgv_lang["fams_charts"]			= "Opcje dla rodziny";
$pgv_lang["stepmom"]				= "Macocha";
$pgv_lang["stepbrother"]			= "Przyprany brat";
$pgv_lang["stepsister"]				= "Przybrana siostra";
$pgv_lang["fams_with_surname"]		= "Rodziny z nazwiskiem #surname#";
$pgv_lang["support_contact"]		= "Kontakt techniczny";
$pgv_lang["genealogy_contact"]		= "Kontakt genealogiczny";
$pgv_lang["continue_import"]		= "Kontynuuj importowanie miejsc";
$pgv_lang["importing_places"]		= "Importowanie miejsc";
$pgv_lang["common_upload_errors"]	= "Bład ten prawdopodobnie znaczy, że próbowałeś załadować plik większy niż dozwolona wielkość. Domyślnie w PHP limit jest ustawiony na 2MB. Spróbuj skontakować się z twoim administratorem aby zwiększył limit w pliku php.ini lub załaduj plik używając FTP. Użyj strony <a href=\"uploadgedcom.php?action=add_form\"><b>Dodaj GEDCOM</b></a> po załadowaniu pliku GEDCOM za pomocą FTP.";
$pgv_lang["total_memory_usage"]		= "Zużycie Pamięci:";
$pgv_lang["stepdad"]				= "Ojczym";
$pgv_lang["ancestors"]				= "Przodkowie w bezpośredniej linii i ich rodziny";
$pgv_lang["spouse-family"]			= "Małżonek/Małżonka i dzieci";
$pgv_lang["direct-ancestors"]		= "Przodkowie w lini prostej";
$pgv_lang["descendants"]			= "Potomkowie";
$pgv_lang["choose_relatives"]		= "Wybierz krewnych";
$pgv_lang["relatives_report"]		= "Raport krewnych";
$pgv_lang["total_not_born"]			= "Jeszcze nienarodzonych";
$pgv_lang["download_zipped"]		= "Pobierz plik GEDCOM skompresowany ZIP-em?";
$pgv_lang["total_dead"]				= "Wszystkich zmarłych";
$pgv_lang["num_to_show"]			= "Liczba elementów do pokazania";
$pgv_lang["htmlplus_block_templates"] = "Szablony";
$pgv_lang["htmlplus_block_name"]	= "Zaawansowany HTML";
$pgv_lang["total_living"]			= "Wszystkich żywych";
$pgv_lang["remember_me"]			= "Pamiętaj mnie";
$pgv_lang["add_unlinked_person"]	= "Dodaj niepowiązaną osobę";
$pgv_lang["add_unlinked_source"]	= "Dodaj niepowiązane źródło";
$pgv_lang["comments"]				= "Komentarze";
$pgv_lang["none"]					= "Żadne";
$pgv_lang["ahnentafel_report"]		= "Wywód przodków";
$pgv_lang["descendancy_header"]		= "Raport potomków dla ";
$pgv_lang["descend_report"]		= "Raport potomków";
$pgv_lang["child-family"]			= "Rodzice i rodzeństwo";
$pgv_lang["html_block_name"]		= "Blok HTML";
$pgv_lang["after"]					= "po";
$pgv_lang["before"]					= "przed";
$pgv_lang["days_to_show"]			= "Liczba dni to pokazania";
$pgv_lang["config_block"]			= "Konfiguruj Blok";
$pgv_lang["pls_note12"]				= "Proszę użyj tego pola aby opisać dlaczego prosisz o nowe konto i w jaki sposób jesteś spokrewniony z osobami znajdującymi się w tej genealogii.";
$pgv_lang["view_changelog"]			= "Pokaż plik changelog.txt";
$pgv_lang["enter_comments"]			= "Proszę wpisać twoje pokrewieństwo to danych w komentarzu";
$pgv_lang["changelog"]				= "Zmiany w wersji #VERSION#";
$pgv_lang["html_block_descr"]		= "Jest to prosy blok HTML, który możesz umieścić na swojej stronie aby dodać dowolny rodzaj wiadomości jaki chcesz.";
$pgv_lang["clear_chart"]			= "Wyczyść Wykres";
$pgv_lang["add_individual_by_id"]		= "Dodaj osobę po ID";
$pgv_lang["file_information"]		= "Informacje o pliku";
$pgv_lang["choose_file_type"]		= "Wybierz typ pliku";
$pgv_lang["advanced_options"]		= "Opcje zaawansowane";
$pgv_lang["zip_files"]				= "Plik(i) Zip";
$pgv_lang["include_media"]			= "Dołącz media (automatycznie pakuje pliki)";
if (file_exists("languages/lang.pl.extra.php")) require "languages/lang.pl.extra.php";
?>