<?php
/**
 * Dutch texts
 * 
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2005  PGV Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @author Eduard Wustenveld
 * @author Boudewijn Sjouke
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: lang.nl.php,v 1.100.2.48 2006/06/26 11:30:52 canajun2eh Exp $
 */
if (preg_match("/lang\...\.php$/", $_SERVER["SCRIPT_NAME"])>0) {
		print "You cannot access a language file directly.";
		exit;
}
//-- GENERAL HELP MESSAGES
$pgv_lang["qm"]							= "?";
$pgv_lang["qm_ah"]						= "?";
$pgv_lang["page_help"]					= "Help";
$pgv_lang["show_context_help"]			= "Toon contextuele help";
$pgv_lang["hide_context_help"]			= "Verberg contextuele help";
$pgv_lang["sorry"]						= "<b>Sorry, de helptekst voor deze pagina is nog niet gereed.</b>";
$pgv_lang["help_not_exist"]				= "<b>Een Help tekst voor dit onderwerp of deze pagina is nog niet beschikbaar</b>";
$pgv_lang["var_not_exist"]				= "<span style=font-weight: bold>De taalvariabele bestaat niet. Meldt dit alstublieft als een probleem aan.</span>";
$pgv_lang["resolution"]					= "Schermresolutie";
$pgv_lang["menu"]						= "Menu";
$pgv_lang["header"]						= "Kopregel";
$pgv_lang["imageview"]					= "Afbeelding bekijken";
$pgv_lang["login_head"]					= "PhpGedView aanmelden gebruiker";
$pgv_lang["help_contents"]				= "Inhoud";
$pgv_lang["help_for_this_page"]			= "Help bij deze pagina";

//-- CONFIG FILE MESSAGES
$pgv_lang["error_title"]				= "FOUT: kan GEDCOM-bestand niet openen";
$pgv_lang["error_header"]				= "Het GEDCOM-bestand, [#GEDCOM#], kan niet worden gevonden op de aangegeven plaats.";
$pgv_lang["error_header_write"]			= "Schrijfrechten benodigd op het GEDCOM-bestand [#GEDCOM#], controleer attributen en toegangsrechten.";
$pgv_lang["for_support"]				= "Voor ondersteuning en informatie neem contact op met";
$pgv_lang["for_contact"]				= "Neem voor genealogische vragen contact op met";
$pgv_lang["for_all_contact"]			= "Neem voor genealogische vragen en vragen over de site contact op met";
$pgv_lang["build_title"]				= "Indexbestanden worden opgebouwd";
$pgv_lang["build_error"]				= "Er is een nieuw GEDCOM-bestand ontdekt.";
$pgv_lang["please_wait"]				= "Even geduld a.u.b. De indexbestanden moeten opnieuw worden opgebouwd.";
$pgv_lang["choose_gedcom"]				= "Kies een GEDCOM-bestand";
$pgv_lang["username"]					= "Gebruikersnaam";
$pgv_lang["invalid_username"]			= "De gebruikersnaam bevat ongeldige tekens";
$pgv_lang["lastname"]					= "Achternaam";
$pgv_lang["firstname"]					= "Voornaam";
$pgv_lang["password"]					= "Wachtwoord";
$pgv_lang["login"]						= "Aanmelden";
$pgv_lang["login_aut"]					= "Mijn gegevens";
$pgv_lang["logout"]						= "Afmelden";
$pgv_lang["admin"]						= "Beheren";
$pgv_lang["logged_in_as"]				= "Aangemeld als";
$pgv_lang["fullname"]					= "Volledige naam";
$pgv_lang["confirm"]					= "Geef wachtwoord opnieuw";
$pgv_lang["my_pedigree"]				= "Mijn kwartierstaat";
$pgv_lang["my_indi"]					= "Mijn persoonsgegevens";
$pgv_lang["yes"]						= "Ja";
$pgv_lang["no"]							= "Nee";
$pgv_lang["add_gedcom"]					= "GEDCOM-bestand toevoegen";
$pgv_lang["change_theme"]				= "Wijzig site-opmaak";
$pgv_lang["gedcom_downloadable"]		= "Dit GEDCOM-bestand kan worden gedownload vanaf het Internet!<br />Lees de SECURITY-sectie in het <a href=\"readme.txt\">readme.txt</a>-bestand om dit probleem te verhelpen.";

//-- INDEX (PEDIGREE_TREE) FILE MESSAGES
$pgv_lang["index_header"]				= "Kwartierstaat";
$pgv_lang["gen_ped_chart"]				= "Kwartierstaat (#PEDIGREE_GENERATIONS# Generaties)";
$pgv_lang["generations"]				= "Generaties";
$pgv_lang["view"]						= "Ververs pagina";
$pgv_lang["fam_spouse"]					= "Gezin met partner";
$pgv_lang["root_person"]				= "Startpersoon ";
$pgv_lang["hide_details"]				= "Verberg details";
$pgv_lang["show_details"]				= "Toon details";
$pgv_lang["person_links"]				= "Verwijzingen naar overzichten, gezinnen en verwanten van deze persoon.";
$pgv_lang["zoom_box"]					= "In/uitzoomen op dit vak.";
$pgv_lang["orientation"]				= "Oriëntatie";
$pgv_lang["portrait"]					= "Staand";
$pgv_lang["landscape"]					= "Liggend";
$pgv_lang["start_at_parents"]			= "Ga naar ouders";
$pgv_lang["charts"]						= "Overzichten";
$pgv_lang["lists"]						= "Detailgegevens";
$pgv_lang["welcome_page"]				= "Welkomstpagina";
$pgv_lang["min_generation"]				= "Het minimum aantal generaties in de kwartierstaat is 3.";
$pgv_lang["box_width"]					= "Breedte vak";
$pgv_lang["max_generation"]				= "Het maximum aantal generaties in de kwartierstaat is #PEDIGREE_GENERATIONS#.";

//-- FUNCTIONS FILE MESSAGES
$pgv_lang["unable_to_find_family"]  	= "Niet gevonden: gezin met ID";
$pgv_lang["unable_to_find_indi"]		= "Niet gevonden: persoon met ID";
$pgv_lang["unable_to_find_record"]  	= "Niet gevonden: record met ID";
$pgv_lang["unable_to_find_source"]  	= "Niet gevonden: bron met ID";
$pgv_lang["unable_to_find_repo"]		= "Niet gevonden: bewaarplaats met ID";
$pgv_lang["repo_name"]					= "Naam bewaarplaats:";
$pgv_lang["address"]					= "Adres:";
$pgv_lang["phone"]						= "Telefoon:";
$pgv_lang["source_name"]				= "Naam bron:";
$pgv_lang["title"]						= "Titel";
$pgv_lang["author"]						= "Auteur:";
$pgv_lang["publication"]				= "Publicatie:";
$pgv_lang["call_number"]				= "Call number:";
$pgv_lang["living"]						= "Levend";
$pgv_lang["private"]					= "Privé";
$pgv_lang["birth"]						= "Geboren:";
$pgv_lang["death"]						= "Overleden:";
$pgv_lang["descend_chart"]				= "Nakomelingen";
$pgv_lang["individual_list"]			= "Personen";
$pgv_lang["family_list"]				= "Gezinnen";
$pgv_lang["source_list"]				= "Bronnen";
$pgv_lang["place_list"]					= "Personen per locatie";
$pgv_lang["place_list_aft"]				= "Locaties binnen";
$pgv_lang["media_list"]					= "Multimedia";
$pgv_lang["search"]						= "Zoeken";
$pgv_lang["clippings_cart"]				= "Stamboomknipsels";
$pgv_lang["not_an_array"]				= "Geen tabel";
$pgv_lang["print_preview"]				= "Printervriendelijke versie";
$pgv_lang["cancel_preview"]				= "Annuleren printervriendelijke versie";
$pgv_lang["change_lang"]				= "Wijzig taal";
$pgv_lang["print"]						= "Afdrukken";
$pgv_lang["total_queries"]				= "Totaal aantal databasevragen:";
$pgv_lang["total_privacy_checks"]		= "Aantal privacycontroles:";
$pgv_lang["back"]						= "Terug";
$pgv_lang["privacy_list_fam_error"] 	= "Een of meer gezinnen zijn verborgen als gevolg van privacy-instellingen.";
$pgv_lang["aka"]						= "Ook bekend als ";
$pgv_lang["privacy_list_indi_error"]	= "Een of meer personen zijn verborgen als gevolg van privacy-instellingen.";

//-- INDIVUDUAL FILE MESSAGES
$pgv_lang["male"]						= "Man";
$pgv_lang["female"]						= "Vrouw";
$pgv_lang["temple"]						= "LDS tempel";
$pgv_lang["temple_code"]				= "LDS Tempelcode:";
$pgv_lang["status"]						= "Status";
$pgv_lang["source"]						= "Bron";
$pgv_lang["citation"]					= "Aanhaling:";
$pgv_lang["text"]						= "Tekst:";
$pgv_lang["note"]						= "Notitie";
$pgv_lang["NN"]							= "Onbekend";
$pgv_lang["PN"]							= "Voornaam onbekend";
$pgv_lang["unrecognized_code"]			= "Onbekende GEDCOM-code";
$pgv_lang["unrecognized_code_msg"]  	= "Er is een fout opgetreden, die we graag willen verhelpen. Meldt deze fout a.u.b. aan";
$pgv_lang["indi_info"]					= "Persoonsinformatie";
$pgv_lang["pedigree_chart"]				= "Kwartierstaat";
$pgv_lang["desc_chart2"]				= "Nakomelingen";
$pgv_lang["individual"]					= "Persoon";
$pgv_lang["family"]						= "Gezin";
$pgv_lang["family_with"]				= "Gezin met";
$pgv_lang["as_spouse"]					= "Gezin met partner";
$pgv_lang["as_child"]					= "Gezin met ouders";
$pgv_lang["view_gedcom"]				= "Toon GEDCOM-gegevens";
$pgv_lang["add_to_cart"]				= "Toevoegen aan knipselbak";
$pgv_lang["still_living_error"]			= "Deze persoon leeft nog of heeft geen geregistreerde geboorte- of sterfdatum. Alle details van levende personen zijn verborgen voor openbaar gebruik.<br />Neem voor meer informatie contact op met";
$pgv_lang["privacy_error"]				= "Details van deze persoon zijn privé.<br />";
$pgv_lang["more_information"]			= "Neem voor meer informatie contact op met ";
$pgv_lang["name"]						= "Naam";
$pgv_lang["given_name"]					= "Voornaam:";
$pgv_lang["surname"]					= "Achternaam:";
$pgv_lang["suffix"]						= "Toevoeging:";
$pgv_lang["object_note"]				= "Object notitie:";
$pgv_lang["sex"]						= "Geslacht";
$pgv_lang["personal_facts"]				= "Persoonlijke feiten en details";
$pgv_lang["type"]						= "Type";
$pgv_lang["date"]						= "Datum";
$pgv_lang["place_description"]			= "Plaats / Omschrijving";
$pgv_lang["parents"]					= "Ouders:";
$pgv_lang["siblings"]					= "Broers/zussen";
$pgv_lang["father"]						= "Vader";
$pgv_lang["mother"]						= "Moeder";
$pgv_lang["parent"] 					= "Ouder";
$pgv_lang["relatives_events"]			= "Gebeurtenissen van naaste familie";
$pgv_lang["relatives"]					= "Verwanten";
$pgv_lang["child"]						= "Kind";
$pgv_lang["spouse"]						= "Partner";
$pgv_lang["surnames"]					= "Achternamen";
$pgv_lang["adopted"]					= "Geadopteerd";
$pgv_lang["foster"]						= "Pleeg";
$pgv_lang["sealing"]					= "Zegeling";
$pgv_lang["link_as_husband"]			= "Koppel deze persoon als partner aan een bestaand gezin";
$pgv_lang["link_as_wife"]				= "Koppel deze persoon als partner aan een bestaand gezin";
$pgv_lang["link_as_child"]				= "Koppel deze persoon als kind aan een bestaand gezin";
$pgv_lang["challenged"]					= "Aan te tonen";
$pgv_lang["deceased"]					= "Overleden";
$pgv_lang["stillborn"]					= "Doodgeboren";
$pgv_lang["infant"]						= "Kind";
$pgv_lang["disproved"]					= "Afgekeurd";
$pgv_lang["link_as"]					= "Koppel deze persoon aan een bestaand gezin als: ";
$pgv_lang["no_tab1"]					= "Geen gebeurtenissen voor deze persoon.";
$pgv_lang["no_tab2"]					= "Geen notities voor deze persoon.";
$pgv_lang["no_tab3"]					= "Geen bronvermeldingen voor deze persoon.";
$pgv_lang["no_tab4"]					= "Geen multimedia-objecten voor deze persoon.";
$pgv_lang["no_tab5"]					= "Geen verwanten voor deze persoon.";
$pgv_lang["no_tab6"]					= "Geen onderzoekslogboek gekoppeld aan deze persoon.";

//-- FAMILY FILE MESSAGES
$pgv_lang["family_info"]				= "Gezinsinformatie";
$pgv_lang["family_group_info"]			= "Gezinsinformatie";
$pgv_lang["husband"]					= "Partner";
$pgv_lang["wife"]						= "Partner";
$pgv_lang["marriage"]					= "Huwelijk:";
$pgv_lang["lds_sealing"]				= "LDS zegeling:";
$pgv_lang["marriage_license"]			= "Huwelijksovereenkomst:";
$pgv_lang["media_object"]				= "Multimedia-object:";
$pgv_lang["children"]					= "Kinderen";
$pgv_lang["no_children"]				= "Geen kinderen";
$pgv_lang["childless_family"]		= "Dit gezin bleef kinderloos";
$pgv_lang["number_children"]			= "Aantal kinderen:";
$pgv_lang["parents_timeline"]			= "Toon partners op de tijdlijn";

//-- CLIPPINGS FILE MESSAGES
$pgv_lang["clip_cart"]					= "Knipselbak";
$pgv_lang["clip_explaination"]			= "De Stamboom knipselbak geeft u de mogelijkheid om \"knipsels\" van deze stamboom te nemen en deze samen te bundelen in één GEDCOM-bestand om te kunnen downloaden.<br /><br />";
$pgv_lang["item_with_id"]				= "Item met ID";
$pgv_lang["error_already"]				= "zit al in uw knipselbak.";
$pgv_lang["which_links"]				= "Welke koppelingen uit dit gezin wilt u nog meer toevoegen?";
$pgv_lang["just_family"]				= "Voeg alleen dit gezin toe.";
$pgv_lang["parents_and_family"]			= "Voeg de ouders en dit gezin toe.";
$pgv_lang["parents_and_child"]			= "Voeg de ouders, dit gezin en de kinderen toe.";
$pgv_lang["parents_desc"]				= "Voeg de ouders, dit gezin en alle nakomelingen toe.";
$pgv_lang["continue"]					= "Doorgaan met toevoegen";
$pgv_lang["which_p_links"]				= "Welke koppelingen van deze persoon wilt u nog meer toevoegen?";
$pgv_lang["just_person"]				= "Voeg alleen deze persoon toe.";
$pgv_lang["person_parents_sibs"]		= "Voeg deze persoon, zijn/haar ouders en broers en zussen toe.";
$pgv_lang["person_ancestors"]			= "Voeg deze persoon en de directe voorouders toe.";
$pgv_lang["person_ancestor_fams"]		= "Voeg deze persoon, de directe voorouders en hun gezinnen toe.";
$pgv_lang["person_spouse"]				= "Voeg deze persoon, zijn/haar partner en kinderen toe.";
$pgv_lang["person_desc"]				= "Voeg deze persoon, zijn/haar partner en alle nakomelingen toe.";
$pgv_lang["unable_to_open"]				= "Het is niet mogelijk om naar de knipselbak te schrijven";
$pgv_lang["person_living"]				= "Deze persoon leeft nog. Persoonlijke details worden niet toegevoegd.";
$pgv_lang["person_private"]				= "Details van deze persoon zijn privé. Persoonlijke details worden niet toegevoegd.";
$pgv_lang["family_private"]				= "Details van dit gezin zijn privé. Details van dit gezin worden niet toegevoegd.";
$pgv_lang["download"]					= "Klik met uw rechter muisknop op de onderstaande koppelingen en selecteer \"Bewaar doel als\" om de bestanden te downloaden.";
$pgv_lang["media_files"]				= "Referenties aan mediabestanden in deze GEDCOM";
$pgv_lang["cart_is_empty"]				= "Uw knipselbak is leeg.";
$pgv_lang["id"]							= "ID";
$pgv_lang["name_description"]			= "Naam / Omschrijving";
$pgv_lang["remove"]						= "Verwijderen";
$pgv_lang["empty_cart"]					= "Maak bak leeg";
$pgv_lang["download_now"]				= "Nu downloaden";
$pgv_lang["indi_downloaded_from"]		= "Deze persoon is gedownload van:";
$pgv_lang["family_downloaded_from"]		= "Dit gezin is gedownload van:";
$pgv_lang["source_downloaded_from"]		= "Deze bron is gedownload van:";

//-- PLACELIST FILE MESSAGES
$pgv_lang["connections"]				= "Locatieverbindingen gevonden";
$pgv_lang["top_level"]					= "Hoogste niveau";
$pgv_lang["form"]						= "Locaties staan geordend in deze volgorde: ";
$pgv_lang["gedcom_form_info"]			= "(vlgs. GEDCOM)";
$pgv_lang["default_form_info"]			= "(Standaard)";
$pgv_lang["default_form"]				= "Plaats, Gemeente, Provincie/Staat, Land";
$pgv_lang["unknown"]					= "Onbekend";
$pgv_lang["individuals"]				= "PERSONEN";
$pgv_lang["view_records_in_place"]		= "Alle personen/gezinnen op deze locatie";
$pgv_lang["place_list2"]				= "Locatielijst";
$pgv_lang["show_place_hierarchy"]		= "Toon locaties op hoogste niveau";
$pgv_lang["show_place_list"]			= "Toon alle locaties in een lijst";
$pgv_lang["total_unic_places"]			= "Aantal unieke locaties";
$pgv_lang["external_objects"]		= "Externe objecten";

//-- MEDIALIST FILE MESSAGES
$pgv_lang["multi_title"]				= "Multimedialijst";
$pgv_lang["media_found"]				= "Multimedia-objecten gevonden";
$pgv_lang["view_person"]				= "Bekijk persoon";
$pgv_lang["view_family"]				= "Bekijk gezin";
$pgv_lang["view_source"]				= "Bekijk bron";
$pgv_lang["view_object"]			= "Bekijk object";
$pgv_lang["prev"]						= "&lt; vorige";
$pgv_lang["next"]						= "volgende &gt;";
$pgv_lang["file_not_found"]				= "Bestand niet gevonden.";
$pgv_lang["medialist_show"]				= "Toon";
$pgv_lang["per_page"]					= "media objecten per pagina";
$pgv_lang["delete_dir_success"]			= "Mappen voor multimedia en miniweergaves succesvol verwijderd";
$pgv_lang["current_dir"]				= "Huidige map: ";
$pgv_lang["delete_dir_success"]			= "Map voor miniatuurweergaves succesvol verwijderd";
$pgv_lang["thumbs_not_deleted"]			= "Map voor miniweergaves niet verwijderd";
$pgv_lang["thumbs_deleted"]				= "Map miniweergaves succesvol verwijderd";
$pgv_lang["media_deleted"]				= "Multimediamap succesvol verwijderd";
$pgv_lang["media_not_deleted"]			= "Multimediamap niet verwijderd";
$pgv_lang["directory_not_exist"]		= "Map bestaat niet";
$pgv_lang["directory_not_empty"]		= "Map is niet leeg";
$pgv_lang["delete_file"]				= "Verwijder bestand";
$pgv_lang["confirm_delete_file"]	= "Bestand verwijderen?";
$pgv_lang["multiple_gedcoms"]		= "Deze file is gekoppeld aan een andere genealogische database op deze server. De file kan niet worden verwijderd, verplaatsts of hernoemd totdat deze koppelingen zijn verwijderd.";
$pgv_lang["external_file"]			= "Dit mediabestand bestaat niet op deze server. Het kan niet worden verwijderd, verplaatsts of hernoemd.";
$pgv_lang["delete_directory"]			= "Verwijder map";
$pgv_lang["remove_object"]			= "Verwijder object";
$pgv_lang["confirm_remove_object"]	= "Object uit database verwijderen?";
$pgv_lang["remove_links"]			= "Verwijder koppelingen";
$pgv_lang["confirm_remove_links"]	= "Alle koppelingen naar dit object verwijderen?";

//-- SEARCH FILE MESSAGES
$pgv_lang["search_gedcom"]				= "Doorzoek genealogie(en)";
$pgv_lang["enter_terms"]				= "Geef zoekcriteria op:";
$pgv_lang["soundex_search"]				= "Zoek gelijkende persoons- of plaatsnamen (Soundex):";
$pgv_lang["sources"]					= "BRONNEN";
$pgv_lang["firstname_search"]			= "Voornaam:";
$pgv_lang["lastname_search"]			= "Achternaam:";
$pgv_lang["search_place"]				= "Locatie:";
$pgv_lang["search_year"]				= "Jaar:";
$pgv_lang["no_results"]					= "Geen resultaat gevonden.";
$pgv_lang["invalid_search_input"]		= "Jaar wordt alleen gebruikt in combinatie met een achternaam, voornaam of locatienaam.";
$pgv_lang["search_options"]				= "Zoekopties";
$pgv_lang["search_geds"]				= "Zoek in genealogie";
$pgv_lang["search_type"]				= "Zoekmethode";
$pgv_lang["search_general"]				= "Tekst zoeken";
$pgv_lang["search_soundex"]				= "Zoeken met Soundex";
$pgv_lang["search_inrecs"]				= "Zoek naar";
$pgv_lang["search_fams"]				= "Gezinnen";
$pgv_lang["search_indis"]				= "Personen";
$pgv_lang["search_sources"]				= "Bronnen";
$pgv_lang["search_more_chars"]      	= "Voer meer dan één letter in.";
$pgv_lang["search_soundextype"]			= "Soundex type:";
$pgv_lang["search_DM"]					= "Daitch-Mokotoff";
$pgv_lang["search_prtall"]				= "Alle namen";
$pgv_lang["search_tagfoff"]				= "Uit";
$pgv_lang["associate"]					= "relatie";
$pgv_lang["search_asso_label"]			= "Relaties";
$pgv_lang["search_asso_text"]			= "Toon gerelateerde personen/families";
$pgv_lang["search_tagfon"]				= "Niet-genealogische gegevens uitsluiten";
$pgv_lang["search_tagfilter"]			= "Zoekfilter:";
$pgv_lang["search_prthit"]				= "Gevonden namen";
$pgv_lang["search_prtnames"]			= "Toon namen<br />van persoon:";
$pgv_lang["search_russell"]				= "Russell";

//-- SOURCELIST FILE MESSAGES
$pgv_lang["sources_found"]				= "Bronnen gevonden";
$pgv_lang["titles_found"]				= "Titels";
$pgv_lang["find_source"]				= "Zoek bron";
$pgv_lang["repo_list"]					= "Bewaarplaatsen";
$pgv_lang["repos_found"]				= "Bewaarplaatsen gevonden";
$pgv_lang["find_repository"]			= "Zoek bewaarplaats";
$pgv_lang["total_repositories"]			= "Aantal bewaarplaatsen";
$pgv_lang["repo_info"]					= "Informatie bewaarplaats";
$pgv_lang["delete_repo"]				= "Verwijder bewaarplaats";
$pgv_lang["other_repo_records"]			= "Gegevens die verwijzen naar deze bewaarplaats:";
$pgv_lang["create_repository"]			= "Maak nieuwe bewaarplaats";
$pgv_lang["new_repo_created"]			= "Nieuwe bewaarplaats aangemaakt";
$pgv_lang["paste_rid_into_field"]		= "Plak het ID van de bewaarplaats in uw invoerpagina om de verwijzing naar de bewaarplaats over te nemen ";
$pgv_lang["confirm_delete_repo"]		= "Weet u zeker dat u de bewaarplaats uit uw genealogie wilt verwijderen?";

//-- SOURCE FILE MESSAGES
$pgv_lang["source_info"]				= "Bron-informatie";
$pgv_lang["other_records"]				= "Andere gegevens die verwijzen naar deze bron:";
$pgv_lang["people"]						= "PERSONEN";
$pgv_lang["families"]					= "GEZINNEN";
$pgv_lang["total_sources"]				= "Aantal bronnen";

//-- BUILDINDEX FILE MESSAGES
$pgv_lang["building_indi"]				= "Persoons- en gezinsindexering wordt opgebouwd";
$pgv_lang["building_index"]				= "Indexlijsten worden gebouwd";
$pgv_lang["invalid_gedformat"]			= "Ongeldig GEDCOM 5.5 formaat";
$pgv_lang["importing_records"]			= "Toevoegen records aan de database";
$pgv_lang["detected_change"]			= "PhpGedView heeft een verandering gevonden in het GEDCOM-bestand #GEDCOM#. Index bestanden moeten eerst opnieuw worden gemaakt voordat u kunt doorgaan.";
$pgv_lang["please_be_patient"]			= "EVEN GEDULD A.U.B.";
$pgv_lang["reading_file"]				= "GEDCOM-bestand inlezen";
$pgv_lang["flushing"]					= "Inhoud verwijderen";
$pgv_lang["found_record"]				= "Record gevonden";
$pgv_lang["exec_time"]					= "Uitvoeringstijd:";
$pgv_lang["time_limit"]					= "Tijdslimiet:";
$pgv_lang["unable_to_create_index"]		= "Schrijven van indexbestand is mislukt. Schrijfrechten op de index-map van PhpGedView zijn vereist. U kunt de schrijfrechten later weer verwijderen als de indexbestanden zijn weggeschreven.";
$pgv_lang["indi_complete"]				= "Persoonsindex voltooid";
$pgv_lang["family_complete"]			= "Gezinsindex voltooid";
$pgv_lang["source_complete"]			= "Algemene index voltooid.";
$pgv_lang["tables_exist"]				= "PhpGedView tabellen bestaan reeds in de database";
$pgv_lang["you_may"]					= "U kunt:";
$pgv_lang["drop_tables"]				= "De huidige tabellen verwijderen";
$pgv_lang["import_multiple"]			= "werken met meerdere GEDCOM-bestanden";
$pgv_lang["explain_options"]			= "Als u ervoor kiest om de bestaande tabellen te verwijderen dan wordt alle informatie vervangen door die in dit GEDCOM-bestand.<br />Als u ervoor kiest om met meerdere GEDCOM-bestanden te werken dan zal PhpGedView alle gegevens verwijderen die dezelfde GEDCOM-bestandsnaam hebben. Deze optie maakt het mogelijk om meerdere GEDCOM-bestanden in dezelfde tabellen op te slaan en eenvoudig te wisselen.";
$pgv_lang["path_to_gedcom"]				= "Geef het pad naar uw GEDCOM-bestand:";
$pgv_lang["dataset_exists"]				= "Een GEDCOM-bestand met deze naam staat reeds in de database.";
$pgv_lang["changes_present"]			= "Er zijn nog niet goedgekeurde wijzigingen aanwezig. Als u doorgaat met importeren, worden deze automatisch in het bestand doorgevoerd.";
$pgv_lang["empty_dataset"]				= "Wilt u de oude gegevens verwijderen en de gegevens uit het nieuwe GEDCOM-bestand toevoegen?";
$pgv_lang["index_complete"]				= "Indexeren gereed.";
$pgv_lang["click_here_to_go_to_pedigree_tree"] = "Klik hier om naar de kwartierstaat te gaan.";
$pgv_lang["updating_is_dead"]			= "Aanpassen van overlijden voor INDI";
$pgv_lang["bytes_read"]					= "Bytes gelezen:";
$pgv_lang["created_remotelinks"]	= "Maken van tabel <i>Remotelinks</i> geslaagd.";
$pgv_lang["created_remotelinks_fail"] 	= "De tabel <i>Remotelinks</i> kan niet worden aangemaakt.";
$pgv_lang["created_indis"]				= "Maken van tabel <i>Individuals</i> geslaagd.";
$pgv_lang["created_indis_fail"]			= "De tabel <i>Individuals</i> kan niet worden aangemaakt.";
$pgv_lang["created_fams"]				= "Maken van tabel <i>Families</i> geslaagd.";
$pgv_lang["created_fams_fail"]			= "De tabel <i>Families</i> kan niet worden aangemaakt.";
$pgv_lang["created_sources"]			= "Maken van tabel <i>Sources</i> geslaagd.";
$pgv_lang["created_sources_fail"]		= "De tabel <i>Sources</i> kan niet worden aangemaakt.";
$pgv_lang["created_other"]				= "Maken van tabel <i>Other</i> geslaagd.";
$pgv_lang["created_other_fail"]			= "De tabel <i>Other</i> kan niet worden aangemaakt.";
$pgv_lang["created_places"]				= "Maken van tabel <i>Places</i> geslaagd.";
$pgv_lang["created_places_fail"]		= "De tabel <i>Places</i> kan niet worden aangemaakt.";
$pgv_lang["created_placelinks"] 	= "Maken van tabel <i>Placelinks</i> geslaagd.";
$pgv_lang["created_media_mapping_fail"]	= "De tabel <i>media mappings</i> kan niet worden aangemaakt.";
$pgv_lang["created_media_fail"]	= "De tabel <i>media</i> kan niet worden aangemaakt.";
$pgv_lang["created_placelinks_fail"]	= "De tabel <i>placelinks</i> kan niet worden aangemaakt.";
$pgv_lang["import_progress"]			= "Voortgang importeren....";
$pgv_lang["sec"]						= "sec.";
$pgv_lang["tools_readme"]				= "Zie ook de \"tools-section\" van het #README.TXT# bestand voor meer informatie.";
$pgv_lang["xreftorin"]					= "Omzetten XREF ID's naar RIN-nummer";
$pgv_lang["dateconvert"]				= "Programma datumconversie";
$pgv_lang["addmedia"]					= "Toevoegen Multimediabestanden";
$pgv_lang["run_tools"]					= "Wilt u een van de volgende programma's uitvoeren voordat het GEDCOM-bestand wordt geïmporteerd:";
$pgv_lang["import_complete"]			= "Import gereed";
$pgv_lang["updating_family_names"]		= "Bijwerken familienamen voor FAM";
$pgv_lang["processed_for"]				= "Bestand verwerkt voor";

//-- INDIVIDUAL AND FAMILYLIST FILE MESSAGES
$pgv_lang["total_fams"]					= "Gezinnen gevonden";
$pgv_lang["total_indis"]				= "Personen gevonden";
$pgv_lang["starts_with"]				= "Beginnend met:";
$pgv_lang["person_list"]				= "Persoonslijst:";
$pgv_lang["paste_person"]				= "Persoon plakken";
$pgv_lang["notes_sources_media"]		= "Notities, bronnen en multimedia";
$pgv_lang["media"]						= "Multimedia";
$pgv_lang["ssourcess"]					= "Bronnen";
$pgv_lang["notes"]						= "Notities";
$pgv_lang["name_contains"]				= "Naam bevat:";
$pgv_lang["filter"]						= "Filter";
$pgv_lang["find_individual"]			= "Zoek persoons-ID";
$pgv_lang["find_familyid"]				= "Zoek gezins-ID";
$pgv_lang["find_sourceid"]				= "Zoek bron-ID";
$pgv_lang["find_specialchar"]			= "Speciale letters";
$pgv_lang["magnify"]					= "Vergroten";
$pgv_lang["skip_surnames"]				= "Sla achternamenlijst over";
$pgv_lang["show_surnames"]				= "Toon achternamenlijst";
$pgv_lang["all"]						= "ALLE";
$pgv_lang["hidden"]						= "Verborgen";
$pgv_lang["confidential"]				= "vertrouwelijk";
$pgv_lang["alpha_index"]					= "Alfabetische index";
$pgv_lang["name_list"] 					= "Namenlijst";
$pgv_lang["firstname_alpha_index"] 		= "Alfabetische index op voornaam";

//-- TIMELINE FILE MESSAGES
$pgv_lang["age"]						= "Leeftijd";
$pgv_lang["days"]						= "dagen";
$pgv_lang["day1"]						= "dag";
$pgv_lang["years"]						= "jaren";
$pgv_lang["months"]						= "maanden";
$pgv_lang["month1"]						= "maand";
$pgv_lang["year1"]						= "jaar";
$pgv_lang["timeline_title"]				= "Tijdlijn";
$pgv_lang["timeline_chart"]				= "Tijdlijn";
$pgv_lang["remove_person"]				= "Persoon verwijderen";
$pgv_lang["show_age"]					= "Toon leeftijdindicator";
$pgv_lang["add_another"]				= "Nog een persoon aan de tijdlijn toevoegen:<br />Persoons ID:";
$pgv_lang["find_id"]					= "Zoek ID";
$pgv_lang["show"]						= "Toon";
$pgv_lang["year"]						= "Jaar:";
$pgv_lang["timeline_instructions"]		= "In de nieuwste Internet Verkenners is het mogelijk om de weergegeven blokken te verschuiven zoals u dat wilt.";
$pgv_lang["zoom_in"]					= "Inzoomen";
$pgv_lang["zoom_out"]					= "Uitzoomen";

// -- MONTH NAMES
$pgv_lang["jan"]						= "januari";
$pgv_lang["feb"]						= "februari";
$pgv_lang["mar"]						= "maart";
$pgv_lang["apr"]						= "april";
$pgv_lang["may"]						= "mei";
$pgv_lang["jun"]						= "juni";
$pgv_lang["jul"]						= "juli";
$pgv_lang["aug"]						= "augustus";
$pgv_lang["sep"]						= "september";
$pgv_lang["oct"]						= "oktober";
$pgv_lang["nov"]						= "november";
$pgv_lang["dec"]						= "december";
$pgv_lang["abt"]						= "ongeveer";
$pgv_lang["aft"]						= "na";
$pgv_lang["and"]						= "en";
$pgv_lang["bef"]						= "voor";
$pgv_lang["bet"]						= "tussen";
$pgv_lang["cal"]						= "berekend";
$pgv_lang["est"]						= "geschat";
$pgv_lang["from"]						= "van";
$pgv_lang["int"]						= "afgeleid";
$pgv_lang["to"]							= "tot";
$pgv_lang["cir"]						= "circa";
$pgv_lang["apx"]						= "ongeveer";

//-- Admin File Messages
$pgv_lang["select_an_option"]			= "Selecteer een optie:";
$pgv_lang["readme_documentation"]		= "README documentatie";
$pgv_lang["view_readme"]				= "README documentatie";
$pgv_lang["configuration"]				= "Instellingen";
$pgv_lang["rebuild_indexes"]			= "Indexen (opnieuw) aanmaken";
$pgv_lang["user_admin"]					= "Beheer gebruikers";
$pgv_lang["user_created"]				= "Gebruiker gemaakt.";
$pgv_lang["user_create_error"]			= "Het is niet mogelijk om de gebruiker toe te voegen. Probeer het opnieuw.";
$pgv_lang["password_mismatch"]			= "Wachtwoorden zijn verschillend.";
$pgv_lang["enter_username"]				= "U moet de gebruikersnaam invullen.";
$pgv_lang["enter_fullname"]				= "U moet de volledige naam invullen.";
$pgv_lang["enter_password"]				= "U moet het wachtwoord invullen.";
$pgv_lang["confirm_password"]			= "U moet het wachtwoord twee keer invullen.";
$pgv_lang["update_user"]				= "Aanpassen gebruiker";
$pgv_lang["update_myaccount"]			= "Mijn gegevens bijwerken";
$pgv_lang["save"]						= "Opslaan";
$pgv_lang["delete"]						= "Verwijder";
$pgv_lang["edit"]						= "Wijzig";
$pgv_lang["full_name"]					= "Volledige naam";
$pgv_lang["visibleonline"]				= "Zichtbaar voor anderen als aangemeld";
$pgv_lang["comment"]					= "Commentaar beheerder";
$pgv_lang["comment_exp"]				= "Waarschuw beheerder op datum";
$pgv_lang["editaccount"]				= "Sta gebruiker toe om gebruikersgegevens te wijzigen";
$pgv_lang["admin_gedcom"]				= "Beheren";
$pgv_lang["confirm_user_delete"]		= "Weet u zeker dat u deze gebruiker wilt verwijderen?";
$pgv_lang["create_user"]				= "Gebruiker maken";
$pgv_lang["no_login"]					= "De gebruiker is niet geautoriseerd.";
$pgv_lang["basic_realm"]			= "PhpGedView Authentication System";
$pgv_lang["basic_auth_failure"]		= "Voer een geldig login naam en wachtwoord in om  deze gegevens te benaderen";
$pgv_lang["basic_auth"]				= "Eenvoudige authorisatie";
$pgv_lang["no_auth_needed"]			= "Geen authorisatie";
$pgv_lang["import_gedcom"]				= "Importeer dit GEDCOM-bestand";
$pgv_lang["duplicate_username"]			= "Een gebruiker met die naam is reeds aanwezig. Ga terug en kies een andere naam.";
$pgv_lang["gedcomid"]					= "Uw ID in de genealogie";
$pgv_lang["enter_gedcomid"]				= "U moet een GEDCOM-ID invoeren.";
$pgv_lang["user_info"]					= "Mijn gebruikersinformatie";
$pgv_lang["rootid"]						= "Startpersoon van de kwartierstaat";
$pgv_lang["download_gedcom"]			= "Download GEDCOM-bestand";
$pgv_lang["upload_gedcom"]				= "Upload GEDCOM-bestand";
$pgv_lang["add_new_gedcom"]				= "Nieuw GEDCOM-bestand maken";
$pgv_lang["file_not_present"]		= "Het bestand bestaat niet.";
$pgv_lang["gedcom_file"]				= "GEDCOM-bestand";
$pgv_lang["enter_filename"]				= "Voer een GEDCOM-bestandsnaam in.";
$pgv_lang["file_not_exists"]			= "Er bestaat geen bestand met de opgegeven naam.";
$pgv_lang["file_exists"]				= "Er bestaat al een GEDCOM-bestand met die naam. Kies een andere naam, of verwijder het oude bestand.";
$pgv_lang["new_gedcom_title"]			= "Genealogie van [#GEDCOMFILE#]";
$pgv_lang["upload_error"]				= "Er is een fout opgetreden bij het uploaden van het bestand.";
$pgv_lang["upload_media_help"]			= "Selecteer de bestanden op uw computer die u naar de server wilt uploaden. Alle bestanden worden geplaatst in de map <b>#MEDIA_DIRECTORY#</b> of een van de submappen.<br /><br />Mapnamen die u specificeert worden toegevoegd aan #MEDIA_DIRECTORY#, bijvoorbeeld #MEDIA_DIRECTORY#fotoos. Als de map voor miniweergaves niet bestaat, wordt deze automatisch aangemaakt.<br /><br />";
$pgv_lang["upload_gedcom_help"]			= "Selecteer op uw computer het GEDCOM- of ZIP-bestand dat u naar de server wilt uploaden. Het bestand wordt geplaatst in de map <b>#INDEX_DIRECTORY#</b>.<br /><br />Als u een ZIP-bestand upload, mag dit maar een GEDCOM-bestand bevatten. Dit GEDCOM bestand wordt automatisch in de volgende stappen gebruikt.<br /><br />";
$pgv_lang["add_gedcom_instructions"]		= "Geef een naam voor het nieuwe GEDCOM-bestand. Deze zal worden geplaatst in de Index-map.";
$pgv_lang["file_success"]				= "Het bestand is goed verstuurd";
$pgv_lang["file_too_big"]				= "Het bestand is te groot.";
$pgv_lang["file_partial"]				= "Het bestand is slechts gedeeltelijk overgestuurd. Probeer het opnieuw.";
$pgv_lang["file_missing"]				= "Geen bestand ontvangen. Verstuur het bestand opnieuw.";
$pgv_lang["manage_gedcoms"]				= "Beheer GEDCOM-bestanden en privacy-instellingen";
$pgv_lang["research_assistant"]		= "Onderzoeks Helper";
$pgv_lang["research_log"]				= "Onderzoekslogboek";
$pgv_lang["administration"]				= "Beheer";
$pgv_lang["ansi_to_utf8"]				= "Converteer dit GEDCOM-bestand van ANSI (ISO-8859-1) naar UTF-8?";
$pgv_lang["utf8_to_ansi"]				= "Converteer dit GEDCOM-bestand van UTF-8 naar ANSI (ISO-8859-1)?";
$pgv_lang["choose_priv"]				= "Kies privacy-niveau:";
$pgv_lang["apply_privacy"]				= "Privacy-instellingen toepassen?";
$pgv_lang["siteadmin"]					= "Site-beheerder";
$pgv_lang["gedadmin"]					= "GEDCOM-beheerder";
$pgv_lang["user"]						= "Aangemelde gebruiker";
$pgv_lang["visitor"]					= "Bezoeker";
$pgv_lang["user_manual"]				= "PhpGedView gebruikershandboek";
$pgv_lang["upgrade"]					= "Upgrade PhpGedView";
$pgv_lang["view_logs"]					= "Bekijk log-bestanden";
$pgv_lang["logfile_content"]			= "Inhoud van log-bestand";
$pgv_lang["img_admin_settings"]			= "Configureren bewerking afbeeldingen";
$pgv_lang["download_note"]				= "LET OP: Bij grote GEDCOM-bestanden kan het lang duren voordat de download gereed is.<br />De toegestane limiet voor de uitvoeringstijd van een PHP-pagina kan hierdoor worden overschreden.<br />Controleer daarom altijd of het gedownloade GEDCOM-bestand als laatste regel '0 TRLR' bevat.";
$pgv_lang["pgv_registry"]				= "Andere websites met PhpGedView";
$pgv_lang["verify_upload_instructions"]		= "Als u kiest om door te gaan, wordt het oude GEDCOM-bestand overschreven door het GEDCOM-bestand dat u heeft ge-upload, en begint het importeren opnieuw. Als u Annuleren kiest blijft het oude GEDCOM-bestand intact.";
$pgv_lang["cancel_upload"]				= "Upload annuleren";
$pgv_lang["add_media_records"]			= "Toevoegen multimediagegevens";
$pgv_lang["manage_media_files"]			= "Beheren multimediabestanden";
$pgv_lang["link_media_records"]			= "Koppel multimedia aan personen";
$pgv_lang["step4"]						= "Stap 4 van 4:";
$pgv_lang["validate_gedcom"]			= "Valideren GEDCOM-bestand";
$pgv_lang["step3"]						= "Stap 3 van 4:";
$pgv_lang["step2"]						= "Stap 2 van 4:";
$pgv_lang["step1"]						= "Stap 1 van 4:";

//-- Relationship chart messages
$pgv_lang["relationship_chart"]			= "Verwantschap";
$pgv_lang["person1"]					= "Persoon 1";
$pgv_lang["person2"]					= "Persoon 2";
$pgv_lang["no_link_found"]				= "Geen (andere) verbinding tussen de twee personen gevonden.";
$pgv_lang["sibling"]					= "Broer/zus";
$pgv_lang["follow_spouse"]				= "Controleer verwantschap via partners.";
$pgv_lang["timeout_error"]				= "Maximale zoektijd overschreden voordat een relatie werd gevonden.";
$pgv_lang["son"]						= "Zoon";
$pgv_lang["aunt"]						= "Tante";
$pgv_lang["uncle"]						= "Oom";
$pgv_lang["firstcousin"]			= "Neef/nicht";
$pgv_lang["femalecousin"]				= "Nicht";
$pgv_lang["malecousin"]					= "Neef";
$pgv_lang["cousin-in-law"]				= "Aangetrouwde neef/nicht";
$pgv_lang["daughter"]					= "Dochter";
$pgv_lang["son-in-law"]					= "Schoonzoon";
$pgv_lang["daughter-in-law"]			= "Schoondochter";
$pgv_lang["grandchild"]					= "Kleinkind";
$pgv_lang["grandson"]					= "Kleinzoon";
$pgv_lang["granddaughter"]				= "Kleindochter";
$pgv_lang["brother"]					= "Broer";
$pgv_lang["sister"]						= "Zus";
$pgv_lang["brother-in-law"]				= "Zwager";
$pgv_lang["sister-in-law"]				= "Schoonzuster";
$pgv_lang["relationship_to_me"]			= "Relatie met mij";
$pgv_lang["rela_husb"]					= "Relatie tot partner";
$pgv_lang["rela_wife"]					= "Relatie tot partner";
$pgv_lang["next_path"]					= "Zoek volgend pad";
$pgv_lang["show_path"]					= "Toon pad";
$pgv_lang["line_up_generations"]		= "Uitlijnen gelijke generaties";
$pgv_lang["oldest_top"]					= "Toon oudste bovenaan";

//-- GEDCOM edit utility
$pgv_lang["check_delete"]				= "Weet u zeker dat u dit GEDCOM-feit wilt verwijderen?";
$pgv_lang["access_denied"]				= "<b>Toegang geweigerd</b><br />U heeft geen toegang tot deze bron.";
$pgv_lang["gedrec_deleted"]				= "GEDCOM-record verwijderd.";
$pgv_lang["gedcom_deleted"]				= "GEDCOM [#GED#] verwijderd.";
$pgv_lang["changes_exist"]				= "Dit GEDCOM-bestand is gewijzigd.";
$pgv_lang["accept_changes"]				= "Wijzigingen accepteren/ongedaan maken";
$pgv_lang["show_changes"]				= "Dit record is gewijzigd. Klik hier om de wijzigingen te tonen.";
$pgv_lang["hide_changes"]				= "Klik hier om wijzigingen te verbergen.";
$pgv_lang["review_changes"]				= "Beoordeel GEDCOM-wijzigingen";
$pgv_lang["undo_successful"]			= "Ongedaan maken geslaagd";
$pgv_lang["undo"]						= "Maak ongedaan";
$pgv_lang["view_change_diff"]			= "Toon wijzigingen";
$pgv_lang["changes_occurred"]			= "De volgende wijzigingen zijn voorgekomen voor deze persoon:";
$pgv_lang["find_place"]					= "Zoek locatie";
$pgv_lang["refresh"]					= "Ververs";
$pgv_lang["close_window"]				= "Sluit venster";
$pgv_lang["close_window_without_refresh"]	= "Sluit venster zonder herladen";
$pgv_lang["place_contains"]				= "Locatie bevat:";
$pgv_lang["accept_gedcom"]				= "Geef voor iedere wijziging aan of deze geaccepteerd moet worden of ongedaan gemaakt.<br />Klik \"Accepteer alle wijzigingen\" om alle in een handeling door te voeren.<br />Klik \"Toon wijzigingen\" om de oude en nieuwe situatie te zien,<br />klik \"Toon GEDCOM-gegevens\" om de nieuwe situatie in GEDCOM-formaat te bekijken.";
$pgv_lang["ged_import"]					= "Importeer";
$pgv_lang["now_import"]					= "Klik op de onderstaande koppeling om het GEDCOM-bestand te importeren in PhpGedView";
$pgv_lang["add_fact"]					= "Nieuw feit toevoegen";
$pgv_lang["add"]						= "Toevoegen";
$pgv_lang["custom_event"]				= "Vrij te kiezen gebeurtenis";
$pgv_lang["update_successful"]			= "Bijwerken geslaagd.";
$pgv_lang["add_child"]					= "Kind toevoegen";
$pgv_lang["add_child_to_family"]		= "Kind toevoegen aan dit gezin";
$pgv_lang["add_sibling"]				= "Voeg broer of zus toe";
$pgv_lang["add_son_daughter"]			= "Voeg zoon of dochter toe";
$pgv_lang["must_provide"]				= "Invoeren:";
$pgv_lang["delete_person"]				= "Verwijder deze persoon";
$pgv_lang["confirm_delete_person"]		= "Weet u zeker dat u deze persoon uit het GEDCOM-bestand wilt verwijderen?";
$pgv_lang["find_media"]					= "Zoek multimedia";
$pgv_lang["add_media"]					= "Voeg nieuwe koppeling met multimedia toe";
$pgv_lang["ansi_encoding_detected"]		= "ANSI bestandscodering geconstateerd. PhpGedView werkt het best met bestanden gecodeerd volgens UTF-8.";
$pgv_lang["invalid_header"]				= "GEDCOM-regels aanwezig voor de kopregel (0 HEAD). Deze worden bij het opschonen verwijderd.";
$pgv_lang["macfile_detected"]			= "Het bestand is in Macintosh-formaat. Bij het opschonen wordt het omgezet naar DOS-formaat.";
$pgv_lang["place_cleanup_detected"]		= "Foutieve locatiecoderingen aanwezig. Deze fouten moeten hersteld worden. Het volgende bestandsdeel geeft de foutieve locatiecodering aan:";
$pgv_lang["cleanup_places"]				= "Opschonen locaties";
$pgv_lang["empty_lines_detected"]		= "Lege regels ontdekt in uw GEDCOM-bestand. Bij het opschonen worden deze verwijderd.";
$pgv_lang["verify_gedcom_help"]	= "Kies hier om door te gaan met de upload en import van het GEDCOM-bestand of om deze af te breken.";
$pgv_lang["import_options_help"] 	= "U kunt extra opties kiezen voor het importeren van het GEDCOM-bestand.";
$pgv_lang["import_options"]		= "Importopties";
$pgv_lang["import_statistics"]	= "Importeren statistieken";
$pgv_lang["verify_gedcom"]		= "Gedcom verifieren";
$pgv_lang["hourglass_chart"]			= "Zandloperdiagram";
$pgv_lang["choose_report"]				= "Kies een rapport";
$pgv_lang["enter_report_values"]		= "Voer waarden voor het rapport in";
$pgv_lang["selected_report"]			= "Geselecteerd rapport";
$pgv_lang["run_report"]					= "Maak rapport";
$pgv_lang["select_report"]				= "Selecteer rapport";
$pgv_lang["download_report"]			= "Rapport downloaden";
$pgv_lang["reports"]					= "Rapporten";
$pgv_lang["pdf_reports"]				= "PDF rapporten";
$pgv_lang["html_reports"]				= "HTML rapporten";

//-- Ahnentafel report
$pgv_lang["ahnentafel_report"]		= "Voorouders";
$pgv_lang["ahnentafel_header"]		= "Voorouder Rapport voor ";
$pgv_lang["ahnentafel_generation"]	= "Generatie ";
$pgv_lang["ahnentafel_pronoun_m"]	= "Hij ";
$pgv_lang["ahnentafel_pronoun_f"]	= "Zij ";
$pgv_lang["ahnentafel_born_m"]		= "werd geboren op";
$pgv_lang["ahnentafel_born_f"]		= "werd geboren op";
$pgv_lang["ahnentafel_christened_m"] = "werd gedoopt op";
$pgv_lang["ahnentafel_christened_f"] = "werd gedoopt op";
$pgv_lang["ahnentafel_married_m"]	= "is getrouwd met";
$pgv_lang["ahnentafel_married_f"]	= "is getrouwd met";
$pgv_lang["ahnentafel_died_m"]		= "overleed";
$pgv_lang["ahnentafel_died_f"]		= "overleed";
$pgv_lang["ahnentafel_buried_m"]	= "werd begraven op";
$pgv_lang["ahnentafel_buried_f"]	= "werd begraven op";
$pgv_lang["ahnentafel_place"]		= " in ";
$pgv_lang["ahnentafel_no_details"]	= " maar de details zijn onbekend";

//-- Descendancy report
$pgv_lang["descend_report"]		= "Nakomelingen";
$pgv_lang["descendancy_header"]		= "Nakomelingen rapport voor ";

$pgv_lang["family_group_report"]		= "Gezin";
$pgv_lang["page"]						= "Pagina";
$pgv_lang["of"]							= "van";
$pgv_lang["enter_famid"]				= "Type gezins-ID";
$pgv_lang["show_sources"]				= "Toon bronnen?";
$pgv_lang["show_notes"]					= "Toon notities?";
$pgv_lang["show_basic"]					= "Druk basisgebeurtenissen af indien leeg?";
$pgv_lang["show_photos"]				= "Toon foto's?";
$pgv_lang["relatives_report_ext"]		= "Uitgebreid Relatives Rapport";
$pgv_lang["with"]						= "met";
$pgv_lang["on"]							= "op";
$pgv_lang["in"]							= "in";
$pgv_lang["individual_report"]			= "Persoon";
$pgv_lang["enter_pid"]					= "Type persoons-ID";
$pgv_lang["individual_list_report"]		= "Lijst personen";
$pgv_lang["generated_by"]				= "Vervaardigd met";
$pgv_lang["list_children"]				= "Kinderen gesorteerd op geboortedatum.";
$pgv_lang["birth_report"]				= "Geboortedata en -locaties";
$pgv_lang["birthplace"]					= "Geboorteplaats bevat";
$pgv_lang["birthdate1"]					= "Periode geboortedatum start op";
$pgv_lang["birthdate2"]					= "Periode geboortedatum eindigt op";
$pgv_lang["marr_report"]			= "Huwelijksdatum en Plaats Rapport";
$pgv_lang["death_report"]			= "Overlijdensdatum en Plaats Rapport";
$pgv_lang["deathdate2"]				= "Overlijdensdatum-bereik eind";
$pgv_lang["deathdate1"]				= "Overlijdensdatum-bereik start";
$pgv_lang["deathplace"]				= "Plaats van overlijden bevat";
$pgv_lang["marrplace"]				= "Huwelijksplaats bevat";
$pgv_lang["marrdate2"]				= "Huwelijksdatum-bereik eind";
$pgv_lang["marrdate1"]				= "Huwelijksdatum-bereik start";
$pgv_lang["sort_by"]					= "Sorteren op";
$pgv_lang["cleanup"]					= "Opschonen";
$pgv_lang["skip_cleanup"]				= "Opschonen overslaan";
$pgv_lang["dynasty_list"]				= "Overzicht van stamouders";
$pgv_lang["make_slklist"]				= "Export naar Excel bestand (SLK formaat)";
$pgv_lang["excel_list"]					= "Uitvoer in Excel (SLK formaat) naar de volgende bestanden (gebruik eerst lijst stamouders):";
$pgv_lang["excel_tab"]					= "tabblad:";
$pgv_lang["excel_create"]				= " wordt aangemakt in het bestand: ";
$pgv_lang["patriarch_list"]				= "Stamouders";
$pgv_lang["slk_list"]					= "Excel (SLK) lijst";
$pgv_lang["statistics"]					= "Statistieken";
$pgv_lang["merge_records"]				= "Gegevens samenvoegen";
$pgv_lang["merge_same"]					= "Gegevens zijn niet van hetzelfde type en kunnen daarom niet worden samengevoegd.";
$pgv_lang["merge_step1"]				= "Samenvoegen stap 1 van 3";
$pgv_lang["merge_step2"]				= "Samenvoegen stap 2 van 3";
$pgv_lang["merge_step3"]				= "Samenvoegen stap 3 van 3";
$pgv_lang["select_gedcom_records"]		= "Selecteer twee ID's om samen te voegen. De gegevens moeten gelijksoortig zijn.";
$pgv_lang["merge_to"]					= "Samenvoegen naar ID:";
$pgv_lang["merge_from"]					= "Samenvoegen van ID:";
$pgv_lang["merge_facts_same"]			= "De volgende gebeurtenissen zijn exact hetzelfde bij beide ID's en zullen worden samengevoegd.";
$pgv_lang["no_matches_found"]			= "Geen overeenkomende gebeurtenissen gevonden";
$pgv_lang["unmatching_facts"]			= "De volgende gebeurtenissen komen niet overeen. Selecteer de gegevens die behouden moeten worden.";
$pgv_lang["record"]						= "Gegevens";
$pgv_lang["adding"]						= "Toevoegen";
$pgv_lang["updating_linked"]			= "Aanpassen gekoppelde gegevens";
$pgv_lang["merge_more"]					= "Meer gegevens samenvoegen.";
$pgv_lang["same_ids"]					= "U heeft dezelfde ID's ingegeven. Samenvoegen is niet mogelijk.";
$pgv_lang["ancestry_chart"]				= "Voorouders";
$pgv_lang["gen_ancestry_chart"]			= "Lijst voorouders, #PEDIGREE_GENERATIONS# generaties";
$pgv_lang["chart_style"]				= "Indeling overzicht";
$pgv_lang["chart_booklet"]   			= "Boek";
$pgv_lang["chart_list"]					= "Lijst";
$pgv_lang["ancestry_list"]				= "Voorouders in lijstvorm";
$pgv_lang["ancestry_booklet"]			= "Voorouders in boekvorm";
$pgv_lang["show_cousins"]				= "Toon neven en nichten";
$pgv_lang["sosa_2"]						= "groot";
$pgv_lang["sosa_3"]						= "over";
$pgv_lang["sosa_4"]						= "bet";
$pgv_lang["sosa_5"]						= "oud";
$pgv_lang["sosa_6"]						= "stam";
$pgv_lang["sosa_7"]						= "edel";
$pgv_lang["sosa_8"]						= "voor";
$pgv_lang["sosa_9"]						= "aards";
$pgv_lang["sosa_10"]					= "opper";
$pgv_lang["sosa_11"]					= "hoog";
$pgv_lang["sosa_12"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_13"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_14"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_15"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_16"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_17"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_18"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_19"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_20"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_21"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_22"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_23"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_24"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_25"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_26"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_27"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_28"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_29"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_30"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_31"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_32"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_33"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_34"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_35"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_43"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_52"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_54"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_60"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_59"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_58"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_57"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_56"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_55"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_53"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_51"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_50"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_49"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_48"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_47"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_46"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_45"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_44"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_42"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_41"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_40"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_39"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_38"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_37"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_36"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_61"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_62"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["sosa_63"]					= "Deze variabele wordt in het Nederlands niet gebruikt.";
$pgv_lang["compact_chart"]			= "Compact overzicht";
$pgv_lang["fan_chart"]					= "Cirkeldiagram";
$pgv_lang["gen_fan_chart"]				= "Cirkeldiagram #PEDIGREE_GENERATIONS# generaties ";
$pgv_lang["fan_width"]					= "Cirkelomvang";
$pgv_lang["gd_library"]					= "De PHP-server is foutief geconfigureerd: De GD-bibliotheek is niet gevonden op de webserver. U kunt de grafische functies niet gebruiken.";
$pgv_lang["gd_freetype"]				= "De PHP-server is foutief geconfigureerd: De Freetype bibliotheek is benodigd voor True Type fonts.";
$pgv_lang["gd_helplink"]				= "http://www.php.net/gd";
$pgv_lang["fontfile_error"]				= "Fontbestand niet gevonden op de webserver.";
$pgv_lang["fanchart_IE"]				= "Dit cirkeldiagram kan niet direct vanuit uw Windows Verkenner worden afgedrukt. Gebruik rechts-klik op uw muis, kies opslaan en druk daarna de afbeelding af.";
$pgv_lang["rss_descr"]					= "Nieuws en snelkoppelingen op de #GEDCOM_TITLE# website";
$pgv_lang["rss_logo_descr"]				= "Vervaardigd met PhpGedView";
$pgv_lang["rss_feeds"]					= "RSS feeds";
$pgv_lang["no_feed_title"]			= "Feed niet beschikbaar";
$pgv_lang["no_feed"]				= "Er is geen RSS feed beschikbaar voor de PhpGedView site.";
$pgv_lang["feed_login"]				= "Indien u bent geregistreerd bij deze PhpGedView site, kunt u zich hier <a href=\"#AUTH_URL#\">aanmelden</a> om beschermde gegevens te kunnen bekijken.";
$pgv_lang["attendant"]					= "Verzorger";
$pgv_lang["attending"]					= "Verzorgt";
$pgv_lang["best_man"] = "Getuige";
$pgv_lang["bridesmaid"] = "Bruidsmeisje";
$pgv_lang["buyer"] = "Koper";
$pgv_lang["circumciser"]				= "Besnijder";
$pgv_lang["civil_registrar"]			= "Ambtenaar Burgerlijke Stand";
$pgv_lang["friend"]						= "Vriend(in)";
$pgv_lang["godfather"]					= "Peetoom";
$pgv_lang["godmother"]					= "Peettante";
$pgv_lang["godparent"]					= "Peet";
$pgv_lang["informant"]					= "Informant";
$pgv_lang["lodger"]						= "Kamerbewoner";
$pgv_lang["nurse"]						= "Verpleegster";
$pgv_lang["priest"]						= "Priester";
$pgv_lang["rabbi"]						= "Rabbijn";
$pgv_lang["registry_officer"]			= "Kerkelijk ambtenaar";
$pgv_lang["seller"] = "Verkoper";
$pgv_lang["servant"]					= "Bediende";
$pgv_lang["twin"]						= "Tweeling";
$pgv_lang["twin_brother"]				= "Tweelingbroer";
$pgv_lang["twin_sister"]				= "Tweelingzus";
$pgv_lang["witness"]					= "Getuige";
$pgv_lang["adds_completed"]				= "Multimedia is succesvol toegevoegd aan het GEDCOM-bestand.";
$pgv_lang["set_link"]					= "Maak koppeling";
$pgv_lang["add_source_lbl"]				= "Voeg bronvermelding toe";
$pgv_lang["add_note_lbl"]				= "Voeg notitie toe";
$pgv_lang["add_media_lbl"]				= "Voeg koppeling met multimedia toe";
$pgv_lang["add_source"]					= "Voeg nieuwe bronvermelding toe";
$pgv_lang["add_note"]					= "Voeg nieuwe notitie toe";
$pgv_lang["delete_source"]				= "Verwijder deze bron";
$pgv_lang["confirm_delete_source"]		= "Weet u zeker dat u deze bron uit het GEDCOM-bestand wilt verwijderen?";
$pgv_lang["add_husb"]					= "Partner toevoegen";
$pgv_lang["add_husb_to_family"]			= "Voeg partner toe aan dit gezin";
$pgv_lang["add_wife"]					= "Partner toevoegen";
$pgv_lang["add_wife_to_family"]			= "Voeg partner toe aan dit gezin";
$pgv_lang["find_family"]				= "Zoek gezin";
$pgv_lang["find_fam_list"]				= "Lijst gezinnen zoeken";
$pgv_lang["add_new_wife"]				= "Nieuwe partner toevoegen";
$pgv_lang["add_new_husb"]				= "Nieuwe partner toevoegen";
$pgv_lang["add_obje"]					= "Multimedia-object toevoegen";
$pgv_lang["no_changes"]					= "Er zijn op dit moment geen wijzigingen ter beoordeling.";
$pgv_lang["accept"]						= "Accepteer";
$pgv_lang["accept_all"]					= "Accepteer alle wijzigingen";
$pgv_lang["accept_successful"]			= "Wijzigingen succesvol aangebracht in de database";
$pgv_lang["edit_raw"]					= "Wijzig GEDCOM-gegevens";
$pgv_lang["select_date"]				= "Selecteer een datum";
$pgv_lang["create_source"]				= "Nieuwe bron";
$pgv_lang["new_source_created"]			= "Bron succesvol aangemaakt.";
$pgv_lang["paste_id_into_field"]		= "Plak dit bron-ID in de invoervelden voor verwijzing naar deze bron ";
$pgv_lang["add_name"]					= "Nieuwe voor/achternaam toevoegen";
$pgv_lang["privacy_not_granted"]		= "U heeft geen toegang tot";
$pgv_lang["user_cannot_edit"]			= "Gebruiker kan deze genealogie niet aanpassen.";
$pgv_lang["privacy_prevented_editing"]	= "Volgens de privacy-instellingen heeft u geen rechten om deze gegevens te wijzigen.";
$pgv_lang["edit_sex"]					= "Wijzig geslacht";
$pgv_lang["ged_noshow"]					= "Deze functie is door de beheerder uitgeschakeld.";
$pgv_lang["bdm"]						= "Geboortes, overlijdens, huwelijken";
$pgv_lang["add_asso"]					= "Nieuwe relatie toevoegen";
$pgv_lang["gedcom_editing_disabled"]	= "De beheerder staat het wijzigen van deze genealogie niet toe.";
$pgv_lang["add_mother"]					= "Moeder toevoegen";
$pgv_lang["add_father"]					= "Vader toevoegen";
$pgv_lang["append"]						= "Gegevens toevoegen";
$pgv_lang["replace"]					= "Gegevens vervangen";
$pgv_lang["edit_name"]					= "Wijzig naam";
$pgv_lang["delete_name"]				= "Verwijder naam";
$pgv_lang["no_temple"]					= "Geen Temple - Living Ordinance";

//-- calendar.php messages
$pgv_lang["on_this_day"]				= "Op deze dag, in het verleden...";
$pgv_lang["in_this_month"]				= "In deze maand, in het verleden...";
$pgv_lang["in_this_year"]				= "In dit jaar, in het verleden....";
$pgv_lang["year_anniversary"]			= "#year_var# jaar geleden";
$pgv_lang["today"]						= "Vandaag";
$pgv_lang["day"]						= "Dag:";
$pgv_lang["month"]						= "Maand:";
$pgv_lang["showcal"]					= "Toon gebeurtenissen van:";
$pgv_lang["anniversary_calendar"]		= "Gebeurteniskalender";
$pgv_lang["sunday"]						= "Zondag";
$pgv_lang["monday"]						= "Maandag";
$pgv_lang["tuesday"]					= "Dinsdag";
$pgv_lang["wednesday"]					= "Woensdag";
$pgv_lang["thursday"]					= "Donderdag";
$pgv_lang["friday"]						= "Vrijdag";
$pgv_lang["saturday"]					= "Zaterdag";
$pgv_lang["viewday"]					= "Toon dag";
$pgv_lang["viewmonth"]					= "Toon maand";
$pgv_lang["viewyear"]					= "Toon jaar";
$pgv_lang["all_people"]					= "Alle personen";
$pgv_lang["living_only"]				= "Levende personen";
$pgv_lang["recent_events"]				= "Recent verleden (< 100 jaar)";
$pgv_lang["day_not_set"]				= "Dag niet bekend";
$pgv_lang["year_error"]					= "Sorry, datums voor 1970 worden in het maandoverzicht niet ondersteund.";
$pgv_lang["upload"]						= "Upload";

//-- upload media messages
$pgv_lang["upload_media"]				= "Uploaden mediabestanden";
$pgv_lang["folder"]		 				= "Map";
$pgv_lang["media_file"]					= "Mediabestand";
$pgv_lang["thumbnail"]					= "Miniweergave";
$pgv_lang["upload_successful"]			= "Upload geslaagd";
$pgv_lang["thumbnail_not_deleted"]	= "Miniweergave kan niet worden verwijderd.";
$pgv_lang["media_record_not_deleted"]	= "Mediagegevens van #xref# en koppelingen kunnen niet worden verwijderd uit het bestand.";
$pgv_lang["record_not_updated"]		= "Gegevens van #pid# kunnen niet worden bijgewerkt.";
$pgv_lang["record_not_removed"]		= "Gegevens van #xref# kunnen niet uit het bestand worden verwijderd.";
$pgv_lang["record_added"]			= "Gegevens van #xref# zijn toegevoegd aan het bestand.";
$pgv_lang["record_not_added"]		= "Gegevens van #xref# kunnen niet worden toegevoegd.";
$pgv_lang["record_removed"]			= "Gegevens van #xref# zijn verwijderd uit het bestand.";
$pgv_lang["record_updated"]			= "Gegevens van #pid# zijn bijgewerkt.";
$pgv_lang["media_record_deleted"]	= "Mediagegevens van #xref# en koppelingen zijn uit het bestand verwijderd.";
$pgv_lang["thumbnail_deleted"]		= "Miniweergave verwijderd.";
$pgv_lang["media_file_not_deleted"]	= "Mediabestand kan niet worden verwijderd.";
$pgv_lang["media_file_not_moved"]	= "Mediabestand kan niet worden verplaatst.";
$pgv_lang["media_file_not_renamed"]	= "Mediabestand kan niet worden verplaatst of hernoemd.";
$pgv_lang["media_file_deleted"]		= "Mediabestand verwijderd.";
$pgv_lang["lost_password"]				= "Wachtwoord vergeten?";

//-- user self registration module
$pgv_lang["requestpassword"]			= "Vraag nieuw wachtwoord aan";
$pgv_lang["no_account_yet"]				= "Nog geen gebruikersnaam?";
$pgv_lang["requestaccount"]				= "Vraag gebruikersnaam aan";
$pgv_lang["emailadress"]				= "E-mail adres";
$pgv_lang["mandatory"] 					= "Vakken met een * zijn verplicht.";
$pgv_lang["mail01_line01"]				= "Hallo #user_fullname# ...";
$pgv_lang["mail01_line02"]				= "Op ( #SERVER_NAME# ) is een verzoek gedaan om aan te melden met uw e-mailadres ( #user_email# ).";
$pgv_lang["mail01_line03"]				= "De volgende gegevens zijn gebruikt.";
$pgv_lang["mail01_line04"]				= "Klik op onderstaande koppeling en vul de gegevens in om uw gebruikersnaam en e-mailadres te verifiëren.";
$pgv_lang["mail01_line05"]				= "Als u deze gegevens niet heeft aangevraagd, kunt u dit bericht verwijderen.";
$pgv_lang["mail01_line06"]				= "U krijgt geen e-mailberichten meer van dit systeem, omdat uw gebruikersnaam, zonder verificatie, binnen zeven dagen wordt verwijderd.";
$pgv_lang["mail01_subject"]				= "Uw registratie op #SERVER_NAME#";
$pgv_lang["mail02_line01"]				= "Hallo Beheerder ...";
$pgv_lang["mail02_line02"]				= "Een nieuwe gebruiker vroeg een gebruikersnaam aan op ( #SERVER_NAME# ).";
$pgv_lang["mail02_line03"]				= "Deze gebruiker ontving een e-mail met de voor verificatie noodzakelijke informatie.";
$pgv_lang["mail02_line04"]				= "U krijgt bericht zodra de gebruiker de verificatie heeft uitgevoerd. Daarna kunt u de gebruiker toestemming geven om aan te melden op de site.";
$pgv_lang["mail02_line04a"]				= "U wordt per e-mail ingelicht als deze toekomstige gebruiker de gegevens heeft geverifieerd. De gebruiker zal daarna in staat zijn zich aan te melden zonder dat van uw kant actie ondernomen hoeft te worden.";
$pgv_lang["mail02_subject"]				= "Er is een verzoek gedaan op ( #SERVER_NAME# ) om aan te melden met uw e-mailadres ( #user_email# ).";
$pgv_lang["hashcode"]					= "Verificatiecode:";
$pgv_lang["thankyou"]					= "Hallo #user_fullname# ...<br />Dank voor uw registratie";
$pgv_lang["pls_note06"]					= "U ontvangt een bevestigingsbericht naar het emailadres ( #user_email# ). Met de gegevens in dit bericht kunt u uw gebruikersnaam activeren. Als dit niet binnen zeven dagen gebeurt, wordt uw aanvraag verwijderd. U kunt dan opnieuw een gebruikersnaam aanvragen. Om aan te melden op deze site heeft u altijd een gebruikersnaam en wachtwoord nodig.";
$pgv_lang["pls_note06a"] 				= "Er wordt nu een bevestiging verzonden naar het e-mailadres ( #user_email# ). U dient uw aanvraag te bevestigen, volg hiervoor de instructies in het e-mailbericht. Als u uw aanvraag niet binnen zeven dagen bevestigt, komt uw aanvraag automatisch te vervallen. U moet dan opnieuw een aanvraag indienen.<br /><br />Nadat u uw aanvraag heeft bevestigd, kunt u zich aanmelden als gebruiker op de website. Gebruik hiervoor uw gebruikersnaam en wachtwoord.<br /><br />";
$pgv_lang["registernew"]				= "Bevestiging nieuwe gebruiker";
$pgv_lang["user_verify"]				= "Verificatie gebruiker";
$pgv_lang["send"]						= "Verzenden";
$pgv_lang["pls_note07"]					= "Type uw gebruikersnaam, wachtwoord en verificatiecode in. Deze heeft u per e-mail ontvangen.";
$pgv_lang["pls_note08"]					= "De gegevens van gebruiker #user_name# zijn gecontroleerd.";
$pgv_lang["mail03_line01"]				= "Hallo Beheerder ...";
$pgv_lang["mail03_line02"]				= "#newuser[username]# ( #newuser[fullname]# ) heeft de registratiegegevens geverifieerd.";
$pgv_lang["mail03_line03"]				= "Klik op de onderstaande koppeling, meld u aan bij uw site en geef de gebruiker toestemming om zich aan te melden.";
$pgv_lang["mail03_line03a"]				= "U hoeft geen actie te ondernemen, de gebruiker kan zich nu aanmelden.";
$pgv_lang["mail03_subject"]				= "Nieuwe verificatie op #SERVER_NAME#";
$pgv_lang["pls_note09"]					= "U bent herkend als geregistreerde gebruiker.";
$pgv_lang["pls_note10"]					= "De beheerder is geïnformeerd.<br /> Zodra hij toestemming heft verleend kunt u met uw gebruikersnaam en wachtwoord aanmelden.";
$pgv_lang["pls_note10a"]				= "U kunt zich nu aanmelden met uw gebruikersnaam en wachtwoord.";
$pgv_lang["data_incorrect"]				= "Gegevens niet correct!<br />Probeer opnieuw!";
$pgv_lang["user_not_found"]				= "Gebruiker niet gevonden!";
$pgv_lang["lost_pw_reset"]				= "Verzoek om een nieuw wachtwoord";
$pgv_lang["pls_note11"]					= "Uw wachtwoord kwijtraken is voor u lastig. Daarnaast betekent het ook een beveiligingsprobleem. Als het in handen komt van anderen, kunnen deze ongeoorloofde toegang krijgen tot gegevens.<br /><br />Type uw gebruikersnaam en e-mail adres in om uw wachtwoord opnieuw aan te vragen. Gebruik de gebruikersnaam en het e-mailadres dat u eerder op deze site heeft opgegeven. Klik daarna op de #pgv_lang[lost_pw_reset]#-knop.<br /><br />Als de gebruikersnaam en het e-mailadres correct zijn, ontvangt u een e-mailbericht, waarin een koppeling en een code zijn opgenomen. Via de koppeling en het intypen van de code kunt u uw wachtwoord opnieuw instellen. Zorg ervoor, dat het e-mailbericht niet in handen van anderen komt, inclusief de beheerder van deze site (deze zal er niet om vragen).<br /><br />Als u niet meer weet welk e-mailadres u eerder op de site heeft opgegeven, kunt u meerdere e-mailadressen proberen. Onze e-mail met de koppeling en code worden alleen verzonden, wanneer de juiste combinatie van gebruikersnaam en e-mailadres is opgegeven. In geval van problemen kunt u altijd contact opnemen met de beheerder van deze site.";
$pgv_lang["enter_email"]				= "U moet een e-mailadres opgeven.";
$pgv_lang["mail04_line05"]			= "Doe het volgende nadat u bent aangemeld: klik op '#pgv_lang[myuserdata]#' in het menu '#pgv_lang[mygedview]#' en vul de gegevens bij wachtwoord in, om uw wachtwoord te wijzigen.";
$pgv_lang["mail04_line01"]				= "Hallo #user_fullname# ...";
$pgv_lang["mail04_line02"]				= "Voor uw gebruikersnaam is een nieuw wachtwoord aangevraagd!";
$pgv_lang["mail04_line03"]				= "Aanbeveling:";
$pgv_lang["mail04_line04"]				= "Klik op de onderstaande koppeling, meldt u aan met het nieuwe wachtwoord en wijzig het vervolgens.";
$pgv_lang["mail04_subject"]				= "Verzoek om gegevens op #SERVER_NAME#";
$pgv_lang["pwreqinfo"]					= "Hallo....<br /><br />Een nieuw wachtwoord is per e-mail verzonden aan (#user[email]#).<br /><br />Binnen enkele minuten zal deze in uw mailbox worden bezorgd.<br /><br />Aanbeveling:<br /><br />Meldt u na ontvangst van de e-mail met uw gebruikersnaam en nieuwe wachtwoord aan en wijzig daarna uw wachtwoord.";
$pgv_lang["editowndata"]				= "Mijn gegevens";
$pgv_lang["savedata"]					= "Gewijzigde gegevens opslaan";
$pgv_lang["datachanged"]				= "Gebruikersgegevens zijn gewijzigd!";
$pgv_lang["datachanged_name"]			= "Opnieuw aanmelden met nieuwe gebruikersnaam a.u.b.";
$pgv_lang["myuserdata"]					= "Mijn gegevens";
$pgv_lang["verified"]					= "Registratie bevestigd";
$pgv_lang["verified_by_admin"]			= "Registratie goedgekeurd";
$pgv_lang["user_theme"]					= "Mijn site-opmaak";
$pgv_lang["mgv"]						= "MyGedView";
$pgv_lang["user_contact_method"]		= "Gewenste verzendwijze";
$pgv_lang["mygedview"]					= "MyGedView";
$pgv_lang["passwordlength"]				= "Het wachtwoord moet uit minimaal 6 karakters bestaan.";
$pgv_lang["admin_approved"]				= "Uw aanmelding op #SERVER_NAME# is goedgekeurd";
$pgv_lang["you_may_login"]				= " door de Beheerder. U kunt nu aanloggen op de website door op de onderstaande koppeling te klikken.";
$pgv_lang["welcome_text_auth_mode_1"]		= "<b>WELKOM OP DEZE GENEALOGIE WEBSITE</b><br /><br />Toegang tot deze website is voorbehouden aan bezoekers die hiervoor zijn geautoriseerd.<br />Als u al beschikt over een gebruikersnaam en wachtwoord, dan kunt u zich op deze pagina aanmelden.<br /><br />Als u nog geen gebruikersnaam en wachtwoord heeft, kunt u er met behulp van de onderstaande koppeling een aanvragen.<br />Na verificatie van de door u verstrekte informatie zal de sitebeheerder uw gebruikersnaam activeren.<br />Zodra activering heeft plaatsgevonden, ontvangt u hierover een e-mailbericht.";
$pgv_lang["welcome_text_auth_mode_2"]		= "<b>WELKOM OP DEZE GENEALOGIE WEBSITE</b><br /><br />Toegang tot deze website is voorbehouden aan bezoekers die hiervoor zijn <b>geautoriseerd</b>.<br />Als u al beschikt over een gebruikersnaam en wachtwoord, dan kunt u zich op deze pagina aanmelden.<br /><br />Als u nog geen gebruikersnaam en wachtwoord heeft, kunt u er met behulp van de onderstaande koppeling een aanvragen.<br />Na verificatie van de door u verstrekte informatie kan de sitebeheerder uw aanvraag toekennen of afwijzen.<br />Zodra uw aanvraag wordt toegekend, ontvangt u hierover een e-mailbericht.";
$pgv_lang["welcome_text_auth_mode_3"]		= "<b>WELKOM OP DEZE GENEALOGIE WEBSITE</b><br /><br />Toegang tot deze website is voorbehouden aan <b>familieleden</b><br /><br />Als u al beschikt over een gebruikersnaam en wachtwoord, dan kunt u zich op deze pagina aanmelden.<br /><br />Als u nog geen gebruikersnaam en wachtwoord heeft, kunt u er met behulp van de onderstaande koppeling een aanvragen.<br />Na verificatie van de door u verstrekte informatie kan de sitebeheerder uw aanvraag toekennen of afwijzen.<br />Zodra uw aanvraag wordt toegekend, ontvangt u hierover een e-mailbericht.";
$pgv_lang["welcome_text_cust_head"]			= "<b>WELKOM OP DEZE GENEALOGIE WEBSITE</b><br /><br />Toegang is voorbehouden aan gebruikers die beschikken over een gebruikersnaam en wachtwoord voor deze site.<br />";


//-- mygedview page
$pgv_lang["welcome"]					= "Welkom";
$pgv_lang["no_events_living1"]			= "Er zijn geen gebeurtenissen van levende personen voor morgen.";
$pgv_lang["none_today_all"]				= "Er zijn geen gebeurtenissen voor vandaag.";
$pgv_lang["none_today_privacy"]			= "Er zijn gebeurtenissen voor vandaag, maar deze worden vanwege privacybeperkingen niet getoond.";
$pgv_lang["more_today_privacy"]			= "<br />Andere gebeurtenissen voor vandaag zijn vanwege privacybeperkingen verborgen.";
$pgv_lang["no_events_privacy"]			= "Er zijn gebeurtenissen in de komende #pgv_lang[global_num1]# dagen, maar deze worden vanwege privacybeperkingen niet getoond.";
$pgv_lang["more_events_privacy"]		= "<br />Andere gebeurtenissen voor de komende #pgv_lang[global_num1]# dagen zijn vanwege privacybeperkingen verborgen.";
$pgv_lang["more_events_privacy1"]		= "<br />Andere gebeurtenissen voor morgen zijn vanwege privacybeperkingen verborgen.";
$pgv_lang["no_events_privacy1"]			= "Er zijn gebeurtenissen voor morgen, maar deze worden vanwege privacybeperkingen niet getoond.";
$pgv_lang["none_today_living"]			= "Er zijn geen gebeurtenissen van levende personen voor vandaag.";
$pgv_lang["no_events_all1"]				= "Er zijn geen gebeurtenissen voor morgen.";
$pgv_lang["basic_or_all"]				= "Alleen geboortes, overlijdens en huwelijken tonen?";
$pgv_lang["no_events_all"]				= "Er zijn geen gebeurtenissen voor de komende #pgv_lang[global_num1]# dagen.";
$pgv_lang["no_events_living"]			= "Er zijn geen gebeurtenissen van levende personen in de komende #pgv_lang[global_num1]# dagen.";
$pgv_lang["living_or_all"]				= "Alleen gebeurtenissen van levende personen tonen?";
$pgv_lang["upcoming_events"]			= "Binnenkort.....";
$pgv_lang["chat"]						= "Chatten";
$pgv_lang["users_logged_in"]			= "Aangemelde gebruikers";
$pgv_lang["anon_user"]					= "1 anoniem aangemelde gebruiker";
$pgv_lang["no_login_users"]				= "Geen (anoniem) aangemelde gebruikers";
$pgv_lang["login_users"]				= "#pgv_lang[global_num1]# aangemelde gebruikers";
$pgv_lang["login_user"]					= "1 aangemelde gebruiker";
$pgv_lang["anon_users"]					= "#pgv_lang[global_num1]# anoniem aangemelde gebruikers";
$pgv_lang["message"]					= "Stuur bericht";
$pgv_lang["my_messages"]				= "Mijn berichten";
$pgv_lang["date_created"]				= "Datum verzonden:";
$pgv_lang["message_from"]				= "E-mail adres:";
$pgv_lang["message_from_name"]			= "Uw naam:";
$pgv_lang["message_to"]					= "Bericht aan:";
$pgv_lang["message_subject"]			= "Onderwerp:";
$pgv_lang["message_body"]				= "Inhoud:";
$pgv_lang["no_to_user"]					= "Geen geadresseerde ingevoerd.";
$pgv_lang["provide_email"]				= "Geef het e-mailadres waar wij het antwoord op uw bericht heen kunnen sturen. Als u dit achterwege laat kunnen wij uw vraag niet beantwoorden. Uw e-mailadres wordt uitsluitend gebruikt om uw vraag te beantwoorden.";
$pgv_lang["reply"]						= "Antwoord";
$pgv_lang["message_deleted"]			= "Bericht verwijderd";
$pgv_lang["message_sent"]				= "Bericht verzonden";
$pgv_lang["reset"]						= "Herstel";
$pgv_lang["site_default"]				= "Standaard site";
$pgv_lang["mygedview_desc"]				= "Op uw persoonlijke MyGedView pagina kunt u uw favoriete personen aangeven, kijken naar gebeurtenissen die binnenkort plaatsvinden en samenwerken met andere PhpGedView gebruikers van deze site.";
$pgv_lang["no_messages"]				= "U heeft geen ongelezen berichten.";
$pgv_lang["clicking_ok"]				= "Als u op OK klikt, wordt een venster geopend om contact op te nemen met";
$pgv_lang["favorites"]				= "Favorieten";
$pgv_lang["my_favorites"]				= "Mijn favorieten";
$pgv_lang["no_favorites"]				= "U heeft geen favorieten geselecteerd. U kunt een persoon aan uw favorieten toevoegen door de details van de persoon op te zoeken en te klikken op \"Toevoegen aan favorieten\". U kunt ook het ID van de persoon, als u dit kent, in het vak hieronder intypen.";
$pgv_lang["add_to_my_favorites"]		= "Toevoegen aan mijn favorieten";
$pgv_lang["gedcom_favorites"]			= "Favorieten in deze genealogie";
$pgv_lang["no_gedcom_favorites"]		= "Op dit moment zijn geen favorieten geselecteerd. De sitebeheerder kan favorieten toevoegen die bij het starten worden getoond.";
$pgv_lang["confirm_fav_remove"]			= "Weet u zeker dat u deze persoon uit uw favorieten wilt verwijderen?";
$pgv_lang["invalid_email"]				= "Voer een geldig e-mailadres in";
$pgv_lang["stat_other"]					= "Overige gegevens";
$pgv_lang["stat_latest_birth"] 		= "Laatste geboortejaar";
$pgv_lang["stat_earliest_death"] 	= "Vroegste jaar van overlijden";
$pgv_lang["stat_latest_death"] 	= "Laatste jaar van overlijden";
$pgv_lang["stat_earliest_birth"] 		= "Vroegste geboortejaar";
$pgv_lang["phpgedview_message"]			= "PhpGedView bericht";
$pgv_lang["default_news_text"]			= "De informatie op deze website wordt beschikbaar gemaakt met behulp van <a href=\"http://www.phpgedview.net/\" target=\"_blank\">PhpGedView  #VERSION#</a>. Deze pagina geeft een introductie in en overzicht over deze genealogie. U kunt een van de overzichten kiezen uit het menu, de details van personen bekijken, of op naam of plaats zoeken.<br /><br />Als u problemen heeft met het gebruik van PhpGedView, kijk dan in het helpmenu voor meer informatie over de pagina waarop u zich bevindt.<br /><br />Dank voor uw bezoek!";
$pgv_lang["reset_default_blocks"]		= "Terug naar standaardindeling";
$pgv_lang["recent_changes"]				= "Recente wijzigingen";
$pgv_lang["recent_changes_block"]		= "Recente wijzigingen";
$pgv_lang["recent_changes_descr"]		= "In het vak \"Recente wijzigingen\" treft u een overzicht aan van alle wijzigingen die in de afgelopen maand zijn aangebracht. De wijzigingen worden getoond aan de hand van de informatie hierover in de persoons- en gezinsinformatie.";
$pgv_lang["recent_changes_none"]		= "<b>Geen wijzigingen in de afgelopen #pgv_lang[global_num1]# dagen.</b><br />";
$pgv_lang["recent_changes_some"]		= "<b>Wijzigingen in de afgelopen #pgv_lang[global_num1]# dagen</b><br />";
$pgv_lang["hide_block_warn"]			= "Als u een leeg vak verbergt, kun u de instellingen ervan niet wijzigen totdat het niet leeg en dus weer zichtbaar is.";
$pgv_lang["show_empty_block"]			= "Vak verbergen wanneer het leeg is?";
$pgv_lang["block_not_configure"]		=	"Dit vak kan niet worden ingesteld.";
$pgv_lang["delete_selected_messages"]			= "Verwijder geselecteerde berichten";
$pgv_lang["use_blocks_for_default"]		= "Gebruik deze vakken als standaard voor alle gebruikers?";
$pgv_lang["default_news_title"]			= "Welkom bij uw genealogie";
$pgv_lang["common_surnames"]			= "Meest voorkomende achternamen";
$pgv_lang["customize_page"]				= "MyGedView indelen";
$pgv_lang["customize_gedcom_page"]		= "Welkomstpagina indelen";
$pgv_lang["hit_count"]		= "Bezoekteller:";
$pgv_lang["user_messages_block"]		= "Mijn berichten";
$pgv_lang["user_messages_descr"]		= "Het vak \"Mijn berichten\" toont een lijst met berichten die aan de actieve gebruiker zijn gezonden.";
$pgv_lang["user_favorites_descr"]		= "Het vak \"Favorieten gebruiker\" toont de gebruiker een lijst van zijn of haar favoriete personen in de genealogie. Op die wijze kan de gebruiker snel de gegevens van deze personen inzien.";
$pgv_lang["welcome_descr"]				= "Het vak \"Welkom .....\" toont de gebruiker de datum en tijd, een directe koppeling naar de eigen gebruikersgegevens en de eigen kwartierstaat.<br />Ook kan de gebruiker de indeling van de eigen MyGedView-pagina wijzigen.";
$pgv_lang["welcome_block"]				= "Welkom ......";
$pgv_lang["gedcom_descr"]				= "In het \"GEDCOM welkom\" vak wordt de gebruiker welkom geheten en wordt de naam van de actieve genealogie getoond, evenals de datum en tijd.";
$pgv_lang["gedcom_block"]				= "GEDCOM welkom";
$pgv_lang["random_media_descr"]			= "In het vak \"Willekeurige afbeelding\" wordt een willekeurige foto of ander multimedia-object geselecteerd en aan de gebruiker getoond.";
$pgv_lang["random_media_persons_or_all"]	= "Toon alleen personen, gebeurtenissen of alles?";
$pgv_lang["random_media_persons"]	= "Personen";
$pgv_lang["random_media_events"]	= "Gebeurtenissen";
$pgv_lang["user_favorites_block"]		= "Favorieten gebruiker";
$pgv_lang["random_media_block"]			= "Willekeurige afbeelding";
$pgv_lang["gedcom_favorites_block"]		= "GEDCOM-favorieten";
$pgv_lang["gedcom_favorites_descr"]		= "In het vak \"GEDCOM-favorieten\" kan de site-beheerder personen uit de genealogie plaatsen, zodat gebruikers deze makkelijk kunnen vinden.<br />Op die manier worden personen, die in de genealogie belangrijk zijn, gemakkelijk toegankelijk gemaakt.";
$pgv_lang["gedcom_stats_block"]			= "GEDCOM-statistieken";
$pgv_lang["gedcom_stats_descr"]			= "Het vak \"GEDCOM-statistieken toont enkele gegevens over het GEDCOM-bestand, zoals het aantal erin aanwezige personen en de datum waarop het is aangemaakt.";
$pgv_lang["gedcom_stats_show_surnames"]	= "Toon veel voorkomende achternamen?";
$pgv_lang["portal_config_intructions"]	= "Op deze pagina kunt u uw persoonlijke MyGedView-pagina inrichten. U kunt kiezen welke vakken worden getoond en welke op positie op het scherm ze worden geplaatst.<br /><br />De pagina is in twee secties verdeeld: aan de linkerkant van het scherm de hoofdsectie, waarin de vakken groot worden weergegeven. Aan de rechterkant de rechtersectie, waarin de vakken klein worden weergegeven.<br /><br />Per sectie kunt u aangeven welke vakken worden getoond en, van boven naar beneden, in welke volgorde.";
$pgv_lang["theme_select_block"]			= "Selecteer een thema";
$pgv_lang["theme_select_descr"]			= "Dit vak geeft de keuzelijst 'selecteer een thema' weer, zelfs wanneer dit staat uitgeschakeld in de instellingen.";
$pgv_lang["block_top10"]				= "Achternamen Top 10";
$pgv_lang["block_top10_title"]			= "Achternamen Top 10";
$pgv_lang["block_top10_descr"]			= "Geeft een lijst met de 10 meest gebruikte namen in de database.";
$pgv_lang["login_block"]				= "Aanmelden";
$pgv_lang["login_descr"]				= "In het vak \"Aanmelden\" kunnen bezoekers zich aanmelden met hun gebruikersnaam en wachtwoord.";
$pgv_lang["gedcom_news_block"]			= "Genealogie prikbord";
$pgv_lang["gedcom_news_descr"]			= "Op het Genealogie prikbord kan de gebruiker nieuws en berichten lezen die er door de beheerder op zijn geplaatst. Het prikbord is een goed middel om bijeenkomsten, nieuws met betrekking tot de site of de genealogie, etc. op te publiceren.";
$pgv_lang["gedcom_news_limit"]		= "Artikelen gelimiteerd door:";
$pgv_lang["gedcom_news_limit_nolimit"]	= "Geen limiet";
$pgv_lang["gedcom_news_limit_date"]		= "Ouderdom van artikel";
$pgv_lang["gedcom_news_flag"]		= "Limiet:";
$pgv_lang["gedcom_news_limit_count"]	= "Aantal artikelen";
$pgv_lang["gedcom_news_archive"] 	= "Bekijk archief";
$pgv_lang["my_journal"]					= "Mijn notitieblok";
$pgv_lang["add_news"]					= "Artikel aan prikbord toevoegen";
$pgv_lang["enter_text"]					= "Typ de tekst voor het artikel of de notitie:";
$pgv_lang["article_text"]				= "Artikeltekst:";
$pgv_lang["news_saved"]					= "Artikel / notitie succesvol opgeslagen.";
$pgv_lang["enter_title"]				= "Geef a.u.b. een titel:";
$pgv_lang["no_news"]					= "Er zijn geen artikelen op het prikbord geplaatst.";
$pgv_lang["edit_news"]					= "Wijzigen/toevoegen artikel/notitie";
$pgv_lang["confirm_journal_delete"]		= "Weet u zeker dat u deze notitie wilt verwijderen?";
$pgv_lang["gedcom_news"]				= "Genealogie prikbord";
$pgv_lang["confirm_news_delete"]		= "Weet u zeker dat u dit artikel wilt verwijderen?";
$pgv_lang["add_journal"]				= "Notitie toevoegen";
$pgv_lang["no_journal"]					= "U heeft geen notities gemaakt.";
$pgv_lang["user_news_descr"]			= "Op het gebruikers notitieblok kan de gebruiker zelf online aantekeningen en notities maken en bewaren.";
$pgv_lang["user_news_block"]			= "Gebruikers notitieblok";
$pgv_lang["main_section"]				= "Vakken hoofdsectie";
$pgv_lang["right_section"]				= "Vakken rechter sectie";
$pgv_lang["available_blocks"]			= "Beschikbare vakken";
$pgv_lang["broadcast_all"]				= "Bericht aan alle gebruikers";
$pgv_lang["move_down"]					= "Omlaag";
$pgv_lang["move_right"]					= "Verplaats naar rechts";
$pgv_lang["move_left"]					= "Verplaats naar links";
$pgv_lang["move_up"]					= "Omhoog";
$pgv_lang["todays_events_descr"]		= "Het vak \"Op deze dag, in het verleden....\" toont een lijst met gebeurtenissen, die op deze dag hebben plaatsgevonden. De gebeurtenissen zijn beperkt tot de actieve genealogie. Op de persoonlijke MyGedView pagina worden alleen gebeurtenissen van levende personen getoond, op een Welkomstpagina de gebeurtenissen van alle personen. Als geen gebeurtenissen worden gevonden, wordt het vak niet getoond.";
$pgv_lang["todays_events_block"]		= "Op deze dag, in het verleden....";
$pgv_lang["logged_in_users_block"]		= "Aangemelde gebruikers";
$pgv_lang["logged_in_users_descr"]		= "Het vak \"Aangemelde gebruikers\" toont een lijst met gebruikers die op dat moment zijn aangemeld.";
$pgv_lang["upcoming_events_block"]		= "Binnenkort...";
$pgv_lang["upcoming_events_descr"]		= "Het vak \"Binnenkort....\" toont een lijst met gebeurtenissen, die op deze dag en tot 30 dagen daarna hebben plaatsgevonden. De gebeurtenissen zijn beperkt tot de actieve genealogie. In een gebruikersportaal worden alleen gebeurtenissen van levende personen getoond, in een portaal van de genealogie de gebeurtenissen van alle personen.";
$pgv_lang["stat_sources"]				= "Bronnen";
$pgv_lang["stat_families"]				= "Gezinnen";
$pgv_lang["stat_individuals"]			= "Personen";
$pgv_lang["gedcom_stats"]				= "Statistieken van deze genealogie:";
$pgv_lang["gedcom_created_on"]			= "Dit genealogiebestand is vervaardigd op <b>#DATE#</b>.";
$pgv_lang["gedcom_created_on2"]			= "op <b>#DATE#</b>";
$pgv_lang["gedcom_created_using"]		= "Dit genealogiebestand is vervaardigd met <b>#SOFTWARE# #VERSION#</b>.";
$pgv_lang["message_instructions"]		= "<b>Let op:</b>Vertrouwelijke informatie over levende personen wordt alleen verstrekt aan verwanten en andere geautoriseerde personen. Voordat u vertrouwelijke informatie ontvangt, wordt eerst uw relatie met de desbetreffende persoon geverifieerd.<br />Soms is informatie over reeds overleden personen ook vertrouwelijk. Dit kan voorkomen, als er niet voldoende informatie voorhanden is, om vast te stellen of de persoon daadwerkelijk is overleden. Waarschijnlijk is ook niet meer informatie voorhanden over deze persoon.<br /><br />Controleer, voordat u een vraag stelt, aan de hand van data, plaatsen en familieleden, dat het de juiste persoon betreft. Als u genealogische informatie versterkt, vermeldt dan de bronnen waar de informatie vandaan komt.";
$pgv_lang["preferred_lang"]				= "Deze gebruiker ontvangt de berichten graag in het #USERLANG#";
$pgv_lang["sending_to"]					= "Bericht wordt verzonden naar #TO_USER#";
$pgv_lang["enter_subject"]				= "Voer onderwerp van het bericht in";
$pgv_lang["enter_body"]					= "Voer tekst in voor het verzenden a.u.b.";
$pgv_lang["confirm_message_delete"]		= "Wilt u dit bericht echt verwijderen? Herstellen is niet mogelijk.";
$pgv_lang["message_email1"]				= "Het volgende bericht is verzonden naar uw PhpGedView-gebruiker:";
$pgv_lang["message_email2"]				= "U zond het volgende bericht naar een PhpGedView-gebruiker:";
$pgv_lang["message_email3"]				= "U zond het volgende bericht naar de PhpGedView beheerder:";
$pgv_lang["viewing_url"]				= "Het bericht is verzonden vanaf de volgende URL:";
$pgv_lang["messaging2_help"]			= "Als u dit bericht verzendt, ontvangt u een kopie op het e-mailadres dat u heeft opgegeven.";
$pgv_lang["random_picture"]				= "Willekeurige afbeelding";

//-- upgrade.php messages
$pgv_lang["upgrade_util"]				= "Opwaardeerprogramma";
$pgv_lang["no_upgrade"]					= "Er zijn geen bestanden om bij te werken.";
$pgv_lang["use_version"]				= "U gebruikt versie:";
$pgv_lang["current_version"]			= "Huidige stabiele versie:";
$pgv_lang["upgrade_download"]			= "Download:";
$pgv_lang["upgrade_tar"]				= "TAR";
$pgv_lang["upgrade_zip"]				= "ZIP";
$pgv_lang["latest"]						= "U heeft de laatste versie van PhpGedView.";
$pgv_lang["location"]					= "Plaats van de opwaardeerbestanden:";
$pgv_lang["include"]					= "Toevoegen:";
$pgv_lang["page_x_of_y"]				= "Pagina #GLOBALS[currentPage]# van #GLOBALS[lastPage]#";
$pgv_lang["options"]					= "Opties:";
$pgv_lang["inc_phpgedview"]				= "PhpGedView";
$pgv_lang["inc_languages"]				= "Talen";
$pgv_lang["inc_config"]					= "Configuratiebestand";
$pgv_lang["inc_researchlog"]			= "Onderzoekslogboek";
$pgv_lang["inc_index"]					= "Indexbestanden";
$pgv_lang["inc_themes"]					= "Thema's";
$pgv_lang["inc_docs"]					= "Handleidingen";
$pgv_lang["inc_privacy"]				= "Privacybestand(en)";
$pgv_lang["inc_backup"]					= "Maak reservekopie";
$pgv_lang["upgrade_help"]				= "Help mij";
$pgv_lang["cannot_read"]				= "Kan bestand niet lezen:";
$pgv_lang["not_configured"]				= "U heeft PhpGedView nog niet geconfigureerd.";
$pgv_lang["location_upgrade"]			= "Geef de locatie van de opwaardeer-bestanden.";
$pgv_lang["new_variable"]				= "Nieuwe variabele gevonden:";
$pgv_lang["file_write_error"]			= "FOUT!! Kan niet schrijven naar bestand [#pgv_lang[global_str1]#].";
$pgv_lang["file_open_error"]			= "Er is een fout opgetreden bij het openen van het bestand [#pgv_lang[global_str1]#].";
$pgv_lang["config_open_error"]			= "Fout bij het openen van het configuratiebestand.";
$pgv_lang["gedcom_config_write_error"]	= "Fout! Kan niet schrijven naar GEDCOM-configuratiebestand.";
$pgv_lang["config_update_ok"]			= "Configuratiebestand is bijgewerkt.";
$pgv_lang["date_of_entry"]				= "Invoerdatum bij bron";
$pgv_lang["main_media_ok1"]				= "Mediabestand <b>#GLOBALS[oldMediaName]#</b> hernoemd naar <b>#GLOBALS[newMediaName]#</b>.";
$pgv_lang["main_media_ok2"]				= "Mediabestand <b>#GLOBALS[oldMediaName]#</b> verplaatst van <b>#GLOBALS[oldMediaFolder]#</b> naar <b>#GLOBALS[newMediaFolder]#</b>";
$pgv_lang["main_media_ok3"]				= "Mediabestand verplaatst en hernoemd van <b>#GLOBALS[oldMediaFolder]##GLOBALS[oldMediaName]#</b> naar <b>#GLOBALS[newMediaFolder]##GLOBALS[newMediaName]#</b>.";
$pgv_lang["main_media_fail0"]			= "Mediabestand <b>#GLOBALS[oldMediaFolder]##GLOBALS[oldMediaName]#</b> bestaat niet.";
$pgv_lang["main_media_fail1"]			= "Mediabestand <b>#GLOBALS[oldMediaName]#</b> kan nier worden hernoemd naar <b>#GLOBALS[newMediaName]#</b>.";
$pgv_lang["main_media_fail2"]			= "Mediabestand <b>#GLOBALS[oldMediaName]#</b> kan niet worden verplaatst van <b>#GLOBALS[oldMediaFolder]#</b> naar <b>#GLOBALS[newMediaFolder]#</b>.";
$pgv_lang["main_media_fail3"]			= "Mediabestand kan niet worden verplaatst en hernoemd van <b>#GLOBALS[oldMediaFolder]##GLOBALS[oldMediaName]#</b> naar <b>#GLOBALS[newMediaFolder]##GLOBALS[newMediaName]#</b>.";
$pgv_lang["thumb_media_ok1"]			= "Miniatuurweergave <b>#GLOBALS[oldMediaName]#</b> hernoemd naar <b>#GLOBALS[newMediaName]#</b>.";
$pgv_lang["thumb_media_ok2"]			= "Miniatuurweergave <b>#GLOBALS[oldMediaName]#</b> verplaatst van <b>#GLOBALS[oldThumbFolder]#</b> naar <b>#GLOBALS[newThumbFolder]#</b>.";
$pgv_lang["thumb_media_ok3"]			= "Miniatuurweergave verplaatst en hernoemd van <b>#GLOBALS[oldThumbFolder]##GLOBALS[oldMediaName]#</b> naar <b>#GLOBALS[newThumbFolder]##GLOBALS[newMediaName]#</b>.|";
$pgv_lang["thumb_media_fail0"]			= "Miniatuurweergave <b>#GLOBALS[oldThumbFolder]##GLOBALS[oldMediaName]#</b> bestaat niet.";
$pgv_lang["thumb_media_fail1"]			= "Miniatuurweergave <b>#GLOBALS[oldMediaName]#</b> kan niet worden hernoemd naar <b>#GLOBALS[newMediaName]#</b>.";
$pgv_lang["thumb_media_fail2"]			= "Miniatuurweergave <b>#GLOBALS[oldMediaName]#</b> kan niet worden verplaatst van <b>#GLOBALS[oldThumbFolder]#</b> naar <b>#GLOBALS[newThumbFolder]#</b>.|";
$pgv_lang["thumb_media_fail3"]			= "Miniatuurweergave kan niet worden verplaatst en hernoemd van <b>#GLOBALS[oldThumbFolder]##GLOBALS[oldMediaName]#</b> naar <b>#GLOBALS[newThumbFolder]##GLOBALS[newMediaName]#</b>.";
$pgv_lang["server_file"]				= "Bestandsnaam op server";
$pgv_lang["server_file_advice"]			= "Niet wijzigen om originele bestandsnaam te behouden.";
$pgv_lang["server_file_advice2"]		= "Hier kan een URL worden ingevoerd, beginnend met &laquo;http://&raquo;.";
$pgv_lang["server_folder"]				= "Mapnaam op server";
$pgv_lang["server_folder_advice"]		= "Voer maximaal #GLOBALS[MEDIA_DIRECTORY_LEVELS]# mapnamen in, welke komen na &laquo;#GLOBALS[MEDIA_DIRECTORY]#&raquo;.<br />Voer niet het  &laquo;#GLOBALS[MEDIA_DIRECTORY]#&raquo; deel van de mapnaam in.";
$pgv_lang["server_folder_advice2"]		= "Dit veld wordt genegeerd indien een URL is ingevoerd in het bestandsnaam veld.";
$pgv_lang["add_linkid_advice"]			= "Voer de ID van de persoon, familie of bron in (of zoek hiernaar) met welke dit mediabestand moet worden verbonden.";
$pgv_lang["use_browse_advice"]			= "Gebruik de knop &laquo;Bladeren&raquo; of &laquo;Browse&raquo; om op uw computer naar de gewenste file te zoeken.";
$pgv_lang["add_media_other_folder"]		= "Andere map ... voer in";
$pgv_lang["add_media_file"]				= "Bestaand mediabestand op server";
$pgv_lang["link_to_existing_media"]		= "Verbind met bestaand mediabestand";
$pgv_lang["page_size"]					= "Paginaformaat";
$pgv_lang["record_not_found"]			= "De opgevraagde gegevens zijn niet gevonden. Dit kan worden veroorzaakt door een verbinding met een onjuist persoon of door een beschadigd GEDCOM bestand.";
$pgv_lang["record_marked_deleted"]		= "Dit record wordt verwijderd na goedkeuring door de beheerder.";
$pgv_lang["result_page"]				= "Resultaat pagina";
$pgv_lang["edit_media"]					= "Wijzigen media bestand";
$pgv_lang["wiki_main_page"]				= "Wiki Hoofd Pagina";
$pgv_lang["wiki_users_guide"]			= "Wiki Gebruikers Handleiding";
$pgv_lang["wiki_admin_guide"]			= "Wiki Beheerders Handleiding";
$pgv_lang["no_search_for"]			= "Selecteer een optie waar naar gezocht moet worden.";
$pgv_lang["no_search_site"]			= "Selecteer ten minste één site.";
$pgv_lang["other_searches"]			= "Andere zoekacties ";
$pgv_lang["multi_site_search"] 		= "Meerdere sites doorzoeken";
$pgv_lang["search_sites"] 			= "Te doorzoeken sites";
$pgv_lang["search_asso_text_unavailable"] = "Verbinding<br /> nog niet beschikbaar met <br /> site zoeken";
$pgv_lang["no_known_servers"]		= "Geen bekende servers<br/>Geen resultaten gevonden";
$pgv_lang["search_sites_discription"] = "Doorzoek bekende sites";
$pgv_lang["basic_search_discription"] = "Eenvoudig zoeken";
$pgv_lang["advanced_search_discription"] = "Geavanceerd zoeken";
$pgv_lang["basic_search"]			= "Zoeken";
$pgv_lang["advanced_search"]		= "Geavanceerd zoeken";
$pgv_lang["name_search"]			= "Naam: ";
$pgv_lang["birthdate_search"]		= "Geboortedatum: ";
$pgv_lang["birthplace_search"]		= "Geboorteplaats: ";
$pgv_lang["deathdate_search"]		= "Overlijdensdatum: ";
$pgv_lang["deathplace_search"]		= "Plaats van overlijden: ";
$pgv_lang["site_had"]				= "bevat de volgende";
$pgv_lang["gender_search"]			= "Geslacht: ";
$pgv_lang["site_list"]				= "Site: ";
$pgv_lang["invalid_search_multisite_input"] = "Voer één van de volgende gegevens in: Naam, Geboortedatum, Geboorteplaats, Overlijdensdatum, Plaats van overlijden of Geslacht";
$pgv_lang["invalid_search_multisite_input_gender"] = "Zoek nogmaals met meer informatie dan alleen geslacht";
$pgv_lang["config_uptodate"]			= "Uw configuratiebestand is bijgewerkt.";
$pgv_lang["processing"]					= "Bezig.......";
$pgv_lang["privacy_open_error"]			= "Fout bij het openen van het [#PRIVACY_MODULE#] bestand.";
$pgv_lang["privacy_write_error"]		= "FOUT!!! Kan niet schrijven naar het [#PRIVACY_MODULE#] bestand.<br />Overtuig u ervan dat de schrijfrechten voor dit bestand zijn ingesteld.<br />De rechten kunnen eventueel weer worden hersteld nadat het privacybestand is geschreven.";
$pgv_lang["privacy_update_ok"]			= "Privacybestand: [#PRIVACY_MODULE#] is bijgewerkt.";
$pgv_lang["privacy_uptodate"]			= "Uw [#PRIVACY_MODULE#] bestand is bijgewerkt.";
$pgv_lang["heading_privacy"]			= "Privacybestand(en):";
$pgv_lang["heading_phpgedview"]			= "PhpGedView-bestanden";
$pgv_lang["heading_image"]				= "Multimediabestanden:";
$pgv_lang["heading_index"]				= "Indexbestanden:";
$pgv_lang["heading_language"]			= "Taalbestanden:";
$pgv_lang["heading_theme"]				= "Themabestanden:";
$pgv_lang["heading_docs"]				= "Handleidingen:";
$pgv_lang["heading_researchlog"]		= "Bestanden onderzoekslogboek:";
$pgv_lang["heading_researchloglang"]	= "Taalbestanden onderzoekslogboek:";
$pgv_lang["copied_success"]				= "kopiëren geslaagd";
$pgv_lang["backup_copied_success"]		= "reservekopie maken geslaagd.";
$pgv_lang["folder_created"]				= "Map gemaakt";
$pgv_lang["folder_no_create"]		= "Map kan niet worden aangemaakt";
$pgv_lang["add_media_button"]			= "Multimedia toevoegen";
$pgv_lang["media_linked"]				= "Dit multimediabestand is gekoppeld aan:";
$pgv_lang["media_not_linked"]			= "Dit multimediabestand is niet aan genealogiegegevens gekoppeld.";
$pgv_lang["phpinfo"]					= "Toon PHP-informatie";
$pgv_lang["admin_info"]					= "Informatie";
$pgv_lang["admin_geds"]					= "Beheer GEDCOM's en gegevens";
$pgv_lang["admin_site"]					= "Beheer website";
$pgv_lang["media_table_created"]		= "De <i>media</i>tabel is bijgewerkt.";
$pgv_lang["click_to_add_media"]			= "Klik hier om de bovenstaande media-items toe te voegen aan het GEDCOM-bestand #GEDCOM#";
$pgv_lang["performing_validation"]		= "GEDCOM-validatie wordt uitgevoerd, selecteer de benodigde opties en klik op \"Opschonen\"";
$pgv_lang["invalid_dates"]				= "Ongeldig datumformaat gevonden. Bij het opschonen worden deze datums gewijzigd in het formaat DD MMM YYYY (bijvoorbeeld 1 JAN 2004).";
$pgv_lang["optional"]					= "Optionele programma's";
$pgv_lang["month_before_day"]			= "Maand voor dag (MM DD YYYY)";
$pgv_lang["order"]						= "Volgorde";
$pgv_lang["inject_media_tool"]			= "Multimedia toevoegen aan GEDCOM-bestand";
$pgv_lang["extension"]					= "Bestandstype";
$pgv_lang["highlighted"]				= "Primaire afbeelding";
$pgv_lang["example_place"]			= "Voorbeeld van een foutieve locatieaanduiding in uw GEDCOM-bestand:";
$pgv_lang["add_media_descr"]			= "Dit programma voegt een OBJE-markering toe aan het GEDCOM-bestand. Sluit het venster als u klaar bent met toevoegen van multimedia.";
$pgv_lang["launch_media_tool"]			= "Klik hier om multimedia toe te voegen.";
$pgv_lang["add_media_tool"]				= "Toevoegen multimedia";
$pgv_lang["example_date"]				= "Voorbeeld van een ongeldige datum in uw GEDCOM-bestand:";
$pgv_lang["change_id"]					= "Wijzig persoons-ID in:";
$pgv_lang["do_not_change"]				= "Niet wijzigen";
$pgv_lang["day_before_month"]			= "Dag voor maand (DD MM YYYY)";
$pgv_lang["optional_tools"]				= "U kunt kiezen om de volgende programma's uit te voeren, voordat het GEDCOM-bestand wordt geïmporteerd.";
$pgv_lang["valid_gedcom"]				= "Geldig GEDCOM-bestand gevonden. Opschonen is niet noodzakelijk.";
$pgv_lang["changed_places"]				= "Ongeldige plaatscoderingen gevonden. Plaatsgegevens zijn opgeschoond zodat deze voldoen aan de GEDCOM 5.5 specificaties.";
$pgv_lang["changed_mac"]				= "Regeleinden in Macintosh-formaat gevonden. Regeleinden met alleen een 'CR' zijn gewijzigd in 'CR' en 'LF'.";
$pgv_lang["process_error"]				= "Er is een probleem met de pagina. Een nieuwere versie kan niet worden gevonden.";
$pgv_lang["upgrade_completed"]			= "Opwaarderen succesvol beëindigd";
$pgv_lang["start_using_upgrad"]			= "Klik hier om te beginnen met versie";

//-- statistics utility
$pgv_lang["statutci"]					= "kan de index niet aanmaken";
$pgv_lang["statnnames"]					= "aantal namen		=";
$pgv_lang["statnfam"]					= "aantal gezinnen =";
$pgv_lang["statnmale"]					= "aantal mannen   =";
$pgv_lang["statnfemale"]				= "aantal vrouwen  =";
$pgv_lang["statvars"]					= "Zet de volgende variabelen voor de plot";
$pgv_lang["statlxa"]					= "langs x-as:";
$pgv_lang["statlya"]					= "langs y-as:";
$pgv_lang["statlza"]					= "langs z-as";
$pgv_lang["stat_18_ard"]				= "leeftijd ten opzichte van overlijdensjaar.";
$pgv_lang["stat_21_nok"]				= "aantal kinderen.";
$pgv_lang["stat_gmx"]					= " controleer grenswaarden voor maand";
$pgv_lang["stat_gax"]					= " controleer grenswaarden voor leeftijden";
$pgv_lang["stat_200_none"]				= "alle (of leeg)";
$pgv_lang["stat_302_cgp"]				= "perioden: controleer grenswaarden voor perioden z-as";
$pgv_lang["stat_301_mf"]				= "m/v";
$pgv_lang["stat_300_none"]				= "geen";
$pgv_lang["stat_202_perc"]				= "percentage";
$pgv_lang["stat_201_num"]				= "aantallen";
$pgv_lang["stat_gnx"]					= " controleer grenswaarden voor aantallen";
$pgv_lang["stat_19_arm"]				= "leeftijd bij huwelijk,";
$pgv_lang["stat_20_arm1"]				= "leeftijd in jaar eerste huwelijk.";
$pgv_lang["stat_17_arb"]				= "leeftijd ten opzichte van geboortejaar.";
$pgv_lang["stat_16_mmb"]				= "Maanden tussen huwelijk en eerste kind";
$pgv_lang["stat_15_mm1"]				= "Maand eerste huwelijk";
$pgv_lang["stat_14_mb1"]				= "Maand van geboorte van eerste kind in relatie";
$pgv_lang["stat_13_mm"]					= "Huwelijksmaand";
$pgv_lang["stat_12_md"]					= "Overlijdensmaand";
$pgv_lang["stat_11_mb"]					= "Geboortemaand";
$pgv_lang["stat_10_none"]				= "geen";
$pgv_lang["statar_xgm"]					= "grenswaarden voor maand (x-as):";
$pgv_lang["statar_zgp"]					= "grenswaarden voor perioden (z-as):";
$pgv_lang["statar_xga"]					= "keuzwaarden voor aantallen (x-as):";
$pgv_lang["statar_xgl"]					= "grenswaarden voor leeftijden (x-as):";
$pgv_lang["statar_xgp"]					= "grenswaarden voor perioden (z-as):";
$pgv_lang["statmess1"]					= "<b>Verander eventueel de volgende waarden afhankelijk van settings x-as en z-as</b>";
$pgv_lang["statreset"]					= "herstel";
$pgv_lang["statsubmit"]					= "laat plot zien";

//-- statisticsplot utility
$pgv_lang["stpl"]						= "...";
$pgv_lang["stplnoim"]					= "niet geïmplementeerd:";
$pgv_lang["stpltype"]					= "type:";
$pgv_lang["stplinfo"]					= "variabelen voor deze grafiek:";
$pgv_lang["stplGDno"]					= "De GD(Graphics Display) Library is niet in PHP 4 aanwezig. Vraag uw systeembeheerder deze te installeren. Dit eist PHP 4.3.8 of hoger<br>";
$pgv_lang["stpljpgraphno"]				= "JPgraph modules zijn niet beschikbaar in phpgedview/jpgraph/. U kunt ze downloaden vanaf http://www.aditus.nu/jpgraph/jpdownload.php<br> <h3>Installeer eerst JPgraph in directory phpgedview/jpgraph/ </h3><br>";
$pgv_lang["stplmf"]						= " / man-vrouw";
$pgv_lang["stplipot"]					= " / per tijdeenheid";
$pgv_lang["stplgzas"]					= "grenzen z-as:";
$pgv_lang["stplmonth"]					= "maand";
$pgv_lang["stplnumbers"]				= "aantallen";
$pgv_lang["stplage"]					= "leeftijd";
$pgv_lang["stplperc"]					= "percentage";
$pgv_lang["stplnumof"]			 = "Aantallen";
$pgv_lang["stplmarrbirth"]		 = "Maanden tussen huwelijk en geboorte eerste kind";
$pgv_lang["alive_in_year"]				= "Levend in jaar";
$pgv_lang["is_alive_in"]				= "Is in leven in ";
$pgv_lang["alive"]						= "Levend ";
$pgv_lang["dead"]						= "Overleden ";
$pgv_lang["maybe"]						= "Misschien ";
$pgv_lang["add_directory"]				= "Map toevoegen";
$pgv_lang["image_format"]				= "Type afbeelding";
$pgv_lang["media_format"]				= "Multimediatype";
$pgv_lang["image_file_size"]			= "Afmeting afbeelding";
$pgv_lang["show_thumbnail"]				= "Toon miniweergaves";
$pgv_lang["gen_all_thumb"]				= "Niet bestaande miniweergaves maken";
$pgv_lang["image_size"]					= "Afmetingen afbeelding";
$pgv_lang["media_file_size"]			= "Multimediagrootte";
$pgv_lang["no_thumb_dir"]				= " map voor miniweergaves bestaat niet en kan niet worden aangemaakt";
$pgv_lang["manage_media"]				= "Beheren multimedia";
$pgv_lang["gen_thumb"]					= "Genereren miniweergave";
$pgv_lang["move_to"]					= "Verplaats naar -->";
$pgv_lang["security_no_create"]			= "Beveiligingswaarschuwing: index.php bestaat niet in ";
$pgv_lang["security_not_exist"]			= "Beveiligingswaarschuwing: kan index.php niet aanmaken in ";
$pgv_lang["illegal_chars"]				= "Ongeldige karakters in de naam";
$pgv_lang["link_media"]					= "Koppel multimedia";
$pgv_lang["to_person"]					= "aan een persoon";
$pgv_lang["to_family"]					= "aan een gezin";
$pgv_lang["move_file_success"]			= "Multimedia- en miniweergavebestanden succesvol verplaatst.";
$pgv_lang["max_media_depth"]		= "U kunt niet meer dan #MEDIA_DIRECTORY_LEVELS# niveaus diep in de mappen gaan";
$pgv_lang["media_folder_corrupt"]		= "De multimediamap is corrupt.";
$pgv_lang["media_thumb_exists"]			= "Miniweergave bestaat al.";
$pgv_lang["media_exists"]				= "Multimediabestand bestaat al.";
$pgv_lang["to_source"]					= "aan een bron";
$pgv_lang["media_id"]					= "Multimedia ID";
$pgv_lang["invalid_id"]					= "Dit ID bestaat niet in deze genealogie.";
$pgv_lang["definitions"]				= "Definities";
$pgv_lang["description"]				= "Omschrijving";
$pgv_lang["block_desc"]					= "Vakbeschrijvingen";
$pgv_lang["accesskeys"]					= "Sneltoetsen";
$pgv_lang["source_contains"]			= "Bron bevat:";
$pgv_lang["display_all"]				= "Alles tonen";
$pgv_lang["accesskey_skip_to_content"]	= "C";
$pgv_lang["accesskey_search"]			= "S";
$pgv_lang["accesskey_skip_to_content_desc"]	= "Direct naar inhoud";
$pgv_lang["accesskey_viewing_advice"]	= "0";
$pgv_lang["accesskey_viewing_advice_desc"]	= "Kijkadvies";
$pgv_lang["accesskey_home_page"]		= "1";
$pgv_lang["accesskey_help_content"]		= "2";
$pgv_lang["accesskey_help_current_page"]= "3";
$pgv_lang["accesskey_contact"]			= "4";
$pgv_lang["accesskey_individual_details"]	= "I";
$pgv_lang["accesskey_individual_relatives"]	= "R";
$pgv_lang["accesskey_individual_notes"]	= "N";
$pgv_lang["accesskey_individual_sources"]	= "O";
$pgv_lang["accesskey_individual_media"]	= "A";
$pgv_lang["accesskey_individual_research_log"]	= "L";
$pgv_lang["accesskey_individual_pedigree"]	= "P";
$pgv_lang["accesskey_individual_descendancy"]	= "D";
$pgv_lang["accesskey_individual_timeline"]	= "T";
$pgv_lang["accesskey_individual_relation_to_me"]	= "M";
$pgv_lang["accesskey_individual_gedcom"]	= "G";
$pgv_lang["accesskey_family_parents_timeline"]	= "P";
$pgv_lang["accesskey_family_children_timeline"]	= "D";
$pgv_lang["accesskey_family_timeline"]	= "T";
$pgv_lang["accesskey_family_gedcom"]	= "G";
$pgv_lang["add_faq_header"] 			= "VGV-titel";
$pgv_lang["add_faq_body"] 				= "VGV-tekst";
$pgv_lang["add_faq_order"] 				= "Positie VGV";
$pgv_lang["no_faq_items"] 				= "De VGV-lijst is leeg.";
$pgv_lang["position_item"] 				= "Onderdeel positioneren";
$pgv_lang["faq_list"] 					= "Veel Gestelde Vragen";
$pgv_lang["confirm_faq_delete"]			= "Weet u zeker dat u deze VGV wilt verwijderen?";
$pgv_lang["no_id"] = "Geen VGV-ID gespecificeerd!";
$pgv_lang["preview"] =  "Voorbeeld";
$pgv_lang["hs_title"] 					= "Zoeken in helpteksten";
$pgv_lang["hs_search"] 					= "Zoek";
$pgv_lang["hs_close"] 					= "Sluit venster";
$pgv_lang["hs_results"] 				= "Aantal resultaten gevonden:";
$pgv_lang["hs_keyword"] 				= "Zoek naar:";
$pgv_lang["hs_searchconfig"]			= "Help voor beheerders";
$pgv_lang["hs_searchhow"]				= "Woordcombinatie:";
$pgv_lang["hs_searchall"]				= "Alle woorden";
$pgv_lang["hs_searchany"]				= "Een of meer woorden";
$pgv_lang["hs_searchsentence"]			= "Exacte zin";
$pgv_lang["hs_intruehelp"]				= "Volwaardige Help-teksten";
$pgv_lang["hs_inallhelp"]				= "Alle tekst in de Help-bestanden";
$pgv_lang["confirm_folder_delete"] = "Map verwijderen?";
$pgv_lang["media_import"] = "Importeren en omzetten multimediagegevens";
$pgv_lang["choose"] = "Kies:";
$pgv_lang["hs_searchuser"]				= "Help voor gebruikers";
$pgv_lang["hs_searchin"]				= "Zoek in:";
$pgv_lang["account_information"] 		= "Gebruikersinformatie";
$pgv_lang["repo_contains"]				= "Bewaarplaats bevat:";
$pgv_lang["media_contains"]				= "Multimedia bevat:";
$pgv_lang["click_here"]					= "Klik hier om door te gaan";
$pgv_lang["click_here_help"]			= "~#pgv_lang[click_here]#~<br /><br />Klik op deze knop om de wijzigingen aan te brengen die eerder zijn opgeslagen.<br /><br />";
$pgv_lang["block_summaries"]			= "~#pgv_lang[block_desc]#~<br /><br />Hier volgt een korte beschrijving van de vakken die u kunt toevoegen aan de #pgv_lang[welcome]# of de #pgv_lang[mygedview]# pagina.<br /><center><table border='1'><tr><td class='list_value'><b>#pgv_lang[name]#</b></td><td class='list_value'><b>#pgv_lang[description]#</b></td></tr>#pgv_lang[block_summary_table]#</table></center><br /><br />";
$pgv_lang["total_places"]				= "Locaties gevonden";
$pgv_lang["block_summary_table"]		= "&nbsp;";

$pgv_lang["privacy"]					= "privé";
$pgv_lang["number_sign"]				= "#";
$pgv_lang["locked"]						= "niet wijzigen";
$pgv_lang["edit_indi"]					= "Wijzig persoon";
$pgv_lang["indis_charts"]				= "Opties voor persoon";
$pgv_lang["cut"]						= "Knippen";
$pgv_lang["record_copied"]				= "Gegevens naar klembord gekopieerd";
$pgv_lang["copy"]						= "Kopiëren";
$pgv_lang["add_from_clipboard"]			= "Toevoegen vanaf klembord";
$pgv_lang["reorder_children"]			= "Kinderen herschikken";
$pgv_lang["sort_by_birth"]				= "Sorteren op geboortedatum";
$pgv_lang["fams_charts"]				= "Opties voor gezin";
$pgv_lang["edit_fam"]					= "Wijzig gezin";
$pgv_lang["max_upload_size"]			= "Maximale uploadgrootte: ";
$pgv_lang["stepbrother"]				= "Stiefbroer";
$pgv_lang["stepsister"]					= "Stiefzuster";
$pgv_lang["stepmom"]					= "Stiefmoeder";
$pgv_lang["stepdad"]					= "Stiefvader";
$pgv_lang["stepfamily"]					= "Stiefgezin";
$pgv_lang["user_default_tab"]			= "Standaard tabblad voor persoonspagina";
$pgv_lang["top10_pageviews"]			= "Meest bekeken gegevens";
$pgv_lang["top10_pageviews_block"]		= "Meest bekeken gegevens";
$pgv_lang["top10_pageviews_descr"]		= "Dit blok toont de 10 gegevens die het meest zijn bekeken. Het is noodzakelijk dat de bezoekteller is ingeschakeld. Zie hiervoor de GEDCOM-configuratie.";
$pgv_lang["add_new_chil"]				= "Nieuw kind toevoegen";
$pgv_lang["update_address"]				= "Adres bijwerken";
$pgv_lang["select_fact"]				= "Selecteer een feit....";
$pgv_lang["photo_replace"]				= "Wilt u een bestaande afbeelding vervangen door deze?";
$pgv_lang["update_photo"]				= "Afbeelding bijwerken";
$pgv_lang["update_fact_restricted"] 	= "Bijwerken van dit feit is beperkt:";
$pgv_lang["update_fact"]				= "Feit bijwerken";
$pgv_lang["update_name"]				= "Naam bijwerken";
$pgv_lang["show_spouses"]				= "Toon partners";
$pgv_lang["quick_update_title"]			= "Snel toevoegen/wijzigen";
$pgv_lang["quick_update_instructions"] 	= "Op deze pagina kunt u snel informatie over een persoon toevoegen of wijzigen. U hoeft alleen de informatie in te vullen die u wilt toevoegen of wijzigen. Vervolgens moeten de gegevens eerst worden goedgekeurd door een beheerder, alvorens ze op de website verschijnen.";
$pgv_lang["mothers_family_with"]		= "Moeders gezin met ";
$pgv_lang["fathers_family_with"]		= "Vaders gezin met ";
$pgv_lang["halfsibling"]				= "Halfbroer of -zus";
$pgv_lang["halfbrother"]				= "Halfbroer";
$pgv_lang["halfsister"]					= "Halfzuster";
$pgv_lang["family_timeline"]			= "Toon gezin op de tijdlijn";
$pgv_lang["children_timeline"]			= "Toon kinderen op de tijdlijn";
$pgv_lang["other"]						= "Overige";
$pgv_lang["sort_by_marriage"]			= "Sorteren op huwelijksdatum";
$pgv_lang["reorder_families"]			= "Gezinnen herschikken";
$pgv_lang["indis_with_surname"]			= "Personen met achternaam #surname#";
$pgv_lang["first_letter_fname"]			= "Kies een letter om personen te tonen wiens voornaam begint met die letter.";
$pgv_lang["import_marr_names"]			= "Importeren achternamen in huwelijk";
$pgv_lang["marr_name_import_instr"]		= "Kies deze functie alleen als u de huwelijkse achternamen wilt opnemen voor vrouwelijke personen in deze genealogie. Dit maakt het mogelijk om vrouwen te zoeken en te tonen op hun huwelijkse achternaam.";
$pgv_lang["calc_marr_names"]			= "Bepalen huwelijkse achternamen";
$pgv_lang["total_names"]				= "Totaal aantal namen";
$pgv_lang["upload_file"]				= "Bestand uploaden vanaf uw computer";
$pgv_lang["thumb_genned"]				= "Miniweergave is automatisch gegenereerd.";
$pgv_lang["thumbgen_error"]				= "Kan miniweergave niet genereren voor ";
$pgv_lang["generate_thumbnail"]			= "Genereer automatisch miniweergave van ";
$pgv_lang["auto_thumbnail"]			= "Automatische miniweergave";
$pgv_lang["no_upload"]					= "Het uploaden van multimediabestanden is niet toegestaan omdat gebruik van multimedia is uitgeschakeld, of omdat u in de multimediamap geen schrijfrechten heeft.";
$pgv_lang["top10_pageviews_nohits"]		= "Er zijn geen bezoeken geregisteerd.";
$pgv_lang["top10_pageviews_msg"]		= "Om dit vak te laten functioneren moet de bezoekteller zijn ingeschakeld in de GEDCOM-configuratie.";
$pgv_lang["review_changes_descr"]		= "Het vak \"Te beoordelen wijzigingen\" toont een lijst met gegevens die op de website zijn aangebracht, maar nog niet zijn beoordeeld en goed- of afgekeurd. Als dit vak is geactiveerd, wordt eens per dag een e-mailbericht verzonden aan gebruikers die accepteer-rechten hebben, om ze te waarschuwen dat er wijzigingen wachten op beoordeling.";
$pgv_lang["review_changes_block"]		= "Te beoordelen wijzigingen";
$pgv_lang["review_changes_email"]		= "Herinneringse-mails verzenden?";
$pgv_lang["review_changes_email_freq"]	= "Frequentie voor herinneringse-mails (dagen)";
$pgv_lang["review_changes_subject"]		= "PhpGedView - Beoordeel wijzigingen";
$pgv_lang["review_changes_body"]		= "Er zijn wijzigingen aangebracht op een genealogie op de PhpGedView site. Deze wijzigingen moeten worden beoordeeld, voordat ze voor gebruikers zichtbaar zijn. Gebruik de link hieronder om naar de site te gaan en u aan te melden om de wijzigingen te beoordelen.";
$pgv_lang["total_memory_usage"]			= "Totaal geheugengebruik:";
$pgv_lang["common_upload_errors"]		= "Deze foutboodschap betekent waarschijnlijk dat het bestand dat u probeert te uploaden, groter is dan het maximum dat de beheerder van de webserver heeft ingesteld. Standaard is de maximum grootte 2Mb. U kunt contact opnemen met de beheerder van de webserver om hem de limiet te laten verhogen, of u kunt het bestand met behulp van een FTP-programma uploaden.<br />Gebruik de functie <a href=\"uploadgedcom.php?action=add_form\">GEDCOM-bestand toevoegen</a> om een bestand in PhpGedView toe te voegen, dat u met zo'n programma heeft ge-upload.<br />";
$pgv_lang["continue_import"]			= "Doorgaan met importeren locaties";
$pgv_lang["importing_places"]			= "Bezig met importeren locaties";
$pgv_lang["support_contact"]			= "Contactpersoon technische hulp";
$pgv_lang["genealogy_contact"]			= "Contactpersoon genealogie";
$pgv_lang["remember_me"]				= "Onthoudt mij op deze PC?";
$pgv_lang["add_unlinked_person"]		= "Niet gekoppeld persoon toevoegen";
$pgv_lang["add_unlinked_source"]	= "Niet gekoppelde bron toevoegen";
$pgv_lang["fams_with_surname"]			= "Gezinnen met achternaam #surname#";
$pgv_lang["cookie_login_help"]			= "Uw gegevens van een vorige maal aanmelden zijn onthouden op deze PC. Hiermee kunt u direct alle voor u toegankelijke informatie benaderen en aan u toegestane functies uitvoeren. Echter, om gegevens te wijzigen of de site te beheren, moet u vanwege veiligheidredenen opnieuw aanmelden.";
$pgv_lang["none"]						= "Geen";
$pgv_lang["child-family"]				= "Ouders, broers en zusters";
$pgv_lang["spouse-family"]				= "Partner en kinderen";
$pgv_lang["direct-ancestors"]			= "Directe voorouders";
$pgv_lang["ancestors"]					= "Directe voorouders en hun gezinnen";
$pgv_lang["descendants"]				= "Nakomelingen";
$pgv_lang["choose_relatives"]			= "Kies verwanten";
$pgv_lang["relatives_report"]			= "Verwanten";
$pgv_lang["total_living"]				= "Totaal in leven";
$pgv_lang["total_dead"]					= "Totaal overleden";
$pgv_lang["total_not_born"]				= "Totaal nog niet geboren";
$pgv_lang["remove_custom_tags"]			= "Verwijder speciale PGV-kenmerken (bijv. _PGVU, _THUM)?";
$pgv_lang["download_zipped"]			= "Download GEDCOM-bestand als ZIP-bestand?";
$pgv_lang["pls_note12"]					= "Gebruik dit vak om aan te geven waarom u als gebruiker wilt worden geregisteerd en hoe u gerelateerd bent aan deze genealogie.";
$pgv_lang["enter_comments"]				= "Geef uw relatie tot de genealogie aan in het commentaarvak.";
$pgv_lang["comments"]					= "Commentaar";

$pgv_lang["html_block_descr"]			= "Dit is een eenvoudig HTML-tekstvak waarin u uw eigen tekst kunt plaatsen.";
$pgv_lang["html_block_sample_part1"]	= "<p class=\"blockhc\"><b>Plaats hier de titel</b></p>rn<p>Klik op de knop \"Instellen\"";
$pgv_lang["html_block_sample_part2"]	= "om aan te passen wat hier is weergegeven.</p>";
$pgv_lang["html_block_name"]			= "HTML-tekstvak";
$pgv_lang["htmlplus_block_name"]	= "Geavanceerd HTML";
$pgv_lang["htmlplus_block_descr"]	= "Dit is een HTML-blok dat op de pagina kan worden geplaatst om een willekeurig type bericht toe te voegen. Er kunnen referenteis naar informatie uit de GEDCOM worden toegevoegd in de HTML-tekst.";
$pgv_lang["htmlplus_block_templates"] = "Sjablonen";
$pgv_lang["htmlplus_block_content"] = "Inhoud";
$pgv_lang["num_to_show"]				= "Aantal te tonen achternamen";
$pgv_lang["days_to_show"]				= "Aantal te tonen dagen";
$pgv_lang["before_or_after"]			= "Plaats tellers voor of achter de naam?";
$pgv_lang["before"]						= "voor";
$pgv_lang["after"]						= "achter";
$pgv_lang["config_block"]				= "Vak instellen";
$pgv_lang["changelog"]					= "Versie #VERSION# aanpassingen";
$pgv_lang["view_changelog"]				= "Versie #VERSION# aanpassingen";
$pgv_lang["continue_import2"]			= "Doorgaan met importeren datums";
$pgv_lang["importing_dates"]			= "Bezig met importeren datums";
$pgv_lang["index_edit_advice"]			= "Selecteer een vaknaam en klik op een van de pijlen om het vak in de aangegeven richting te verplaatsen.";
$pgv_lang["index_edit_advice2"]			= "Klik op de knop \"<b>#pgv_lang[save]#</b>\" om uw wijzigingen door te voeren.";
$pgv_lang["undo_all_confirm"]			= "Weet u zeker dat u alle wijzigingen ongedaan wilt maken?";
$pgv_lang["undo_all"]					= "Alle wijzigingen ongedaan maken";
$pgv_lang["autocomplete"]				= "Auto-aanvullen";
$pgv_lang["address_list"]				= "Adreslijst";
$pgv_lang["filter_address"]				= "Toon adressen die bevatten:";
$pgv_lang["address_labels"]				= "Adresetiketten";


$pgv_lang["link_new_husb"]				= "Mannelijke partner toevoegen aan bestaand persoon";
$pgv_lang["link_new_wife"]				= "Vrouwelijke partner toevoegen aan bestaand persoon";
$pgv_lang["change"]						= "Wijzig";
$pgv_lang["change_family_instr"]	= "Op deze pagina kunt u gezinsleden wijzigen en verwijderen.<br /><br />Voor ieder gezinslid kunt u de koppeling \"Wijzig\" gebruiken om en ander persoon de desbetreffende rol binnen het gezin te geven. U kunt ook de koppeling \"Verwijderen\"gebruiken om de persoon uit het gezin te verwijderen.<br /><br />Als u klaar bent met aanpassen van de gezinsleden, kunt u de wijzigingen opslaan met de \"Opslaan\"-knop.<br />";
$pgv_lang["cancel"]						= "Afbreken";
$pgv_lang["cookie_help"]			= "Deze site gebruikt \"cookies\" om uw aanmelding vast te houden.<br /><br />Het gebruik van \"cookies\" is niet toegestaan in uw windows-verkenner, waardoor u niet kunt aanmelden. Raadpleeg de Help-informatie van uw windows-verkenner om het gebruik van \"cookies\" toe te staan.<br />";
$pgv_lang["change_family_members"]		= "Wijzig gezinsleden";
$pgv_lang["delete_family_confirm"]	= "Door het verwijderen van het gezin verbreekt u het verband tussen de personen. De gegevens van de personen zelf worden niet verwijderd. Weet u zeker dat u dit gezin wilt verwijderen?";
$pgv_lang["delete_family"]				= "Verwijder gezin";
$pgv_lang["add_favorite"]				= "Favoriet toevoegen";
$pgv_lang["url"]						= "URL";
$pgv_lang["add_fav_enter_note"]			= "Type een notitie bij deze favoriet (optie)";
$pgv_lang["add_fav_or_enter_url"]		= "OF<br />type een URL en een titel";
$pgv_lang["import_time_exceeded"]	= "De maximale uitvoeringstijd is bereikt. Druk op de knop \"Doorgaan\" om de import van het GEDCOM-bestand voort te zetten.";
$pgv_lang["add_fav_enter_id"]			= "Type een persoons-, gezins- of bron-ID";
$pgv_lang["next_email_sent"]			= "De volgende e-mailherinnering wordt verzonden na ";
$pgv_lang["last_email_sent"]			= "De laatste e-mailherinnering is verzonden op ";
$pgv_lang["confirm_remove"]				= "Weet u zeker dat u deze persoon uit het gezin wilt verwijderen?";
$pgv_lang["remove_child"]				= "Verwijder dit kind uit het gezin";
$pgv_lang["link_manage_servers"]    	= "Site-koppelingen beheren";
$pgv_lang["indi_is_remote"]				= "De informatie over deze persoon is afkomstig van een gekoppelde site.";
$pgv_lang["link_remote"]            	= "Koppel persoon op andere site";
$pgv_lang["current_person"]         	= "Zelfde als huidige";
$pgv_lang["title_remote_link"]      	= "Koppeling naar andere site toevoegen";
$pgv_lang["title_search_link"]      = "Lokale koppeling toevoegen";
$pgv_lang["label_allowed_servers"]  	= "Toegestane sites";
$pgv_lang["label_banned_servers"]   	= "Geblokkeerde sites";
$pgv_lang["label_manual_search_engines"]   = "Handmatig zoekmachines markeren op basis van IP adres";
$pgv_lang["label_search_engine_detected"]  = "Zoekmachine gedetecteerd";
$pgv_lang["label_search_engine_spider"]    = "Zoekmachine";
$pgv_lang["label_ban_server"]       	= "Blokkeer&gt;&gt;";
$pgv_lang["label_add_search_server"]	= "IP-Adres toevoegen";
$pgv_lang["remove_ip"] 			= "Verwijder IP adres";
$pgv_lang["label_remove_ip"]		= "Blokkeer IP adres: ";
$pgv_lang["label_remove_search"]	= "Markeer IP adres als Zoekmachine Spin";
$pgv_lang["label_username_id"]		= "Gebruikersnaam";
$pgv_lang["label_username_id2"]		= "Gebruikersnaam: ";
$pgv_lang["label_password_id"]		= "Wachtwoord";
$pgv_lang["label_password_id2"]		= "Wachtwoord: ";
$pgv_lang["label_allow_server"]     	= "&lt;&lt;Sta toe";
$pgv_lang["label_allow_view_links"] 	= "Bekijk koppelingen met deze toegestane site";
$pgv_lang["label_ban_view_links"]   	= "Bekijk koppelingen met deze geblokkeerde site";
$pgv_lang["label_delete"]           	= "Verwijder";
$pgv_lang["label_new_server"]       	= "Site toevoegen";
$pgv_lang["label_server_type"]      	= "Type";
$pgv_lang["label_server_url"]       	= "URL/IP";
$pgv_lang["label_banned"]           	= "Geblokkeerd";
$pgv_lang["label_allowed"]          	= "Toegestaan";
$pgv_lang["error_exists_server"]    	= "De site bestaat al.";
$pgv_lang["title_view_conns"]       = "Bekijk verbindingen";
$pgv_lang["label_server_info"]      = "Alle personen gekoppeld via deze site:";
$pgv_lang["label_view_remote"]      = "Bekijk gekoppelde informatie van een persoon";
$pgv_lang["label_view_local"]       = "Bekijk lokale informatie van een persoon";
$pgv_lang["label_added_servers"]	= "Toegevoegde gekoppelde servers";
$pgv_lang["error_delete_person"]    = "Selecteer de persoon waarvan de externe koppeling verwijderd moet worden.";
$pgv_lang["error_view_info"]        = "Selecteer de persoon waarvan de informatie moet worden getoond.";
$pgv_lang["label_add_server"]       	= "Toevoegen";
$pgv_lang["error_url"]              	= "Een site moet een IP-adres of URL hebben.";
$pgv_lang["label_individuals"]      	= "Personen";
$pgv_lang["label_families"]         	= "Gezinnen";
$pgv_lang["ex-spouse"] = "Ex-echtgenoot";
$pgv_lang["ex-wife"] = "Ex-vrouw";
$pgv_lang["ex-husband"] = "Ex-man";
$pgv_lang["onlyemail"] 				= "Alleen adressen met email-adres";
$pgv_lang["noemail"] 				= "Adressen zonder email-adres";
$pgv_lang["label_same_server"]      	= "Zelfde site";
$pgv_lang["label_diff_server"]      	= "Andere site";
$pgv_lang["error_same"]             	= "U heeft dezelfde site geselecteerd.";
$pgv_lang["lbl_server_list"]        = "Gebruik een bestaande site.";
$pgv_lang["link_success"]			= "Koppeling toegevoegd";
$pgv_lang["error_url_blank"]		= "Gekoppelde site naam of URL niet leeg laten";
$pgv_lang["error_siteauth_failed"]	= "Aanmelden bij gekoppelde site niet gelukt";
$pgv_lang["lbl_type_server"]         = "Voer nieuwe site in:";
$pgv_lang["error_delete_server"]    = "Selecteer de site die u wilt verwijderen.";
$pgv_lang["error_view_connections"] = "Selecteer de site die u wilt bekijken.";
$pgv_lang["error_ban_server"]       = "Selecteer de site die u wilt blokkeren.";
$pgv_lang["error_allow_server"]     = "Selecteer de site die u wilt toestaan.";
$pgv_lang["error_server_exists"]    	= "De site die u probeert toe te voegen bestaat al.<br />Gebruik de keuzelijst om de site te selecteren.";
$pgv_lang["error_remote"]           	= "U heeft een gekoppelde site geselecteerd.";
$pgv_lang["label_add_remote_link"]  	= "Koppeling toevoegen";
$pgv_lang["title_manage_servers"]   	= "Beheer sites";
$pgv_lang["label_gedcom_id2"]       = "GEDCOM-ID:";
$pgv_lang["label_gedcom_id"]        	= "GEDCOM-ID";
$pgv_lang["label_merge_options"]    	= "Samenvoegopties";
$pgv_lang["label_local_id"]         	= "Persoons-ID";
$pgv_lang["label_remote_id"]        	= "ID persoon op andere site";
$pgv_lang["label_site_url"]         	= "Website URL:";
$pgv_lang["label_site_url2"]        = "Website URL";
$pgv_lang["label_site"]             = "Site";
$pgv_lang["label_location"]         	= "Locatie";
$pgv_lang["label_rel_to_current"]   	= "Relatie met huidige persoon";
$pgv_lang["label_ask_first"]        	= "Eerst vragen";
$pgv_lang["label_accept_changes"]   	= "Accepteer alle wijzigingen";

$pgv_lang["edit_source"]			= "Bewerk bron";
$pgv_lang["family_of"]				= "Familie van: &nbsp;";
$pgv_lang["descent_steps"]			= "Nakomelingen stappen";
$pgv_lang["source_menu"]			= "Opties voor bron";
$pgv_lang["familybook_chart"]		= "Familieboek";
$pgv_lang["user_auto_accept"]		= "Accepteer wijzigingen van deze gebruiker automatisch";
$pgv_lang["sunday_1st"]					= "Zo";
$pgv_lang["monday_1st"]					= "Ma";
$pgv_lang["tuesday_1st"]				= "Di";
$pgv_lang["wednesday_1st"]				= "Wo";
$pgv_lang["thursday_1st"]				= "Do";
$pgv_lang["friday_1st"]					= "Vrij";
$pgv_lang["saturday_1st"]				= "Za";

$pgv_lang["january_1st"]			= "Jan";
$pgv_lang["february_1st"]			= "Feb";
$pgv_lang["march_1st"]				= "Maa";
$pgv_lang["april_1st"]				= "Apr";
$pgv_lang["may_1st"]				= "Mei";
$pgv_lang["june_1st"]				= "Juni";
$pgv_lang["july_1st"]				= "Juli";
$pgv_lang["august_1st"]				= "Aug";
$pgv_lang["september_1st"]			= "Sep";
$pgv_lang["october_1st"]			= "Okt";
$pgv_lang["november_1st"]			= "Nov";
$pgv_lang["december_1st"]			= "Dec";

$pgv_lang["maxviews_exceeded"]		= "Maximaal aantal pagina's overschreden, probeer later opnieuw.";
$pgv_lang["broadcast_not_logged_6mo"]	= "Bericht aan langer dan 6 maanden niet aangemelde gebruikers";
$pgv_lang["stat_average_children"]	= "Gemiddeld aantal kinderen per gezin";
$pgv_lang["stat_users"]				= "Aantal gebruikers";
$pgv_lang["no_family_facts"]		= "Geen gebeurtenissen voor dit gezin";
$pgv_lang["stat_surnames"]			= "Aantal achternamen";
$pgv_lang["stat_events"]			= "Aantal gebeurtenissen";
$pgv_lang["stat_most_children"]		= "Gezin met meeste kinderen";
$pgv_lang["stat_longest_life"]		= "Langst levende persoon";
$pgv_lang["stat_avg_age_at_death"]	= "Gemiddelde leeftijd bij overlijden";
$pgv_lang["stats_to_show"]			= "Selecteer in dit vak te tonen statistieken";
$pgv_lang["broadcast_never_logged_in"]	= "Bericht aan nooit aangemelde gebruikers";

//-- Media item "TYPE" sub-field
$pgv_lang["TYPE__audio"] = "Audio";
$pgv_lang["TYPE__book"] = "Boek";
$pgv_lang["TYPE__card"] = "Kaart";
$pgv_lang["TYPE__certificate"] = "Certificaat";
$pgv_lang["TYPE__document"] = "Document";
$pgv_lang["TYPE__electronic"] = "Electronisch";
$pgv_lang["TYPE__fiche"] = "Microfiche";
$pgv_lang["TYPE__film"] = "Microfilm";
$pgv_lang["TYPE__magazine"] = "Magazine";
$pgv_lang["TYPE__manuscript"] = "Manuscript";
$pgv_lang["TYPE__map"] = "Kaart";
$pgv_lang["TYPE__newspaper"] = "Krant";
$pgv_lang["TYPE__photo"] = "Foto";
$pgv_lang["TYPE__tombstone"] = "Grafsteen";
$pgv_lang["TYPE__video"] = "Video";
$pgv_lang["hebrew_surn"]			= "Hebreeuwse achternaam";
$pgv_lang["hebrew_givn"]			= "Hebreeuwse voornamen";

$pgv_lang["roman_surn"]				= "Geromaniseerde achternaam";
$pgv_lang["roman_givn"]				= "Geromaniseerde voornamen";

if (file_exists("languages/lang.nl.extra.php")) require "languages/lang.nl.extra.php";
?>
