<?php

/*
 * This example is mostly for playing with color ranges (gradients)
 * and alpha channels.
 */

require './package.Imlib.php';

$red = Array(255,35,35,255);
$blue = Array(35,65,255,255);
$text = Array(200,220,255,255);
$shadow = Array(10,10,10,100);

// Create objects
$im = new ImlibImage;
$cr = new ImlibColorRange;
$d = new ImlibDraw;
$t = new ImlibText;

// Set up objects
$im->create(250,150);
$cr->create();
$cr->set_image($im->get_id());
$d->set_image($im->get_id());
$t->set_image($im->get_id());
$t->load('','banco.ttf','25');

// Large blue rectangle and gradient
$d->set_color(22,28,235,255);
$d->fill_rectangle(10,10,210,110);
$cr->add_color_array(0, $red);
$cr->add_color(0,0,225,225,255);
$cr->add_color_array(0, $blue);
$cr->fill_rectangle(15,15,200,100,125);

// Text with semitransparent shadow
$t->set_color_array($shadow);
$t->draw(43,48,'Showing off.');
$t->set_color_array($text);
$t->draw(40,45,'Showing off.');

// Purple semitransparent square
$d->set_color(195,105,195,127);
$d->fill_rectangle(30,90,50,50);

// Green-to-transparent gradient square
$cr->free();
$cr->create();
$cr->add_color(0,0,255,0,0);
$cr->add_color(0,0,255,0,50);
$cr->add_color(0,0,255,0,255);
$cr->fill_rectangle(90,90,50,50,235);

$im->save('testgrad.png',50);

?>
