# $Progeny: installer-x.sh,v 1.87 2002/04/23 23:52:45 branden Exp $

run_installer () {
    # ensure no filesystems from a previous install attempt are still mounted
    unmount_targets
    if [ -n "$DISPLAY" ]; then
        # remote start
        pgilog "xinitrc"
        xinitrc
    else
        # local start
        pgilog "xinit $LIVE/bin/xinitrc -- -allowMouseOpenFail -layout $LAYOUT -verbose 3 -nolisten tcp vt7"
        xinit $LIVE/bin/xinitrc -- -allowMouseOpenFail -layout $LAYOUT -verbose 3 -nolisten tcp vt7 >> $LOGFILE 2>&1
    fi;
}

echo
echo
echo "Starting PGI Debian graphical installer..."

STATUSFILE=/tmp/installer-druid-exit-status
export STATUSFILE

pgilog "Prompting mode is \"$PROMPTING\"."
pgilog "Using Linux kernel $KERNEL_VERSION."

echo "lspci output:" >> $LOGFILE
lspci >> $LOGFILE
echo "*******************************************************" >> $LOGFILE

echo "lspci -n output (no different from above if PCI list not compiled into kernel):" >> $LOGFILE
lspci -n >> $LOGFILE
echo "*******************************************************" >> $LOGFILE

pgilog "Dumping dmesg to $DMESGLOG."
dmesg >> $DMESGLOG

# required commands
DISCOVER=$LIVE/sbin/discover
MDETECT=$LIVE/bin/mdetect
DIALOG=$LIVE/bin/dialog
AWK=$LIVE/bin/awk

# optional commands
GET_EDID=$LIVE/bin/get-edid
PARSE_EDID=$LIVE/bin/parse-edid

for COMMAND in $DISCOVER $MDETECT $DIALOG $AWK; do
    while :; do
        pgilog -n "Checking for command $COMMAND..."
        if command -v $(basename $COMMAND) > /dev/null 2>&1; then
            pgilog "found."
            break
        else
            pgilog "not found.  Spawning shell."
            echo "Error in installer environment: can't find $COMMAND in $PATH."
            echo "Here's a shell prompt so you can set things right."
            envsh
        fi
    done
done

HAVE_EDID=yes

for COMMAND in $GET_EDID $PARSE_EDID; do
    pgilog -n "Checking for optional command $COMMAND..."
    if command -v $(basename $COMMAND) > /dev/null 2>&1; then
        pgilog "found."
    else
        pgilog "not found.  Oh, well."
        HAVE_EDID=
    fi
done

if [ -n "$DISPLAY" ]; then
    pgilog "\$DISPLAY is \"$DISPLAY\"."
    echo -n "Connecting to $DISPLAY..."
    run_installer
    X_WORKED=yes
else
    pgilog "Beginning X configuration cycle."
    echo "Configuring X server.  Please wait..."
fi

# sorry, folks, gotta turn off debugging for dialog's sake
set +x

while [ -z "$X_WORKED" ]; do
    # prepare an XF86Config file
    DRIVER_PROMPTING=$PROMPTING
    pgilog "Looking for VGA devices on the PCI bus."
    # try to figure out the video; find all devices in the VGA class
    PCI_VIDEO_DEVICES=$(lspci -n | grep 'Class 0300')
    if [ -n "$PCI_VIDEO_DEVICES" ]; then
        pgilog "Found the following:"
        pgilog "$PCI_VIDEO_DEVICES"
        DISCOVERED_VIDEO=$($DISCOVER --format="%V %M\t%D\n" video 2>> $LOGFILE)
        # ") # gratutitous comment to work around broken syntax highlighting in vim
        DRIVERS=$(echo "$DISCOVERED_VIDEO" | awk 'BEGIN { FS="\t" } { print $NF }' | sort | uniq)
        NDRIVERS=$(echo "$DRIVERS" | wc -l | tr -d ' ')
        if [ $NDRIVERS -eq 1 ]; then
            pgilog "Autodetected X server driver: $DRIVERS."
            if [ -z "$DRIVERS" -o "$DRIVERS" = "unknown" ]; then
                VIDEO_DRIVER=vesa
                pgilog "Autodetected X server driver was null or unknown, using $VIDEO_DRIVER instead."
            else
                VIDEO_DRIVER=$DRIVERS
            fi
        elif [ $NDRIVERS -gt 1 ]; then
            pgilog "Detected multiple server drivers: $(echo $DRIVERS)"
            DRIVER_PROMPTING=more
        else
            pgilog "Could not autodetect any server drivers."
        fi
    else
        pgilog "Did not find any VGA devices on the PCI bus."
        DRIVER_PROMPTING=more
    fi

    if [ "$DRIVER_PROMPTING" = "more" ]; then
        if [ -n "$DISCOVERED_VIDEO" ]; then
            VIDEOCARD_DRIVER_REPORT=$(echo "$DISCOVERED_VIDEO" | awk 'BEGIN { FS="\t"; printf "%-30s%30s\n", "Detected video card", "Suggested driver module"; print "------------------------------------------------------------" } { printf "%-50s%10s\n", $1, $2 } END { printf "\n" }')
            TEXT="Choose a video driver.  You should first try the suggested driver; otherwise, try the vesa driver.  If vesa does not work, try vga.\n\n$VIDEOCARD_DRIVER_REPORT\n"
        else
            TEXT="Choose a video driver.  A video driver could not be autodetected, so it is recommended that you use a driver for hardware that most closely resembles your video card.  If in doubt, try the vesa driver.  If vesa does not work, try vga.\n"
        fi
        pgilog "Prompting user for video driver."
        $DIALOG --no-cancel --cr-wrap --backtitle \
            "PGI Debian Installer" \
            --title "Select Video Driver" --menu \
            "$TEXT\n" 20 70 4 \
            "apm"       "Alliance" \
            "ark"       "Ark Logic" \
            "ati"       "ATI" \
            "chips"     "Chips and Technologies" \
            "cirrus"    "Cirrus Logic" \
            "cyrix"     "Cyrix" \
            "fbdev"     "Linux kernel framebuffer driver" \
            "glide"     "3Dfx Voodoo Graphics / Voodoo2" \
            "glint"     "3DLabs" \
            "i128"      "Number Nine Image 128" \
            "i740"      "Intel i740" \
            "i810"      "Intel i810 / i820 / i830" \
            "imstt"     "IMS (Integrated Micro Solutions)" \
            "mga"       "Matrox" \
            "neomagic"  "NeoMagic" \
            "nv"        "NVidia" \
            "rendition" "Rendition" \
            "s3virge"   "S3 ViRGE & Trio3D" \
            "savage"    "S3 Savage" \
            "siliconmotion" "SMI (Silicon Motion, Inc.)" \
            "sis"       "SiS (Silicon Integrated Systems)" \
            "tdfx"      "3Dfx Voodoo Banshee / Voodoo3 / Voodoo4 / Voodoo5" \
            "tga"       "DEC (Digital Equipment Corp.) TGA" \
            "trident"   "Trident" \
            "tseng"     "Tseng Labs" \
            "vesa"      "generic VESA driver" \
            "vga"       "generic VGA driver" \
            2> /tmp/prompt
            # check for cancellation
            if [ $? -ne 0 ]; then
                CANCEL=yes
                break
            fi
            VIDEO_DRIVER=$(cat /tmp/prompt)
            pgilog "User said the video driver should be $VIDEO_DRIVER."
    else
            pgilog "Assuming that the video driver should be $VIDEO_DRIVER."
    fi

    # XXX: make this a yesno dialog
    USE_FBDEV="false"
    if [ -e /proc/fb ]; then
        if [ -n "$(cat /proc/fb)" ]; then
            USE_FBDEV="true"
        fi
    fi

    if [ "$PROMPTING" = "more" ]; then
        pgilog "Prompting user about mouse autodetection."
        $DIALOG --no-cancel --cr-wrap --backtitle \
            "PGI Debian Installer" \
            --title "Attempt Mouse Autodetection?" --yesno \
            "If you have a mouse (or similar pointing device) attached to the computer, an attempt to detect it can be made if you answer \"Yes\".  If you would like to attach a mouse to your computer, do so now only if you have a USB or serial port mouse.  Otherwise, turn off the computer, connect the mouse, and restart this installer.  If you have no mouse, or wish to select a mouse type manually, answer \"No\"."  11 70
        case "$?" in
        0)
            # yes
            AUTODETECT_MOUSE=yes
            pgilog "User wants to attempt mouse autodetection."
            ;;
        1)
            # no
            AUTODETECT_MOUSE=
            pgilog "User does not want to attempt mouse autodetection."
            ;;
        *)
            # cancel/error
            AUTODETECT_MOUSE=
            CANCEL=yes
            break
            ;;
        esac
    else
        pgilog "Assuming mouse autodetection desired."
        AUTODETECT_MOUSE=yes
    fi

    if [ -n "$AUTODETECT_MOUSE" ]; then
        MDETECT_STATUS=1
        while [ "$MDETECT_STATUS" != "0" ]; do
            echo -n "Detecting mouse..."
            pgilog -n "Running mdetect to detect mouse..."
            MDETECT_OUTPUT=$($MDETECT -x)
            MDETECT_STATUS=$?
            echo "done."
            pgilog "exited with status $MDETECT_STATUS.  Output follows."
            pgilog "$MDETECT_OUTPUT"

            # Try again in case they started moving the mouse too late.
            if [ "$MDETECT_STATUS" != "0" ]; then
                pgilog "Prompting user to move mouse around."
                $DIALOG --no-cancel --cr-wrap --backtitle \
                    "PGI Debian Installer" \
                    --title "Mouse Autodetection" --infobox \
                    "Please move your mouse around for several seconds to aid autodetection..." 4 45
                # give the user time to read it, in the case where
                # mdetect works quickly
                sleep 3
                pgilog -n "Running mdetect (again)..."
                MDETECT_OUTPUT=$($MDETECT -x)
                MDETECT_STATUS=$?
                pgilog "exited with status $MDETECT_STATUS.  Output follows."
                pgilog "$MDETECT_OUTPUT"
            fi

            if [ "$MDETECT_STATUS" != "0" ]; then
                pgilog "Prompting user to retry mouse detection."
                $DIALOG --no-cancel --cr-wrap --backtitle \
                    "PGI Debian Installer" \
                    --title "Retry Mouse Detection?" --yesno \
                    "A mouse (or compatible pointing device) was not detected.  If you have a mouse attached to the computer, another attempt to detect it can be made if you answer \"Yes\".  If you would like to attach a mouse to your computer, do so now only if you have a USB or serial port mouse.  Otherwise, turn off the computer, connect the mouse, and restart this installer.  If you wish to select a mouse type manually, answer \"No\"."  11 70
                case "$?" in
                0)
                    # yes
                    pgilog -n "Running mdetect again at user request..."
                    MDETECT_OUTPUT=$($MDETECT -x)
                    MDETECT_STATUS=$?
                    pgilog "exited with status $MDETECT_STATUS.  Output follows."
                    pgilog "$MDETECT_OUTPUT"
                    ;;
                1)
                    # no
                    pgilog "User did not want to retry mouse detection."
                    AUTODETECT_MOUSE=
                    break
                    ;;
                *)
                    # cancel/error
                    AUTODETECT_MOUSE=
                    CANCEL=yes
                    break
                    ;;
                esac
            fi
        done
    fi

    if [ -z "$AUTODETECT_MOUSE" -o -z "$MDETECT_OUTPUT" ]; then
        pgilog "\$AUTODETECT_MOUSE was \"$AUTODETECT_MOUSE\"."
        pgilog "\$MDETECT_OUTPUT was:"
        pgilog "$MDETECT_OUTPUT"
        pgilog "Prompting user about mouse ports and protocols."
        $DIALOG --no-cancel --cr-wrap --backtitle \
            "PGI Debian Installer" \
            --title "Mouse Port and Protocol Selection" --msgbox \
            "On the next screen, please specify which port (connection type) your mouse uses.  Serial ports use D-shaped connectors with 9 or 25 pins (a.k.a. DB-9 or DB-25); the mouse connector is female (has holes) and the computer connector is male (has pins).  PS/2 ports are small round connectors (DIN) with 6 pins; the mouse connector is male and the computer side female.  You may alternatively have a USB (relatively new) mouse, a bus/inport (very old) mouse, or have no mouse at all.  If you need to attach or remove bus/inport or PS/2 devices from your computer, please shut down and do so with the power off." 15 64
        pgilog "Prompting user for mouse port."
        $DIALOG --no-cancel --cr-wrap --backtitle "PGI Debian Installer" \
            --title "Mouse Port Selection" --menu \
            "Please choose your mouse port." 15 60 8 \
            "/dev/psaux"      "PS/2 port" \
            "/dev/ttyS0"      "Serial port COM1" \
            "/dev/ttyS1"      "Serial port COM2" \
            "/dev/ttyS2"      "Serial port COM3" \
            "/dev/ttyS3"      "Serial port COM4" \
            "/dev/input/mice" "USB mouse" \
            "/dev/atibm"      "Bus / inport mouse" \
            "none"          "no mouse" \
            2> /tmp/prompt
        # check for cancellation
        if [ $? -ne 0 ]; then
            CANCEL=yes
            break
        fi
        MOUSE_PORT=$(cat /tmp/prompt)
        case "$MOUSE_PORT" in
        *psaux)
            pgilog "Prompting user for PS/2 mouse protocol."
            $DIALOG --no-cancel --cr-wrap --backtitle "PGI Debian Installer" \
                --title "Mouse Protocol Selection" --menu \
                "Please choose the entry that best describes your mouse. If in doubt, choose the \"PS/2\" option." 16 70 8 \
                "PS/2"          "(generic) any 2 or 3-button PS/2 mouse" \
                "GlidePointPS/2"    "ALPS GlidePoint" \
                "NetMousePS/2"      "Genius NetMouse or NetMousePro" \
                "NetScrollPS/2"     "Genius NetScroll" \
                "ThinkingMousePS/2" "Kensington Thinking Mouse" \
                "MouseManPlusPS/2"  "Logitech MouseMan+ or FirstMouse+" \
                "ImPS/2"        "Microsoft IntelliMouse" \
                "ExplorerPS/2"      "Microsoft IntelliMouse Explorer" \
                2> /tmp/prompt
                # check for cancellation
                if [ $? -ne 0 ]; then
                    CANCEL=yes
                    break
                fi
                MOUSE_PROTOCOL=$(cat /tmp/prompt)
            ;;
        *ttyS*|*tts/*)
            pgilog "Prompting user for serial mouse protocol."
            $DIALOG --no-cancel --cr-wrap --backtitle "PGI Debian Installer" \
                --title "Mouse Protocol Selection" --menu \
                "Please choose the entry that best describes your mouse. If in doubt, choose the autodetect option." 18 70 10 \
                "Auto"      "autodetect" \
                "Microsoft" "Microsoft Mouse (most generic 2-button mice)" \
                "MouseSystems"  "MouseSystems (most generic 3-button mice)" \
                "GlidePoint"    "ALPS GlidePoint" \
                "ThinkingMouse" "Kensington Thinking Mouse" \
                "MouseMan"  "Logitech MouseMan" \
                "Logitech"  "Logitech (very old models)" \
                "IntelliMouse"  "Microsoft IntelliMouse" \
                "MMSeries"  "MMSeries (rare)" \
                "MMHitTab"  "MM Hitachi Tablet (rare)" \
                2> /tmp/prompt
                # check for cancellation
                if [ $? -ne 0 ]; then
                    CANCEL=yes
                    break
                fi
                MOUSE_PROTOCOL=$(cat /tmp/prompt)
            ;;
        *input/mice)
            MOUSE_PROTOCOL=ImPS/2
            ;;
        *atibm|*atixl)
            MOUSE_PROTOCOL=BusMouse
            ;;
        none)
            pgilog "Prompting user about how to use X without a mouse."
            $DIALOG --no-cancel --cr-wrap --backtitle "PGI Debian Installer" \
                --title "Using the Graphical Installer Without a Mouse" \
                --msgbox \
                "You can navigate the graphical installer without a mouse.  When the welcome screen comes up, press Shift+NumLock.  You will then be able to use your keyboard's numeric keypad to move the pointer on the screen.  The digits 8, 2, 4, and 6 move up, down, left, and right, respectively.  The 1, 3, 7, 9 keys move diagonally, and 5 \"clicks\" the mouse.\n\nPressing Shift+NumLock again restores the numeric keypad's normal functions.  You can toggle the keypad's mouse emulation back and forth in this way as many times as you like." 14 70
            # check for cancellation
            if [ $? -ne 0 ]; then
                CANCEL=yes
                break
            fi
            # dummy values to keep the XF86Config parser happy
            MOUSE_PORT=/dev/psaux
            MOUSE_PROTOCOL=PS/2
            ;;
        esac
    else
        MOUSE_PORT=$(echo "$MDETECT_OUTPUT" | head -n 1)
        MOUSE_PROTOCOL=$(echo "$MDETECT_OUTPUT" | tail -n 1)
    fi

    pgilog "Mouse port is: $MOUSE_PORT."
    pgilog "Mouse protocol is: $MOUSE_PROTOCOL."

    if [ "$PROMPTING" = "more" ]; then
        # TODO: modify the following text when we have serial console install support
        # (or perhaps by then we'll have a boot prompt option like "install=text")
        pgilog "Prompting user about monitor autodetection."
        $DIALOG --no-cancel --cr-wrap --backtitle \
            "PGI Debian Installer" \
            --title "Attempt Monitor Autodetection?" --yesno \
            "An attempt can be made to autodetect your monitor characteristics (using the VESA DDC protocol); however, some buggy video cards and monitors behave poorly when probed for this information.  Would you like to attempt monitor autodetection?"  8 70
        case "$?" in
        0)
            # yes
            AUTODETECT_MONITOR=yes
            pgilog "User wants to attempt monitor autodetection."
            ;;
        1)
            # no
            AUTODETECT_MONITOR=
            pgilog "User does not want to attempt monitor autodetection."
            ;;
        *)
            # cancel/error
            AUTODETECT_MONITOR=
            CANCEL=yes
            break
            ;;
        esac
    else
        AUTODETECT_MONITOR=yes
        pgilog "Assuming monitor autodetection desired."
    fi

    if [ -n "$AUTODETECT_MONITOR" ]; then
        if [ -n "$HAVE_EDID" ]; then
            echo -n "Detecting monitor..."
            pgilog "Running $GET_EDID | $PARSE_EDID, stderr follows."
            PARSE_EDID_OUTPUT=$( ($GET_EDID | $PARSE_EDID) 2>> $LOGFILE)
            echo "done."
            pgilog
            pgilog "$GET_EDID | $PARSE_EDID stdout follows."
            pgilog "$PARSE_EDID_OUTPUT"
            HORIZ_SYNC=$(echo "$PARSE_EDID_OUTPUT" | grep HorizSync | $AWK '{print $2}')
            VERT_REFRESH=$(echo "$PARSE_EDID_OUTPUT" | grep VertRefresh | $AWK '{print $2}')
        fi
    fi

    if [ -z "$AUTODETECT_MONITOR" -o -z "$HORIZ_SYNC" -o -z "$VERT_REFRESH" ]; then
        # the user didn't want to autodetect, or autodetection failed
        if [ "$PROMPTING" != "more" ]; then
            pgilog "Assuming that the monitor is cool; setting layout to high."
            LAYOUT=high
        elif [ "$VIDEO_DRIVER" != "vga" ]; then
            # no sense prompting if the vga driver is being used; see below
            pgilog "Prompting user for layout: video capabilities (resolution, depth)."
            $DIALOG --no-cancel --cr-wrap --backtitle \
                "PGI Debian Installer" \
                --title "Select Video Mode" --menu \
                "Please choose a video mode in which to run the graphical installer.  Not all drivers support all modes, so it may be necessary to experiment." 11 70 3 \
                "high"    "800x600 pixels; 32,768 colors" \
                "medium"  "640x480 pixels; 256 colors" \
                "low"     "640x480 pixels; 16 colors" \
                2> /tmp/prompt
            # check for cancellation
            if [ $? -ne 0 ]; then
                CANCEL=yes
                break
            fi
            LAYOUT=$(cat /tmp/prompt)
            pgilog "User said the layout was $LAYOUT."
        else
            # If the vga driver is being used, we *must* use the low-res/depth
            # layout.  Configure the monitor accordingly.
            pgilog "$VIDEO_DRIVER driver is being used; forcing \"low\" layout."
            LAYOUT=low
        fi
        case "$LAYOUT" in
        high)
            HORIZ_SYNC=30-55
            VERT_REFRESH=50-90
            ;;
        medium)
            HORIZ_SYNC=30-38
            VERT_REFRESH=50-72
            ;;
        low)
            HORIZ_SYNC=30-31.5
            VERT_REFRESH=50-60
            ;;
        esac
    else
        # autodetection succeeded; we assume that any monitor that is man
        # enough to report EDID settings can handle the "high" layout...unless
        # we're using the "vga" driver
        pgilog "Monitor autodetection succeeded."
        if [ "$VIDEO_DRIVER" != "vga" ]; then
            pgilog "Setting layout to \"high\"."
            LAYOUT=high
        else
            pgilog "$VIDEO_DRIVER driver is being used; forcing \"low\" layout."
            LAYOUT=low
        fi
    fi

    # Set a default value for the "high" layout's color depth.
    HIGH_DEPTH=15

    # Some XFree86 video drivers support depth 15 but not 16, or vice-versa.
    # *Sigh*.  Revisit this list when PGI is based on XFree86 4.2.  We prefer
    # depth 15 when available, so that the color cube is a color cube, not a
    # color parallelepiped, and so that grays aren't green.
    case "$VIDEO_DRIVER" in
    # XXX: for future development
    # sunbw2 supports only depth 1
    # suncg14 supports only depth 32 (!?)
    # suncg3 supports only depth 8
    # suncg6 supports only depth 8
    # sunffb supports only depth 24
    # sunleo supports only depth 32 (!?)
    # suntcx supports only depths 8 and 32, and depth 32 only sometimes
    ark|ati|chips|cirrus|cyrix|glint|i128|i810|imstt|mga|neomagic|nv|s3virge|savage|sis|trident)
        pgilog "$VIDEO_DRIVER driver is being used; setting \"high\" layout color depth to 15."
        HIGH_DEPTH=15
        ;;
    apm|glide|i740|rendition|siliconmotion|tdfx|tseng)
        pgilog "$VIDEO_DRIVER driver is being used; setting \"high\" layout color depth to 16."
        HIGH_DEPTH=16
        ;;
    newport|tga|vesa)
        pgilog "$VIDEO_DRIVER driver is being used; forcing \"medium\" layout."
        LAYOUT=medium
        ;;
    vga)
        # already handled above
        ;;
    *)
        pgilog "\"$VIDEO_DRIVER\" driver unrecognized for color depth and layout forcing issues."
        ;;
    esac

    pgilog "Horizontal sync is: $HORIZ_SYNC."
    pgilog "Vertical refresh is: $VERT_REFRESH."

    pgilog "Writing XF86Config file."
    sed -e "s@LIVE@$LIVE@" \
        -e "s@VIDEO_DRIVER@$VIDEO_DRIVER@" \
        -e "s@USE_FBDEV@$USE_FBDEV@" \
        -e "s@MOUSE_PORT@$MOUSE_PORT@" \
        -e "s@MOUSE_PROTOCOL@$MOUSE_PROTOCOL@" \
        -e "s@HORIZ_SYNC@$HORIZ_SYNC@" \
        -e "s@VERT_REFRESH@$VERT_REFRESH@" \
        -e "s@HIGH_DEPTH@$HIGH_DEPTH@" \
        < $LIVE/XF86Config.template > /etc/XF86Config

    if [ -n "$PGIDEBUG" ]; then
        cat << EOF
The XFree86 X server configuration file has been written to /etc/XF86Config.
You may edit this file if necessary; when this shell exits, the X server will
start.
EOF
        sh
    fi

    echo "Contents of /etc/XF86Config:" >> $LOGFILE
    cat /etc/XF86Config >> $LOGFILE
    echo "*******************************************************" >> $LOGFILE

    if [ -z "$PGIDEBUG" -a "$PROMPTING" != "more" ]; then
        clear
    fi

    STARTX_TIME=$(date +%s)
    pgilog "Checking version of X with \"X -version\":"
    X -version >> $LOGFILE 2>&1
    echo "*******************************************************" >> $LOGFILE
    pgilog "Starting X at $STARTX_TIME Unix standard time."
    # the installer will trace to standard output, which we catch in $LOGFILE
    run_installer
    STOPX_TIME=$(date +%s)
    DURATION=$(( $STOPX_TIME - $STARTX_TIME ))
    pgilog "X exited at $STOPX_TIME Unix standard time, after running for $DURATION seconds."
    echo "*******************************************************" >> $LOGFILE

    if [ ! -e $STATUSFILE ]; then
        # X server failed to start
        pgilog "$STATUSFILE does not exist."
        pgilog "Prompting user about retry (reconfigure X/textmode instead/cancel)."
        $DIALOG --no-cancel --cr-wrap --backtitle \
            "PGI Debian Installer" \
            --title "Retry Installer?" --menu \
            "The graphical installer process failed because the X server failed to start.\n\n(Information about what caused the failure may be available in $LOGFILE).\n\nPlease select one of the following options to proceed." 16 60 3 \
            "graphical" "Manually configure X server and try again" \
            "text"      "Use text-mode installer instead" \
            "cancel"    "Cancel installation of Debian GNU/Linux" \
            2> /tmp/prompt
        # check for cancellation
        if [ $? -ne 0 ]; then
            CANCEL=yes
            break
        fi
        case "$(cat /tmp/prompt)" in
        graphical)
            pgilog "User wants to run the installer again.  Increasing prompting level."
            PROMPTING=more
            ;;
        text)
            pgilog "User wants to run the installer in text mode."
            TEXTMODE_FALLBACK=yes
            break
            ;;
        cancel)
            # with initrd/linuxrc in its current form, no
            # need to do anything special
            pgilog "User wants to cancel installation."
            CANCEL=yes
            break
            ;;
        esac
    else
        X_WORKED=yes
    fi
done

if [ -z "$CANCEL" ]; then
    while :; do
        if [ -e $STATUSFILE ]; then
            EXITSTATUS=$(cat $STATUSFILE)
            pgilog "$STATUSFILE reports exit status of $EXITSTATUS."
            case "$EXITSTATUS" in
            0)
                pgilog "$STATUSFILE reports successful installation."
                break
                ;;
            90)
                # user cancelled
                pgilog "$STATUSFILE reports that user wants to cancel installation."
                CANCEL=yes
                break
                ;;
            *)
                pgilog "Prompting user about retry (graphical/text/cancel)."
                $DIALOG --no-cancel --cr-wrap --backtitle \
                    "PGI Debian Installer" \
                    --title "Retry Installer?" --menu \
                    "The graphical installer process failed.\n\n(Information about what caused the failure may be available in $LOGFILE).\n\nPlease select one of the following options to proceed." 15 60 3 \
                    "graphical" "Retry graphical installer" \
                    "text"      "Use text-mode installer instead" \
                    "cancel"    "Cancel installation of Debian GNU/Linux" \
                    2> /tmp/prompt
                # check for cancellation
                if [ $? -ne 0 ]; then
                    CANCEL=yes
                    break
                fi
                case "$(cat /tmp/prompt)" in
                graphical)
                    pgilog "User wants to run the installer again."
                    ;;
                text)
                    pgilog "User wants to run the installer in text mode."
                    TEXTMODE_FALLBACK=yes
                    break
                    ;;
                cancel)
                    # with initrd/linuxrc in its current form, no
                    # need to do anything special
                    pgilog "User wants to cancel installation."
                    CANCEL=yes
                    break
                    ;;
                esac
                ;;
            esac
        fi
        run_installer
    done
    if [ -z "$TEXTMODE_FALLBACK" -a -z "$CANCEL" ]; then
        # clear the screen of any retry dialog
        if [ "$PROMPTING" != "more" ]; then
            clear
        fi
        echo -n "Writing X server configuration to installed system..."
        # pre-answer xserver-common debconf questions
        pgilog -n "Loading $LIVE/share/debconf/xserver-common.templates..."
        cp $LIVE/share/debconf/xserver-common.templates $TARGET/tmp/xserver-common.templates
        chroot $TARGET debconf-loadtemplate xserver-common /tmp/xserver-common.templates
        pgilog "done."
        rm -f $TARGET/etc/X11/Xwrapper.config
        pgilog "debconf-communicating for xserver-common..."
        debconf_poke xserver-common "set xserver-common/manage_config_with_debconf true" 2>&1 >> $LOGFILE
        debconf_poke xserver-common "fset xserver-common/manage_config_with_debconf seen true" 2>&1 >> $LOGFILE
        debconf_poke xserver-common "set xserver-common/xwrapper/allowed_users Console Users Only" 2>&1 >> $LOGFILE
        debconf_poke xserver-common "fset xserver-common/xwrapper/allowed_users seen true" 2>&1 >> $LOGFILE
        debconf_poke xserver-common "set xserver-common/xwrapper/actual_allowed_users console" 2>&1 >> $LOGFILE
        debconf_poke xserver-common "fset xserver-common/xwrapper/actual_allowed_users seen true" 2>&1 >> $LOGFILE
        debconf_poke xserver-common "set xserver-common/xwrapper/nice_value -10" 2>&1 >> $LOGFILE
        debconf_poke xserver-common "fset xserver-common/xwrapper/nice_value seen true" 2>&1 >> $LOGFILE
        rm $TARGET/tmp/xserver-common.templates
        pgilog "done."
        # pre-answer xserver-xfree86 debconf questions
        pgilog -n "Loading $LIVE/share/debconf/xserver-xfree86.templates..."
        cp $LIVE/share/debconf/xserver-xfree86.templates $TARGET/tmp/xserver-xfree86.templates
        chroot $TARGET debconf-loadtemplate xserver-xfree86 /tmp/xserver-xfree86.templates
        pgilog "done."
        rm -f $TARGET/etc/X11/X $TARGET/etc/X11/XF86Config-4
        pgilog -n "debconf-communicating for xserver-xfree86..."
        debconf_poke xserver-xfree86 "set shared/default-x-server xserver-xfree86" 2>&1 >> $LOGFILE
        debconf_poke xserver-xfree86 "fset shared/default-x-server seen true" 2>&1 >> $LOGFILE
        debconf_poke xserver-xfree86 "set xserver-xfree86/manage_config_with_debconf true" 2>&1 >> $LOGFILE
        debconf_poke xserver-xfree86 "fset xserver-xfree86/manage_config_with_debconf seen true" 2>&1 >> $LOGFILE
        debconf_poke xserver-xfree86 "set xserver-xfree86/config/device/driver $VIDEO_DRIVER" 2>&1 >> $LOGFILE
        debconf_poke xserver-xfree86 "fset xserver-xfree86/config/device/driver seen true" 2>&1 >> $LOGFILE
        debconf_poke xserver-xfree86 "set xserver-xfree86/config/device/use_fbdev $USE_FBDEV" 2>&1 >> $LOGFILE
        debconf_poke xserver-xfree86 "fset xserver-xfree86/config/device/use_fbdev seen true" 2>&1 >> $LOGFILE
        debconf_poke xserver-xfree86 "set xserver-xfree86/config/inputdevice/mouse/port $MOUSE_PORT" 2>&1 >> $LOGFILE
        debconf_poke xserver-xfree86 "fset xserver-xfree86/config/inputdevice/mouse/port seen true" 2>&1 >> $LOGFILE
        debconf_poke xserver-xfree86 "set xserver-xfree86/config/inputdevice/mouse/protocol $MOUSE_PROTOCOL" 2>&1 >> $LOGFILE
        debconf_poke xserver-xfree86 "fset xserver-xfree86/config/inputdevice/mouse/protocol seen true" 2>&1 >> $LOGFILE
        debconf_poke xserver-xfree86 "set xserver-xfree86/config/monitor/horiz-sync $HORIZ_SYNC" 2>&1 >> $LOGFILE
        debconf_poke xserver-xfree86 "fset xserver-xfree86/config/monitor/horiz-sync seen true" 2>&1 >> $LOGFILE
        debconf_poke xserver-xfree86 "set xserver-xfree86/config/monitor/vert-refresh $VERT_REFRESH" 2>&1 >> $LOGFILE
        debconf_poke xserver-xfree86 "fset xserver-xfree86/config/monitor/vert-refresh seen true" 2>&1 >> $LOGFILE
        debconf_poke xserver-xfree86 "set xserver-xfree86/config/display/modes 800x600, 640x480" 2>&1 >> $LOGFILE
        debconf_poke xserver-xfree86 "fset xserver-xfree86/config/display/modes seen true" 2>&1 >> $LOGFILE
        pgilog "done."
        echo "done."
        rm $TARGET/tmp/xserver-xfree86.templates
    fi
fi

# vim:ai:et:sts=4:sw=4:tw=0:
