#ifdef PETSC_RCS_HEADER
static char vcid[] = "$Id: meshregall.c,v 1.3 1999/09/18 16:36:44 knepley Exp $";
#endif

#include "src/mesh/meshimpl.h"     /*I  "mesh.h"  I*/
EXTERN_C_BEGIN
extern int MeshCreate_Triangular_1D(Mesh);
extern int MeshCreate_Triangular_2D(Mesh);

extern int MeshSerialize_Triangular_2D(MPI_Comm, Mesh *, PetscViewer, PetscTruth);

extern int MeshOrdering_Triangular_2D_RCM(Mesh, MeshOrderingType, AO *);
extern int MeshOrdering_Triangular_2D_Test(Mesh, MeshOrderingType, AO *);
EXTERN_C_END

#undef __FUNCT__  
#define __FUNCT__ "MeshRegisterAll"
/*@C
  MeshRegisterAll - Registers all of the generation routines in the Mesh package. 

  Not Collective

  Input parameter:
. path - The dynamic library path

  Level: advanced

.keywords: Mesh, register, all
.seealso: MeshRegister(), MeshRegisterDestroy()
@*/
int MeshRegisterAll(const char path[])
{
  int ierr;

  PetscFunctionBegin;
  MeshRegisterAllCalled = PETSC_TRUE;

  ierr = MeshRegisterDynamic(MESH_TRIANGULAR_1D, path, "MeshCreate_Triangular_1D", MeshCreate_Triangular_1D);CHKERRQ(ierr);
  ierr = MeshRegisterDynamic(MESH_TRIANGULAR_2D, path, "MeshCreate_Triangular_2D", MeshCreate_Triangular_2D);CHKERRQ(ierr);
  PetscFunctionReturn(0);
}

#undef __FUNCT__  
#define __FUNCT__ "MeshSerializeRegisterAll"
/*@C
  MeshSerializeRegisterAll - Registers all of the serialization routines in the Mesh package. 

  Not Collective

  Input parameter:
. path - The dynamic library path

  Level: advanced

.keywords: mesh, register, all, serialize
.seealso: MeshSerializeRegister(), MeshSerializeRegisterDestroy()
@*/
int MeshSerializeRegisterAll(const char path[])
{
  int ierr;

  PetscFunctionBegin;
  MeshSerializeRegisterAllCalled = PETSC_TRUE;

  ierr = MeshSerializeRegisterDynamic(MESH_SER_TRIANGULAR_2D_BINARY, path, "MeshSerialize_Triangular_2D",MeshSerialize_Triangular_2D);CHKERRQ(ierr);
  PetscFunctionReturn(0);
}

#undef __FUNCT__  
#define __FUNCT__ "MeshOrderingRegisterAll"
/*@C
  MeshOrderingRegisterAll - Registers all of the ordering routines in the Mesh package. 

  Not Collective

  Input parameter:
. path - The dynamic library path

  Level: advanced

.keywords: mesh, register, all, serialization
.seealso: MeshOrderingRegister(), MeshOrderingRegisterDestroy()
@*/
int MeshOrderingRegisterAll(const char path[])
{
  int ierr;

  PetscFunctionBegin;
  MeshOrderingRegisterAllCalled = PETSC_TRUE;

  ierr = MeshOrderingRegisterDynamic(MESH_ORDER_TRIANGULAR_2D_RCM,  path, "MeshOrdering_Triangular_2D_RCM",MeshOrdering_Triangular_2D_RCM);CHKERRQ(ierr);
  ierr = MeshOrderingRegisterDynamic(MESH_ORDER_TRIANGULAR_2D_Test, path, "MeshOrdering_Triangular_2D_Test",MeshOrdering_Triangular_2D_Test);CHKERRQ(ierr);
  PetscFunctionReturn(0);
}
