/* $Id: triimpl.h,v 1.2 1999/07/23 06:35:47 knepley Exp $ */
/* 
   This private file should not be included in users' code.
*/

#ifndef __TRIIMPL_H
#define __TRIIMPL_H
#include "src/mesh/meshimpl.h"

/* This avoids allocation of coordinate arrays passed to operator functions */
#define MAX_CORNERS 6

typedef struct  {
  /* Necessary data
     -- d is the space dimension
     -- Each node is given a class (integer) which indicates a set of fields
        which are defined on that node
     -- A field is said to contain a class if that field is defined on any
        node of that class
  */
  double *nodes;               /* [dN]:  List of node coordinates stored x_1, y_1, (z_1), x_2, y_2, (z_2), ... */
  double *nodesOld;            /* [dN]:  List of previous node coordinates stored x_1, y_1, (z_1), x_2, y_2, (z_2), ... */
  int    *markers;             /* [N]:   List of node markers 0 Interior, >0 Bd Number, <0 -Bd Number (usually for moving boundaries) */
  int    *degrees;             /* [N]:   List of the degree of each node */
  int    *edges;               /* [2E]:  List of edge endpoints */
  int    *edgemarkers;         /* [E]:   List of edge markers 0 Interior, >0 Bd Number, <0 -Bd Number (usually for moving boundaries) */
  int    *faces;               /* [C'F]: List of triangle corners */
  int    *facemarkers;         /* [F]:   List of face markers 0 Interior, >0 Bd Number, <0 -Bd Number (usually for moving boundaries) */
  int    *neighbors;           /* [3F]:  List of triangle    neighbors, neighbor i is opposite vertex i
                                  [4C]:  List of tetrahedron neighbors, neighbor i is opposite vertex i */
  int    *cells;               /* [C*C]: List of tetrahedron corners */
  int    *bdNodes;             /* [NB]:  List of boundary nodes, ordered by markers, topologically ordered per marker in 2D */
  int    *bdEdges;             /* [EB]:  List of boundary edges, ordered by markers, topologically ordered per marker in 2D */
  int    *bdFaces;             /* [FB]:  List of boundary edges, ordered by markers */
  int    *bdMarkers;           /* [B]:   List of markers in the order they appear in bdBegin[], bdNodes[], etc. */
  int    *bdBegin;             /* [B+1]: List of indices for boundary beginnings in bdNodes[] */
  int    *bdEdgeBegin;         /* [B+1]: List of indices for boundary beginnings in bdEdges[] */
  int    *bdFaceBegin;         /* [B+1]: List of indices for boundary beginnings in bdFaces[] */

  /* Derived data that is nice to have around */
  double *areas;               /* [F]:   List of face areas */
  double *aspectRatios;        /* [F]:   List of face aspect ratios */
  double *volumes;             /* [C]:   List of cell areas */
} Mesh_Triangular;

#endif /* __TRIIMPL_H */
