
/* $Id: 2dimpl.h,v 1.3 1999/11/17 16:23:07 knepley Exp $ */
/* 
   This private file should not be included in users' code.
*/

#ifndef __2DIMPL_H
#define __2DIMPL_H
#include "src/mesh/impls/triangular/triimpl.h"

typedef struct  {
  /* Partitioning order */
  PetscTruth isNodePartitioned;    /*      The flag indicating that the nodes have been partitioned */
  PetscTruth isEdgePartitioned;    /*      The flag indicating that the nodes have been partitioned */
  /* Node partition structures */
  AO         nodeOrdering;         /*      The renumbering of the nodes */
  int        numLocNodes;          /*  N:  The number of local nodes */
  int        numNodes;             /*      The global number of nodes */
  int        numOverlapNodes;      /* N+G: The number of local nodes + ghost nodes */
  int       *firstNode;            /* [P]: The first node in each domain */
  int       *ghostNodes;           /* [G]: The global node number of each ghost node */
  int       *ghostNodeProcs;       /* [G]: The domain of each ghost node */
  /* Edge partition structures */
  AO         edgeOrdering;         /*      The renumbering of the edges */
  int        numLocEdges;          /*      The number of local edges */
  int        numEdges;             /*      The global number of edges */
  int       *firstEdge;            /* [P]: The first edge in each domain */
  /* Boundary node partition structures */
  int        numLocBdNodes;        /*      The number of local boundary nodes */
  int        numBdNodes;           /*      The global number of boundary nodes */
  int        numOverlapBdNodes;    /*      The number of local + ghost boundary nodes */
  int       *firstBdNode;          /*      The first boundary node in each domain */
  int       *ghostBdNodes;         /*      The index into ghostNodes of each ghost boundary node */
} Partition_Triangular_2D;

#endif /* __2DIMPL_H */
