#ifdef PETSC_RCS_HEADER
static char vcid[] = "$Id: dlregis.c,v 1.1 2000/01/10 03:54:20 knepley Exp $";
#endif

#include "petscts.h"
#include "gsolver.h"

EXTERN_C_BEGIN
extern int GTSCreate_BEuler(TS);
extern int PCCreate_Jacobi_Constrained(PC);
extern int PCCreate_Schur(PC);
extern int GTSSerialize_BEuler(MPI_Comm, TS *, PetscViewer, PetscTruth);
extern int GVecKSPOptionsChecker_Private(KSP);
extern int GSNESOptionsChecker_Private(GSNES);
extern int GTSOptionsChecker_Private(GTS);

#if !defined (PETSC_USE_COMPLEX)
extern int PCCreate_Multilevel(PC);
#endif

EXTERN_C_END

#undef __FUNCT__  
#define __FUNCT__ "GSolverInitializePackage"
/*@C
  GSolverInitializePackage - This function initializes everything in the GSolver package. It is called
  from PetscDLLibraryRegister() when using dynamic libraries, and on the first call to GSNESCreate()
  or GTSCreate() when using static libraries.

  Input Parameter:
  path - The dynamic library path, or PETSC_NULL

  Level: developer

.keywords: Mesh, initialize, package
.seealso: PetscInitialize()
@*/
int GSolverInitializePackage(char *path) {
  static PetscTruth initialized = PETSC_FALSE;
  int               ierr;

  PetscFunctionBegin;
  if (initialized == PETSC_TRUE) PetscFunctionReturn(0);
  initialized = PETSC_TRUE;
  /* Register Classes */
  /* Register Constructors and Serializers */
  ierr = TSRegisterDynamic("gbeuler", path, "GTSCreate_BEuler", GTSCreate_BEuler);                        CHKERRQ(ierr);
  ierr = TSSerializeRegisterDynamic(GTS_SER_BEULER_BINARY, path, "GTSSerialize_BEuler", GTSSerialize_BEuler);CHKERRQ(ierr);
  ierr = PCRegisterDynamic("jacobic",    path, "PCCreate_Jacobi_Constrained", PCCreate_Jacobi_Constrained);CHKERRQ(ierr);
#if !defined (PETSC_USE_COMPLEX)
  ierr = PCRegisterDynamic(PCMULTILEVEL, path, "PCCreate_Multilevel", PCCreate_Multilevel);               CHKERRQ(ierr);
#endif
  ierr = PCRegisterDynamic(PCSCHUR     , path, "PCCreate_Schur",      PCCreate_Schur);                    CHKERRQ(ierr); 
  /* Register Events */
  ierr = PetscLogEventRegister(&GTS_Reform,     "GTSReform",     TS_COOKIE);                              CHKERRQ(ierr);
  ierr = PetscLogEventRegister(&GTS_Reallocate, "GTSReallocate", TS_COOKIE);                              CHKERRQ(ierr);
  /* Process info exclusions */
  /* Process summary exclusions */
  /* Add options checkers */
  ierr = KSPAddOptionsChecker(GVecKSPOptionsChecker_Private);                                             CHKERRQ(ierr);
  ierr = SNESAddOptionsChecker(GSNESOptionsChecker_Private);                                              CHKERRQ(ierr);
  /*ierr = TSAddOptionsChecker(GTSOptionsChecker_Private);                                                  CHKERRQ(ierr);*/
  PetscFunctionReturn(0);
}

#ifdef PETSC_USE_DYNAMIC_LIBRARIES
EXTERN_C_BEGIN
#undef __FUNCT__  
#define __FUNCT__ "PetscDLLibraryRegister"
/*
  PetscDLLibraryRegister - This function is called when the dynamic library it is in is opened.

  This one registers all the solvers in the GSolver library.

  Input Parameter:
  path - library path
*/
int PetscDLLibraryRegister(char *path) {
  int ierr;

  ierr = PetscInitializeNoArguments();
  if (ierr) return(1);
  /*
      If we got here then PETSc was properly loaded
  */
  ierr = GSolverInitializePackage(path);                                                                  CHKERRQ(ierr);
  PetscFunctionReturn(0);
}
EXTERN_C_END

/* --------------------------------------------------------------------------*/
static char *contents = "PETSc Finite Element Solver library";

static char *authors = "Matt Knepley    knepley@cs.purdue.edu\n\
  http://www.cs.purdue.edu/homes/knepley/comp_fluid\n";

#include "src/sys/src/utils/dlregis.h"

/* --------------------------------------------------------------------------*/

#endif /* PETSC_USE_DYNAMIC_LIBRARIES */
