#ifdef PETSC_RCS_HEADER
static char vcid[] = "$Id: fieldClassMapRegAll.c,v 1.1 1999/10/04 10:56:23 knepley Exp $";
#endif

#include "src/grid/gridimpl.h"    /*I "grid.h" I*/

EXTERN_C_BEGIN
extern int FieldClassMapCreate_Triangular_2D(FieldClassMap);

extern int FieldClassMapSerialize_Triangular_2D(MPI_Comm, FieldClassMap *, PetscViewer, PetscTruth);
EXTERN_C_END

#undef __FUNCT__  
#define __FUNCT__ "FieldClassMapRegisterAll"
/*@C
  FieldClassMapRegisterAll - Registers all of the serialization routines in the FieldClassMap package. 

  Not Collective

  Input parameters:
. path - Dynamic library path

  Level: advanced

.keywords: class, field class, class map, register, all, serialization
.seealso: FieldClassMapRegister(), FieldClassMapRegisterDestroy()
@*/
int FieldClassMapRegisterAll(const char path[])
{
  int ierr;

  PetscFunctionBegin;
  FieldClassMapRegisterAllCalled = 1;

  ierr = FieldClassMapRegister(CLASS_MAP_TRIANGULAR_2D, path, "FieldClassMapCreate_Triangular_2D",
                               FieldClassMapCreate_Triangular_2D);
  CHKERRQ(ierr);
  PetscFunctionReturn(0);
}

#undef __FUNCT__  
#define __FUNCT__ "FieldClassMapSerializeRegisterAll"
/*@C
  FieldClassMapSerializeRegisterAll - Registers all of the serialization routines in the FieldClassMap package. 

  Not Collective

  Input parameters:
. path - Dynamic library path

  Level: advanced

.keywords: class, field class, class map, register, all, serialization
.seealso: FieldClassMapSerializeRegister(), FieldClassMapSerializeRegisterDestroy()
@*/
int FieldClassMapSerializeRegisterAll(const char path[])
{
  int ierr;

  PetscFunctionBegin;
  FieldClassMapSerializeRegisterAllCalled = 1;

  ierr = FieldClassMapSerializeRegister(CLASS_MAP_SER_TRIANGULAR_2D_BINARY, path, "FieldClassMapSerialize_Triangular_2D",
                                        FieldClassMapSerialize_Triangular_2D);
  CHKERRQ(ierr);
  PetscFunctionReturn(0);
}
