/* meshMovement.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void *);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void *);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "petscfix.h"
#include "meshMovement.h"
#include "petscfix.h"
#include "grid.h"
#include "petscfix.h"
#include "gvec.h"
#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshsetmover_ PMESHSETMOVER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshsetmover_ pmeshsetmover
#else
#define meshsetmover_ pmeshsetmover_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshsetmover_ MESHSETMOVER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshsetmover_ meshsetmover
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetmover_ PMESHGETMOVER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetmover_ pmeshgetmover
#else
#define meshgetmover_ pmeshgetmover_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetmover_ MESHGETMOVER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetmover_ meshgetmover
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmovemesh_ PMESHMOVEMESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmovemesh_ pmeshmovemesh
#else
#define meshmovemesh_ pmeshmovemesh_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmovemesh_ MESHMOVEMESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmovemesh_ meshmovemesh
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshupdatenodevalues_ PMESHUPDATENODEVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshupdatenodevalues_ pmeshupdatenodevalues
#else
#define meshupdatenodevalues_ pmeshupdatenodevalues_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshupdatenodevalues_ MESHUPDATENODEVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshupdatenodevalues_ meshupdatenodevalues
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshreform_ PMESHREFORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshreform_ pmeshreform
#else
#define meshreform_ pmeshreform_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshreform_ MESHREFORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshreform_ meshreform
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmovercreate_ PMESHMOVERCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmovercreate_ pmeshmovercreate
#else
#define meshmovercreate_ pmeshmovercreate_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmovercreate_ MESHMOVERCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmovercreate_ meshmovercreate
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmoversetup_ PMESHMOVERSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmoversetup_ pmeshmoversetup
#else
#define meshmoversetup_ pmeshmoversetup_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmoversetup_ MESHMOVERSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmoversetup_ meshmoversetup
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmoversetfromoptions_ PMESHMOVERSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmoversetfromoptions_ pmeshmoversetfromoptions
#else
#define meshmoversetfromoptions_ pmeshmoversetfromoptions_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmoversetfromoptions_ MESHMOVERSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmoversetfromoptions_ meshmoversetfromoptions
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmoverprinthelp_ PMESHMOVERPRINTHELP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmoverprinthelp_ pmeshmoverprinthelp
#else
#define meshmoverprinthelp_ pmeshmoverprinthelp_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmoverprinthelp_ MESHMOVERPRINTHELP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmoverprinthelp_ meshmoverprinthelp
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmoverduplicate_ PMESHMOVERDUPLICATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmoverduplicate_ pmeshmoverduplicate
#else
#define meshmoverduplicate_ pmeshmoverduplicate_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmoverduplicate_ MESHMOVERDUPLICATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmoverduplicate_ meshmoverduplicate
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmoverconvert_ PMESHMOVERCONVERT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmoverconvert_ pmeshmoverconvert
#else
#define meshmoverconvert_ pmeshmoverconvert_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmoverconvert_ MESHMOVERCONVERT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmoverconvert_ meshmoverconvert
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmoverview_ PMESHMOVERVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmoverview_ pmeshmoverview
#else
#define meshmoverview_ pmeshmoverview_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmoverview_ MESHMOVERVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmoverview_ meshmoverview
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmoverdestroy_ PMESHMOVERDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmoverdestroy_ pmeshmoverdestroy
#else
#define meshmoverdestroy_ pmeshmoverdestroy_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmoverdestroy_ MESHMOVERDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmoverdestroy_ meshmoverdestroy
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmoversetmesh_ PMESHMOVERSETMESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmoversetmesh_ pmeshmoversetmesh
#else
#define meshmoversetmesh_ pmeshmoversetmesh_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmoversetmesh_ MESHMOVERSETMESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmoversetmesh_ meshmoversetmesh
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmovergetmesh_ PMESHMOVERGETMESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmovergetmesh_ pmeshmovergetmesh
#else
#define meshmovergetmesh_ pmeshmovergetmesh_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmovergetmesh_ MESHMOVERGETMESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmovergetmesh_ meshmovergetmesh
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmovergetmovement_ PMESHMOVERGETMOVEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmovergetmovement_ pmeshmovergetmovement
#else
#define meshmovergetmovement_ pmeshmovergetmovement_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmovergetmovement_ MESHMOVERGETMOVEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmovergetmovement_ meshmovergetmovement
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmoversetmovement_ PMESHMOVERSETMOVEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmoversetmovement_ pmeshmoversetmovement
#else
#define meshmoversetmovement_ pmeshmoversetmovement_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmoversetmovement_ MESHMOVERSETMOVEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmoversetmovement_ meshmoversetmovement
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmovergetvelocitygrid_ PMESHMOVERGETVELOCITYGRID
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmovergetvelocitygrid_ pmeshmovergetvelocitygrid
#else
#define meshmovergetvelocitygrid_ pmeshmovergetvelocitygrid_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmovergetvelocitygrid_ MESHMOVERGETVELOCITYGRID
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmovergetvelocitygrid_ meshmovergetvelocitygrid
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmovergetaccelerationgrid_ PMESHMOVERGETACCELERATIONGRID
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmovergetaccelerationgrid_ pmeshmovergetaccelerationgrid
#else
#define meshmovergetaccelerationgrid_ pmeshmovergetaccelerationgrid_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmovergetaccelerationgrid_ MESHMOVERGETACCELERATIONGRID
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmovergetaccelerationgrid_ meshmovergetaccelerationgrid
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmovercalcvelocitybcvalues_ PMESHMOVERCALCVELOCITYBCVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmovercalcvelocitybcvalues_ pmeshmovercalcvelocitybcvalues
#else
#define meshmovercalcvelocitybcvalues_ pmeshmovercalcvelocitybcvalues_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmovercalcvelocitybcvalues_ MESHMOVERCALCVELOCITYBCVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmovercalcvelocitybcvalues_ meshmovercalcvelocitybcvalues
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmovercalcaccelerationbcvalues_ PMESHMOVERCALCACCELERATIONBCVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmovercalcaccelerationbcvalues_ pmeshmovercalcaccelerationbcvalues
#else
#define meshmovercalcaccelerationbcvalues_ pmeshmovercalcaccelerationbcvalues_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmovercalcaccelerationbcvalues_ MESHMOVERCALCACCELERATIONBCVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmovercalcaccelerationbcvalues_ meshmovercalcaccelerationbcvalues
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmovercalcnodevelocities_ PMESHMOVERCALCNODEVELOCITIES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmovercalcnodevelocities_ pmeshmovercalcnodevelocities
#else
#define meshmovercalcnodevelocities_ pmeshmovercalcnodevelocities_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmovercalcnodevelocities_ MESHMOVERCALCNODEVELOCITIES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmovercalcnodevelocities_ meshmovercalcnodevelocities
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmovercalcnodeaccelerations_ PMESHMOVERCALCNODEACCELERATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmovercalcnodeaccelerations_ pmeshmovercalcnodeaccelerations
#else
#define meshmovercalcnodeaccelerations_ pmeshmovercalcnodeaccelerations_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmovercalcnodeaccelerations_ MESHMOVERCALCNODEACCELERATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmovercalcnodeaccelerations_ meshmovercalcnodeaccelerations
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmoversetnodevelocities_ PMESHMOVERSETNODEVELOCITIES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmoversetnodevelocities_ pmeshmoversetnodevelocities
#else
#define meshmoversetnodevelocities_ pmeshmoversetnodevelocities_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmoversetnodevelocities_ MESHMOVERSETNODEVELOCITIES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmoversetnodevelocities_ meshmoversetnodevelocities
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmoversetnodeaccelerations_ PMESHMOVERSETNODEACCELERATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmoversetnodeaccelerations_ pmeshmoversetnodeaccelerations
#else
#define meshmoversetnodeaccelerations_ pmeshmoversetnodeaccelerations_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmoversetnodeaccelerations_ MESHMOVERSETNODEACCELERATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmoversetnodeaccelerations_ meshmoversetnodeaccelerations
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmoversetmovementcaption_ PMESHMOVERSETMOVEMENTCAPTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmoversetmovementcaption_ pmeshmoversetmovementcaption
#else
#define meshmoversetmovementcaption_ pmeshmoversetmovementcaption_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshmoversetmovementcaption_ MESHMOVERSETMOVEMENTCAPTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshmoversetmovementcaption_ meshmoversetmovementcaption
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridreformmesh_ PGRIDREFORMMESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridreformmesh_ pgridreformmesh
#else
#define gridreformmesh_ pgridreformmesh_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridreformmesh_ GRIDREFORMMESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridreformmesh_ gridreformmesh
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridreform_ PGRIDREFORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridreform_ pgridreform
#else
#define gridreform_ pgridreform_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gridreform_ GRIDREFORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gridreform_ gridreform
#endif
#endif



/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL meshsetmover_(Mesh mesh,MeshMover *mover, int *ierr ){
*ierr = MeshSetMover(
	(Mesh)PetscToPointer( (mesh) ),*mover);
}
void PETSC_STDCALL meshgetmover_(Mesh mesh,MeshMover *mover, int *ierr ){
*ierr = MeshGetMover(
	(Mesh)PetscToPointer( (mesh) ),
	(MeshMover* )PetscToPointer( (mover) ));
}
void PETSC_STDCALL meshmovemesh_(Mesh mesh,double *dt, int *ierr ){
*ierr = MeshMoveMesh(
	(Mesh)PetscToPointer( (mesh) ),*dt);
}
void PETSC_STDCALL meshupdatenodevalues_(Mesh mesh,GVec sol,Vec vec,Vec ghostVec, int *ierr ){
*ierr = MeshUpdateNodeValues(
	(Mesh)PetscToPointer( (mesh) ),
	(GVec)PetscToPointer( (sol) ),
	(Vec)PetscToPointer( (vec) ),
	(Vec)PetscToPointer( (ghostVec) ));
}
void PETSC_STDCALL meshreform_(Mesh mesh,PetscTruth *refine,PointFunction *area,PetscTruth *newBd,Mesh *newMesh, int *ierr ){
*ierr = MeshReform(
	(Mesh)PetscToPointer( (mesh) ),*refine,*area,*newBd,newMesh);
}
void PETSC_STDCALL meshmovercreate_(Mesh mesh,MeshMover *mover, int *ierr ){
*ierr = MeshMoverCreate(
	(Mesh)PetscToPointer( (mesh) ),
	(MeshMover* )PetscToPointer( (mover) ));
}
void PETSC_STDCALL meshmoversetup_(MeshMover *mover, int *ierr ){
*ierr = MeshMoverSetup(*mover);
}
void PETSC_STDCALL meshmoversetfromoptions_(MeshMover *mover, int *ierr ){
*ierr = MeshMoverSetFromOptions(*mover);
}
void PETSC_STDCALL meshmoverprinthelp_(MeshMover *mover, int *ierr ){
*ierr = MeshMoverPrintHelp(*mover);
}
void PETSC_STDCALL meshmoverduplicate_(MeshMover *mover,MeshMover *newMover, int *ierr ){
*ierr = MeshMoverDuplicate(*mover,
	(MeshMover* )PetscToPointer( (newMover) ));
}
void PETSC_STDCALL meshmoverconvert_(MeshMover *mover,Mesh newMesh,MeshMover *newMover, int *ierr ){
*ierr = MeshMoverConvert(*mover,
	(Mesh)PetscToPointer( (newMesh) ),
	(MeshMover* )PetscToPointer( (newMover) ));
}
void PETSC_STDCALL meshmoverview_(MeshMover *mover,PetscViewer *viewer, int *ierr ){
*ierr = MeshMoverView(*mover,*viewer);
}
void PETSC_STDCALL meshmoverdestroy_(MeshMover *mover, int *ierr ){
*ierr = MeshMoverDestroy(*mover);
}
void PETSC_STDCALL meshmoversetmesh_(MeshMover *mover,Mesh mesh, int *ierr ){
*ierr = MeshMoverSetMesh(*mover,
	(Mesh)PetscToPointer( (mesh) ));
}
void PETSC_STDCALL meshmovergetmesh_(MeshMover *mover,Mesh *mesh, int *ierr ){
*ierr = MeshMoverGetMesh(*mover,mesh);
}
void PETSC_STDCALL meshmovergetmovement_(MeshMover *mover,MeshSolveMethod *vtype,MeshSolveMethod *atype,PetscObject *ctx, int *ierr ){
*ierr = MeshMoverGetMovement(*mover,
	(MeshSolveMethod* )PetscToPointer( (vtype) ),
	(MeshSolveMethod* )PetscToPointer( (atype) ),ctx);
}
void PETSC_STDCALL meshmoversetmovement_(MeshMover *mover,MeshSolveMethod *vtype,MeshSolveMethod *atype,PetscObject ctx, int *ierr ){
*ierr = MeshMoverSetMovement(*mover,*vtype,*atype,
	(PetscObject)PetscToPointer( (ctx) ));
}
void PETSC_STDCALL meshmovergetvelocitygrid_(MeshMover *mover,Grid *velGrid, int *ierr ){
*ierr = MeshMoverGetVelocityGrid(*mover,velGrid);
}
void PETSC_STDCALL meshmovergetaccelerationgrid_(MeshMover *mover,Grid *accGrid, int *ierr ){
*ierr = MeshMoverGetAccelerationGrid(*mover,accGrid);
}
void PETSC_STDCALL meshmovercalcvelocitybcvalues_(MeshMover *mover, int *ierr ){
*ierr = MeshMoverCalcVelocityBCValues(*mover);
}
void PETSC_STDCALL meshmovercalcaccelerationbcvalues_(MeshMover *mover, int *ierr ){
*ierr = MeshMoverCalcAccelerationBCValues(*mover);
}
void PETSC_STDCALL meshmovercalcnodevelocities_(MeshMover *mover,PetscTruth *flag, int *ierr ){
*ierr = MeshMoverCalcNodeVelocities(*mover,*flag);
}
void PETSC_STDCALL meshmovercalcnodeaccelerations_(MeshMover *mover,PetscTruth *flag, int *ierr ){
*ierr = MeshMoverCalcNodeAccelerations(*mover,*flag);
}
void PETSC_STDCALL meshmoversetnodevelocities_(MeshMover *mover,PointFunction *func,PetscScalar *alpha,void*ctx, int *ierr ){
*ierr = MeshMoverSetNodeVelocities(*mover,*func,*alpha,ctx);
}
void PETSC_STDCALL meshmoversetnodeaccelerations_(MeshMover *mover,PointFunction *func,PetscScalar *alpha,void*ctx, int *ierr ){
*ierr = MeshMoverSetNodeAccelerations(*mover,*func,*alpha,ctx);
}
void PETSC_STDCALL meshmoversetmovementcaption_(MeshMover *mover,char *caption, int *ierr ){
*ierr = MeshMoverSetMovementCaption(*mover,caption);
}
void PETSC_STDCALL gridreformmesh_(Grid grid,PetscTruth *refine,PointFunction *area,PetscTruth *newBd,Mesh *oldMesh, int *ierr ){
*ierr = GridReformMesh(
	(Grid)PetscToPointer( (grid) ),*refine,*area,*newBd,oldMesh);
}
void PETSC_STDCALL gridreform_(Grid grid,Mesh oldMesh,GVec x,GVec *y, int *ierr ){
*ierr = GridReform(
	(Grid)PetscToPointer( (grid) ),
	(Mesh)PetscToPointer( (oldMesh) ),
	(GVec)PetscToPointer( (x) ),y);
}
#if defined(__cplusplus)
}
#endif
