/* $Id: pointFunction.h,v 1.16 2000/10/17 13:49:33 knepley Exp $ */

/*
    Routines for working with point functions
*/

#ifndef __POINT_FUNCTION_H
#define __POINT_FUNCTION_H

#include "petsc.h"

/* Point Functions encapsulate functions defined over a mesh */
typedef int (*PointFunction)(int, int, double *, double *, double *, PetscScalar *, void *);
extern int PointFunctionOne(int, int, double *, double *, double *, PetscScalar *, void *);
extern int PointFunctionZero(int, int, double *, double *, double *, PetscScalar *, void *);
extern int PointFunctionConstant(int, int, double *, double *, double *, PetscScalar *, void *);
extern int PointFunctionInterpolateField(int, int, double *, double *, double *, PetscScalar *, void *);
extern int PointFunctionInterpolateFieldBatch(int, int, double *, double *, double *, PetscScalar *, void *);

#endif /* __POINT_FUNCTION_H */
