#include "npsummary.h"

void NP_Summary::write_requests_file()
{
   if ( tree == NULL ||
        !strcmp( group, "OUTBOX" ) ||
        !strcmp( group, "SENT-MAIL" ) ||
        !strcmp( group, "FOLLOW-UPS" ) ||
        !strcmp( group, "POSTED" ))
      return;

   NP_File requests;
   char *home, buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.peruser_spool/%s-%s:requests",
             home = getenv( "HOME" ), server, group );
   if ( requests.openw( buffer ))
   {
      requests.print_error();
      return;
   }

   for( np_thread_node_t *pointer = spool_beginning;
        pointer != NULL;
        pointer = pointer->spool_next )
   {
      if ( pointer->is_requested != 1 )
         continue;

      if ( pointer->server != NULL && pointer->group != NULL )
         snprintf( buffer, sizeof buffer, "%s:%s:%s\n", 
               pointer->message_id, pointer->server, pointer->group );
      else
         snprintf( buffer, sizeof buffer, "%s\n", pointer->message_id );

      if ( requests.put_string( buffer ))
      {
         requests.print_error();
         return;
      }
   }

   requests.close();
   
   return;
}
