#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>

#include "npfile.h"
#include "npstringarray.h"
#include "nppex.h"

int NP_Pex::pack_group( char *server, char *group )
{
   if ( server == NULL )
   {
      strcpy( error_message, "NP_Pex: pack_group(): NULL server passed as "
              "argument." );
      return 1;
   }

   if ( group == NULL )
   {
      strcpy( error_message, "NP_Pex: pack_group(): NULL group passed as "
              "argument." );
      return 1;
   }

   char path[ 1024 ];
   snprintf( path, sizeof path, "%s/.peruser_spool/%s-%s",
             home, server, group );

   if ( spool.openr( path ))
   {
      if ( errno == ENOENT )
         return 0;

      snprintf( error_message, sizeof error_message, "NP_Pex: pack_group(): "
                "%s", spool.get_error());
      return 1;
   }

   char temp_path[ 1024 ];
   snprintf( temp_path, sizeof temp_path, "%s:tmp", path );
   if ( temp.openw( temp_path ))
   {
      spool.close();
      snprintf( error_message, sizeof error_message, "NP_Pex: pack_group(): "
                "%s", temp.get_error());
      return 1;
   }

   char read_path[ 1024 ];
   snprintf( read_path, sizeof read_path, "%s:read", path );
   if ( read.openr( read_path ))
   {
      if ( errno == ENOENT )
      {
         spool.close();
         temp.close();
         truncate( path, 0 );
         remove( temp_path );
         return 0;
      }

      snprintf( error_message, sizeof error_message, "NP_Pex: pack_group(): "
                "%s", read.get_error());
      return 1;
   }

   char temp_read_path[ 1024 ];
   snprintf( temp_read_path, sizeof temp_read_path, "%s:temp", read_path );
   if ( temp_read.openw( temp_read_path ))
   {
      spool.close();
      temp.close();
      read.close();
      remove( temp_path );
      snprintf( error_message, sizeof error_message, "NP_Pex: pack_group(): "
                "%s", temp_read.get_error());
      return 1;
   }
   
   char *status;
   while(( status = read.get_string()) != NULL )
   {
      char *line ="";

      if ( status[ 0 ] == 'u' )
      {
         while( strncmp( line, ".\r\n", 3 ))
         {
            if (( line = spool.get_string()) == NULL )
            {
               spool.close();
               read.close();
               temp.close();
               temp_read.close();
               remove( temp_path );
               remove( temp_read_path );
               return 0;
            }

            if ( temp.put_string( line ))
            {
               spool.close();
               read.close();
               temp.close();
               temp_read.close();
               remove( temp_path );
               remove( temp_read_path );
               snprintf( error_message, sizeof error_message, "NP_Pex: "
                         "pack_group(): %s", temp.get_error());
               return 1;
            }
         }

         if ( temp_read.put_string( status ))
         {
            spool.close();
            read.close();
            temp.close();
            temp_read.close();
            remove( temp_path );
            remove( temp_read_path );
            snprintf( error_message, sizeof error_message, "NP_Pex: "
                      "pack_group(): %s", temp_read.get_error());
            return 1;
         }
      }
      else
         while( strncmp( line, ".\r\n", 3 ))
            if (( line = spool.get_string()) == NULL )
            {
               spool.close();
               read.close();
               temp.close();
               temp_read.close();
               remove( temp_path );
               remove( temp_read_path );
               return 0;
            }
   }

   spool.close();
   read.close();
   temp.close();
   temp_read.close();
   
   rename( temp_path, path );
   rename( temp_read_path, read_path );
   
   return 0;
}
