/*******************************************
 PDF Chain
 
 Copyright: 2009 Martin Singer
 <http://sourceforge.net/projects/pdfchain/>
 
 Author: Martin Singer
 <m_power3@users.sourceforge.net>
 
 License: GPL version 3+
 <http://www.gnu.org/licenses/>
 
 Tools
 src/attachments.cc
 *******************************************/

#include "definings.hh"
#include "mainwindow.hh"

/*** TreeView - Attachments - Constructor ***/
class_window_main::class_treeview_attachments::class_treeview_attachments(){
	
	// Create Liststore
	ref_liststore_attachments = Gtk::ListStore::create(treemodel_attachments);
	set_model(ref_liststore_attachments);
	
	append_column_editable(Text::str_ADD,         treemodel_attachments.column_add);
	append_column         (Text::str_ATTACHMENTS, treemodel_attachments.column_attachpath);
	
	// Create Popup Menu
	{
		// Create MenuItems - Icons		
		hbox_up.pack_start    (*(new Gtk::Image(Gtk::Stock::GO_UP,   Gtk::ICON_SIZE_MENU)), Gtk::PACK_SHRINK, 0);
		hbox_down.pack_start  (*(new Gtk::Image(Gtk::Stock::GO_DOWN, Gtk::ICON_SIZE_MENU)), Gtk::PACK_SHRINK, 0);
		hbox_add.pack_start   (*(new Gtk::Image(Gtk::Stock::ADD,     Gtk::ICON_SIZE_MENU)), Gtk::PACK_SHRINK, 0);
		hbox_copy.pack_start  (*(new Gtk::Image(Gtk::Stock::COPY,    Gtk::ICON_SIZE_MENU)), Gtk::PACK_SHRINK, 0);
		hbox_remove.pack_start(*(new Gtk::Image(Gtk::Stock::REMOVE,  Gtk::ICON_SIZE_MENU)), Gtk::PACK_SHRINK, 0);
		
		// Create MenuItems - Text		
		hbox_up.pack_start    (*(new Gtk::Label(Text::str_UP,       Gtk::ALIGN_LEFT)), Gtk::PACK_EXPAND_WIDGET, 0);
		hbox_down.pack_start  (*(new Gtk::Label(Text::str_DOWN,     Gtk::ALIGN_LEFT)), Gtk::PACK_EXPAND_WIDGET, 0);
		hbox_add.pack_start   (*(new Gtk::Label(Text::str_ADD,      Gtk::ALIGN_LEFT)), Gtk::PACK_EXPAND_WIDGET, 0);
		hbox_remove.pack_start(*(new Gtk::Label(Text::str_REMOVE,   Gtk::ALIGN_LEFT)), Gtk::PACK_EXPAND_WIDGET, 0);
		
		// Create MenuItems
		menuitem_up.add    (hbox_up);
		menuitem_down.add  (hbox_down);
		menuitem_add.add   (hbox_add);
		menuitem_remove.add(hbox_remove);
		
		// Create PopupMenu
		popupmenu.attach(menuitem_up,                     0,1, 0,1);
		popupmenu.attach(menuitem_down,                   0,1, 1,2);
		popupmenu.attach(*(new Gtk::SeparatorMenuItem()), 0,1, 2,3);
		popupmenu.attach(menuitem_add,                    0,1, 3,4);
		popupmenu.attach(menuitem_remove,                 0,1, 4,5);
		
		// PopupMenu - Signalhandlers		
		menuitem_up.signal_activate().connect    (sigc::mem_fun(*this, &class_window_main::class_treeview_attachments::row_up));
		menuitem_down.signal_activate().connect  (sigc::mem_fun(*this, &class_window_main::class_treeview_attachments::row_down));
		menuitem_add.signal_activate().connect   (sigc::mem_fun(*this, &class_window_main::class_treeview_attachments::row_add));
		menuitem_remove.signal_activate().connect(sigc::mem_fun(*this, &class_window_main::class_treeview_attachments::row_remove));
	}
	popupmenu.show_all();
	popupmenu.accelerate(*this);
	
	return;
}

/*** TreeView - Attachments - Set Dialogs ***/
void class_window_main::class_treeview_attachments::set_dialogs(class_dialogs* dialogs){
	
	pt_dialogs = dialogs;
	return;
}


/*** TreeView - Attachments - Set Parent ***/
void class_window_main::class_treeview_attachments::set_parent(class_window_main* parent){
	
	pt_parent = parent;
	return;
}

/*** TreeView - Attachments - Clear ***/
void class_window_main::class_treeview_attachments::clear(){
	
	ref_liststore_attachments->clear();
	return;
}



/*** TreeView - Attachments - On Button Press Event (used for Popup Menus) ***/
bool class_window_main::class_treeview_attachments::on_button_press_event(GdkEventButton* event){
	
	if((event->type == GDK_BUTTON_PRESS) && (event->button == 3)){
		popupmenu.popup(event->button, event->time);
		//popupmenu_attachments.show_all();
	}
	
	return Gtk::TreeView::on_button_press_event(event);
}



/*** TreeView - Attachments - Row UP ***/
void class_window_main::class_treeview_attachments::row_up(){
	
	Glib::RefPtr<Gtk::TreeView::Selection> ref_selection = get_selection();
	Gtk::TreeModel::iterator iter = ref_selection->get_selected();
	Gtk::TreeModel::Children children = ref_liststore_attachments->children();
	
	if(iter){
		if(iter != children.begin()){
			
			Gtk::TreeModel::iterator iter_up = iter--;
			ref_liststore_attachments->iter_swap(iter, iter_up);
		}
	}
	
	return;
}



/*** TreeView - Attachments - Row DOWN ***/
void class_window_main::class_treeview_attachments::row_down(){
	
	Glib::RefPtr<Gtk::TreeView::Selection> ref_selection = get_selection();
	Gtk::TreeModel::iterator iter = ref_selection->get_selected();
	Gtk::TreeModel::Children children = ref_liststore_attachments->children();
	
	if(iter){
		if(iter != --children.end()){
			
			Gtk::TreeModel::iterator iter_down = iter++;
			ref_liststore_attachments->iter_swap(iter, iter_down);
		}
	}
	
	return;
}



/*** TreeView - Attachments - Row ADD ***/
void class_window_main::class_treeview_attachments::row_add(){
	
	// Create Filechooser (multiple selection)
	class_filechoosers filechooser(pt_parent, Pdfchain::FILE_CHOOSER_OPEN_MULTIPLE, Pdfchain::FILE_FILTER_ANY, Pdfchain::FILE_FILTER_PDF);
	Gtk::FileChooserDialog* pt_filechooser = filechooser.run_multiple();
	
	if(pt_filechooser != NULL){
		Glib::SListHandle<Glib::ustring> handle_attachpaths = pt_filechooser->get_filenames();
		Glib::SListHandle<Glib::ustring>::iterator i = handle_attachpaths.begin();
		Glib::ustring attachpath;
		
		Glib::RefPtr<Gtk::TreeView::Selection> ref_selection = get_selection();
		Gtk::TreeModel::iterator iter_selection = ref_selection->get_selected();
		Gtk::TreeModel::iterator iter;
		
		// For every Filename
		for(i = handle_attachpaths.begin(); i != handle_attachpaths.end(); ++i){
			attachpath = *i;
			
			if(attachpath != ""){
				
				// Add to Treeview
				if(iter_selection){
					iter = ref_liststore_attachments->insert_after(iter_selection);
				}
				else{
					iter = ref_liststore_attachments->append();
				}
				
				Gtk::TreeModel::Row row = *iter;
				row[treemodel_attachments.column_add]        = true;
				row[treemodel_attachments.column_attachpath] = attachpath;
				row[treemodel_attachments.column_attachfile] = get_filename(attachpath);

			}
		}
				
		// Set Cursor (Selection)
		set_cursor(ref_liststore_attachments->get_path(*iter));
	}
	
	return;
}



/*** TreeView - Attachments - Row REMOVE ***/
void class_window_main::class_treeview_attachments::row_remove(){
	
	Glib::RefPtr<Gtk::TreeView::Selection> ref_selection = get_selection();
	Gtk::TreeModel::iterator iter_next, iter = ref_selection->get_selected();
	Gtk::TreeModel::Children children = ref_liststore_attachments->children();
	
	if(iter){
		
		iter_next = iter;
		if(iter != children.begin())
			--iter_next;
		
		else if(iter != children.end())
			++iter_next;
		
		ref_liststore_attachments->erase(iter);
		
		if(iter_next)
			ref_selection->select(iter_next);
	}
	
	return;
}



/*** On Button Attachments -> Sourcefile ***/
void class_window_main::on_button_attachments_sourcefile(){
	
	// Create Filechooser
	class_filechoosers filechooser(this, Pdfchain::FILE_CHOOSER_OPEN, Pdfchain::FILE_FILTER_PDF);
	Glib::ustring filename = filechooser.run();
	
	if(filename != ""){
		
		entry_attachments_sourcefile.set_text(filename);
		ustring_attachments_sourcefile = get_filename(filename);
		ustring_attachments_pages      = get_ustring_from_unsigned_int(get_pagenumber(filename));
		adjustment_attachments_page.set_upper(static_cast<double>(atoi(ustring_attachments_pages.c_str())));
	}
	
	// Push Status
	push_status(Pdfchain::ATTACHMENTS);
	return;
}

/*** On Button Attachments -> Add ***/
void class_window_main::on_button_attachments_add(){
	
	treeview_attachments.row_add();
	return;
}

/*** On Button Attachments -> Remove ***/
void class_window_main::on_button_attachments_remove(){
	
	treeview_attachments.row_remove();
	return;
}

/*** On Button Attachments -> Up ***/
void class_window_main::on_button_attachments_up(){
	
	treeview_attachments.row_up();
	return;
}

/*** On Button Merge -> Down ***/
void class_window_main::on_button_attachments_down(){
	
	treeview_attachments.row_down();
	return;
}




/*** Save - Attachments ***/
void class_window_main::save_attachments(){
	
	Gtk::TreeModel::Row row;
	Gtk::TreeModel::Children children = treeview_attachments.ref_liststore_attachments->children();
	
	// Check Errors -> No Source File
	if(entry_attachments_sourcefile.get_text() == ""){
		
		// Error Messages
		dialogs.error_cerr("class_window_main::save_attachments()",
			Text::err_NO_SOURCE_FILE,
			Text::err_msg_EXIT_FUNCTION);
		
		dialogs.error_message(this, Text::str_ATTACHMENTS, Text::err_NO_SOURCE_FILE);
		
		return;
	}
	
	// Check Errors -> No Attachments
	if(children == 0){
		
		// Error Messages
		dialogs.error_cerr("class_window_main::save_attachments()",
			Text::err_NO_ATTACHMENT_FILE,
			Text::err_msg_EXIT_FUNCTION);
		
		dialogs.error_message(this, Text::str_ATTACHMENTS, Text::err_NO_ATTACHMENT_FILE);
		
		return;
	}
	
	Glib::ustring command;
	
	// Create Filechooser
	class_filechoosers filechooser(this, Pdfchain::FILE_CHOOSER_SAVE, Pdfchain::FILE_FILTER_PDF);
	Glib::ustring filename = filechooser.run();
	
	if(filename != ""){
		
		// Create Command
		command += Command::cmd_PDFTK + Command::cmd_SPACE;
		command += quote_out(entry_attachments_sourcefile.get_text());         // Quoting Special Chars of Source File
		command += Command::cmd_ATTACH_FILES;
		
		// Input Filename
		for( Gtk::TreeModel::iterator iter = children.begin(); iter != children.end(); ++iter){
			
			row = *iter;
			if(row[treeview_attachments.treemodel_attachments.column_add] == true){ // Checkbox
				command += Command::cmd_SPACE;
				command += quote_out(row[treeview_attachments.treemodel_attachments.column_attachpath]); // Quoting Special Chars of Attach File
			}
		}
		
		if(radiobutton_attachments_page.property_active() == true){
			command += Command::cmd_TO_PAGE + Command::cmd_SPACE;
			command += spinbutton_attachments_page.get_text();
		}
		else if(radiobutton_attachments_file.property_active() == true){
			; // Do nothing
		}
		else{ // Error Message
			
			dialogs.error_cerr("class_window_main::save_attachments()",
				Text::err_UNKNOWN_SELECTION_PAGE,
				Text::str_ADD_TO_FILE);
		}
		
		// Output
		command += Command::cmd_OUTPUT + Command::cmd_SPACE;
		command += quote_out(filename);                                        // Quoting Special Chars of Output File
		
		// Set Rights
		command += save_set_rights();
		
		// Execute Command
		execute(this, command);
	}
	
	return;
}
