/*
 * ImportDialog.java
 *
 * Created on 25. März 2005, 14:07
 */

package pauker.program.gui.swing;

import java.awt.Dimension;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import pauker.program.Card;
import pauker.program.CardSide;

/**
 * A dialog for importing text lines.
 * @author Ronny.Standtke@gmx.net
 */
public class ImportDialog extends javax.swing.JDialog {

    private final static Logger logger =
            Logger.getLogger(ImportDialog.class.getName());
    private final PaukerFrame paukerFrame;

    /** Creates new form ImportDialog
     * @param paukerFrame the Pauker frame
     */
    public ImportDialog(PaukerFrame paukerFrame) {
        super(paukerFrame, true);
        this.paukerFrame = paukerFrame;

        initComponents();

        LineLabeler lineLabeler = new LineLabeler(
                textArea,
                PaukerFrame.STRINGS.getString("Frontside"),
                PaukerFrame.STRINGS.getString("Reverse_Side"));
        scrollPane.setRowHeaderView(lineLabeler);

        pack();
        setLocationRelativeTo(paukerFrame);

        // fix the size of the info label
        Dimension size = infoLabel.getSize();
        infoLabel.setMinimumSize(size);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        infoLabel = new javax.swing.JLabel();
        scrollPane = new javax.swing.JScrollPane();
        textArea = new javax.swing.JTextArea();
        jPanel1 = new javax.swing.JPanel();
        importButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("pauker/Strings"); // NOI18N
        setTitle(bundle.getString("Text_Import")); // NOI18N

        infoLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        infoLabel.setText(bundle.getString("Text_Import_Info")); // NOI18N

        scrollPane.setPreferredSize(new java.awt.Dimension(500, 300));
        scrollPane.setViewportView(textArea);

        importButton.setText(bundle.getString("Import")); // NOI18N
        importButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                importButtonActionPerformed(evt);
            }
        });
        jPanel1.add(importButton);

        cancelButton.setText(bundle.getString("Cancel")); // NOI18N
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });
        jPanel1.add(cancelButton);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, scrollPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 584, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, infoLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 584, Short.MAX_VALUE)
                    .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 584, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(infoLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 26, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(scrollPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents
    private void importButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_importButtonActionPerformed
        // check, that there are no empty sides
        // TODO: line numbers, color highlighting
        Document document = textArea.getDocument();
        Element rootElement = document.getDefaultRootElement();
        int numberOfLines = rootElement.getElementCount();

        // check, that we have an even number of lines
        if (numberOfLines % 2 != 0) {
            JOptionPane.showMessageDialog(this,
                    PaukerFrame.STRINGS.getString(
                    "Error_Import_Incomplete_Card"),
                    PaukerFrame.STRINGS.getString("Error"),
                    JOptionPane.ERROR_MESSAGE);
            textArea.requestFocusInWindow();
            // move caret to last line
            Element lastLine = rootElement.getElement(numberOfLines - 1);
            textArea.setCaretPosition(lastLine.getEndOffset() - 1);
            return;
        }

        for (int i = 0; i < numberOfLines; i++) {
            Element line = rootElement.getElement(i);
            if (line.getStartOffset() + 1 == line.getEndOffset()) {
                JOptionPane.showMessageDialog(this,
                        PaukerFrame.STRINGS.getString(
                        "Error_Import_Empty_Card_Side"),
                        PaukerFrame.STRINGS.getString("Error"),
                        JOptionPane.ERROR_MESSAGE);
                textArea.requestFocusInWindow();
                // move caret to empty line
                textArea.setCaretPosition(line.getStartOffset());
                return;
            }
        }

        // import cards
        String frontSideText = null;
        String reverseSideText = null;
        try {
            for (int i = 0; i < numberOfLines; i++) {
                Element line = rootElement.getElement(i);
                int offset = line.getStartOffset();
                int length = line.getEndOffset() - offset - 1;
                if (i % 2 == 0) {
                    frontSideText = document.getText(offset, length);
                } else {
                    reverseSideText = document.getText(offset, length);
                    CardSide frontSide = new CardSide(frontSideText);
                    CardSide reverseSide = new CardSide(reverseSideText);
                    Card newCard = new Card(frontSide, reverseSide);
                    paukerFrame.addCard(newCard);
                }
            }
        } catch (BadLocationException badLocationException) {
            logger.log(Level.SEVERE, null, badLocationException);
        }
        dispose();
        setVisible(false);
    }//GEN-LAST:event_importButtonActionPerformed

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        dispose();
        setVisible(false);
    }//GEN-LAST:event_cancelButtonActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JButton importButton;
    private javax.swing.JLabel infoLabel;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane scrollPane;
    private javax.swing.JTextArea textArea;
    // End of variables declaration//GEN-END:variables
}
